/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jtf;

import java.io.PrintStream;
import java.util.Enumeration;
import org.exolab.core.CWCommandLine;
import org.exolab.exceptions.CWClassConstructorException;
import org.exolab.jtf.CWTestCategory;
import org.exolab.jtf.CWTestHarness;

public abstract class CWBaseApplication {
    private CWTestHarness harness_ = null;

    public CWBaseApplication(String string) throws CWClassConstructorException {
        this.harness_ = new CWTestHarness(string);
    }

    public void add(CWTestCategory cWTestCategory) {
        this.harness_.add(cWTestCategory.name(), cWTestCategory, true);
    }

    protected boolean execute(String string, boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = this.harness_.execute(string, System.out, bl);
            System.out.println("\n\n\n##### RESULTS #####");
            this.harness_.result(System.out);
        }
        catch (Throwable throwable) {
            System.out.println("ERR execute - " + throwable.getMessage());
            throwable.printStackTrace(System.err);
        }
        return bl2;
    }

    protected boolean executeAll(boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = this.harness_.execute("*", System.out, bl);
            System.out.println("\n\n\n##### RESULTS #####");
            this.harness_.result(System.out);
        }
        catch (Throwable throwable) {
            System.out.println("ERR executeAll - " + throwable.getMessage());
        }
        return bl2;
    }

    protected abstract String getApplicationName();

    protected abstract Enumeration getCategoryClassNames();

    protected void info() {
        try {
            this.harness_.info(System.out);
        }
        catch (Throwable throwable) {
            System.out.println("ERR info - " + throwable.getMessage());
        }
    }

    protected void register() {
        Enumeration enumeration = this.getCategoryClassNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                if (obj instanceof CWTestCategory) {
                    CWTestCategory cWTestCategory = (CWTestCategory)obj;
                    this.harness_.add(cWTestCategory.name(), cWTestCategory, true);
                    continue;
                }
                System.err.println("obj is not an instance of CWTestCategory It is an instance of " + obj.getClass().getName());
            }
            catch (Exception exception) {
                System.err.println("Problem with " + string + " " + exception.toString());
            }
        }
    }

    public void run(String[] stringArray) {
        CWCommandLine cWCommandLine = new CWCommandLine(stringArray);
        boolean bl = false;
        this.register();
        if (cWCommandLine.exists("verbose")) {
            bl = true;
        }
        if (cWCommandLine.exists("help")) {
            this.usage();
        } else if (cWCommandLine.exists("info")) {
            this.info();
        } else if (cWCommandLine.exists("execute")) {
            if (cWCommandLine.isSwitch("execute")) {
                this.executeAll(bl);
            } else {
                this.execute(cWCommandLine.value("execute"), bl);
            }
        } else {
            this.usage();
        }
    }

    protected void usage() {
        PrintStream printStream = System.out;
        printStream.println("\n\n" + this.getApplicationName());
        printStream.println("    [-help | -info | -execute [category name]");
        printStream.println("                  -verbose]\n");
        printStream.println("\t-help displays this screen\n");
        printStream.println("\t-info displays all registered categories and their");
        printStream.println("\t contained test cases\n");
        printStream.println("\t-execute to run all the test cases in the hierarchy");
        printStream.println("\t If a name is specified then it will run all tests");
        printStream.println("\t starting from that point in the hierarchy.\n");
        printStream.println("\t-verbose is used in conjunction with the -execute");
        printStream.println("\t option.\n");
    }
}

