/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.Header;
import javax.mail.MessagingException;

public class InternetHeaders {
    private static final String[] STRING_ARRAY = new String[0];
    private Map _headers = new HashMap();
    private Header _last;
    private List _lines = new LinkedList();

    private static Header parse(String line) {
        int colon = line.indexOf(":");
        String name = line.substring(0, colon).trim();
        String value = line.substring(colon + 1).trim();
        return new Header(name, value);
    }

    public InternetHeaders() {
    }

    public InternetHeaders(InputStream in) throws MessagingException {
        this.load(in);
    }

    private void add(Header header, String line) {
        if (line == null) {
            line = header.getName() + ": " + header.getValue();
        } else if (header == null) {
            header = InternetHeaders.parse(line);
        }
        String NAME = header.getName().toUpperCase();
        LinkedList<Header> list = (LinkedList<Header>)this._headers.get(NAME);
        if (list == null) {
            list = new LinkedList<Header>();
            this._headers.put(NAME, list);
        }
        list.add(header);
        this._lines.add(line);
        this._last = header;
    }

    public void addHeader(String name, String value) {
        this.add(new Header(name, value), null);
    }

    public void addHeaderLine(String line) {
        this.add(null, line);
    }

    public Enumeration getAllHeaderLines() {
        return Collections.enumeration(this._lines);
    }

    public Enumeration getAllHeaders() {
        LinkedList result = new LinkedList();
        Iterator it = this._headers.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            result.addAll(list);
        }
        return Collections.enumeration(result);
    }

    public String[] getHeader(String name) {
        List headers = this.getHeaderList(name);
        if (headers == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        Iterator it = headers.iterator();
        while (it.hasNext()) {
            Header element = (Header)it.next();
            result.add(element.getValue());
        }
        return result.toArray(STRING_ARRAY);
    }

    public String getHeader(String name, String delimiter) {
        List list = this.getHeaderList(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Iterator it = list.iterator();
        StringBuffer result = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                if (delimiter == null) break;
                result.append(delimiter);
            }
            Header header = (Header)it.next();
            result.append(header.getValue());
        }
        return result.toString();
    }

    private List getHeaderList(String name) {
        return (List)this._headers.get(name.toUpperCase());
    }

    private Enumeration getHeaders(String[] names, boolean match) {
        ArrayList<String> matches = new ArrayList<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            matches.add(names[i].toUpperCase());
        }
        LinkedList result = new LinkedList();
        Iterator entries = this._headers.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (matches.contains(entry.getKey()) != match) continue;
            result.addAll((Collection)entry.getValue());
        }
        return Collections.enumeration(result);
    }

    private Enumeration getLines(String[] names, boolean match) {
        ArrayList<String> matches = new ArrayList<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            matches.add(names[i].toUpperCase());
        }
        Iterator it = this._lines.iterator();
        LinkedList<String> result = new LinkedList<String>();
        while (it.hasNext()) {
            int colon;
            String line = (String)it.next();
            String name = line.substring(0, colon = line.indexOf(":")).toUpperCase();
            if (matches.contains(name) != match) continue;
            result.add(line);
        }
        return Collections.enumeration(result);
    }

    public Enumeration getMatchingHeaderLines(String[] names) {
        return this.getLines(names, true);
    }

    public Enumeration getMatchingHeaders(String[] names) {
        return this.getHeaders(names, true);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) {
        return this.getLines(names, false);
    }

    public Enumeration getNonMatchingHeaders(String[] names) {
        return this.getHeaders(names, false);
    }

    public void load(InputStream in) throws MessagingException {
        try {
            StringBuffer buffer = new StringBuffer();
            boolean cr = false;
            boolean lf = false;
            boolean flush = true;
            String line = null;
            while (true) {
                boolean white;
                int c = in.read();
                boolean start = buffer.length() == 0;
                boolean bl = white = c == 9 || c == 32;
                if (start && line != null) {
                    if (white) {
                        while (c == 9 || c == 32) {
                            c = in.read();
                        }
                        buffer.append(line);
                        buffer.append(' ');
                    } else {
                        this.addHeaderLine(line);
                        line = null;
                    }
                }
                if (c == 13) {
                    cr = true;
                } else if (c == 10) {
                    lf = true;
                } else {
                    buffer.append((char)c);
                    if (cr || lf) {
                        lf = true;
                        cr = true;
                    }
                }
                if (!cr || !lf) continue;
                line = buffer.toString().trim();
                if (line.length() != 0) {
                    buffer = new StringBuffer();
                    lf = false;
                    cr = false;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public void removeHeader(String name) {
        String NAME = name.toUpperCase();
        this._headers.remove(NAME);
        NAME = NAME + ":";
        Iterator it = this._lines.iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            if (!line.toUpperCase().startsWith(NAME)) continue;
            it.remove();
        }
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }
}

