/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import java.io.PrintWriter;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import tyrex.tm.TyrexTransactionManager;
import tyrex.tm.XAResourceCallback;
import tyrex.tm.impl.NestedSystemException;
import tyrex.tm.impl.ThreadContext;
import tyrex.tm.impl.TransactionDomainImpl;
import tyrex.tm.impl.TransactionImpl;
import tyrex.tm.impl.Util;
import tyrex.tm.impl.XAResourceHolder;
import tyrex.util.Messages;

final class TransactionManagerImpl
implements TransactionManager,
Status,
TyrexTransactionManager {
    private TransactionDomainImpl _txDomain;

    TransactionManagerImpl(TransactionDomainImpl transactionDomainImpl) {
        if (transactionDomainImpl == null) {
            throw new IllegalArgumentException("Argument 'txDomain' is null");
        }
        this._txDomain = transactionDomainImpl;
    }

    public void begin() throws NotSupportedException, SystemException {
        XAResourceHolder[] xAResourceHolderArray;
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl != null && transactionImpl._status != 3 && transactionImpl._status != 4) {
            if (!this._txDomain.getNestedTransactions()) {
                throw new NotSupportedException(Messages.message("tyrex.tx.noNested"));
            }
            threadContext._tx = transactionImpl = this._txDomain.createTransaction(transactionImpl, 0L);
            return;
        }
        transactionImpl = this._txDomain.createTransaction(null, 0L);
        if (this._txDomain.enlistThread(transactionImpl, threadContext, thread) && (xAResourceHolderArray = threadContext.getXAResourceHolders()) != null) {
            this.enlistResources(transactionImpl, xAResourceHolderArray);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl == null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
        }
        transactionImpl.commit();
        this._txDomain.delistThread(threadContext, thread);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl == null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
        }
        transactionImpl.rollback();
        this._txDomain.delistThread(threadContext, thread);
    }

    public int getStatus() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl == null) {
            return 6;
        }
        return transactionImpl._status;
    }

    public Transaction getTransaction() {
        return ThreadContext.getThreadContext()._tx;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        if (!(transaction instanceof TransactionImpl)) {
            throw new InvalidTransactionException(Messages.message("tyrex.tx.resumeForeign"));
        }
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        if (threadContext._tx != null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.resumeOverload"));
        }
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            if (transactionImpl.getTimedOut()) {
                throw new InvalidTransactionException(Messages.message("tyrex.tx.timedOut"));
            }
            if (transactionImpl._status != 0 && transactionImpl._status != 1) {
                throw new InvalidTransactionException(Messages.message("tyrex.tx.inactive"));
            }
            try {
                ((TransactionImpl)transactionImpl.getTopLevel()).resumeAndEnlistResources(threadContext.getXAResourceHolders());
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
            this._txDomain.enlistThread(transactionImpl, threadContext, thread);
        }
    }

    public Transaction suspend() {
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl == null) {
            return null;
        }
        transactionImpl = (TransactionImpl)transactionImpl.getTopLevel();
        threadContext._tx = null;
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            this._txDomain.delistThread(threadContext, thread);
            if (transactionImpl._status == 0 || transactionImpl._status == 1) {
                try {
                    transactionImpl.suspendResources();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                TransactionImpl transactionImpl3 = transactionImpl;
                return transactionImpl3;
            }
            Transaction transaction = null;
            return transaction;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl == null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
        }
        transactionImpl.setRollbackOnly();
    }

    public void setTransactionTimeout(int n) {
        this._txDomain.setTransactionTimeout(n);
    }

    public Transaction getTransaction(Xid xid) {
        return this._txDomain.findTransaction(xid);
    }

    public Transaction getTransaction(String string) {
        return this._txDomain.findTransaction(string);
    }

    public void dumpTransactionList(PrintWriter printWriter) {
        this._txDomain.dumpTransactionList(printWriter);
    }

    public void dumpCurrentTransaction(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("Argument writer is null");
        }
        TransactionImpl transactionImpl = (TransactionImpl)this.getTransaction();
        if (transactionImpl == null) {
            printWriter.println("No transaction associated with current thread");
        } else {
            printWriter.println("  Transaction " + transactionImpl._xid + " " + Util.getStatus(transactionImpl._status));
            printWriter.println("  Started " + Util.fromClock(transactionImpl._started) + " time-out " + Util.fromClock(transactionImpl._timeout));
        }
    }

    public Transaction getTransaction(Thread thread) {
        return ThreadContext.getThreadContext()._tx;
    }

    public void enlistResource(XAResource xAResource) throws SystemException {
        this.enlistResource(xAResource, null);
    }

    public void enlistResource(XAResource xAResource, XAResourceCallback xAResourceCallback) throws SystemException {
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        threadContext.add(xAResource, xAResourceCallback);
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl != null) {
            try {
                ((TransactionImpl)transactionImpl.getTopLevel()).enlistResource(xAResource, xAResourceCallback);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
    }

    public void delistResource(XAResource xAResource, int n) {
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        if (n != 0x4000000 && n != 0x20000000) {
            throw new IllegalArgumentException("Invalid value for flag");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        threadContext.remove(xAResource);
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl != null) {
            try {
                transactionImpl.getTopLevel().delistResource(xAResource, n);
            }
            catch (SystemException systemException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected void internalResume(TransactionImpl transactionImpl) throws IllegalStateException, SystemException {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        Thread thread = Thread.currentThread();
        ThreadContext threadContext = ThreadContext.getThreadContext(thread);
        if (threadContext._tx != null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.resumeOverload"));
        }
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            this._txDomain.enlistThread(transactionImpl, threadContext, thread);
        }
    }

    private void enlistResources(TransactionImpl transactionImpl, XAResourceHolder[] xAResourceHolderArray) throws SystemException {
        if (xAResourceHolderArray != null) {
            try {
                int n = xAResourceHolderArray.length;
                while (n-- > 0) {
                    transactionImpl.enlistResource(xAResourceHolderArray[n]._xaResource, xAResourceHolderArray[n]._callback);
                }
            }
            catch (Exception exception) {
                try {
                    this.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception instanceof SystemException) {
                    throw (SystemException)((Object)exception);
                }
                throw new NestedSystemException(exception);
            }
        }
    }
}

