/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jndi;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mockejb.jndi.MockContext;
import org.mockejb.jndi.MockContextFactory;
import org.mockejb.jndi.MockContextNameParser;

public class MockContextTest
extends TestCase {
    private Context initialCtx;
    private Context compCtx;
    private Context envCtx;
    private Context ejbCtx;

    public MockContextTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        MockContextFactory.setAsInitial();
        this.initialCtx = new InitialContext();
        this.initialCtx.bind("java:comp/env/ejb/Dummy", null);
        this.compCtx = (Context)this.initialCtx.lookup("java:comp");
        this.envCtx = (Context)this.compCtx.lookup("env");
        this.ejbCtx = (Context)this.envCtx.lookup("ejb");
    }

    protected void tearDown() throws Exception {
        this.clearContext(this.initialCtx);
        this.ejbCtx = null;
        this.envCtx = null;
        this.compCtx = null;
        this.initialCtx = null;
        MockContextFactory.revertSetAsInitial();
    }

    private void clearContext(Context context) throws NamingException {
        NamingEnumeration<Binding> e = context.listBindings("");
        while (e.hasMoreElements()) {
            Binding binding = (Binding)e.nextElement();
            if (binding.getObject() instanceof Context) {
                this.clearContext((Context)binding.getObject());
            }
            context.unbind(binding.getName());
        }
    }

    public void testSubcontextCreationOfDuplicates() throws NamingException {
        try {
            this.initialCtx.createSubcontext("java:comp");
            Assert.fail();
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        try {
            this.compCtx.createSubcontext("env/ejb");
            Assert.fail();
        }
        catch (NameAlreadyBoundException ex) {}
    }

    public void testSubcontextNonEmptyDestruction() throws NamingException {
        this.ejbCtx.bind("EmptyTest", (Object)"EmptyTest Object");
        try {
            this.initialCtx.destroySubcontext("java:comp");
            Assert.fail();
        }
        catch (ContextNotEmptyException ex) {
            // empty catch block
        }
        try {
            this.initialCtx.destroySubcontext("java:comp/env/ejb");
            Assert.fail();
        }
        catch (ContextNotEmptyException ex) {
            // empty catch block
        }
        try {
            this.envCtx.destroySubcontext("ejb");
            Assert.fail();
        }
        catch (ContextNotEmptyException ex) {}
    }

    public void testSubcontextDestruction() throws NamingException {
        Context sub1 = this.ejbCtx.createSubcontext("sub1");
        Context sub2 = this.ejbCtx.createSubcontext("sub2");
        Context sub3 = this.envCtx.createSubcontext("sub3");
        this.initialCtx.destroySubcontext("java:comp/env/ejb/sub1");
        this.ejbCtx.destroySubcontext("sub2");
        this.envCtx.destroySubcontext("sub3");
        try {
            this.ejbCtx.lookup("sub1");
            Assert.fail();
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        try {
            this.envCtx.lookup("ejb/sub2");
            Assert.fail();
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        try {
            this.initialCtx.lookup("java:comp/sub3");
            Assert.fail();
        }
        catch (NameNotFoundException ex) {}
    }

    public void testSubcontextInvokingMethodsOnDestroyedContext() throws NamingException {
        Context sub = this.ejbCtx.createSubcontext("subXX");
        this.initialCtx.destroySubcontext("java:comp/env/ejb/subXX");
        try {
            sub.bind("SomeName", (Object)"SomeObject");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            sub.unbind("SomeName");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            sub.createSubcontext("SomeSubcontext");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            sub.destroySubcontext("DummyName");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            sub.list("");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            sub.lookup("DummyName");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            sub.composeName("name", "prefix");
            Assert.fail();
        }
        catch (NoPermissionException ex) {
            // empty catch block
        }
        try {
            MockContextNameParser parser = new MockContextNameParser();
            sub.composeName(parser.parse("a"), parser.parse("b"));
            Assert.fail();
        }
        catch (NoPermissionException ex) {}
    }

    public void testBindLookup() throws NamingException {
        String o1 = new String("Test object for atomic binding");
        String o2 = new String("Test object for compound binding");
        String o3 = new String("Test object for complex compound binding");
        this.ejbCtx.bind("AtomicNull", null);
        this.ejbCtx.bind("AtomicObject", (Object)o1);
        this.initialCtx.bind("java:comp/env/CompoundNull", null);
        this.initialCtx.bind("java:comp/env/CompoundObject", (Object)o2);
        this.initialCtx.bind("java:comp/env/ejb/subToCreate1/subToCreate2/oo", (Object)o3);
        Assert.assertNull((Object)this.ejbCtx.lookup("AtomicNull"));
        Assert.assertSame((Object)this.ejbCtx.lookup("AtomicObject"), (Object)o1);
        Assert.assertNull((Object)this.compCtx.lookup("env/CompoundNull"));
        Assert.assertSame((Object)this.initialCtx.lookup("java:comp/env/CompoundObject"), (Object)o2);
        Assert.assertSame((Object)this.ejbCtx.lookup("subToCreate1/subToCreate2/oo"), (Object)o3);
    }

    public void testUnbind() throws NamingException {
        this.envCtx.bind("testUnbindName1", null);
        this.compCtx.bind("env/ejb/testUnbindName2", (Object)new String("Test unbind object"));
        this.initialCtx.unbind("java:comp/env/testUnbindName1");
        this.ejbCtx.unbind("testUnbindName2");
        try {
            this.envCtx.lookup("testUnbindName1");
            Assert.fail();
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        try {
            this.initialCtx.lookup("java:comp/env/ejb/testUnbindName2");
            Assert.fail();
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        try {
            this.ejbCtx.unbind("This name does not exist in the context");
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            this.compCtx.unbind("env/ejb/ejb1/somename");
            Assert.fail();
        }
        catch (NameNotFoundException ex) {}
    }

    public void testListBindings() throws NamingException {
        String o1 = new String("Test list bindings 1");
        String o2 = new String("Test list bindings 2");
        this.compCtx.bind("env/ejb/testListBindings1", (Object)o1);
        this.envCtx.bind("testListBindings2", (Object)o2);
        this.ejbCtx.bind("testListBindings3", null);
        this.verifyListBindingsResult(this.envCtx, "", o1, o2);
        this.verifyListBindingsResult(this.initialCtx, "java:comp/env", o1, o2);
    }

    private void verifyListBindingsResult(Context c, String name, Object o1, Object o2) throws NamingException {
        boolean ejbFoundFlg = false;
        boolean o2FoundFlg = false;
        boolean ejbO1FoundFlg = false;
        boolean ejbNullFoundFlg = false;
        NamingEnumeration<Binding> en = c.listBindings(name);
        while (en.hasMore()) {
            Binding b = en.next();
            if (b.getName().equals("ejb")) {
                Assert.assertEquals((Object)b.getObject(), (Object)this.ejbCtx);
                ejbFoundFlg = true;
                Context nextCon = (Context)b.getObject();
                NamingEnumeration<Binding> en1 = nextCon.listBindings("");
                while (en1.hasMore()) {
                    Binding b1 = en1.next();
                    if (b1.getName().equals("testListBindings1")) {
                        Assert.assertEquals((Object)b1.getObject(), (Object)o1);
                        ejbO1FoundFlg = true;
                        continue;
                    }
                    if (!b1.getName().equals("testListBindings3")) continue;
                    Assert.assertNull((Object)b1.getObject());
                    ejbNullFoundFlg = true;
                }
                continue;
            }
            if (!b.getName().equals("testListBindings2")) continue;
            Assert.assertEquals((Object)b.getObject(), (Object)o2);
            o2FoundFlg = true;
        }
        if (!(ejbFoundFlg && o2FoundFlg && ejbO1FoundFlg && ejbNullFoundFlg)) {
            Assert.fail();
        }
    }

    public void testCompositeNameWithLeadingTrailingEmptyComponents() throws Exception {
        MockContext c = new MockContext(null);
        Object o = new Object();
        c.rebind("/a/b/c/", o);
        Assert.assertEquals((Object)c.lookup("a/b/c"), (Object)o);
        Assert.assertEquals((Object)c.lookup("///a/b/c///"), (Object)o);
    }

    public void testLookup() throws Exception {
        MockContext mockCtx = new MockContext(null);
        Object obj = new Object();
        mockCtx.rebind("a/b/c/d", obj);
        Assert.assertEquals((Object)obj, (Object)mockCtx.lookup("a/b/c/d"));
        mockCtx.bind("a", obj);
        Assert.assertEquals((Object)obj, (Object)mockCtx.lookup("a"));
    }

    public void testGetCompositeName() throws Exception {
        MockContext mockCtx = new MockContext(null);
        mockCtx.rebind("a/b/c/d", new Object());
        MockContext subCtx = (MockContext)mockCtx.lookup("a");
        Assert.assertEquals((String)"a", (String)subCtx.getCompoundStringName());
        subCtx = (MockContext)mockCtx.lookup("a/b/c");
        Assert.assertEquals((String)"a/b/c", (String)subCtx.getCompoundStringName());
    }

    public void testDelegateContext() throws Exception {
        ArrayList recordedLookups = new ArrayList();
        MockContext ctx = new MockContext(new RecordingMockContext(recordedLookups));
        String wrongName = "mockejb";
        ctx.lookup(wrongName);
        Assert.assertEquals((int)1, (int)recordedLookups.size());
        Assert.assertEquals((Object)wrongName, recordedLookups.get(0));
        recordedLookups.clear();
        wrongName = "mockejb/a";
        ctx.lookup(wrongName);
        Assert.assertEquals((int)1, (int)recordedLookups.size());
        Assert.assertEquals((Object)wrongName, recordedLookups.get(0));
        recordedLookups.clear();
        ctx.rebind("mockejb/dummy", new Object());
        wrongName = "mockejb/a";
        ctx.lookup(wrongName);
        Assert.assertEquals((int)1, (int)recordedLookups.size());
        Assert.assertEquals((Object)wrongName, recordedLookups.get(0));
    }

    class RecordingMockContext
    extends MockContext {
        private Collection recordedLookups;

        public RecordingMockContext(Collection recordedNames) {
            super(null);
            this.recordedLookups = recordedNames;
        }

        public Object lookup(Name name) throws NamingException {
            this.recordedLookups.add(name.toString());
            return new Object();
        }

        public Object lookup(String name) throws NamingException {
            this.recordedLookups.add(name);
            return new Object();
        }
    }
}

