/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.ObjectInvoker;

public class ObjectInvokerTest
extends TestCase
implements InvocationHandler {
    static final String TEST_CONTEXT = "testContext";
    private ObjectInvoker objectInvoker;
    private List interceptorList = new LinkedList();
    static /* synthetic */ Class class$org$mockejb$interceptor$ObjectInvokerTest$TestIface;

    public ObjectInvokerTest(String name) {
        super(name);
    }

    public void testConstruction() throws Exception {
        ObjectInvoker objectInvoker = null;
        try {
            objectInvoker = new ObjectInvoker(null);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        this.interceptorList.add(this);
        try {
            objectInvoker = new ObjectInvoker(this.interceptorList);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {}
    }

    public void testInvocation() throws Exception {
        TestIface testProxy = (TestIface)Proxy.newProxyInstance((class$org$mockejb$interceptor$ObjectInvokerTest$TestIface == null ? (class$org$mockejb$interceptor$ObjectInvokerTest$TestIface = ObjectInvokerTest.class$("org.mockejb.interceptor.ObjectInvokerTest$TestIface")) : class$org$mockejb$interceptor$ObjectInvokerTest$TestIface).getClassLoader(), new Class[]{class$org$mockejb$interceptor$ObjectInvokerTest$TestIface == null ? (class$org$mockejb$interceptor$ObjectInvokerTest$TestIface = ObjectInvokerTest.class$("org.mockejb.interceptor.ObjectInvokerTest$TestIface")) : class$org$mockejb$interceptor$ObjectInvokerTest$TestIface}, (InvocationHandler)this);
        this.interceptorList.clear();
        this.objectInvoker = new ObjectInvoker(this.interceptorList);
        Assert.assertEquals((String)"test", (String)testProxy.echo("test"));
        TestInterceptor interceptor1 = new TestInterceptor();
        TestInterceptor interceptor2 = new TestInterceptor();
        this.interceptorList.add(interceptor1);
        this.interceptorList.add(interceptor2);
        Assert.assertEquals((String)"test", (String)testProxy.echo("test"));
        Assert.assertTrue((boolean)interceptor1.wasInvoked());
        Assert.assertTrue((boolean)interceptor2.wasInvoked());
        Assert.assertEquals((String)"test", (String)testProxy.echo("test"));
        Assert.assertTrue((boolean)interceptor1.wasInvoked());
        Assert.assertTrue((boolean)interceptor2.wasInvoked());
        Assert.assertEquals((int)0, (int)interceptor1.getCallIndexBefore());
        Assert.assertEquals((int)0, (int)interceptor1.getCallIndexAfter());
        Assert.assertEquals((int)1, (int)interceptor2.getCallIndexBefore());
        Assert.assertEquals((int)1, (int)interceptor2.getCallIndexAfter());
        interceptor2.setThrowException(new RuntimeException());
        try {
            testProxy.echo("test");
            Assert.fail((String)"Expected RuntimeExeption");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        Assert.assertTrue((boolean)interceptor1.wasInvoked());
        Assert.assertTrue((boolean)interceptor2.wasInvoked());
        Assert.assertTrue((!this.objectInvoker.getInterceptorIterator().hasPrevious() ? 1 : 0) != 0);
    }

    public void testContext() throws Exception {
        TestIface testProxy = (TestIface)Proxy.newProxyInstance((class$org$mockejb$interceptor$ObjectInvokerTest$TestIface == null ? (class$org$mockejb$interceptor$ObjectInvokerTest$TestIface = ObjectInvokerTest.class$("org.mockejb.interceptor.ObjectInvokerTest$TestIface")) : class$org$mockejb$interceptor$ObjectInvokerTest$TestIface).getClassLoader(), new Class[]{class$org$mockejb$interceptor$ObjectInvokerTest$TestIface == null ? (class$org$mockejb$interceptor$ObjectInvokerTest$TestIface = ObjectInvokerTest.class$("org.mockejb.interceptor.ObjectInvokerTest$TestIface")) : class$org$mockejb$interceptor$ObjectInvokerTest$TestIface}, (InvocationHandler)this);
        this.interceptorList.clear();
        this.objectInvoker = new ObjectInvoker(this.interceptorList);
        this.objectInvoker.setInvocationContext(TEST_CONTEXT, "test");
        TestInterceptor interceptor1 = new TestInterceptor();
        this.interceptorList.add(interceptor1);
        testProxy.echo("test");
        Assert.assertEquals((Object)"test", (Object)interceptor1.getContext());
        this.objectInvoker.clear();
        Assert.assertNull((Object)this.objectInvoker.getInvocationContext(TEST_CONTEXT));
    }

    public Object invoke(Object proxy, Method ifaceMethod, Object[] paramVals) throws Throwable {
        Method objMethod = this.getClass().getMethod(ifaceMethod.getName(), ifaceMethod.getParameterTypes());
        return this.objectInvoker.invoke(this, objMethod, paramVals);
    }

    public String echo(String s) {
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TestInterceptor
    implements Interceptor {
        private boolean wasInvoked = false;
        private int callIndexBefore = 0;
        private int callIndexAfter = 0;
        private Exception exception;
        private Object context;

        private TestInterceptor() {
        }

        public Object intercept(ObjectInvoker objectInvoker, Object targetObj, Method method, Object[] paramVals) throws Exception {
            this.wasInvoked = true;
            this.callIndexBefore = objectInvoker.getInterceptorIterator().previousIndex();
            this.context = objectInvoker.getInvocationContext(ObjectInvokerTest.TEST_CONTEXT);
            System.out.println("Was invoked: " + this.callIndexBefore);
            if (this.exception != null) {
                throw this.exception;
            }
            Object obj = objectInvoker.invoke(targetObj, method, paramVals);
            this.callIndexAfter = objectInvoker.getInterceptorIterator().previousIndex();
            return obj;
        }

        boolean wasInvoked() {
            boolean tmpWasInvoked = this.wasInvoked;
            this.wasInvoked = false;
            return tmpWasInvoked;
        }

        int getCallIndexBefore() {
            return this.callIndexBefore;
        }

        int getCallIndexAfter() {
            return this.callIndexAfter;
        }

        void setThrowException(Exception exception) {
            this.exception = exception;
        }

        Object getContext() {
            return this.context;
        }
    }

    static interface TestIface {
        public String echo(String var1);
    }
}

