/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import org.apache.cactus.ServletTestCase;

public class OptionalCactusTestCase
extends ServletTestCase {
    public OptionalCactusTestCase(String testName) {
        super(testName);
    }

    protected boolean isCactusMode() {
        String cactusProp = System.getProperty("mockejb.cactus.mode");
        return cactusProp != null && cactusProp.equalsIgnoreCase("true");
    }

    public boolean isRunningOnServer() {
        return this.request != null;
    }

    public void runBare() throws Throwable {
        if (!this.isRunningOnServer()) {
            this.runBareLocally();
        } else {
            super.runBare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runBareLocally() throws Throwable {
        if (this.isCactusMode()) {
            super.runBare();
        } else {
            this.setUp();
            try {
                this.runTestLocally();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.tearDown();
                throw throwable;
            }
            this.tearDown();
            {
            }
        }
    }

    protected void runTestLocally() throws Throwable {
        Assert.assertNotNull((Object)this.getName());
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), null);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Method \"" + this.getName() + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            Assert.fail((String)("Method \"" + this.getName() + "\" should be public"));
        }
        try {
            runMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }
}

