/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.jms.MessageListener;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.mockejb.MessageBeanHome;
import org.mockejb.MockEjbObject;
import org.mockejb.SessionBeanDescriptor;
import org.mockejb.SessionBeanHome;

public class MockContainer {
    private Context context;

    public MockContainer(Context context) {
        this.context = context;
    }

    public MockEjbObject deploy(SessionBeanDescriptor descriptor) throws NamingException {
        SessionBeanHome home = new SessionBeanHome(descriptor);
        this.context.rebind(descriptor.getJndiName(), home.createProxy());
        return home.getMockEjbObject();
    }

    public MockEjbObject deployMessageBean(Class beanClass) {
        MessageBeanHome home = new MessageBeanHome(beanClass);
        return home.getEjbObject();
    }

    public MessageListener createMessageBean(MockEjbObject ejbObject) {
        MessageBeanHome home = (MessageBeanHome)ejbObject.getHomeImpl();
        return home.create();
    }

    public static boolean isSystemException(Throwable throwable) {
        return throwable instanceof RuntimeException || throwable instanceof RemoteException || throwable instanceof SystemException || throwable instanceof NotSupportedException || throwable instanceof InvalidTransactionException || throwable instanceof InvocationTargetException;
    }
}

