/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.postgresql.Field;
import org.postgresql.PG_Stream;
import org.postgresql.core.Notification;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.util.PSQLException;

public class QueryExecutor {
    private final String[] m_sqlFrags;
    private final Object[] m_binds;
    private final Statement statement;
    private final PG_Stream pg_stream;
    private final AbstractJdbc1Connection connection;
    private Field[] fields = null;
    private Vector tuples = new Vector();
    private boolean binaryCursor = false;
    private String status = null;
    private int update_count = 1;
    private long insert_oid = 0L;
    private int maxRows;

    public QueryExecutor(String[] p_sqlFrags, Object[] p_binds, Statement statement, PG_Stream pg_stream, Connection connection) throws SQLException {
        this.m_sqlFrags = p_sqlFrags;
        this.m_binds = p_binds;
        this.statement = statement;
        this.pg_stream = pg_stream;
        this.connection = (AbstractJdbc1Connection)((Object)connection);
        this.maxRows = statement != null ? statement.getMaxRows() : 0;
    }

    public ResultSet execute() throws SQLException {
        StringBuffer errorMessage = null;
        PG_Stream pG_Stream = this.pg_stream;
        synchronized (pG_Stream) {
            this.sendQuery();
            boolean l_endQuery = false;
            while (!l_endQuery) {
                int c = this.pg_stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.pg_stream.ReceiveInteger(4);
                        String msg = this.pg_stream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 66: {
                        this.receiveTuple(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatus();
                        break;
                    }
                    case 68: {
                        this.receiveTuple(false);
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.pg_stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 73: {
                        int t = this.pg_stream.ReceiveChar();
                        break;
                    }
                    case 78: {
                        this.connection.addWarning(this.pg_stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 80: {
                        String pname = this.pg_stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 84: {
                        this.receiveFields();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                throw new SQLException(errorMessage.toString());
            }
            ResultSet resultSet = this.connection.getResultSet(this.statement, this.fields, this.tuples, this.status, this.update_count, this.insert_oid, this.binaryCursor);
            return resultSet;
        }
    }

    private void sendQuery() throws SQLException {
        try {
            this.pg_stream.SendChar(81);
            int i = 0;
            while (i < this.m_binds.length) {
                if (this.m_binds[i] == null) {
                    throw new PSQLException("postgresql.prep.param", new Integer(i + 1));
                }
                this.pg_stream.Send(this.connection.getEncoding().encode(this.m_sqlFrags[i]));
                this.pg_stream.Send(this.connection.getEncoding().encode(this.m_binds[i].toString()));
                ++i;
            }
            this.pg_stream.Send(this.connection.getEncoding().encode(this.m_sqlFrags[this.m_binds.length]));
            this.pg_stream.SendChar(0);
            this.pg_stream.flush();
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.con.ioerror", e);
        }
    }

    private void receiveTuple(boolean isBinary) throws SQLException {
        if (this.fields == null) {
            throw new PSQLException("postgresql.con.tuple");
        }
        byte[][] tuple = this.pg_stream.ReceiveTuple(this.fields.length, isBinary);
        if (isBinary) {
            this.binaryCursor = true;
        }
        if (this.maxRows == 0 || this.tuples.size() < this.maxRows) {
            this.tuples.addElement(tuple);
        }
    }

    private void receiveCommandStatus() throws SQLException {
        this.status = this.pg_stream.ReceiveString(this.connection.getEncoding());
        try {
            if (this.status.startsWith("INSERT") || this.status.startsWith("UPDATE") || this.status.startsWith("DELETE") || this.status.startsWith("MOVE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("INSERT")) {
                this.insert_oid = Long.parseLong(this.status.substring(1 + this.status.indexOf(32), this.status.lastIndexOf(32)));
            }
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException("postgresql.con.fathom", (Object)this.status);
        }
    }

    private void receiveFields() throws SQLException {
        if (this.fields != null) {
            throw new PSQLException("postgresql.con.multres");
        }
        int size = this.pg_stream.ReceiveIntegerR(2);
        this.fields = new Field[size];
        int i = 0;
        while (i < this.fields.length) {
            String typeName = this.pg_stream.ReceiveString(this.connection.getEncoding());
            int typeOid = this.pg_stream.ReceiveIntegerR(4);
            int typeLength = this.pg_stream.ReceiveIntegerR(2);
            int typeModifier = this.pg_stream.ReceiveIntegerR(4);
            this.fields[i] = new Field(this.connection, typeName, typeOid, typeLength, typeModifier);
            ++i;
        }
    }
}

