/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.dom;

import java.io.IOException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.impl.URILocationImpl;
import org.exolab.adaptx.util.NestedIOException;
import org.exolab.adaptx.xml.SAXURILocation;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xslt.dom.Root;
import org.exolab.adaptx.xslt.dom.XPNBuilder;
import org.exolab.adaptx.xslt.util.Configuration;
import org.exolab.adaptx.xslt.util.SAXInput;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPNReader {
    private static final String REUSE_ERR = "This XPNReader was previously used. Please create a new one.";
    private URILocation _location = null;
    private Parser _parser = null;
    private boolean _saveLocation = false;
    private boolean _usable = true;

    public XPNReader(String string) throws IOException {
        if (string == null) {
            String string2 = "The argument 'url' may not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._location = new URILocationImpl(string);
        this.initParser();
    }

    public XPNReader(URILocation uRILocation) throws IOException {
        if (uRILocation == null) {
            String string = "The argument 'location' may not be null.";
            throw new IllegalArgumentException(string);
        }
        this._location = uRILocation;
        this.initParser();
    }

    private void initParser() throws IOException {
        this._parser = Configuration.getSAXParser();
        if (this._parser == null) {
            throw new NestedIOException("unable to create SAX parser.");
        }
    }

    public XPathNode read() throws IOException {
        Object object;
        Object object2;
        Object object3 = this;
        synchronized (object3) {
            if (!this._usable) {
                throw new IOException(REUSE_ERR);
            }
            this._usable = false;
        }
        object3 = null;
        InputSource inputSource = null;
        if (this._location instanceof SAXURILocation) {
            object2 = (SAXURILocation)this._location;
            object3 = ((SAXURILocation)object2).getXMLReader();
            inputSource = ((SAXURILocation)object2).getInputSource();
        }
        object2 = null;
        try {
            if (inputSource == null) {
                inputSource = new InputSource();
                inputSource.setSystemId(this._location.getAbsoluteURI());
                inputSource.setCharacterStream(this._location.getReader());
            }
            if (object3 != null) {
                object = new SAXInput(this._saveLocation);
                object3.setContentHandler((ContentHandler)object);
                object3.parse(inputSource);
                object2 = ((SAXInput)object).getRoot();
            } else {
                object = new XPNBuilder();
                ((XPNBuilder)object).setSaveLocation(this._saveLocation);
                this._parser.setDocumentHandler((DocumentHandler)object);
                this._parser.parse(inputSource);
                object2 = ((XPNBuilder)object).getRoot();
            }
        }
        catch (SAXException sAXException) {
            SAXParseException sAXParseException = null;
            Exception exception = sAXException.getException();
            if (sAXException instanceof SAXParseException) {
                sAXParseException = (SAXParseException)sAXException;
            } else if (exception != null && exception instanceof SAXParseException) {
                sAXParseException = (SAXParseException)exception;
            }
            if (sAXParseException != null) {
                StringBuffer stringBuffer = new StringBuffer(((SAXException)sAXParseException).toString());
                stringBuffer.append("\n - ");
                stringBuffer.append(sAXParseException.getSystemId());
                stringBuffer.append("; line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append(", column: ");
                stringBuffer.append(sAXParseException.getColumnNumber());
                throw new NestedIOException(stringBuffer.toString(), sAXException);
            }
            throw new NestedIOException(sAXException);
        }
        object = (Root)object2;
        ((Root)object).setDocumentURI(this._location.getAbsoluteURI());
        return object;
    }

    public void setSaveLocation(boolean bl) {
        this._saveLocation = bl;
    }
}

