/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.AbstractPathComponent;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.LocationStepImpl;
import org.exolab.adaptx.xpath.expressions.PathComponent;
import org.exolab.adaptx.xpath.expressions.PathExpr;

class PathExprImpl
extends PathExpr {
    private ErrorExpr error = null;
    private AbstractPathComponent _filter = null;
    private boolean _absolute = false;
    private PathExprImpl _subPath = null;
    private PathExprImpl _parent = null;

    public PathExprImpl() {
    }

    public PathExprImpl(AbstractPathComponent abstractPathComponent) {
        this._filter = abstractPathComponent;
    }

    public PathExprImpl(AbstractPathComponent abstractPathComponent, PathExprImpl pathExprImpl) {
        this._filter = abstractPathComponent;
        this._subPath = pathExprImpl;
        this._subPath._parent = this;
    }

    public PathExprImpl(ErrorExpr errorExpr) {
        this.error = errorExpr;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        return this.evaluate(xPathContext, true);
    }

    protected NodeSet evaluate(XPathContext xPathContext, boolean bl) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        if (this._filter == null || xPathNode == null) {
            return xPathContext.newNodeSet(0);
        }
        XPathContext xPathContext2 = xPathContext;
        if (bl && this.isAbsolute() && xPathNode.getNodeType() != 9) {
            xPathNode = xPathNode.getRootNode();
            xPathContext2 = xPathContext.newContext(xPathNode);
        }
        NodeSet nodeSet = (NodeSet)this._filter.evaluate(xPathContext2);
        if (this._subPath != null && nodeSet.size() > 0) {
            NodeSet nodeSet2 = xPathContext2.newNodeSet();
            XPathContext xPathContext3 = xPathContext2.newContext(nodeSet, 0);
            int n = 0;
            while (n < nodeSet.size()) {
                xPathContext3.setPosition(n);
                nodeSet2.add(this._subPath.evaluate(xPathContext3, false));
                ++n;
            }
            nodeSet = nodeSet2;
        }
        if (nodeSet == null) {
            nodeSet = xPathContext.newNodeSet(0);
        }
        return nodeSet;
    }

    public double getDefaultPriority() {
        if (this._subPath != null) {
            return 0.5;
        }
        return this._filter.getDefaultPriority();
    }

    public PathComponent getPathComponent() {
        return this._filter;
    }

    public PathExpr getSubPath() {
        return this._subPath;
    }

    private boolean hasDescendantsAxis(AbstractPathComponent abstractPathComponent) {
        if (abstractPathComponent.getExprType() == 7) {
            LocationStepImpl locationStepImpl = (LocationStepImpl)abstractPathComponent;
            short s = locationStepImpl.getAxisIdentifier();
            return s == 4 || s == 5;
        }
        return false;
    }

    public boolean isAbsolute() {
        return this._absolute;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        Object object;
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        if (xPathNode == null || this._filter == null) {
            return false;
        }
        XPathContext xPathContext2 = xPathContext.newContext(xPathNode);
        if (this._subPath == null) {
            boolean bl = this.hasDescendantsAxis(this._filter);
            if (this._parent != null) {
                XPathNode xPathNode2 = xPathNode.getParentNode();
                NodeSet nodeSet = xPathContext2.getNodeSet();
                while (xPathNode2 != null) {
                    nodeSet.clear();
                    nodeSet.add(xPathNode2);
                    if (this._filter.matches(xPathNode, xPathContext2)) {
                        return true;
                    }
                    XPathNode xPathNode3 = xPathNode2 = bl ? xPathNode2.getParentNode() : null;
                }
            } else {
                XPathNode xPathNode4 = xPathNode;
                NodeSet nodeSet = xPathContext2.getNodeSet();
                while (xPathNode4 != null) {
                    nodeSet.clear();
                    nodeSet.add(xPathNode4);
                    if (this._filter.matches(xPathNode, xPathContext2)) {
                        return true;
                    }
                    xPathNode4 = xPathNode4.getParentNode();
                }
            }
            return false;
        }
        PathExprImpl pathExprImpl = this;
        while (pathExprImpl._subPath != null) {
            pathExprImpl = pathExprImpl._subPath;
        }
        NodeSet nodeSet = xPathContext.newNodeSet(2);
        NodeSet nodeSet2 = xPathContext.newNodeSet(2);
        NodeSet nodeSet3 = null;
        nodeSet.add(xPathNode);
        while (pathExprImpl != null) {
            object = pathExprImpl._filter;
            boolean bl = this.hasDescendantsAxis((AbstractPathComponent)object);
            int n = 0;
            while (n < nodeSet.size()) {
                NodeSet nodeSet4;
                XPathNode xPathNode5;
                XPathNode xPathNode6 = nodeSet.item(n);
                if (pathExprImpl._parent != null) {
                    xPathNode5 = xPathNode6.getParentNode();
                    while (xPathNode5 != null) {
                        nodeSet4 = xPathContext2.getNodeSet();
                        nodeSet4.clear();
                        nodeSet4.add(xPathNode5);
                        if (((AbstractPathComponent)object).matches(xPathNode6, xPathContext2)) {
                            nodeSet2.add(xPathNode5);
                        }
                        XPathNode xPathNode7 = xPathNode5 = bl ? xPathNode5.getParentNode() : null;
                    }
                } else if (pathExprImpl == this) {
                    xPathNode5 = xPathNode6;
                    nodeSet4 = xPathContext2.getNodeSet();
                    while (xPathNode5 != null) {
                        nodeSet4.clear();
                        nodeSet4.add(xPathNode5);
                        if (((AbstractPathComponent)object).matches(xPathNode6, xPathContext2)) {
                            return true;
                        }
                        xPathNode5 = xPathNode5.getParentNode();
                    }
                } else {
                    return false;
                }
                ++n;
            }
            if (nodeSet2.size() == 0) {
                return false;
            }
            nodeSet.clear();
            nodeSet3 = nodeSet;
            nodeSet = nodeSet2;
            nodeSet2 = nodeSet3;
            if (pathExprImpl == this) break;
            pathExprImpl = pathExprImpl._parent;
        }
        if (this.isAbsolute()) {
            object = xPathNode.getRootNode();
            return nodeSet.contains((XPathNode)object);
        }
        return nodeSet.size() > 0;
    }

    protected final void setAbsolute(boolean bl) {
        if (this._parent != null && bl) {
            String string = "A PathExpr with a parent expression cannot be absolute.";
            throw new IllegalStateException(string);
        }
        this._absolute = bl;
    }

    public void setFilter(AbstractPathComponent abstractPathComponent) {
        this._filter = abstractPathComponent;
    }

    public void setPathComponent(AbstractPathComponent abstractPathComponent) {
        this._filter = abstractPathComponent;
    }

    public void setSubPath(PathExprImpl pathExprImpl) {
        if (this._subPath != null) {
            this._subPath._parent = null;
        }
        this._subPath = pathExprImpl;
        if (this._subPath != null) {
            this._subPath._parent = this;
        }
    }

    public String toString() {
        return this.toString(null);
    }

    private String toString(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (this._filter != null) {
            if (this._parent != null) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this._filter.toString());
        }
        if (this._subPath != null) {
            this._subPath.toString(stringBuffer);
        }
        return stringBuffer.toString();
    }
}

