/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.BinaryExprImpl;
import org.exolab.adaptx.xpath.expressions.Operator;

class OrExpr
extends BinaryExprImpl {
    private static String OR = " or ";
    private static final Operator _operator = new OrOperator();

    public OrExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        return _operator.execute(this.leftExpr, this.rightExpr, xPathContext);
    }

    public short getExprType() {
        return 0;
    }

    public Operator getOperator() {
        return _operator;
    }

    static class OrOperator
    implements Operator {
        OrOperator() {
        }

        public XPathResult execute(XPathExpression xPathExpression, XPathExpression xPathExpression2, XPathContext xPathContext) throws XPathException {
            XPathResult xPathResult = null;
            if (xPathExpression != null && (xPathResult = xPathExpression.evaluate(xPathContext)).booleanValue()) {
                return BooleanResult.TRUE;
            }
            if (xPathExpression2 != null) {
                xPathResult = xPathExpression2.evaluate(xPathContext);
                return BooleanResult.from(xPathResult.booleanValue());
            }
            return BooleanResult.FALSE;
        }

        public XPathResult execute(XPathResult xPathResult, XPathResult xPathResult2) throws XPathException {
            if (xPathResult != null && xPathResult.booleanValue()) {
                return BooleanResult.TRUE;
            }
            if (xPathResult2 != null) {
                return BooleanResult.from(xPathResult2.booleanValue());
            }
            return BooleanResult.FALSE;
        }

        public int getOperatorType() {
            return 6;
        }

        public String toString() {
            return OR;
        }
    }
}

