/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.NumericOperation;
import org.exolab.adaptx.xpath.expressions.Operator;

class NumericOperator
implements Operator {
    private NumericOperation _operation = null;
    private int _type = -1;

    NumericOperator(NumericOperation numericOperation, int n) {
        this._type = n;
        this._operation = numericOperation;
    }

    public XPathResult execute(XPathExpression xPathExpression, XPathExpression xPathExpression2, XPathContext xPathContext) throws XPathException {
        if (xPathExpression == null || xPathExpression2 == null) {
            return NumberResult.NaN;
        }
        double d = xPathExpression.evaluate(xPathContext).numberValue();
        double d2 = xPathExpression2.evaluate(xPathContext).numberValue();
        return new NumberResult(this._operation.execute(d, d2));
    }

    public XPathResult execute(XPathResult xPathResult, XPathResult xPathResult2) throws XPathException {
        if (xPathResult == null || xPathResult2 == null) {
            return NumberResult.NaN;
        }
        double d = xPathResult.numberValue();
        double d2 = xPathResult2.numberValue();
        return new NumberResult(this._operation.execute(d, d2));
    }

    public int getOperatorType() {
        return this._type;
    }

    public String toString() {
        return this._operation.toString();
    }
}

