/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.AbstractPathComponent;
import org.exolab.adaptx.xpath.engine.AttributeExpr;
import org.exolab.adaptx.xpath.engine.AxisIdentifier;
import org.exolab.adaptx.xpath.engine.ElementExpr;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.expressions.LocationStep;
import org.exolab.adaptx.xpath.expressions.NodeExpression;

class LocationStepImpl
extends AbstractPathComponent
implements LocationStep {
    private static final String AXIS_SEPARATOR = "::";
    private short _axisIdentifier = (short)3;
    private NodeExpression _nodeExpr = null;
    private ErrorExpr _error = null;

    protected LocationStepImpl() {
    }

    protected LocationStepImpl(ErrorExpr errorExpr) {
        this._error = errorExpr;
    }

    protected LocationStepImpl(short s) {
        this._axisIdentifier = s;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode;
        if (this._error != null) {
            this._error.evaluate(xPathContext);
        }
        if ((xPathNode = xPathContext.getNode()) == null || this._nodeExpr == null) {
            return xPathContext.newNodeSet();
        }
        NodeSet nodeSet = null;
        switch (this._axisIdentifier) {
            case 0: {
                nodeSet = AxisIdentifier.fromAncestors(this._nodeExpr, xPathContext);
                break;
            }
            case 1: {
                nodeSet = AxisIdentifier.fromAncestorsOrSelf(this._nodeExpr, xPathContext);
                break;
            }
            case 2: {
                nodeSet = AxisIdentifier.fromAttributes(this._nodeExpr, xPathContext);
                break;
            }
            case 12: {
                nodeSet = AxisIdentifier.fromNamespaces(this._nodeExpr, xPathContext);
                break;
            }
            case 4: {
                nodeSet = AxisIdentifier.fromDescendants(this._nodeExpr, xPathContext);
                break;
            }
            case 5: {
                nodeSet = AxisIdentifier.fromDescendantsOrSelf(this._nodeExpr, xPathContext);
                break;
            }
            case 6: {
                nodeSet = AxisIdentifier.fromFollowing(this._nodeExpr, xPathContext);
                break;
            }
            case 7: {
                nodeSet = AxisIdentifier.fromFollowingSiblings(this._nodeExpr, xPathContext);
                break;
            }
            case 8: {
                nodeSet = AxisIdentifier.fromParent(this._nodeExpr, xPathContext);
                break;
            }
            case 9: {
                nodeSet = AxisIdentifier.fromPreceding(this._nodeExpr, xPathContext);
                break;
            }
            case 10: {
                nodeSet = AxisIdentifier.fromPrecedingSiblings(this._nodeExpr, xPathContext);
                break;
            }
            case 11: {
                nodeSet = AxisIdentifier.fromSelf(this._nodeExpr, xPathContext);
                break;
            }
            default: {
                nodeSet = AxisIdentifier.fromChildren(this._nodeExpr, xPathContext);
            }
        }
        if (this.hasPredicates()) {
            this.evaluatePredicates(nodeSet, xPathContext);
        }
        return nodeSet;
    }

    public short getAxisIdentifier() {
        return this._axisIdentifier;
    }

    public double getDefaultPriority() {
        if (this._nodeExpr == null) {
            return -0.5;
        }
        double d = -0.5;
        switch (this._nodeExpr.getNodeExprType()) {
            case 8: {
                d = 0.0;
                break;
            }
            case 2: {
                d = ((ElementExpr)this._nodeExpr).getDefaultPriority();
                break;
            }
            case 1: {
                d = ((AttributeExpr)this._nodeExpr).getDefaultPriority();
                break;
            }
        }
        if (this.getPredicate() != null) {
            d = 0.5;
        }
        return d;
    }

    public short getExprType() {
        return 7;
    }

    public NodeExpression getNodeExpr() {
        return this._nodeExpr;
    }

    public XPathExpression getSubExpression() {
        return this.getNodeExpr();
    }

    public boolean isFilterExpr() {
        return false;
    }

    public boolean isLocationStep() {
        return true;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (this._nodeExpr == null) {
            return false;
        }
        if (this.hasPredicates()) {
            NodeSet nodeSet = (NodeSet)this.evaluate(xPathContext);
            return nodeSet.contains(xPathNode);
        }
        return this._nodeExpr.matches(xPathNode, xPathContext);
    }

    void setAxisIdentifier(short s) {
        this._axisIdentifier = s;
    }

    void setNodeExpr(NodeExpression nodeExpression) {
        this._nodeExpr = nodeExpression;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        switch (this._axisIdentifier) {
            case 0: {
                stringBuffer.append("ancestor");
                break;
            }
            case 1: {
                stringBuffer.append("ancestor-or-self");
                break;
            }
            case 2: {
                stringBuffer.append("attribute");
                break;
            }
            case 4: {
                stringBuffer.append("descendant");
                break;
            }
            case 5: {
                stringBuffer.append("descendant-or-self");
                break;
            }
            case 6: {
                stringBuffer.append("following");
                break;
            }
            case 7: {
                stringBuffer.append("following-sibling");
                break;
            }
            case 8: {
                stringBuffer.append("parent");
                break;
            }
            case 9: {
                stringBuffer.append("preceding");
                break;
            }
            case 10: {
                stringBuffer.append("preceding-sibling");
                break;
            }
            case 11: {
                stringBuffer.append("self");
                break;
            }
            case 12: {
                stringBuffer.append("namespace");
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            stringBuffer.append(AXIS_SEPARATOR);
        }
        if (this._nodeExpr == null) {
            stringBuffer.append(super.toString());
        } else {
            stringBuffer.append(this._nodeExpr.toString());
            stringBuffer.append(super.toString());
        }
        return stringBuffer.toString();
    }
}

