/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.NodeExpressionImpl;

class ElementExpr
extends NodeExpressionImpl {
    private static final String NS_WILDCARD_PREFIX = "*:";
    private static final String WILD_CARD = "*";
    private String _name = null;
    private boolean _namespaceIsWild = false;
    private String _prefix = null;
    private boolean _nameIsWild = false;

    ElementExpr(String string) throws XPathException {
        if (string == null) {
            throw new XPathException("Argument qname is null");
        }
        if (string.equals(WILD_CARD)) {
            this._nameIsWild = true;
            this._namespaceIsWild = true;
        } else {
            this._name = string;
            if (string.startsWith(NS_WILDCARD_PREFIX)) {
                this._name = string.substring(2);
                this._namespaceIsWild = true;
                this._prefix = WILD_CARD;
            } else {
                int n = string.indexOf(58);
                if (n > 0) {
                    this._prefix = string.substring(0, n);
                    this._name = string.substring(n + 1);
                }
                if (this._name.equals(WILD_CARD)) {
                    this._nameIsWild = true;
                }
            }
        }
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = xPathContext.newNodeSet();
        XPathNode xPathNode = xPathContext.getNode();
        if (xPathNode == null) {
            return nodeSet;
        }
        XPathNode xPathNode2 = xPathNode.getFirstChild();
        while (xPathNode2 != null) {
            if (this.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        return nodeSet;
    }

    public double getDefaultPriority() {
        if (this._namespaceIsWild) {
            return -0.5;
        }
        if (this._nameIsWild) {
            return -0.25;
        }
        return 0.0;
    }

    public short getExprType() {
        return 3;
    }

    public String getName() {
        if (this._prefix == null) {
            return this._name;
        }
        return String.valueOf(this._prefix) + ':' + this._name;
    }

    public short getNodeExprType() {
        return 2;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (xPathNode == null) {
            return false;
        }
        if (xPathNode.getNodeType() == 1) {
            String string = xPathNode.getLocalName();
            if (this._namespaceIsWild) {
                if (this._nameIsWild) {
                    return true;
                }
                return string.equals(this._name);
            }
            if (this._prefix == null) {
                String string2 = xPathNode.getNamespaceURI();
                if (string2 != null && string2.length() > 0) {
                    return false;
                }
                return this._nameIsWild || string.equals(this._name);
            }
            if (!this._nameIsWild && !string.equals(this._name)) {
                return false;
            }
            String string3 = xPathContext.getNamespaceURI(this._prefix);
            if (string3 == null) {
                throw new XPathException("Unable to resolve namespace for prefix: " + this._prefix);
            }
            return string3.equals(xPathNode.getNamespaceURI());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

