/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.functions.FalseFunctionCall;
import org.exolab.adaptx.xpath.functions.TrueFunctionCall;

class BooleanExpr
implements XPathExpression {
    private XPathExpression expr = null;

    public BooleanExpr() {
        this(null);
    }

    public BooleanExpr(XPathExpression xPathExpression) {
        this.expr = xPathExpression;
    }

    public BooleanExpr(boolean bl) {
        this.expr = bl ? new TrueFunctionCall() : new FalseFunctionCall();
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.expr != null) {
            return BooleanResult.from(this.expr.evaluate(xPathContext));
        }
        return BooleanResult.FALSE;
    }

    public short getExprType() {
        return 0;
    }

    public String toString() {
        if (this.expr != null) {
            return this.expr.toString();
        }
        return "false()";
    }
}

