/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xml.parser;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXPDOMParser
implements DOMParser {
    private DocumentBuilderFactory _factory = null;
    private DocumentBuilder _builder = null;

    public JAXPDOMParser() {
        this._factory = DocumentBuilderFactory.newInstance();
        this._factory.setNamespaceAware(false);
    }

    private JAXPDOMParser(DocumentBuilderFactory documentBuilderFactory) {
        this._factory = documentBuilderFactory;
    }

    public DOMParser copyInstance() {
        return new JAXPDOMParser(this._factory);
    }

    public Document createDocument() {
        if (this._builder == null) {
            try {
                this._builder = this._factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                String string = "An exception of type '" + parserConfigurationException.getClass().getName();
                string = String.valueOf(string) + "' occurred while attempting to create a new Document instance; " + parserConfigurationException.getMessage();
                throw new IllegalStateException(string);
            }
        }
        return this._builder.newDocument();
    }

    public Document readDocument(URILocation uRILocation, ErrorObserver errorObserver) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = this._factory.newDocumentBuilder();
            InputSource inputSource = new InputSource(uRILocation.getReader());
            inputSource.setSystemId(uRILocation.getAbsoluteURI());
            document = documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "An exception of type '" + parserConfigurationException.getClass().getName();
            string = String.valueOf(string) + "' occurred while attempting to read document '" + uRILocation.getAbsoluteURI() + "';\n " + parserConfigurationException.getMessage();
            if (errorObserver != null) {
                errorObserver.receiveError(string, 0);
            } else {
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            String string = "error while trying to read document '";
            string = String.valueOf(string) + uRILocation.getAbsoluteURI() + "';\n " + iOException.toString();
            if (errorObserver != null) {
                errorObserver.receiveError(string, 0);
            } else {
                System.out.println(string);
            }
        }
        catch (SAXException sAXException) {
            String string = "error while trying to read document '";
            string = String.valueOf(string) + uRILocation.getAbsoluteURI() + "';\n " + sAXException.getMessage();
            if (sAXException instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)sAXException;
                string = String.valueOf(string) + "\n   -- error occured at line ";
                string = String.valueOf(string) + sAXParseException.getLineNumber();
                string = String.valueOf(string) + ", column " + sAXParseException.getColumnNumber();
            }
            if (errorObserver != null) {
                errorObserver.receiveError(string, 0);
            }
            System.out.println(string);
        }
        return document;
    }

    public void setDocumentType(Document document, String string) {
    }

    public void setValidation(boolean bl) {
        this._factory.setValidating(bl);
    }
}

