/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.jaxp.transform;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exolab.adaptx.jaxp.transform.ErrorListenerWrapper;
import org.exolab.adaptx.jaxp.transform.URIResolverWrapper;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.impl.URILocationImpl;
import org.exolab.adaptx.net.impl.URIUtils;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xslt.ResultHandler;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLOutput;
import org.exolab.adaptx.xslt.XSLTProcessor;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.dom.Root;
import org.exolab.adaptx.xslt.handlers.DOMBuilder;
import org.exolab.adaptx.xslt.handlers.DefaultHandler;
import org.exolab.adaptx.xslt.handlers.ResultHandlerAdapter2;
import org.exolab.adaptx.xslt.util.Configuration;
import org.exolab.adaptx.xslt.util.SAXInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TransformerImpl
extends Transformer {
    private XSLTProcessor _processor = new XSLTProcessor();
    private XSLTStylesheet _stylesheet = null;
    private URIResolverWrapper _uriResolver = null;
    private ErrorListenerWrapper _errorObserver = null;
    private Properties _outputProperties = null;

    public TransformerImpl() {
    }

    public TransformerImpl(XSLTStylesheet xSLTStylesheet) {
        this._stylesheet = xSLTStylesheet;
    }

    public void clearParameters() {
        this._processor.removeAllParameters();
    }

    public ErrorListener getErrorListener() {
        if (this._errorObserver == null) {
            return null;
        }
        return this._errorObserver.getListener();
    }

    public Properties getOutputProperties() {
        if (this._outputProperties == null) {
            return new Properties();
        }
        return new Properties(this._outputProperties);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        if (this._outputProperties == null) {
            return null;
        }
        return this._outputProperties.getProperty(string);
    }

    public Object getParameter(String string) {
        return this._processor.getParameter(string);
    }

    public XSLTProcessor getProcessor() {
        return this._processor;
    }

    public static final ResultHandler getResultHandler(Result result) throws TransformerException {
        ResultHandler resultHandler = null;
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            Writer writer = null;
            if (streamResult.getOutputStream() != null) {
                writer = new OutputStreamWriter(streamResult.getOutputStream());
            } else if (streamResult.getWriter() != null) {
                writer = streamResult.getWriter();
            } else if (streamResult.getSystemId() != null) {
                try {
                    writer = URIUtils.getWriter(streamResult.getSystemId(), null);
                }
                catch (IOException iOException) {
                    throw new TransformerException(iOException);
                }
            } else {
                String string = "Invalid StreamResult, missing Writer, or OutputStream.";
                throw new TransformerException(string);
            }
            resultHandler = new DefaultHandler(writer);
        } else if (result instanceof DOMResult) {
            DOMResult dOMResult = (DOMResult)result;
            Node node = dOMResult.getNode();
            if (node == null) {
                DOMParser dOMParser = Configuration.getDOMParser();
                Document document = dOMParser.createDocument();
                dOMResult.setNode(document);
                resultHandler = new DOMBuilder(document);
            } else {
                resultHandler = new DOMBuilder(node);
            }
        } else if (result instanceof SAXResult) {
            resultHandler = new ResultHandlerAdapter2(((SAXResult)result).getHandler());
        } else {
            String string = "The Result of type '" + result.getClass().getName();
            string = String.valueOf(string) + "' is not supported by this Transformer.";
            throw new TransformerException(string);
        }
        return resultHandler;
    }

    public URIResolver getURIResolver() {
        if (this._uriResolver != null) {
            return this._uriResolver.getResolver();
        }
        return null;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (this._errorObserver != null) {
            this._processor.removeErrorObserver(this._errorObserver);
        }
        this._errorObserver = errorListener == null ? null : new ErrorListenerWrapper(errorListener);
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            this._processor.setOutputProperties(null);
            this._outputProperties = null;
        } else {
            this._outputProperties = new Properties();
            XSLOutput xSLOutput = new XSLOutput();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this._outputProperties.setProperty(string, string2);
                try {
                    xSLOutput.setAttribute(string, string2);
                }
                catch (XSLException xSLException) {
                    throw new IllegalArgumentException("Invalid property: " + string);
                }
            }
            this._processor.setOutputProperties(xSLOutput);
        }
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (this._outputProperties == null) {
            this._outputProperties = new Properties();
            this._processor.setOutputProperties(new XSLOutput());
        }
        try {
            XSLOutput xSLOutput = this._processor.getOutputProperties();
            xSLOutput.setAttribute(string, string2);
        }
        catch (XSLException xSLException) {
            throw new IllegalArgumentException("Invalid property: " + string);
        }
        this._outputProperties.setProperty(string, string2);
    }

    public void setParameter(String string, Object object) {
        this._processor.setParameter(string, object.toString());
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver == null ? null : new URIResolverWrapper(uRIResolver);
        this._processor.setURIResolver(this._uriResolver);
    }

    public void transform(Source source, Result result) throws TransformerException {
        ResultHandler resultHandler = TransformerImpl.getResultHandler(result);
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            URILocationImpl uRILocationImpl = null;
            String string = streamSource.getSystemId();
            if (string == null) {
                string = streamSource.getPublicId();
            }
            uRILocationImpl = streamSource.getInputStream() != null ? new URILocationImpl(streamSource.getInputStream(), string) : (streamSource.getReader() != null ? new URILocationImpl(streamSource.getReader(), string) : new URILocationImpl(string));
            this._processor.process((URILocation)uRILocationImpl, this._stylesheet, resultHandler);
        } else if (source instanceof DOMSource) {
            Object object;
            DOMSource dOMSource = (DOMSource)source;
            Node node = dOMSource.getNode();
            boolean bl = false;
            if (node == null) {
                object = Configuration.getDOMParser();
                Document document = object.createDocument();
                node = document;
            }
            switch (node.getNodeType()) {
                case 9: {
                    this._processor.process((Document)node, this._stylesheet, resultHandler);
                    break;
                }
                default: {
                    object = "Invalid node type. Only Document and Element nodes are supported as input to a trasformation.";
                    throw new TransformerException((String)object);
                }
            }
            if (bl) {
                dOMSource.setNode(node);
            }
        } else if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            InputSource inputSource = sAXSource.getInputSource();
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (inputSource == null) {
                this._processor.process((XPathNode)new Root(), this._stylesheet, resultHandler);
            } else {
                SAXInput sAXInput = new SAXInput();
                sAXInput.setProcessor(this._processor);
                sAXInput.setOutputHandler(resultHandler);
                sAXInput.setStylesheet(this._stylesheet);
                if (xMLReader == null) {
                    xMLReader = Configuration.getXMLReader();
                }
                try {
                    xMLReader.setContentHandler(sAXInput);
                    xMLReader.parse(inputSource);
                }
                catch (SAXException sAXException) {
                    throw new TransformerException(sAXException);
                }
                catch (IOException iOException) {
                    throw new TransformerException(iOException);
                }
            }
        } else {
            String string = "The Source of type '" + source.getClass().getName();
            string = String.valueOf(string) + "' is not supported by this Transformer.";
            throw new TransformerException(string);
        }
    }
}

