/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.JsonDecoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class Util {
    Util() {
    }

    static BufferedInputStream fileOrStdin(String filename, InputStream stdin) throws IOException {
        if (filename.equals("-")) {
            return new BufferedInputStream(stdin);
        }
        String[] parts = filename.split(":");
        if (parts.length == 1) {
            return new BufferedInputStream(new FileInputStream(new File(filename)));
        }
        if (parts[0].equals("hdfs")) {
            FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)new Configuration());
            return new BufferedInputStream((InputStream)fs.open(new Path(filename)));
        }
        throw new FileNotFoundException();
    }

    static BufferedOutputStream fileOrStdout(String filename, OutputStream stdout) throws IOException {
        if (filename.equals("-")) {
            return new BufferedOutputStream(stdout);
        }
        String[] parts = filename.split(":");
        if (parts.length == 1) {
            return new BufferedOutputStream(new FileOutputStream(new File(filename)));
        }
        if (parts[0].equals("hdfs")) {
            FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)new Configuration());
            return new BufferedOutputStream((OutputStream)fs.create(new Path(filename)));
        }
        throw new FileNotFoundException();
    }

    static Object jsonToGenericDatum(Schema schema, String jsonData) throws IOException {
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
        Object datum = reader.read(null, new JsonDecoder(schema, jsonData));
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object datumFromFile(Schema schema, String file) throws IOException {
        DataFileReader in = new DataFileReader(new File(file), new GenericDatumReader(schema));
        try {
            Object d = in.next();
            return d;
        }
        finally {
            in.close();
        }
    }
}

