/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.util.Utf8;

public class BlockingBinaryEncoder
extends BinaryEncoder {
    private byte[] buf;
    private int pos;
    private BlockedValue[] blockStack;
    private int stackTop = -1;
    private static final int STACK_STEP = 10;
    private EncoderBuffer encoderBuffer = new EncoderBuffer();
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private static final int MIN_BUFFER_SIZE = 64;

    private boolean check() {
        assert (this.out != null);
        assert (this.buf != null);
        assert (64 <= this.buf.length);
        assert (0 <= this.pos);
        assert (this.pos <= this.buf.length) : this.pos + " " + this.buf.length;
        assert (this.blockStack != null);
        BlockedValue prev = null;
        for (int i = 0; i <= this.stackTop; ++i) {
            BlockedValue v = this.blockStack[i];
            v.check(prev, this.pos);
            prev = v;
        }
        return true;
    }

    public BlockingBinaryEncoder(OutputStream out) {
        this(out, 65536);
    }

    public BlockingBinaryEncoder(OutputStream out, int bufferSize) {
        super(out);
        if (bufferSize < 64) {
            throw new IllegalArgumentException("Buffer size too smll.");
        }
        this.buf = new byte[bufferSize];
        this.pos = 0;
        this.blockStack = new BlockedValue[0];
        this.expandStack();
        BlockedValue bv = this.blockStack[++this.stackTop];
        bv.type = null;
        bv.state = BlockedValue.State.ROOT;
        bv.lastFullItem = 0;
        bv.start = 0;
        bv.items = 1;
        assert (this.check());
    }

    private void expandStack() {
        int oldLength = this.blockStack.length;
        this.blockStack = Arrays.copyOf(this.blockStack, this.blockStack.length + 10);
        for (int i = oldLength; i < this.blockStack.length; ++i) {
            this.blockStack[i] = new BlockedValue();
        }
    }

    @Override
    public void init(OutputStream out) throws IOException {
        super.init(out);
        this.pos = 0;
        this.stackTop = 0;
        assert (this.check());
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            BlockedValue bv = this.blockStack[this.stackTop];
            if (bv.state == BlockedValue.State.ROOT) {
                this.out.write(this.buf, 0, this.pos);
                this.pos = 0;
            } else {
                while (bv.state != BlockedValue.State.OVERFLOW) {
                    this.compact();
                }
            }
            this.out.flush();
        }
        assert (this.check());
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        if (this.buf.length < this.pos + 1) {
            this.ensure(1);
        }
        this.buf[this.pos++] = (byte)(b ? 1 : 0);
        assert (this.check());
    }

    @Override
    public void writeInt(int n) throws IOException {
        if (this.pos + 5 > this.buf.length) {
            this.ensure(5);
        }
        this.pos = BlockingBinaryEncoder.encodeLong(n, this.buf, this.pos);
        assert (this.check());
    }

    @Override
    public void writeLong(long n) throws IOException {
        if (this.pos + 10 > this.buf.length) {
            this.ensure(10);
        }
        this.pos = BlockingBinaryEncoder.encodeLong(n, this.buf, this.pos);
        assert (this.check());
    }

    @Override
    public void writeFloat(float f) throws IOException {
        if (this.pos + 4 > this.buf.length) {
            this.ensure(4);
        }
        this.pos = BlockingBinaryEncoder.encodeFloat(f, this.buf, this.pos);
        assert (this.check());
    }

    @Override
    public void writeDouble(double d) throws IOException {
        if (this.pos + 8 > this.buf.length) {
            this.ensure(8);
        }
        this.pos = BlockingBinaryEncoder.encodeDouble(d, this.buf, this.pos);
        assert (this.check());
    }

    @Override
    public void writeString(Utf8 utf8) throws IOException {
        this.writeBytes(utf8.getBytes(), 0, utf8.getLength());
        assert (this.check());
    }

    @Override
    public void writeBytes(ByteBuffer bytes) throws IOException {
        this.writeBytes(bytes.array(), bytes.position(), bytes.remaining());
        assert (this.check());
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.doWriteBytes(bytes, start, len);
        assert (this.check());
    }

    @Override
    public void writeEnum(int e) throws IOException {
        this.writeInt(e);
    }

    @Override
    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        if (this.pos + 5 > this.buf.length) {
            this.ensure(5);
        }
        this.pos = BlockingBinaryEncoder.encodeLong(len, this.buf, this.pos);
        this.doWriteBytes(bytes, start, len);
        assert (this.check());
    }

    @Override
    public void writeArrayStart() throws IOException {
        if (this.stackTop + 1 == this.blockStack.length) {
            this.expandStack();
        }
        BlockedValue bv = this.blockStack[++this.stackTop];
        bv.type = Schema.Type.ARRAY;
        bv.state = BlockedValue.State.REGULAR;
        bv.start = bv.lastFullItem = this.pos;
        bv.items = 0;
        assert (this.check());
    }

    @Override
    public void setItemCount(long itemCount) throws IOException {
        BlockedValue v = this.blockStack[this.stackTop];
        assert (v.type == Schema.Type.ARRAY || v.type == Schema.Type.MAP);
        assert (v.itemsLeftToWrite == 0L);
        v.itemsLeftToWrite = itemCount;
        assert (this.check());
    }

    @Override
    public void startItem() throws IOException {
        if (this.blockStack[this.stackTop].state == BlockedValue.State.OVERFLOW) {
            this.finishOverflow();
        }
        BlockedValue t = this.blockStack[this.stackTop];
        ++t.items;
        t.lastFullItem = this.pos;
        --t.itemsLeftToWrite;
        assert (this.check());
    }

    @Override
    public void writeArrayEnd() throws IOException {
        BlockedValue top = this.blockStack[this.stackTop];
        if (top.type != Schema.Type.ARRAY) {
            throw new AvroTypeException("Called writeArrayEnd outside of an array.");
        }
        if (top.itemsLeftToWrite != 0L) {
            throw new AvroTypeException("Failed to write expected number of array elements.");
        }
        this.endBlockedValue();
        assert (this.check());
    }

    @Override
    public void writeMapStart() throws IOException {
        if (this.stackTop + 1 == this.blockStack.length) {
            this.expandStack();
        }
        BlockedValue bv = this.blockStack[++this.stackTop];
        bv.type = Schema.Type.MAP;
        bv.state = BlockedValue.State.REGULAR;
        bv.start = bv.lastFullItem = this.pos;
        bv.items = 0;
        assert (this.check());
    }

    @Override
    public void writeMapEnd() throws IOException {
        BlockedValue top = this.blockStack[this.stackTop];
        if (top.type != Schema.Type.MAP) {
            throw new AvroTypeException("Called writeMapEnd outside of a map.");
        }
        if (top.itemsLeftToWrite != 0L) {
            throw new AvroTypeException("Failed to read write expected number of array elements.");
        }
        this.endBlockedValue();
        assert (this.check());
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        if (this.pos + 5 > this.buf.length) {
            this.ensure(5);
        }
        this.pos = BlockingBinaryEncoder.encodeLong(unionIndex, this.buf, this.pos);
        assert (this.check());
    }

    private void endBlockedValue() throws IOException {
        while (true) {
            assert (this.check());
            BlockedValue t = this.blockStack[this.stackTop];
            assert (t.state != BlockedValue.State.ROOT);
            if (t.state == BlockedValue.State.OVERFLOW) {
                this.finishOverflow();
            }
            assert (t.state == BlockedValue.State.REGULAR);
            if (0 >= t.items) break;
            int byteCount = this.pos - t.start;
            if (t.start == 0 && this.blockStack[this.stackTop - 1].state != BlockedValue.State.REGULAR) {
                BlockingBinaryEncoder.encodeLong(-t.items, this.out);
                BlockingBinaryEncoder.encodeLong(byteCount, this.out);
                break;
            }
            BlockingBinaryEncoder.encodeLong(-t.items, this.encoderBuffer);
            BlockingBinaryEncoder.encodeLong(byteCount, this.encoderBuffer);
            int headerSize = this.encoderBuffer.length();
            if (this.buf.length >= this.pos + headerSize) {
                this.pos += headerSize;
                int m = t.start;
                System.arraycopy(this.buf, m, this.buf, m + headerSize, byteCount);
                System.arraycopy(this.encoderBuffer.buffer(), 0, this.buf, m, headerSize);
                this.encoderBuffer.reset();
                break;
            }
            this.encoderBuffer.reset();
            this.compact();
        }
        --this.stackTop;
        if (this.buf.length < this.pos + 1) {
            this.ensure(1);
        }
        this.buf[this.pos++] = 0;
        assert (this.check());
        if (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT) {
            this.flush();
        }
    }

    private void finishOverflow() throws IOException {
        BlockedValue s = this.blockStack[this.stackTop];
        if (s.state != BlockedValue.State.OVERFLOW) {
            throw new IllegalStateException("Not an overflow block");
        }
        assert (this.check());
        this.out.write(this.buf, 0, this.pos);
        this.pos = 0;
        s.state = BlockedValue.State.REGULAR;
        s.lastFullItem = 0;
        s.start = 0;
        s.items = 0;
        assert (this.check());
    }

    private void ensure(int l) throws IOException {
        if (this.buf.length < l) {
            throw new IllegalArgumentException("Too big: " + l);
        }
        while (this.buf.length < this.pos + l) {
            if (this.blockStack[this.stackTop].state == BlockedValue.State.REGULAR) {
                this.compact();
                continue;
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
    }

    private void doWriteBytes(byte[] bytes, int start, int len) throws IOException {
        if (len < this.buf.length) {
            this.ensure(len);
            System.arraycopy(bytes, start, this.buf, this.pos, len);
            this.pos += len;
        } else {
            this.ensure(this.buf.length);
            assert (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT || this.blockStack[this.stackTop].state == BlockedValue.State.OVERFLOW);
            this.write(bytes, start, len);
        }
        assert (this.check());
    }

    private void write(byte[] b, int off, int len) throws IOException {
        if (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT) {
            this.out.write(b, off, len);
        } else {
            assert (this.check());
            while (this.buf.length < this.pos + len) {
                if (this.blockStack[this.stackTop].state == BlockedValue.State.REGULAR) {
                    this.compact();
                    continue;
                }
                this.out.write(this.buf, 0, this.pos);
                this.pos = 0;
                if (this.buf.length > len) continue;
                this.out.write(b, off, len);
                len = 0;
            }
            System.arraycopy(b, off, this.buf, this.pos, len);
            this.pos += len;
            assert (this.check());
        }
    }

    private void compact() throws IOException {
        int i;
        assert (this.check());
        BlockedValue s = null;
        for (i = 1; i <= this.stackTop; ++i) {
            s = this.blockStack[i];
            if (s.state == BlockedValue.State.REGULAR) break;
        }
        assert (s != null);
        this.out.write(this.buf, 0, s.start);
        if (1 < s.items) {
            BlockingBinaryEncoder.encodeLong(-(s.items - 1), this.out);
            BlockingBinaryEncoder.encodeLong(s.lastFullItem - s.start, this.out);
            this.out.write(this.buf, s.start, s.lastFullItem - s.start);
            s.start = s.lastFullItem;
            s.items = 1;
        }
        BlockingBinaryEncoder.encodeLong(1L, this.out);
        BlockedValue n = i + 1 <= this.stackTop ? this.blockStack[i + 1] : null;
        int end = n == null ? this.pos : n.start;
        this.out.write(this.buf, s.lastFullItem, end - s.lastFullItem);
        System.arraycopy(this.buf, end, this.buf, 0, this.pos - end);
        for (int j = i + 1; j <= this.stackTop; ++j) {
            n = this.blockStack[j];
            n.start -= end;
            n.lastFullItem -= end;
        }
        this.pos -= end;
        assert (s.items == 1);
        s.lastFullItem = 0;
        s.start = 0;
        s.state = BlockedValue.State.OVERFLOW;
        assert (this.check());
    }

    private static final class EncoderBuffer
    extends ByteArrayOutputStream {
        private EncoderBuffer() {
        }

        public byte[] buffer() {
            return this.buf;
        }

        public int length() {
            return this.count;
        }
    }

    private static class BlockedValue {
        public Schema.Type type = null;
        public State state = State.ROOT;
        public int start = 0;
        public int lastFullItem = 0;
        public int items = 1;
        public long itemsLeftToWrite;

        public boolean check(BlockedValue prev, int pos) {
            assert (this.state != State.ROOT || this.type == null);
            assert (this.state == State.ROOT || this.type == Schema.Type.ARRAY || this.type == Schema.Type.MAP);
            assert (0 <= this.items);
            assert (0 != this.items || this.start == pos);
            assert (1 < this.items || this.start == this.lastFullItem);
            assert (this.items <= 1 || this.start <= this.lastFullItem);
            assert (this.lastFullItem <= pos);
            switch (this.state) {
                case ROOT: {
                    assert (this.start == 0);
                    assert (prev == null);
                    break;
                }
                case REGULAR: {
                    assert (this.start >= 0);
                    assert (prev.lastFullItem <= this.start);
                    assert (1 <= prev.items);
                    break;
                }
                case OVERFLOW: {
                    assert (this.start == 0);
                    assert (this.items == 1);
                    assert (prev.state == State.ROOT || prev.state == State.OVERFLOW);
                    break;
                }
            }
            return false;
        }

        public static enum State {
            ROOT,
            REGULAR,
            OVERFLOW;

        }
    }
}

