
+++
title = "anemone"
description = "A minimalist Zola theme that prioritizes clean CSS and avoids heavy JavaScript. Enjoy a seamless user experience with lightning-fast load times. Let your content take center stage in a clutter-free, elegant design that enhances readability. Responsive and efficient, anemone brings focus to your ideas."
template = "theme.html"
date = 2023-11-11T02:14:17+03:00

[extra]
created = 2023-11-11T02:14:17+03:00
updated = 2023-11-11T02:14:17+03:00
repository = "https://github.com/Speyll/anemone"
homepage = "https://github.com/Speyll/anemone"
minimum_version = "0.4.0"
license = "MIT"
demo = "https://anemone.pages.dev"

[extra.author]
name = "Speyll"
homepage = "https://speyllsite.pages.dev/"
+++        

# anemone

Introducing "anemone," a minimalist [Zola](https://www.getzola.org) theme that prioritizes clean CSS and avoids heavy JavaScript. Enjoy a seamless user experience with lightning-fast load times. Let your content take center stage in a clutter-free, elegant design that enhances readability. Responsive and efficient, anemone brings focus to your ideas.

You can browse the demo website [here](https://anemone.pages.dev/)
I also use it on my own [website.](https://speyllsite.pages.dev/)

Anemone is a versatile Zola theme that comes with both light and dark variants. You can easily switch between the light and dark themes to suit your preferences.

![Anemone Light and Dark Theme](screenshot.png)

### Installation

To get started with Anemone, follow these simple steps:

1. Download the theme to your `themes` directory:

```bash
cd themes
git clone https://github.com/Speyll/anemone
```

2. Enable Anemone in your `config.toml`:

```toml
theme = "anemone"
```

### Options

Anemone provides various options to customize your website:

#### Default Taxonomies

To use tags, add the following code to a page's metadata:

```toml
[taxonomies]
tags = ["tag1", "tag2"]
```

#### Pages List in Homepage

Enable listing of pages in the homepage by adding the following code to `config.toml`:

```toml
[extra]
list_pages = true
```

#### Multilanguage

The theme has a built-in feature that allows you to use multiple languages. For detailed instructions on how to use this feature, you can refer to the [Zola Multilingual documentation](https://www.getzola.org/documentation/content/multilingual/). This documentation provides additional information on how to make the most out of this multilingual capability.

```toml
[languages.en]
weight = 1
title = "anemone"
languageName = "English"
languageCode = "en"
relativeURL = false

[languages.fr]
weight = 2
title = "anemone"
languageName = "Français"
languageCode = "fr"
relativeURL = false

taxonomies = [
    {name = "tags", feed = true},
]
```
#### Multilanguage-Ready Navigation Bar

Customize the header navigation links with the following code in the `extra` section of `config.toml`:

```toml
[extra]

[[extra.header_nav]]
en = { name = "/home/", url = "/" }
fr = { name = "/accueil/", url = "/fr" }

[[extra.header_nav]]
en = { name = "/about/", url = "/about" }
fr = { name = "/concernant/", url = "/about" }

[[extra.header_nav]]
en = { name = "/journal/", url = "/journal" }
fr = { name = "/journal/", url = "/journal" }

[[extra.header_nav]]
en = { name = "/blog/", url = "/blog" }
fr = { name = "/blog/", url = "/blog" }
```

### Webrings

Add a webring with a shortcode:

```html
{{/* webring(prev="#", webring="#", webringName="Random Webring", next="#") */}}
```

#### Add Table of Contents (TOC) to Pages

In a page's frontmatter, set `extra.toc` to `true`:

```toml
[extra]
toc = true
```

### Extra Data

- Set the `author` in both the main config and in pages' metadata.
- Use the `image` variable in pages to add an image to HTML `<meta>` tags.
- Similarly, set `favicon` in the main config, and it will be used as the site icon.

#### Disable Twitter Card

Twitter metatags are generated by default. To disable them, set `extra.twitter_card` to `false` in `config.toml`:

```toml
[extra]
twitter_card = true
```

### License

The Anemone theme is available as open source under the terms of the [MIT License](https://opensource.org/licenses/MIT).

        