static BANNER: &str = "
██╗  ██╗██╗    ███████╗██████╗  ██████╗ ███╗   ███╗    ███████╗███████╗██╗     ██╗     ██╗     ██╗██╗
██║  ██║██║    ██╔════╝██╔══██╗██╔═══██╗████╗ ████║    ╚══███╔╝██╔════╝██║     ██║     ██║     ██║██║
███████║██║    █████╗  ██████╔╝██║   ██║██╔████╔██║      ███╔╝ █████╗  ██║     ██║     ██║     ██║██║
██╔══██║██║    ██╔══╝  ██╔══██╗██║   ██║██║╚██╔╝██║     ███╔╝  ██╔══╝  ██║     ██║     ██║██   ██║╚═╝
██║  ██║██║    ██║     ██║  ██║╚██████╔╝██║ ╚═╝ ██║    ███████╗███████╗███████╗███████╗██║╚█████╔╝██╗
╚═╝  ╚═╝╚═╝    ╚═╝     ╚═╝  ╚═╝ ╚═════╝ ╚═╝     ╚═╝    ╚══════╝╚══════╝╚══════╝╚══════╝╚═╝ ╚════╝ ╚═╝
";

static SMALL_BANNER: &str = "
██╗  ██╗██╗    ██╗
██║  ██║██║    ██║
███████║██║    ██║
██╔══██║██║    ╚═╝
██║  ██║██║    ██╗
╚═╝  ╚═╝╚═╝    ╚═╝
";

static MEDIUM_BANNER: &str = "
██╗  ██╗██╗    ████████╗██╗  ██╗███████╗██████╗ ███████╗    ██╗
██║  ██║██║    ╚══██╔══╝██║  ██║██╔════╝██╔══██╗██╔════╝    ██║
███████║██║       ██║   ███████║█████╗  ██████╔╝█████╗      ██║
██╔══██║██║       ██║   ██╔══██║██╔══╝  ██╔══██╗██╔══╝      ╚═╝
██║  ██║██║       ██║   ██║  ██║███████╗██║  ██║███████╗    ██╗
╚═╝  ╚═╝╚═╝       ╚═╝   ╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝╚══════╝    ╚═╝                 
";

pub fn render_banner(x: usize, y: usize, rows: usize, cols: usize) {
    if rows >= 8 {
        if cols > 100 {
            println!("\u{1b}[{}H", y + rows.saturating_sub(8) / 2);
            for line in BANNER.lines() {
                println!("\u{1b}[{}C{}", x.saturating_sub(1), line);
            }
        } else if cols > 63 {
            println!("\u{1b}[{}H", y + rows.saturating_sub(8) / 2);
            let x = (cols.saturating_sub(63) as f64 / 2.0) as usize;
            for line in MEDIUM_BANNER.lines() {
                println!("\u{1b}[{}C{}", x, line);
            }
        } else {
            println!("\u{1b}[{}H", y + rows.saturating_sub(8) / 2);
            let x = (cols.saturating_sub(18) as f64 / 2.0) as usize;
            for line in SMALL_BANNER.lines() {
                println!("\u{1b}[{}C{}", x, line);
            }
        }
    } else if rows > 2 {
        println!(
            "\u{1b}[{};{}H\u{1b}[1mHi from Zellij!",
            (y + rows / 2) + 1,
            (x + cols.saturating_sub(15) / 2).saturating_sub(1)
        );
    }
}

pub fn render_welcome_boundaries(rows: usize, cols: usize) {
    let width_of_main_menu = std::cmp::min(cols, 101);
    let has_room_for_logos = cols.saturating_sub(width_of_main_menu) > 100;
    let left_boundary_x = (cols.saturating_sub(width_of_main_menu) as f64 / 2.0).floor() as usize;
    let right_boundary_x = left_boundary_x + width_of_main_menu;
    let y_starting_point = rows.saturating_sub(15) / 2;
    let middle_row =
        (y_starting_point + rows.saturating_sub(y_starting_point) / 2).saturating_sub(1);
    for i in y_starting_point..rows {
        if i == middle_row {
            if has_room_for_logos {
                print!("\u{1b}[{};{}H┤", i + 1, left_boundary_x + 1);
                print!(
                    "\u{1b}[m\u{1b}[{};{}H├\u{1b}[K",
                    i + 1,
                    right_boundary_x + 1
                );
                print!("\u{1b}[{};{}H", i + 1, left_boundary_x.saturating_sub(9));
                for _ in 0..10 {
                    print!("─");
                }
                print!("\u{1b}[{};{}H", i + 1, right_boundary_x + 2);
                for _ in 0..10 {
                    print!("─");
                }
            } else {
                print!("\u{1b}[{};{}H│", i + 1, left_boundary_x + 1);
                print!(
                    "\u{1b}[m\u{1b}[{};{}H│\u{1b}[K",
                    i + 1,
                    right_boundary_x + 1
                );
            }
        } else {
            if i == y_starting_point {
                print!("\u{1b}[{};{}H┌", i + 1, left_boundary_x + 1);
                print!(
                    "\u{1b}[m\u{1b}[{};{}H┐\u{1b}[K",
                    i + 1,
                    right_boundary_x + 1
                );
            } else if i == rows.saturating_sub(1) {
                print!("\u{1b}[{};{}H└", i + 1, left_boundary_x + 1);
                print!(
                    "\u{1b}[m\u{1b}[{};{}H┘\u{1b}[K",
                    i + 1,
                    right_boundary_x + 1
                );
            } else {
                print!("\u{1b}[{};{}H│", i + 1, left_boundary_x + 1);
                print!(
                    "\u{1b}[m\u{1b}[{};{}H│\u{1b}[K",
                    i + 1,
                    right_boundary_x + 1
                ); // this includes some
                   // ANSI magic to delete
                   // everything after this
                   // boundary in order to
                   // fix some rendering
                   // bugs in the legacy
                   // components of this
                   // plugin
            }
        }
    }
    if rows.saturating_sub(y_starting_point) > 25 && has_room_for_logos {
        for (i, line) in LOGO.lines().enumerate() {
            print!(
                "\u{1b}[{};{}H{}",
                middle_row.saturating_sub(12) + i,
                0,
                line
            );
        }
        for (i, line) in LOGO.lines().enumerate() {
            print!(
                "\u{1b}[{};{}H{}",
                middle_row.saturating_sub(12) + i,
                cols.saturating_sub(47),
                line
            );
        }
    }
}
static LOGO: &str = r#" [38;2;0;0;0m                                               
 [38;2;0;0;0m                                               
 [38;2;0;0;0m                   [38;2;160;186;139m_[38;2;142;164;125my[38;2;148;171;129m$ [38;2;79;88;77my[38;2;151;175;132m@[38;2;131;151;117mg[38;2;163;189;141m_                    
 [38;2;0;0;0m                [38;2;114;130;103my[38;2;156;181;136ma[38;2;159;184;138m@[38;2;163;189;141m@@@[38;2;73;82;73mL[38;2;103;117;95m4[38;2;163;189;141m@@@@[38;2;160;185;138mg[38;2;123;141;110my[38;2;110;125;100m_                
 [38;2;0;0;0m              [38;2;82;92;79mu[38;2;163;189;141m@@@@@@[38;2;160;185;138mF [38;2;85;96;82m"[38;2;143;165;126m@[38;2;163;189;141m@@@@@@[38;2;148;171;129m@[38;2;145;167;127my[38;2;162;188;140m_             
 [38;2;0;0;0m         [38;2;190;97;107m_[38;2;165;84;95ma[38;2;174;88;99m@[38;2;190;97;107m@[38;2;117;59;73m, [38;2;159;184;138m@[38;2;163;189;141m@[38;2;160;186;139m@[38;2;147;170;129mP[38;2;163;189;141m~[38;2;66;73;67m` [38;2;126;159;190m_[38;2;118;149;179m_ [38;2;106;121;97m~[38;2;120;138;108mT[38;2;135;156;120m@[38;2;163;189;141m@@@@@@[38;2;162;188;140m@[38;2;132;152;117mg           
 [38;2;0;0;0m     [38;2;130;66;79m_[38;2;144;73;86my[38;2;187;95;105mg[38;2;189;96;106m@[38;2;190;97;107m@@@@[38;2;174;89;99m$ [38;2;118;136;107m"[38;2;128;147;114m~ [38;2;89;110;138m_[38;2;97;120;149my[38;2;124;156;187mg[38;2;125;158;189m@[38;2;126;159;190m@@[38;2;123;156;186m@[38;2;112;140;170mg[38;2;84;103;131my [38;2;120;138;108m`[38;2;162;188;140m~[38;2;128;148;115mP[38;2;146;168;128mR[38;2;135;155;119m@[38;2;139;160;122mF[38;2;158;183;137m~[38;2;233;202;138m_[38;2;196;170;119my[38;2;234;203;139mg[38;2;217;188;130mg[38;2;180;155;111my[38;2;166;143;104m_      
 [38;2;0;0;0m   [38;2;168;85;97my[38;2;174;89;99m$[38;2;190;97;107m@@@@@@[38;2;184;94;104mP[38;2;139;70;83mF  [38;2;125;158;189m_[38;2;112;141;171my[38;2;116;146;176m$[38;2;126;159;190m@@@@@@@@@@[38;2;125;158;189mg[38;2;100;125;153my[38;2;101;127;155m_   [38;2;206;179;125m4[38;2;232;202;138m@[38;2;234;203;139m@@@@@[38;2;212;183;127m@[38;2;206;178;124my[38;2;145;124;93m_   
 [38;2;0;0;0m  [38;2;189;96;106mg[38;2;190;97;107m@@@@[38;2;178;91;101m@[38;2;168;85;97mF[38;2;187;95;105m~ [38;2;65;79;104m_[38;2;91;113;141my[38;2;120;151;182mg[38;2;124;157;188m@[38;2;126;159;190m@@@@@@@@@@@@@@@@[38;2;119;149;180m@[38;2;101;126;155mg[38;2;126;159;190m_  [38;2;200;173;121m~[38;2;180;156;111mF[38;2;217;188;130m@[38;2;234;203;139m@@@@[38;2;196;169;119m@   
 [38;2;0;0;0m  [38;2;183;93;104m$[38;2;190;97;107m@@@[38;2;189;97;107mF  [38;2;103;128;157my[38;2;126;159;190mg@@@@@@@@@@@@@@@@@@@@@@@@[38;2;122;154;185mg[38;2;75;92;118my  [38;2;206;178;124m9[38;2;234;203;139m@[38;2;199;172;121m@[38;2;193;167;118mF[38;2;106;90;73m"   
 [38;2;0;0;0m  [38;2;182;93;103m$[38;2;190;97;107m@@@[38;2;130;66;79m$ [38;2;79;97;124m4[38;2;126;159;190m@@@@@[38;2;112;140;170m@[38;2;126;159;190m~[38;2;104;130;159m@[38;2;126;159;190m@@@@@@@@@@@@@@@@@@@@  [38;2;82;68;61m"[38;2;154;132;98m_[38;2;183;157;112my[38;2;226;196;135mg[38;2;208;180;126m$   
 [38;2;0;0;0m  [38;2;178;90;101m$[38;2;190;97;107m@@@[38;2;131;66;79m$ [38;2;80;98;125m4[38;2;126;159;190m@@@@[38;2;96;120;148m@   [38;2;108;136;165m~[38;2;105;132;161m@[38;2;126;159;190m@@@@@@@@@@@@@@@@@@  [38;2;168;144;105mg[38;2;234;203;139m@@@[38;2;233;202;138m@   
 [38;2;0;0;0m  [38;2;173;88;99m$[38;2;190;97;107m@@@[38;2;131;66;80m$ [38;2;80;98;125m4[38;2;126;159;190m@@@@@[38;2;118;148;178m@[38;2;91;113;141my   [38;2;109;136;166m~[38;2;107;134;163m@[38;2;126;159;190m@@@@@@@@@@@@@@@@  [38;2;182;157;112m$[38;2;234;203;139m@@[38;2;233;202;138m@[38;2;224;194;134mF   
 [38;2;0;0;0m  [38;2;173;88;99m$[38;2;190;97;107m@@@[38;2;132;67;80m$ [38;2;80;98;125m4[38;2;126;159;190m@@@@@@@[38;2;116;146;176m@[38;2;79;98;124my   [38;2;109;137;166m~[38;2;112;141;171m@[38;2;126;159;190m@@@@@@@@@@@@@@  [38;2;140;120;90m`[38;2;189;163;116m~[38;2;234;203;139m_[38;2;161;138;101my[38;2;182;157;112m_   
 [38;2;0;0;0m  [38;2;173;88;99m$[38;2;190;97;107m@@@[38;2;134;68;81m$ [38;2;80;99;125m4[38;2;126;159;190m@@@@@@@[38;2;114;143;173mP[38;2;113;142;172m`  [38;2;56;67;92m_[38;2;98;122;151mg[38;2;125;158;189m@[38;2;126;159;190m@@@@@@@@@@@@@@  [38;2;148;127;95my[38;2;234;203;139m@@@[38;2;213;184;128m@   
 [38;2;0;0;0m  [38;2;173;88;99m$[38;2;190;97;107m@@@[38;2;139;70;83m$ [38;2;80;99;126m4[38;2;126;159;190m@@@@@[38;2;117;147;177mP[38;2;119;150;180m`  [38;2;52;62;86m_[38;2;109;137;166my[38;2;125;158;189m@[38;2;126;159;190m@@@@@@@@@@@@@@@@  [38;2;163;140;102m4[38;2;234;203;139m@@@[38;2;216;187;129m@   
 [38;2;0;0;0m  [38;2;174;88;99m$[38;2;190;97;107m@@@[38;2;143;73;85m$ [38;2;80;99;126m4[38;2;126;159;190m@@@@[38;2;104;129;158m$[38;2;54;64;89m_  [38;2;108;136;165my[38;2;125;158;189m@[38;2;126;159;190m@@@[38;2;110;139;168m@[38;2;126;159;190m         [38;2;114;144;174m$[38;2;126;159;190m@@@@  [38;2;136;116;88m4[38;2;234;203;139m@@@[38;2;218;189;131m@   
 [38;2;0;0;0m  [38;2;174;88;99m$[38;2;190;97;107m@@@[38;2;145;73;86m$ [38;2;81;99;126m4[38;2;126;159;190m@@@@@@[38;2;113;142;172mg[38;2;124;157;188m@[38;2;126;159;190m@@@@@[38;2;125;158;188m@[38;2;107;135;164m@[38;2;107;134;163m@@@@@@@[38;2;108;136;165m@[38;2;121;153;184m@[38;2;126;159;190m@@@@   [38;2;198;171;120m~[38;2;208;180;125m@[38;2;234;203;139m@[38;2;220;191;132m@   
 [38;2;0;0;0m  [38;2;174;89;99m$[38;2;190;97;107m@@[38;2;184;93;104mP   [38;2;91;113;141m7[38;2;109;137;166mR[38;2;126;159;190m@@@@@@@@@@@@@@@@@@@@@@@[38;2;123;155;186m@[38;2;111;139;169mP[38;2;84;104;131m~ [38;2;117;134;106m_[38;2;129;149;115m@[38;2;140;162;124mg[38;2;83;93;80m_[38;2;174;150;108m7[38;2;222;192;133m@   
 [38;2;0;0;0m  [38;2;145;73;86m~[38;2;168;85;97m~[38;2;140;162;124m_[38;2;125;144;112my[38;2;158;183;137mg[38;2;157;182;137m@[38;2;146;169;128mg[38;2;111;127;101my[38;2;61;67;64m_ [38;2;115;145;175m~[38;2;91;113;141m5[38;2;121;152;182m@[38;2;126;159;190m@@@@@@@@@@@@@@@@[38;2;108;136;165m@[38;2;105;131;160mF[38;2;98;122;151m~ [38;2;145;167;127m_[38;2;130;150;116my[38;2;162;188;140mg[38;2;163;189;141m@@@@[38;2;137;158;121my    
 [38;2;0;0;0m    [38;2;140;161;123mR[38;2;163;189;141m@@@@@@[38;2;113;129;102m@   [38;2;82;101;128m~[38;2;126;159;190m~[38;2;101;126;154m@[38;2;126;159;190m@@@@@@@@@[38;2;125;158;189m@[38;2;118;148;178mP[38;2;126;159;190m~[38;2;84;103;130m` [38;2;112;127;102my[38;2;153;177;133ma[38;2;154;179;134m@[38;2;163;189;141m@@@@@@[38;2;132;152;117m@[38;2;117;134;106mF    
 [38;2;0;0;0m      [38;2;147;170;129m~[38;2;116;132;105m5[38;2;153;177;133m@[38;2;163;189;141m@@@ [38;2;117;134;106m4[38;2;160;185;138m@[38;2;144;166;126mg[38;2;107;122;98my [38;2;62;74;99m`[38;2;122;154;184m~[38;2;109;137;167m4[38;2;124;157;188m@[38;2;126;159;190m@@[38;2;114;143;173m@[38;2;109;137;166mF[38;2;115;145;175m~   [38;2;122;140;110my[38;2;155;179;135m@[38;2;163;189;141m@@@@@[38;2;160;186;139m@[38;2;146;169;128mP[38;2;163;189;141m~[38;2;61;67;63m`      
 [38;2;0;0;0m         [38;2;162;188;140m`[38;2;163;189;141m~[38;2;143;165;126mP [38;2;99;112;92m4[38;2;163;189;141m@@@@[38;2;162;187;140mg[38;2;127;145;113my[38;2;120;137;108m_ [38;2;105;131;160m`[38;2;104;130;159m` [38;2;133;154;118m_[38;2;130;149;116my[38;2;126;145;113mr [38;2;137;158;121ma[38;2;163;189;141m@@@@[38;2;144;167;127m@[38;2;139;160;122mF[38;2;138;159;122m~          
 [38;2;0;0;0m              [38;2;116;132;105m5[38;2;154;178;134m@[38;2;163;189;141m@@@@@[38;2;152;176;133m@[38;2;163;189;141mgg[38;2;147;169;128m@[38;2;161;187;140m@[38;2;148;171;129m~[38;2;103;117;95m_[38;2;162;188;140mg[38;2;163;189;141m@@[38;2;122;140;110m@[38;2;163;189;141m~[38;2;140;161;123m`             
 [38;2;0;0;0m                [38;2;95;108;89m~[38;2;163;189;141m~[38;2;128;147;114m@[38;2;163;189;141m@@@@@[38;2;145;168;127m@[38;2;82;92;79m^[38;2;129;149;115my[38;2;155;180;135m@[38;2;145;168;127mF[38;2;160;185;139m~                 
 [38;2;0;0;0m                   [38;2;71;78;71m`[38;2;157;181;136m~[38;2;140;162;124m4[38;2;149;173;131m@[38;2;151;175;132mF  [38;2;108;124;99m~                    
 [38;2;0;0;0m                                               
 [38;2;0;0;0m                                               "#;
