# Awesome Plugins

Here's a list of awesome xplr plugins that you might want to [check out][48]. If none
of the following plugins work for you, it's very easy to
[write your own][1].

### Extension

- [**sayanarijit/command-mode.xplr**][37] The missing command mode for xplr.
- [**igorepst/context-switch.xplr**][42] Context switch plugin for xplr.
- [**sayanarijit/dual-pane.xplr**][43] Implements support for dual-pane navigation into xplr.
- [**sayanarijit/map.xplr**][38] Visually inspect and interactively execute batch commands using xplr.
- [**sayanarijit/offline-docs.xplr**][51] Fetch the appropriate version of xplr docs and browse offline.
- [**sayanarijit/regex-search.xplr**][55] Bring back the regex based seach in xplr.
- [**sayanarijit/registers.xplr**][49] Use multiple registers to store the selected paths.
- [**sayanarijit/tri-pane.xplr**][56] xplr plugin that implements ranger-like three pane layout.
- [**sayanarijit/type-to-nav.xplr**][28] Inspired by [nnn's type-to-nav mode][29] for xplr,
  with some tweaks.
- [**igorepst/term.xplr**][39] Terminal integration for xplr
- [**sayanarijit/wl-clipboard.xplr**][52] Copy and paste with system clipboard using wl-clipboard
- [**dtomvan/xpm.xplr**][47] The XPLR Plugin Manager

### Integration

- [**sayanarijit/alacritty.xplr**][33] [Alacritty][34] integration for xplr.
- [**sayanarijit/dragon.xplr**][4] Drag and drop files using [dragon][5].
- [**sayanarijit/dua-cli.xplr**][6] Get the disk usage using [dua-cli][7] with selection
  support.
- [**sayanarijit/fzf.xplr**][8] Fuzzy search using [fzf][9] to focus on a file or enter
- [**sayanarijit/find.xplr**][44] An interactive finder plugin to complement [map.xplr][38].
- [**Junker/nuke.xplr**][53] Open files in apps by file type or mime
- [**sayanarijit/nvim-ctrl.xplr**][35] Send files to running Neovim sessions using
  [nvim-ctrl][36].
- [**dtomvan/ouch.xplr**][40] This plugin uses [ouch][41] to compress and decompress files.
- [**dtomvan/paste-rs.xplr**][23] Use this plugin to paste your files to
  [paste.rs][24], and open/delete them later using [fzf][9].
- [**sayanarijit/preview-tabbed.xplr**][10] Preview paths using suckless [tabbed][11] and
  [nnn preview-tabbed][12].
- [**sayanarijit/qrcp.xplr**][26] Send and receive files via QR code using [qrcp][27].
- [**sayanarijit/scp.xplr**][54] Integrate xplr with scp.
- [**sayanarijit/trash-cli.xplr**][13] Trash files and directories using [trash-cli][14].
- [**sayanarijit/xargs.xplr**][22] Batch execute commands on the focused or selected files
  using `xargs`.
- [**sayanarijit/xclip.xplr**][15] Copy and paste with system clipboard using [xclip][16].
- [**sayanarijit/zoxide.xplr**][17] Change directory using the [zoxide][18] database.

### Theme

- [**sayanarijit/material-landscape.xplr**][19] Material Landscape
- [**sayanarijit/material-landscape2.xplr**][20] Material Landscape 2
- [**sayanarijit/zentable.xplr**][31] A clean, distraction free xplr table UI
- [**prncss-xyz/icons.xplr**][30] An icon theme for xplr.
- [**dtomvan/extra-icons.xplr**][50] Adds more icons to icons.xplr, compatible
  with zentable.xplr.

## Also See:

- [Awesome Hacks][45]
- [Awesome Integrations][46]

[1]: writing-plugins.md
[2]: #integration
[3]: #theme
[4]: https://github.com/sayanarijit/dragon.xplr
[5]: https://github.com/mwh/dragon
[6]: https://github.com/sayanarijit/dua-cli.xplr
[7]: https://github.com/Byron/dua-cli
[8]: https://github.com/sayanarijit/fzf.xplr
[9]: https://github.com/junegunn/fzf
[10]: https://github.com/sayanarijit/preview-tabbed.xplr
[11]: https://tools.suckless.org/tabbed/
[12]: https://github.com/jarun/nnn/blob/master/plugins/preview-tabbed
[13]: https://github.com/sayanarijit/trash-cli.xplr
[14]: https://github.com/andreafrancia/trash-cli
[15]: https://github.com/sayanarijit/xclip.xplr
[16]: https://github.com/astrand/xclip
[17]: https://github.com/sayanarijit/zoxide.xplr
[18]: https://github.com/ajeetdsouza/zoxide
[19]: https://github.com/sayanarijit/material-landscape.xplr
[20]: https://github.com/sayanarijit/material-landscape2.xplr
[22]: https://github.com/sayanarijit/xargs.xplr
[23]: https://github.com/dtomvan/paste-rs.xplr
[24]: https://paste.rs
[25]: https://github.com/sayanarijit/completion.xplr
[26]: https://github.com/sayanarijit/qrcp.xplr
[27]: https://github.com/claudiodangelis/qrcp
[28]: https://github.com/sayanarijit/type-to-nav.xplr
[29]: https://github.com/jarun/nnn/wiki/concepts#type-to-nav
[30]: https://github.com/prncss-xyz/icons.xplr
[31]: https://github.com/sayanarijit/zentable.xplr
[32]: #extension
[33]: https://github.com/sayanarijit/alacritty.xplr
[34]: https://github.com/alacritty/alacritty
[35]: https://github.com/sayanarijit/nvim-ctrl.xplr
[36]: https://github.com/chmln/nvim-ctrl
[37]: https://github.com/sayanarijit/command-mode.xplr
[38]: https://github.com/sayanarijit/map.xplr
[39]: https://github.com/igorepst/term.xplr
[40]: https://github.com/dtomvan/ouch.xplr
[41]: https://github.com/ouch-org/ouch
[42]: https://github.com/igorepst/context-switch.xplr
[43]: https://github.com/sayanarijit/dual-pane.xplr
[44]: https://github.com/sayanarijit/find.xplr
[45]: awesome-hacks.md
[46]: awesome-integrations.md
[47]: https://github.com/dtomvan/xpm.xplr
[48]: installing-plugins.md
[49]: https://github.com/sayanarijit/registers.xplr
[50]: https://github.com/dtomvan/extra-icons.xplr
[51]: https://github.com/sayanarijit/offline-docs.xplr
[52]: https://github.com/sayanarijit/wl-clipboard.xplr
[53]: https://github.com/Junker/nuke.xplr
[54]: https://github.com/sayanarijit/scp.xplr
[55]: https://github.com/sayanarijit/regex-search.xplr
[56]: https://github.com/sayanarijit/tri-pane.xplr
