(Updated 13-12-2019)

The following table summarizes the progress that has been made in porting *Whitebox GAT* (Java, Groovy) tools to the new *WhiteboxTools* (Rust) library. Currently, **435 tools** have been added to the *WhiteboxTools* library, including some with no GAT equivalent, and **38 tools** remain to be ported. For those tools that still need to be ported, a priority has been provided.

| *Whitebox GAT* Tool Name                          | *WhiteboxTools* Name                | Priority | Notes                                                                                                                                                                               |
|---------------------------------------------------|-------------------------------------|----------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Absolute Value                                    | AbsoluteValue                       |          |                                                                                                                                                                                     |
| Adaptive Filter                                   | AdaptiveFilter                      |          |                                                                                                                                                                                     |
| Add                                               | Add                                 |          |                                                                                                                                                                                     |
| Add Point Coordinates to Table                    | AddPointCoordinatesToTable          |          |                                                                                                                                                                                     |
| Aggregate                                         | AggregateRaster                     |          |                                                                                                                                                                                     |
| AND                                               | And                                 |          |                                                                                                                                                                                     |
| Append                                            |                                     | 3        |                                                                                                                                                                                     |
| ArcCos                                            | ArcCos                              |          |                                                                                                                                                                                     |
| ArcSin                                            | ArcSin                              |          |                                                                                                                                                                                     |
| ArcTan                                            | ArcTan                              |          |                                                                                                                                                                                     |
| Area                                              | PolygonArea                         |          | Only works for vectors. Still need to create raster equivalent RasterArea                                                                                                           |
| Aspect                                            | Aspect                              |          |                                                                                                                                                                                     |
| Assign Row or Column Number to Cells              | RasterCellAssignment                |          |                                                                                                                                                                                     |
| Atrribute Histogram                               | AttributeHistogram                  |          |                                                                                                                                                                                     |
| Attribute Scattergram                             | AttributeScattergram                |          |                                                                                                                                                                                     |
| Average Flowpath Slope from Cell to Divide        | AverageFlowpathSlope                |          |                                                                                                                                                                                     |
| Average Overlay                                   | AverageOverlay                      |          |                                                                                                                                                                                     |
| Average Uplslope Flowpath Length                  | AverageUpslopeFlowpathLength        |          |                                                                                                                                                                                     |
| Balance Contrast Enhancement                      | BalanceContrastEnhancement          |          |                                                                                                                                                                                     |
| Branch Length                                     | MaxBranchLength                     |          |                                                                                                                                                                                     |
| Breach Depressions                                | BreachDepressionsLeastCost          |          |                                                                                                                                                                                     |
| Breach Depressions (Fast)                         | BreachDepressions                   |          |                                                                                                                                                                                     |
| Breach Single Cell Pits                           | BreachSingleCellPits                |          |                                                                                                                                                                                     |
| Buffer (Raster)                                   | BufferRaster                        |          |                                                                                                                                                                                     |
| Buffer (Vector)                                   |                                     | 3        |                                                                                                                                                                                     |
| Burn Streams                                      |                                     | 1        |                                                                                                                                                                                     |
| Burn Streams at Roads                             | BurnStreamsAtRoads                  |          |                                                                                                                                                                                     |
| Canopy Model (LiDAR)                              | LidarTophatTransform                |          |                                                                                                                                                                                     |
| Ceil                                              | Ceil                                |          |                                                                                                                                                                                     |
| Centroid (Raster)                                 | Centroid                            |          |                                                                                                                                                                                     |
| Centroid (Vector)                                 | CentroidVector                      |          |                                                                                                                                                                                     |
| Change Vector Analysis                            | ChangeVectorAnalysis                |          |                                                                                                                                                                                     |
| Clip                                              | Clip                                |          |                                                                                                                                                                                     |
| Clip Raster to Polygon                            | ClipRasterToPolygon                 |          |                                                                                                                                                                                     |
| Closing                                           | Closing                             |          |                                                                                                                                                                                     |
| Clump Group                                       | Clump                               |          |                                                                                                                                                                                     |
| Cluster Attributes                                |                                     | 3        |                                                                                                                                                                                     |
| Compactness Ratio                                 | CompactnessRatio                    |          | Currently works for vectors only                                                                                                                                                    |
| Compare Images for Difference                     | PairedSampleTTest, TwoSampleKSTest  |          |                                                                                                                                                                                     |
| Conditional Evaluation                            |                                     | 3        |                                                                                                                                                                                     |
| Conservative Smoothing Filter                     | ConservativeSmoothingFilter         |          |                                                                                                                                                                                     |
| Construct TIN                                     | ConstructVectorTin                  |          |                                                                                                                                                                                     |
| Contour                                           |                                     | 2        |                                                                                                                                                                                     |
| Convert LAS to ASCII (LAS2ASCII)                  | LasToAscii                          |          |                                                                                                                                                                                     |
| Convert LAS to MultipointZ Shapefile              | LasToMultipointShapefile            |          |                                                                                                                                                                                     |
| Convert LAS to Shapefile (LAS2Shapefile)          | LasToShapefile                      |          |                                                                                                                                                                                     |
| Convert NoData to Zero                            | ConvertNodataToZero                 |          |                                                                                                                                                                                     |
| Correct Vignetting                                | CorrectVignetting                   |          |                                                                                                                                                                                     |
| Correlation For Attributes                        | AttributeCorrelation                |          |                                                                                                                                                                                     |
| Cos                                               | Cos                                 |          |                                                                                                                                                                                     |
| Cosh                                              | Cosh                                |          |                                                                                                                                                                                     |
| Cost Accumulation                                 | CostDistance                        |          |                                                                                                                                                                                     |
| Cost Allocation                                   | CostAllocation                      |          |                                                                                                                                                                                     |
| Cost Pathway                                      | CostPathway                         |          |                                                                                                                                                                                     |
| Create Blank Outlet Raster                        | NewRasterFromBase                   |          |                                                                                                                                                                                     |
| Create Colour Composite                           | CreateColourComposite               |          |                                                                                                                                                                                     |
| Create Hexagonal Vector Grid                      | CreateHexagonalVectorGrid           |          |                                                                                                                                                                                     |
| Create Multiscale Topographic Position Image      | MultiscaleTopographicPositionImage  |          |                                                                                                                                                                                     |
| Create Plane                                      | CreatePlane                         |          |                                                                                                                                                                                     |
| Create Rectangular Vector Grid                    | CreateRectangularVectorGrid         |          |                                                                                                                                                                                     |
| Crispness Index                                   | CrispnessIndex                      |          |                                                                                                                                                                                     |
| Cross Tabulation                                  | CrossTabulation                     |          |                                                                                                                                                                                     |
| Cumulative Distribution Function                  | CumulativeDistribution              |          |                                                                                                                                                                                     |
| D-infinity Flow Accumulation                      | DInfFlowAccumulation                |          |                                                                                                                                                                                     |
| D-infinity Flow Pointer                           | DInfPointer                         |          |                                                                                                                                                                                     |
| D-Infinity Mass Flux                              | DInfMassFlux                        |          |                                                                                                                                                                                     |
| D8 Flow Accumulation                              | D8FlowAccumulation                  |          |                                                                                                                                                                                     |
| D8 Flow Pointer                                   | D8Pointer                           |          |                                                                                                                                                                                     |
| D8 Mass Flux                                      | D8MassFlux                          |          |                                                                                                                                                                                     |
| D8 Pointer (Parallel)                             | D8Pointer                           |          |                                                                                                                                                                                     |
| De-noise DEM                                      | Use FeaturePreservingDenoise        |          |                                                                                                                                                                                     |
| Decrement                                         | Decrement                           |          |                                                                                                                                                                                     |
| Delete Small Lakes and Extend Rivers              |                                     | 3        |                                                                                                                                                                                     |
| Depth in Sink                                     | DepthInSink                         |          |                                                                                                                                                                                     |
| Deviation from Mean Elevation                     | DevFromMeanElev                     |          |                                                                                                                                                                                     |
| Difference                                        | Erase                               |          |                                                                                                                                                                                     |
| Difference from Mean Elevation                    | DiffFromMeanElev                    |          |                                                                                                                                                                                     |
| Difference-of-Gaussian Filters                    | DiffOfGaussianFilter                |          |                                                                                                                                                                                     |
| Direct Decorrelation Stretch                      | DirectDecorrelationStretch          |          |                                                                                                                                                                                     |
| Directional Relief                                | DirectionalRelief                   |          |                                                                                                                                                                                     |
| Discrete Sibson (Natural Neighbour) Interpolation | NaturalNeighbourInterpolation       |          |                                                                                                                                                                                     |
| Discrete Sibson Interpolation (LiDAR)             |                                     | 1        |                                                                                                                                                                                     |
| Dissolve                                          | Dissolve                            |          |                                                                                                                                                                                     |
| Distance to Outlet                                | DistanceToOutlet                    |          |                                                                                                                                                                                     |
| Distributions                                     |                                     | 3        |                                                                                                                                                                                     |
| Diversity Filter                                  | DiversityFilter                     |          |                                                                                                                                                                                     |
| Divide                                            | Divide                              |          |                                                                                                                                                                                     |
| Downslope Distance to Stream                      | DownslopeDistanceToStream           |          |                                                                                                                                                                                     |
| Downslope Flowpath Length                         | DownslopeFlowpathLength             |          |                                                                                                                                                                                     |
| Downslope Index                                   | DownslopeIndex                      |          |                                                                                                                                                                                     |
| Downslope Index (Radius)                          |                                     | 3        |                                                                                                                                                                                     |
| Edge Proportion                                   | EdgeProportion                      |          |                                                                                                                                                                                     |
| Edge-Preserving Smoothing Filter                  | BilateralFilter                     |          |                                                                                                                                                                                     |
| Elevation above Pit                               | ElevAbovePit                        |          |                                                                                                                                                                                     |
| Elevation above Stream                            | ElevationAboveStream                |          |                                                                                                                                                                                     |
| Elevation Percentile (Image Histogram)            | ElevPercentile                      |          |                                                                                                                                                                                     |
| Elevation Relative to Min and Max                 | ElevRelativeToMinMax                |          |                                                                                                                                                                                     |
| Elevation Relative to Watershed Min and Max       | ElevRelativeToWatershedMinMax       |          |                                                                                                                                                                                     |
| Eliminate Coincident Points                       | EliminateCoincidentPoints           |          |                                                                                                                                                                                     |
| Elongation Ratio                                  | ElongationRatio                     |          | Need to addd raster functionality                                                                                                                                                   |
| Emboss Filter                                     | EmbossFilter                        |          |                                                                                                                                                                                     |
| Equal To                                          | EqualTo                             |          |                                                                                                                                                                                     |
| Euclidean Allocation                              | EuclideanAllocation                 |          |                                                                                                                                                                                     |
| Euclidean Distance                                | EuclideanDistance                   |          |                                                                                                                                                                                     |
| Erase Polygon from Raster                         | ErasePolygonFromRaster              |          |                                                                                                                                                                                     |
| Estimate Heights from Parallax                    |                                     | 3        |                                                                                                                                                                                     |
| Exp                                               | Exp                                 |          |                                                                                                                                                                                     |
| Export ArcGIS ASCII Grid                          | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export ArcGIS Binary Grid (.flt)                  | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export GeoTiff                                    | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export GRASS ASCII Grid                           | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export IDRISI Raster (.rst)                       | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export SAGA Grid                                  | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export Surfer ASCII Grid                          | ConvertRasterFormat                 |          |                                                                                                                                                                                     |
| Export Table to CSV                               | ExportTableToCsv                    |          |                                                                                                                                                                                     |
| Exposure Towards a wind flux                      |                                     | 2        |                                                                                                                                                                                     |
| Extend Vector Lines                               | ExtendVectorLines                   |          |                                                                                                                                                                                     |
| Extract Nodes                                     | ExtractNodes                        |          |                                                                                                                                                                                     |
| Extract Raster Values at Points                   | ExtractRasterValuesAtPoints         |          |                                                                                                                                                                                     |
| Extract Statistics                                | ZonalStatistics                     |          |                                                                                                                                                                                     |
| Extract Streams                                   | ExtractStreams                      |          |                                                                                                                                                                                     |
| Extract Valleys (Johnson and Rosenfeld)           | ExtractValleys                      |          | --variant='JandR'                                                                                                                                                                   |
| Extract Valleys (Lower Quartile)                  | ExtractValleys                      |          | --variant='lq'                                                                                                                                                                      |
| Extract Valley (Peucker and Douglas)              | ExtractValleys                      |          | --variant='PandD'                                                                                                                                                                   |
| Extract Values at X,Y coordinates                 |                                     | 1        |                                                                                                                                                                                     |
| FD8 Flow Accumulation                             | FD8FlowAccumulation                 |          |                                                                                                                                                                                     |
| FD8 Flow Accumulation 2                           | FD8FlowAccumulation                 |          |                                                                                                                                                                                     |
| FD8 Flow Pointer                                  | FD8Pointer                          |          |                                                                                                                                                                                     |
| Fetch Analysis                                    | FetchAnalysis                       |          |                                                                                                                                                                                     |
| FillBurn                                          | FillBurn                            |          |                                                                                                                                                                                     |
| Fill Depressions                                  | FillDepressions                     |          |                                                                                                                                                                                     |
| Fill Depressions (Planchon and Darboux)           | FillDepressions                     |          |                                                                                                                                                                                     |
| Fill Missing Data Holes                           | FillMissingData                     |          |                                                                                                                                                                                     |
| Fill Single-Cell Pits                             | FillSingleCellPits                  |          |                                                                                                                                                                                     |
| Filter LAS Scan Angles                            | FilterLidarScanAngles               |          |                                                                                                                                                                                     |
| Find Flightline Edge Points                       | FindFlightlineEdgePoints            |          |                                                                                                                                                                                     |
| Find Lowest/Highest Locations                     | FindLowestOrHighestPoints           |          |                                                                                                                                                                                     |
| Find Main Stem                                    | FindMainStem                        |          |                                                                                                                                                                                     |
| Find No-Flow Cells                                | FindNoFlowCells                     |          |                                                                                                                                                                                     |
| Find Parallel Flow                                | FindParallelFlow                    |          |                                                                                                                                                                                     |
| Find Patch or Class Edge Cells                    | FindPatchOrClassEdgeCells           |          |                                                                                                                                                                                     |
| Find Ridges                                       | FindRidges                          |          |                                                                                                                                                                                     |
| Find Tie Points                                   |                                     | 3        |                                                                                                                                                                                     |
| Flip Image                                        | FlipImage                           |          |                                                                                                                                                                                     |
| Flood Order                                       | FloodOrder                          |          |                                                                                                                                                                                     |
| Floor                                             | Floor                               |          |                                                                                                                                                                                     |
| Fractal Dimension                                 |                                     | 1        |                                                                                                                                                                                     |
| Furthest Upstream Channel Head Distance           | FarthestChannelHead                 |          |                                                                                                                                                                                     |
| Fuse                                              | Union                               |          |                                                                                                                                                                                     |
| Fuzzy Membership                                  |                                     | 1        |                                                                                                                                                                                     |
| Gaussian Contrast Stretch                         | GaussianContrastStretch             |          |                                                                                                                                                                                     |
| Gaussian Filter                                   | GaussianFilter                      |          |                                                                                                                                                                                     |
| Get LAS File Summary                              | LasInfo                             |          |                                                                                                                                                                                     |
| Greater Than                                      | GreaterThan                         |          |                                                                                                                                                                                     |
| Greater Than Equal To                             | GreaterThan                         |          | With --incl_equals flag                                                                                                                                                             |
| Ground Point Separation (LiDAR)                   | LidarGroundPointFilter              |          |                                                                                                                                                                                     |
| Hack Stream Order                                 | HackStreamOrder                     |          |                                                                                                                                                                                     |
| Hex-binning                                       | VectorHexBinning, LidarHexBinning   |          |                                                                                                                                                                                     |
| High-Pass Filter                                  | HighPassFilter                      |          |                                                                                                                                                                                     |
| Highest Position                                  | HighestPosition                     |          |                                                                                                                                                                                     |
| Hillshade                                         | Hillshade                           |          |                                                                                                                                                                                     |
| Hillslopes                                        | Hillslopes                          |          |                                                                                                                                                                                     |
| Histogram                                         | RasterHistogram                     |          |                                                                                                                                                                                     |
| Histogram Equalization                            | HistogramEqualization               |          |                                                                                                                                                                                     |
| Histogram Matching                                | HistogramMatching                   |          |                                                                                                                                                                                     |
| Histogram Matching (Two Images)                   | HistogramMatchingTwoImages          |          |                                                                                                                                                                                     |
| Hole Proportion                                   | HoleProportion                      |          |                                                                                                                                                                                     |
| Horizon Angle                                     | HorizonAngle                        |          |                                                                                                                                                                                     |
| Horton-Strahler Stream Order                      | StrahlerStreamOrder                 |          |                                                                                                                                                                                     |
| IDW Interpolation (LiDAR)                         | LidarIdwInterpolation               |          | Add the ability to: Exclude points based on max scan angle divation and Interpolate all LAS files within a directory (i.e. directory input rather than single file).                |
| IHS to RGB                                        | IhsToRgb                            |          |                                                                                                                                                                                     |
| Image Autocorrelation                             | ImageAutocorrelation                |          |                                                                                                                                                                                     |
| Image Average                                     | RasterSummaryStats                  |          |                                                                                                                                                                                     |
| Image Correlation                                 | ImageCorrelation                    |          |                                                                                                                                                                                     |
| Image De-Striping                                 |                                     | 1        |                                                                                                                                                                                     |
| Image Rectification                               |                                     | 1        |                                                                                                                                                                                     |
| Image Regression                                  | ImageRegression                     |          |                                                                                                                                                                                     |
| Image Stack Profile                               | ImageStackProfile                   |          |                                                                                                                                                                                     |
| Image Standard Deviation                          | RasterSummaryStats                  |          |                                                                                                                                                                                     |
| Image Total                                       | RasterSummaryStats                  |          |                                                                                                                                                                                     |
| Import CSV                                        | CsvPointsToVector                   |          |                                                                                                                                                                                     |
| Impoundment Index                                 | ImpoundmentIndex                    |          |                                                                                                                                                                                     |
| Increment                                         | Increment                           |          |                                                                                                                                                                                     |
| Integer Division                                  | IntegerDivision                     |          |                                                                                                                                                                                     |
| Integral Image                                    | IntegralImage                       |          |                                                                                                                                                                                     |
| Intersect                                         | Intersect                           |          |                                                                                                                                                                                     |
| Intersection Density                              |                                     | 1        |                                                                                                                                                                                     |
| Inverse Distance Weighted (IDW) Interpolation     | IdwInterpolation                    |          |                                                                                                                                                                                     |
| Inverse Principal Component Analysis              |                                     | 2        |                                                                                                                                                                                     |
| IsNoData                                          | IsNoData                            |          |                                                                                                                                                                                     |
| Isobasin                                          | Isobasins                           |          |                                                                                                                                                                                     |
| Isolate Raster features by Location               |                                     | 1        |                                                                                                                                                                                     |
| Isolate Vector Features by Attribute              |                                     | 2        |                                                                                                                                                                                     |
| Isolate Vector Features by Location               |                                     | 2        |                                                                                                                                                                                     |
| Jenson Snap Pour Points                           | JensonSnapPourPoints                |          | This tool should be updated to take vector pour points as inputs/outputs when vector support has been added.                                                                        |
| Join (LiDAR)                                      | LidarJoin                           |          |                                                                                                                                                                                     |
| Join Tables                                       | JoinTables                          |          |                                                                                                                                                                                     |
| k-Means Classification                            | KMeansClustering                    |          |                                                                                                                                                                                     |
| k-Nearest Mean Filter                             | KNearestMeanFilter                  |          |                                                                                                                                                                                     |
| Kappa Index of Agreement                          | KappaIndex                          |          |                                                                                                                                                                                     |
| Kriging Interpolation                             |                                     | 3        |                                                                                                                                                                                     |
| KS Test for Normality                             | KSTestForNormality                  |          |                                                                                                                                                                                     |
| Laplacian Filter                                  | LaplacianFilter                     |          |                                                                                                                                                                                     |
| Laplacian-of-Gaussian Filter                      | LaplacianOfGaussianFilter           |          |                                                                                                                                                                                     |
| LAS Footprint                                     | LidarTileFootprint                  |          | Now outputs the convex hull of the point cloud. Also works on whole directory of tiles.                                                                                             |
| Layer Footprint                                   | LayerFootprint                      |          |                                                                                                                                                                                     |
| Lee (Sigma) Filter                                | LeeSigmaFilter                      |          |                                                                                                                                                                                     |
| Less Than                                         | LessThan                            |          |                                                                                                                                                                                     |
| Less Than Equal To                                | LessThan                            |          | With --incl_equals flag                                                                                                                                                             |
| LiDAR Elevation Slice                             | LidarElevationSlice                 |          |                                                                                                                                                                                     |
| LiDAR Histogram                                   | LidarHistogram                      |          |                                                                                                                                                                                     |
| LiDAR Segmentation                                | LidarSegmentation                   |          |                                                                                                                                                                                     |
| Linearity Index                                   | LinearityIndex                      |          | Works for vector data only.                                                                                                                                                         |
| Line Thinning                                     | LineThinning                        |          |                                                                                                                                                                                     |
| Line-Detection Filter                             | LineDetectionFilter                 |          |                                                                                                                                                                                     |
| Lines to Polygons                                 | LinesToPolygons                     |          |                                                                                                                                                                                     |
| List Unique Values                                | ListUniqueValues                    |          |                                                                                                                                                                                     |
| Ln (Natural Log)                                  | Ln                                  |          |                                                                                                                                                                                     |
| Local Topographic Position Scale signature        | MaxElevDevSignature                 |          |                                                                                                                                                                                     |
| Locate Principal Point                            |                                     | 1        |                                                                                                                                                                                     |
| Log base 10                                       | Log10                               |          |                                                                                                                                                                                     |
| Log base 2                                        | Log2                                |          |                                                                                                                                                                                     |
| Long Axis                                         | PolygonLongAxis                     |          |                                                                                                                                                                                     |
| Long Profile                                      | LongProfile                         |          |                                                                                                                                                                                     |
| Long Profile from Point                           | LongProfileFromPoints               |          |                                                                                                                                                                                     |
| Lowest Position                                   | LowestPosition                      |          |                                                                                                                                                                                     |
| Majority Fiter (Modal)                            | MajorityFilter                      |          |                                                                                                                                                                                     |
| Max                                               | Max                                 |          |                                                                                                                                                                                     |
| Max Absolute Overlay                              | MaxAbsoluteOverlay                  |          |                                                                                                                                                                                     |
| Max Overlay                                       | MaxOverlay                          |          |                                                                                                                                                                                     |
| Maximum Downslope Elevation Change                | MaxDownslopeElevChange              |          |                                                                                                                                                                                     |
| Maximum Elevation Deviation (Multiscale)          | MaxElevationDeviation               |          |                                                                                                                                                                                     |
| Maximum Filter                                    | MaximumFilter                       |          |                                                                                                                                                                                     |
| Maximum Interpolation (LiDAR)                     | Use BlockMaximum instead            |          |                                                                                                                                                                                     |
| Maximum Upslope Flowpath Length                   | MaxUpslopefFlowpathLength           |          |                                                                                                                                                                                     |
| MDInf Flow Accumulation                           | MDInfFlowAccumulation               |          |                                                                                                                                                                                     |
| Mean Filter                                       | MeanFilter                          |          |                                                                                                                                                                                     |
| Median Filter                                     | MedianFilter                        |          |                                                                                                                                                                                     |
| Medoid                                            | Medoid                              |          |                                                                                                                                                                                     |
| Merge Shapefiles                                  | MergeVectors                        |          |                                                                                                                                                                                     |
| Merge Table with CSV                              | MergeTableWithCsv                   |          |                                                                                                                                                                                     |
| Min                                               | Min                                 |          |                                                                                                                                                                                     |
| Minimum Bounding Box                              | MinimumBoundingBox                  |          |                                                                                                                                                                                     |
| Minimum Convex Hull                               | MinimumConvexHull                   |          |                                                                                                                                                                                     |
| Minimum Interpolation (LiDAR)                     | Use BlockMinimum instead            |          |                                                                                                                                                                                     |
| Min Overlay                                       | MinOverlay                          |          |                                                                                                                                                                                     |
| Min-Max Contrast Stretch                          | MinMaxContrastStretch               |          |                                                                                                                                                                                     |
| Minimum Downslope Elevation Change                | MinDownslopeElevChange              |          |                                                                                                                                                                                     |
| Minimum Filter                                    | MinimumFilter                       |          |                                                                                                                                                                                     |
| Minimum Interpolation                             | BlockMinimumGridding                |          |                                                                                                                                                                                     |
| Modified k-means classification                   | ModifiedKMeansClustering            |          |                                                                                                                                                                                     |
| Modulo                                            | Modulo                              |          |                                                                                                                                                                                     |
| Mosaic                                            | Mosaic                              |          |                                                                                                                                                                                     |
| Mosaic with Feathering                            | MosaicWithFeathering                |          |                                                                                                                                                                                     |
| Multi-parts to Single-parts                       | MultiPartToSinglePart               |          |                                                                                                                                                                                     |
| Multiply                                          | Multiply                            |          |                                                                                                                                                                                     |
| Nearest-Neighbour Analysis                        |                                     | 1        |                                                                                                                                                                                     |
| Nearest Neighbour Interpolation                   | NearestNeighbourGridding            |          |                                                                                                                                                                                     |
| Nearest Neighbour Interpolation (LiDAR)           | LidarNearestNeighbourGridding       |          |                                                                                                                                                                                     |
| Negate                                            | Negate                              |          | This tool differs from the Whitebox GAT equivalent in that in additional to changing the sign of continous data, it also handles Boolean data by reversing values (i.e. 0-1 to 1-0) |
| New Raster From Base                              | NewRasterFromBase                   |          |                                                                                                                                                                                     |
| Normalized Difference Vegetation Index (NDVI)     | NormalizedDifferenceVegetationIndex |          |                                                                                                                                                                                     |
| NOT                                               | Not                                 |          |                                                                                                                                                                                     |
| Not Equal To                                      | NotEqualTo                          |          |                                                                                                                                                                                     |
| Number of Downslope Neighbours                    | NumDownslopeNeighbours              |          |                                                                                                                                                                                     |
| Number of Grid Cells                              | RasterSummaryStats                  |          |                                                                                                                                                                                     |
| Number of Inflowing Neighbours                    | NumInFlowingNeighbours              |          |                                                                                                                                                                                     |
| Number of Upslope Neighbours                      | NumUpslopeNeighbours                |          |                                                                                                                                                                                     |
| Olympic Filter                                    | Olympic Filter                      |          |                                                                                                                                                                                     |
| Opening                                           | Opening                             |          |                                                                                                                                                                                     |
| Optimised Soil-Adjusted Vegetation Index (OSAVI)  | NormalizedDifferenceVegetationIndex |          | Use --osavi flag                                                                                                                                                                    |
| OR                                                | Or                                  |          |                                                                                                                                                                                     |
| Panchromatic Sharpening                           | PanchromaticSharpening              |          |                                                                                                                                                                                     |
| Patch Orientation                                 | PatchOrientation                    |          |                                                                                                                                                                                     |
| PCA For Attributes                                |                                     | 3        |                                                                                                                                                                                     |
| Pennock's Landform Classification                 | PennockLandformClass                |          |                                                                                                                                                                                     |
| Percent Elevation Range                           | PercentElevRange                    |          |                                                                                                                                                                                     |
| Percent Equal To                                  | PercentEqualTo                      |          |                                                                                                                                                                                     |
| Percent Greater Than                              | PercentGreaterThan                  |          |                                                                                                                                                                                     |
| Percent Less Than                                 | PercentLessThan                     |          |                                                                                                                                                                                     |
| Percentage Contrast Stretch                       | PercentageContrastStretch           |          |                                                                                                                                                                                     |
| Percentile Filter                                 | PercentFilter                       |          |                                                                                                                                                                                     |
| Perimeter                                         | PolygonPerimeter                    |          | Currently this works for vectors only; update to work for rasters                                                                                                                   |
| Perimeter-Area Ratio                              | PerimeterAreaRatio                  |          | Currently this works for vectors only; update to work for rasters                                                                                                                   |
| Pick From List                                    | PickFromList                        |          |                                                                                                                                                                                     |
| Plan Curvature                                    | PlanCurvature                       |          |                                                                                                                                                                                     |
| Plot Variogram                                    |                                     | 3        |                                                                                                                                                                                     |
| Point Density                                     |                                     | 2        |                                                                                                                                                                                     |
| Point Density (LiDAR)                             | LidarPointDensity                   |          |                                                                                                                                                                                     |
| Polygonize                                        | Polygonize                          |          |                                                                                                                                                                                     |
| Polygons to Lines                                 | PolygonsToLines                     |          |                                                                                                                                                                                     |
| Power                                             | Power                               |          |                                                                                                                                                                                     |
| Prewitt Filter                                    | PrewittFilter                       |          |                                                                                                                                                                                     |
| Principal Component Analysis                      | PrincipalComponentAnalysis          |          |                                                                                                                                                                                     |
| Profile                                           | Profile                             |          |                                                                                                                                                                                     |
| Profile Curvature                                 | ProfileCurvature                    |          |                                                                                                                                                                                     |
| Prune Vector Stream Network                       |                                     | 1        |                                                                                                                                                                                     |
| Quantile                                          | Quantiles                           |          |                                                                                                                                                                                     |
| Radius of Gyration                                | RadiusOfGyration                    |          |                                                                                                                                                                                     |
| Random Field                                      | RandomField                         |          |                                                                                                                                                                                     |
| Random Sample                                     | RandomSample                        |          |                                                                                                                                                                                     |
| Range Filter                                      | RangeFilter                         |          |                                                                                                                                                                                     |
| Raster Streams to Vector                          | RasterStreamsToVector               |          |                                                                                                                                                                                     |
| Raster to Vector Lines                            | RasterToVectorLines                 |          |                                                                                                                                                                                     |
| Raster to Vector Points                           | RasterToVectorPoints                |          |                                                                                                                                                                                     |
| Raster to Vector Polygons                         | RasterToVectorPolygons              |          |                                                                                                                                                                                     |
| Rasterize Streams                                 | RasterizeStreams                    |          |                                                                                                                                                                                     |
| Rasterize TIN                                     | TINGridding                         |          |                                                                                                                                                                                     |
| Reciprocal                                        | Reciprocal                          |          |                                                                                                                                                                                     |
| Reclass                                           | Reclass                             |          |                                                                                                                                                                                     |
| Reclass Equal Interval                            | ReclassEqualInterval                |          |                                                                                                                                                                                     |
| Reclass From File                                 | ReclassFromFile                     |          |                                                                                                                                                                                     |
| Reinitialize Attribute Table                      | ReinitializeAttributeTable          |          |                                                                                                                                                                                     |
| Related Circumscribing Circle                     | RelatedCircumscribingCircle         |          | Currently works for vectors only.                                                                                                                                                   |
| Relative Aspect                                   | RelativeAspect                      |          |                                                                                                                                                                                     |
| Relative Stream Power Index                       | StreamPowerIndex                    |          |                                                                                                                                                                                     |
| Remove Off-Terrain Objects                        | RemoveOffTerrainObjects             |          |                                                                                                                                                                                     |
| Remove Polygon Holes                              | RemovePolygonHoles                  |          |                                                                                                                                                                                     |
| Remove Short Streams                              | RemoveShortStreams                  |          |                                                                                                                                                                                     |
| Remove Spurs (pruning)                            | RemoveSpurs                         |          |                                                                                                                                                                                     |
| Resample                                          | Resample                            |          |                                                                                                                                                                                     |
| Rescale Image Value Range                         | RescaleValueRange                   |          |                                                                                                                                                                                     |
| RGB to IHS                                        | RgbToIhs                            |          |                                                                                                                                                                                     |
| Rho8 Flow Pointer                                 | Rho8Pointer                         |          |                                                                                                                                                                                     |
| Root Mean Square Error                            | RootMeanSquareError                 |          |                                                                                                                                                                                     |
| Round                                             | Round                               |          |                                                                                                                                                                                     |
| Sediment Transport Index                          | SedimentTransportIndex              |          |                                                                                                                                                                                     |
| Set NoData Value                                  | SetNodataValue                      |          |                                                                                                                                                                                     |
| Shape Complexity Index                            | ShapeComplexityIndex                |          | Currently works for vectors only.                                                                                                                                                   |
| Short Axis                                        | PolygonShortAxis                    |          |                                                                                                                                                                                     |
| Show GeoTiff Tags                                 | PrintGeoTiffTags                    |          |                                                                                                                                                                                     |
| Shreve Stream Magnitude                           | ShreveStreamMagnitude               |          |                                                                                                                                                                                     |
| Sigmoidal Contrast Stretch                        | SigmoidalContrastStretch            |          |                                                                                                                                                                                     |
| Simple Region Grow                                |                                     | 1        |                                                                                                                                                                                     |
| Simplify Line or Polygon                          |                                     | 2        |                                                                                                                                                                                     |
| Sin                                               | Sin                                 |          |                                                                                                                                                                                     |
| Single-parts to Multi-parts                       | SinglePartToMultiPart               |          |                                                                                                                                                                                     |
| Sinh                                              | Sinh                                |          |                                                                                                                                                                                     |
| Sink                                              | Sink                                |          |                                                                                                                                                                                     |
| Slope                                             | Slope                               |          |                                                                                                                                                                                     |
| Smooth                                            | SmoothVectors                       |          |                                                                                                                                                                                     |
| Snap Pour Points                                  | SnapPourPoints                      |          | This tool should be updated to take vector pour points as inputs/outputs when vector support has been added.                                                                        |
| Sobel Filter                                      | SobelFilter                         |          |                                                                                                                                                                                     |
| Split Colour Composite                            | SplitColourComposite                |          |                                                                                                                                                                                     |
| Split Vector Lines                                |                                     | 2        |                                                                                                                                                                                     |
| Square                                            | Square                              |          |                                                                                                                                                                                     |
| Square Root                                       | SquareRoot                          |          |                                                                                                                                                                                     |
| Standard Deviation Filter                         | StandardDeviationFilter             |          |                                                                                                                                                                                     |
| Standard Deviation of Elevation                   | StandardDeviationFilter             |          |                                                                                                                                                                                     |
| Stochastic Depression Analysis                    | StochasticDepressionAnalysis        |          |                                                                                                                                                                                     |
| Strahler-Order Basins                             | StrahlerOrderBasins                 |          |                                                                                                                                                                                     |
| Stream Link Classification                        | StreamLinkClass                     |          |                                                                                                                                                                                     |
| Stream Link Identifier                            | StreamLinkIdentifier                |          |                                                                                                                                                                                     |
| Stream Link Length                                | StreamLinkLength                    |          |                                                                                                                                                                                     |
| Stream Link Slope                                 | StreamLinkSlope                     |          |                                                                                                                                                                                     |
| Stream Slope (Continuous)                         | StreamSlopeContinuous               |          |                                                                                                                                                                                     |
| Sub-basins                                        | Subbasins                           |          |                                                                                                                                                                                     |
| Sutract                                           | Subtract                            |          |                                                                                                                                                                                     |
| Symmetric Difference                              | SymmetricalDifference               |          |                                                                                                                                                                                     |
| Tan                                               | Tan                                 |          |                                                                                                                                                                                     |
| Tangential Curvature                              | TangentialCurvature                 |          |                                                                                                                                                                                     |
| Tanh                                              | Tanh                                |          |                                                                                                                                                                                     |
| Thicken Raster Line                               | ThickenRasterLine                   |          |                                                                                                                                                                                     |
| Tile LAS File                                     | LidarTile                           |          |                                                                                                                                                                                     |
| Topographic Ruggedness Index                      | RuggednessIndex                     |          |                                                                                                                                                                                     |
| Topological Breach-Burn (Stream Burning)          |                                     | 1        |                                                                                                                                                                                     |
| Topological Stream Ordering                       | TopologicalStreamOrder              |          |                                                                                                                                                                                     |
| Total Curvature                                   | TotalCurvature                      |          |                                                                                                                                                                                     |
| Total Filter                                      | TotalFilter                         |          |                                                                                                                                                                                     |
| Total Length of Upstream Channels                 | LengthOfUpstreamChannels            |          |                                                                                                                                                                                     |
| Trace Downslope Flowpaths                         | TraceDownslopeFlowpaths             |          |                                                                                                                                                                                     |
| Trend Surface                                     | TrendSurface                        |          |                                                                                                                                                                                     |
| Trend Surface Vector Points                       | TrendSurfaceVectorPoints            |          |                                                                                                                                                                                     |
| Truncate                                          | Truncate                            |          |                                                                                                                                                                                     |
| Turning Bands Simulation                          | TurningBandsSimulation              |          |                                                                                                                                                                                     |
| Unnest Basins                                     | UnnestBasins                        |          |                                                                                                                                                                                     |
| User-Define Weights filter                        | UserDefinedWeightsFilter            |          |                                                                                                                                                                                     |
| Vector Attribute Gridding                         |                                     | 2        |                                                                                                                                                                                     |
| Vector Cleaning                                   |                                     | 2        |                                                                                                                                                                                     |
| Vector Feature Density                            |                                     | 2        |                                                                                                                                                                                     |
| Vector Lines to Raster                            | VectorLinesToRaster                 |          |                                                                                                                                                                                     |
| Vector Points to Raster                           | VectorPointsToRaster                |          |                                                                                                                                                                                     |
| Vector Polygons to Raster                         | VectorPolygonsToRaster              |          |                                                                                                                                                                                     |
| Vector Stream Analysis                            |                                     | 1        |                                                                                                                                                                                     |
| Viewshed                                          | Viewshed                            |          |                                                                                                                                                                                     |
| Visibility Index                                  | VisibilityIndex                     |          |                                                                                                                                                                                     |
| Voronoi Diagram                                   | VoronoiDiagram                      |          |                                                                                                                                                                                     |
| Wall-in Watershed                                 | RaiseWalls                          |          |                                                                                                                                                                                     |
| Watershed                                         | Watershed                           |          |                                                                                                                                                                                     |
| Weighted Overlay                                  | WeightedOverlay                     |          |                                                                                                                                                                                     |
| Weighted Sum                                      | WeightedSum                         |          |                                                                                                                                                                                     |
| Wetness Index                                     | WetnessIndex                        |          |                                                                                                                                                                                     |
| White Top-Hat Transform                           | TophatTransform                     |          | With --variant='white'                                                                                                                                                              |
| Write Function Memory Insert                      | WriteFunctionMemoryInsertion        |          |                                                                                                                                                                                     |
| XOR                                               | Xor                                 |          |                                                                                                                                                                                     |
| Z-Scores                                          | Zscores                             |          |                                                                                                                                                                                     |
