# Environment variables

uv accepts the following command-line arguments as environment variables:

- `UV_INDEX`: Equivalent to the `--index` command-line argument. If set, uv will use this
  space-separated list of URLs as additional indexes when searching for packages.
- `UV_DEFAULT_INDEX`: Equivalent to the `--default-index` command-line argument. If set, uv will use
  this URL as the default index when searching for packages.
- `UV_INDEX_URL`: Equivalent to the `--index-url` command-line argument. If set, uv will use this
  URL as the default index when searching for packages. (Deprecated: use `UV_DEFAULT_INDEX`
  instead.)
- `UV_EXTRA_INDEX_URL`: Equivalent to the `--extra-index-url` command-line argument. If set, uv will
  use this space-separated list of URLs as additional indexes when searching for packages.
  (Deprecated: use `UV_INDEX` instead.)
- `UV_FIND_LINKS`: Equivalent to the `--find-links` command-line argument. If set, uv will use this
  comma-separated list of additional locations to search for packages.
- `UV_CACHE_DIR`: Equivalent to the `--cache-dir` command-line argument. If set, uv will use this
  directory for caching instead of the default cache directory.
- `UV_NO_CACHE`: Equivalent to the `--no-cache` command-line argument. If set, uv will not use the
  cache for any operations.
- `UV_RESOLUTION`: Equivalent to the `--resolution` command-line argument. For example, if set to
  `lowest-direct`, uv will install the lowest compatible versions of all direct dependencies.
- `UV_PRERELEASE`: Equivalent to the `--prerelease` command-line argument. For example, if set to
  `allow`, uv will allow pre-release versions for all dependencies.
- `UV_SYSTEM_PYTHON`: Equivalent to the `--system` command-line argument. If set to `true`, uv will
  use the first Python interpreter found in the system `PATH`. WARNING: `UV_SYSTEM_PYTHON=true` is
  intended for use in continuous integration (CI) or containerized environments and should be used
  with caution, as modifying the system Python can lead to unexpected behavior.
- `UV_PYTHON`: Equivalent to the `--python` command-line argument. If set to a path, uv will use
  this Python interpreter for all operations.
- `UV_BREAK_SYSTEM_PACKAGES`: Equivalent to the `--break-system-packages` command-line argument. If
  set to `true`, uv will allow the installation of packages that conflict with system-installed
  packages. WARNING: `UV_BREAK_SYSTEM_PACKAGES=true` is intended for use in continuous integration
  (CI) or containerized environments and should be used with caution, as modifying the system Python
  can lead to unexpected behavior.
- `UV_NATIVE_TLS`: Equivalent to the `--native-tls` command-line argument. If set to `true`, uv will
  use the system's trust store instead of the bundled `webpki-roots` crate.
- `UV_INDEX_STRATEGY`: Equivalent to the `--index-strategy` command-line argument. For example, if
  set to `unsafe-any-match`, uv will consider versions of a given package available across all index
  URLs, rather than limiting its search to the first index URL that contains the package.
- `UV_REQUIRE_HASHES`: Equivalent to the `--require-hashes` command-line argument. If set to `true`,
  uv will require that all dependencies have a hash specified in the requirements file.
- `UV_CONSTRAINT`: Equivalent to the `--constraint` command-line argument. If set, uv will use this
  file as the constraints file. Uses space-separated list of files.
- `UV_BUILD_CONSTRAINT`: Equivalent to the `--build-constraint` command-line argument. If set, uv
  will use this file as constraints for any source distribution builds. Uses space-separated list of
  files.
- `UV_OVERRIDE`: Equivalent to the `--override` command-line argument. If set, uv will use this file
  as the overrides file. Uses space-separated list of files.
- `UV_LINK_MODE`: Equivalent to the `--link-mode` command-line argument. If set, uv will use this as
  a link mode.
- `UV_NO_BUILD_ISOLATION`: Equivalent to the `--no-build-isolation` command-line argument. If set,
  uv will skip isolation when building source distributions.
- `UV_CUSTOM_COMPILE_COMMAND`: Equivalent to the `--custom-compile-command` command-line argument.
  Used to override uv in the output header of the `requirements.txt` files generated by
  `uv pip compile`. Intended for use-cases in which `uv pip compile` is called from within a wrapper
  script, to include the name of the wrapper script in the output file.
- `UV_KEYRING_PROVIDER`: Equivalent to the `--keyring-provider` command-line argument. If set, uv
  will use this value as the keyring provider.
- `UV_CONFIG_FILE`: Equivalent to the `--config-file` command-line argument. Expects a path to a
  local `uv.toml` file to use as the configuration file.
- `UV_NO_CONFIG`: Equivalent to the `--no-config` command-line argument. If set, uv will not read
  any configuration files from the current directory, parent directories, or user configuration
  directories.
- `UV_EXCLUDE_NEWER`: Equivalent to the `--exclude-newer` command-line argument. If set, uv will
  exclude distributions published after the specified date.
- `UV_PYTHON_PREFERENCE`: Equivalent to the `--python-preference` command-line argument. Whether uv
  should prefer system or managed Python versions.
- `UV_PYTHON_DOWNLOADS`: Equivalent to the
  [`python-downloads`](../reference/settings.md#python-downloads) setting and, when disabled, the
  `--no-python-downloads` option. Whether uv should allow Python downloads.
- `UV_COMPILE_BYTECODE`: Equivalent to the `--compile-bytecode` command-line argument. If set, uv
  will compile Python source files to bytecode after installation.
- `UV_PUBLISH_URL`: Equivalent to the `--publish-url` command-line argument. The URL of the upload
  endpoint of the index to use with `uv publish`.
- `UV_PUBLISH_TOKEN`: Equivalent to the `--token` command-line argument in `uv publish`. If set, uv
  will use this token (with the username `__token__`) for publishing.
- `UV_PUBLISH_USERNAME`: Equivalent to the `--username` command-line argument in `uv publish`. If
  set, uv will use this username for publishing.
- `UV_PUBLISH_PASSWORD`: Equivalent to the `--password` command-line argument in `uv publish`. If
  set, uv will use this password for publishing.
- `UV_NO_SYNC`: Equivalent to the `--no-sync` command-line argument. If set, uv will skip updating
  the environment.
- `UV_LOCKED`: Equivalent to the `--locked` command-line argument. If set, uv will assert that the
  `uv.lock` remains unchanged.
- `UV_FROZEN`: Equivalent to the `--frozen` command-line argument. If set, uv will run without
  updating the `uv.lock` file.

In each case, the corresponding command-line argument takes precedence over an environment variable.

In addition, uv respects the following environment variables:

- `UV_CONCURRENT_DOWNLOADS`: Sets the maximum number of in-flight concurrent downloads that uv will
  perform at any given time.
- `UV_CONCURRENT_BUILDS`: Sets the maximum number of source distributions that uv will build
  concurrently at any given time.
- `UV_CONCURRENT_INSTALLS`: Used to control the number of threads used when installing and unzipping
  packages.
- `UV_TOOL_DIR`: Used to specify the directory where uv will store managed tools.
- `UV_TOOL_BIN_DIR`: Used to specify the "bin" directory where uv will install tool executables.
- `UV_PROJECT_ENVIRONMENT`: Use to specify the path to the directory to use for a project virtual
  environment. See the
  [project documentation](../concepts/projects.md#configuring-the-project-environment-path) for more
  details.
- `UV_PYTHON_INSTALL_DIR`: Used to specify the directory where uv will store managed Python
  installations.
- `UV_PYTHON_INSTALL_MIRROR`: Managed Python installations are downloaded from
  [`python-build-standalone`](https://github.com/indygreg/python-build-standalone). This variable
  can be set to a mirror URL to use a different source for Python installations. The provided URL
  will replace `https://github.com/indygreg/python-build-standalone/releases/download` in, e.g.,
  `https://github.com/indygreg/python-build-standalone/releases/download/20240713/cpython-3.12.4%2B20240713-aarch64-apple-darwin-install_only.tar.gz`.
  Distributions can be read from a local directory by using the `file://` URL scheme.
- `UV_PYPY_INSTALL_MIRROR`: Managed PyPy installations are downloaded from
  [python.org](https://downloads.python.org/). This variable can be set to a mirror URL to use a
  different source for PyPy installations. The provided URL will replace
  `https://downloads.python.org/pypy` in, e.g.,
  `https://downloads.python.org/pypy/pypy3.8-v7.3.7-osx64.tar.bz2`. Distributions can be read from a
  local directory by using the `file://` URL scheme.
- `XDG_CONFIG_HOME`: Used to specify the path to uv user-level configuration directory on Unix
  systems.
- `XDG_CACHE_HOME`: Used to specify the directory where uv stores cache files on Unix systems.
- `XDG_DATA_HOME`: Used to specify the directory where uv stores managed Python installations and
  managed tools on Unix systems.
- `XDG_BIN_HOME`: Used to specify the directory where executables are installed into.
- `SSL_CERT_FILE`: If set, uv will use this file as the certificate bundle instead of the system's
  trust store.
- `SSL_CLIENT_CERT`: If set, uv will use this file for mTLS authentication. This should be a single
  file containing both the certificate and the private key in PEM format.
- `RUST_LOG`: If set, uv will use this value as the log level for its `--verbose` output. Accepts
  any filter compatible with the `tracing_subscriber` crate. For example, `RUST_LOG=trace` will
  enable trace-level logging. See the
  [tracing documentation](https://docs.rs/tracing-subscriber/latest/tracing_subscriber/filter/struct.EnvFilter.html#example-syntax)
  for more.
- `HTTP_PROXY`, `HTTPS_PROXY`, `ALL_PROXY`: The proxy to use for all HTTP/HTTPS requests.
- `HTTP_TIMEOUT` (or `UV_HTTP_TIMEOUT`): If set, uv will use this value (in seconds) as the timeout
  for HTTP reads (default: 30 s).
- `NETRC`: If set, uv will read authentication information from this file instead of `~/.netrc`.
- `PYC_INVALIDATION_MODE`: The validation modes to use when run with `--compile`. See:
  [`PycInvalidationMode`](https://docs.python.org/3/library/py_compile.html#py_compile.PycInvalidationMode).
- `VIRTUAL_ENV`: Used to detect an activated virtual environment.
- `CONDA_PREFIX`: Used to detect an activated Conda environment.
- `PROMPT`: Used to detect the use of the Windows Command Prompt (as opposed to PowerShell).
- `VIRTUAL_ENV_DISABLE_PROMPT`: If set to `1` before a virtual environment is activated, then the
  virtual environment name will not be prepended to the terminal prompt.
- `NU_VERSION`: Used to detect the use of NuShell.
- `FISH_VERSION`: Used to detect the use of the Fish shell.
- `BASH_VERSION`: Used to detect the use of the Bash shell.
- `ZSH_VERSION`: Used to detect the use of the Zsh shell.
- `MACOSX_DEPLOYMENT_TARGET`: Used with `--python-platform macos` and related variants to set the
  deployment target (i.e., the minimum supported macOS version). Defaults to `12.0`, the
  least-recent non-EOL macOS version at time of writing.
- `NO_COLOR`: Disable colors. Takes precedence over `FORCE_COLOR`. See
  [no-color.org](https://no-color.org).
- `FORCE_COLOR`: Enforce colors regardless of TTY support. See
  [force-color.org](https://force-color.org).
