// Generated by modified Perl script at https://github.com/google/sentencepiece/blob/master/data/gen_unicode_scripts_code.pl
// Unicode scripts : https://gist.github.com/Narsil/07556f26dc84a6baeff4d499e68d3cd2
// Rust adaptation : https://gist.github.com/Narsil/1df9fbbf5296a8d4d62de55dcb2fe700

#[derive(PartialEq, Debug, Clone, Copy)]
pub enum Script {
    Any,
    Adlam,
    Ahom,
    AnatolianHieroglyphs,
    Arabic,
    Armenian,
    Avestan,
    Balinese,
    Bamum,
    BassaVah,
    Batak,
    Bengali,
    Bhaiksuki,
    Bopomofo,
    Brahmi,
    Braille,
    Buginese,
    Buhid,
    CanadianAboriginal,
    Carian,
    CaucasianAlbanian,
    Chakma,
    Cham,
    Cherokee,
    Common,
    Coptic,
    Cuneiform,
    Cypriot,
    Cyrillic,
    Deseret,
    Devanagari,
    Duployan,
    EgyptianHieroglyphs,
    Elbasan,
    Ethiopic,
    Georgian,
    Glagolitic,
    Gothic,
    Grantha,
    Greek,
    Gujarati,
    Gurmukhi,
    Han,
    Hangul,
    Hanunoo,
    Hatran,
    Hebrew,
    Hiragana,
    ImperialAramaic,
    Inherited,
    InscriptionalPahlavi,
    InscriptionalParthian,
    Javanese,
    Kaithi,
    Kannada,
    Katakana,
    KayahLi,
    Kharoshthi,
    Khmer,
    Khojki,
    Khudawadi,
    Lao,
    Latin,
    Lepcha,
    Limbu,
    LinearA,
    LinearB,
    Lisu,
    Lycian,
    Lydian,
    Mahajani,
    Malayalam,
    Mandaic,
    Manichaean,
    Marchen,
    MeeteiMayek,
    MendeKikakui,
    MeroiticCursive,
    MeroiticHieroglyphs,
    Miao,
    Modi,
    Mongolian,
    Mro,
    Multani,
    Myanmar,
    Nabataean,
    NewTaiLue,
    Newa,
    Nko,
    Ogham,
    OlChiki,
    OldHungarian,
    OldItalic,
    OldNorthArabian,
    OldPermic,
    OldPersian,
    OldSouthArabian,
    OldTurkic,
    Oriya,
    Osage,
    Osmanya,
    PahawhHmong,
    Palmyrene,
    PauCinHau,
    PhagsPa,
    Phoenician,
    PsalterPahlavi,
    Rejang,
    Runic,
    Samaritan,
    Saurashtra,
    Sharada,
    Shavian,
    Siddham,
    SignWriting,
    Sinhala,
    SoraSompeng,
    Sundanese,
    SylotiNagri,
    Syriac,
    Tagalog,
    Tagbanwa,
    TaiLe,
    TaiTham,
    TaiViet,
    Takri,
    Tamil,
    Tangut,
    Telugu,
    Thaana,
    Thai,
    Tibetan,
    Tifinagh,
    Tirhuta,
    Ugaritic,
    Vai,
    WarangCiti,
    Yi,
}

pub fn get_script(c: char) -> Script {
    match c as u32 {
        0x0000..=0x001F => Script::Common,
        0x0020 => Script::Common,
        0x0021..=0x0023 => Script::Common,
        0x0024 => Script::Common,
        0x0025..=0x0027 => Script::Common,
        0x0028 => Script::Common,
        0x0029 => Script::Common,
        0x002A => Script::Common,
        0x002B => Script::Common,
        0x002C => Script::Common,
        0x002D => Script::Common,
        0x002E..=0x002F => Script::Common,
        0x0030..=0x0039 => Script::Common,
        0x003A..=0x003B => Script::Common,
        0x003C..=0x003E => Script::Common,
        0x003F..=0x0040 => Script::Common,
        0x005B => Script::Common,
        0x005C => Script::Common,
        0x005D => Script::Common,
        0x005E => Script::Common,
        0x005F => Script::Common,
        0x0060 => Script::Common,
        0x007B => Script::Common,
        0x007C => Script::Common,
        0x007D => Script::Common,
        0x007E => Script::Common,
        0x007F..=0x009F => Script::Common,
        0x00A0 => Script::Common,
        0x00A1 => Script::Common,
        0x00A2..=0x00A5 => Script::Common,
        0x00A6 => Script::Common,
        0x00A7 => Script::Common,
        0x00A8 => Script::Common,
        0x00A9 => Script::Common,
        0x00AB => Script::Common,
        0x00AC => Script::Common,
        0x00AD => Script::Common,
        0x00AE => Script::Common,
        0x00AF => Script::Common,
        0x00B0 => Script::Common,
        0x00B1 => Script::Common,
        0x00B2..=0x00B3 => Script::Common,
        0x00B4 => Script::Common,
        0x00B5 => Script::Common,
        0x00B6..=0x00B7 => Script::Common,
        0x00B8 => Script::Common,
        0x00B9 => Script::Common,
        0x00BB => Script::Common,
        0x00BC..=0x00BE => Script::Common,
        0x00BF => Script::Common,
        0x00D7 => Script::Common,
        0x00F7 => Script::Common,
        0x02B9..=0x02C1 => Script::Common,
        0x02C2..=0x02C5 => Script::Common,
        0x02C6..=0x02D1 => Script::Common,
        0x02D2..=0x02DF => Script::Common,
        0x02E5..=0x02E9 => Script::Common,
        0x02EC => Script::Common,
        0x02ED => Script::Common,
        0x02EE => Script::Common,
        0x02EF..=0x02FF => Script::Common,
        0x0374 => Script::Common,
        0x037E => Script::Common,
        0x0385 => Script::Common,
        0x0387 => Script::Common,
        0x0589 => Script::Common,
        0x0605 => Script::Common,
        0x060C => Script::Common,
        0x061B => Script::Common,
        0x061C => Script::Common,
        0x061F => Script::Common,
        0x0640 => Script::Common,
        0x06DD => Script::Common,
        0x08E2 => Script::Common,
        0x0964..=0x0965 => Script::Common,
        0x0E3F => Script::Common,
        0x0FD5..=0x0FD8 => Script::Common,
        0x10FB => Script::Common,
        0x16EB..=0x16ED => Script::Common,
        0x1735..=0x1736 => Script::Common,
        0x1802..=0x1803 => Script::Common,
        0x1805 => Script::Common,
        0x1CD3 => Script::Common,
        0x1CE1 => Script::Common,
        0x1CE9..=0x1CEC => Script::Common,
        0x1CEE..=0x1CF1 => Script::Common,
        0x1CF2..=0x1CF3 => Script::Common,
        0x1CF5..=0x1CF6 => Script::Common,
        0x2000..=0x200A => Script::Common,
        0x200B => Script::Common,
        0x200E..=0x200F => Script::Common,
        0x2010..=0x2015 => Script::Common,
        0x2016..=0x2017 => Script::Common,
        0x2018 => Script::Common,
        0x2019 => Script::Common,
        0x201A => Script::Common,
        0x201B..=0x201C => Script::Common,
        0x201D => Script::Common,
        0x201E => Script::Common,
        0x201F => Script::Common,
        0x2020..=0x2027 => Script::Common,
        0x2028 => Script::Common,
        0x2029 => Script::Common,
        0x202A..=0x202E => Script::Common,
        0x202F => Script::Common,
        0x2030..=0x2038 => Script::Common,
        0x2039 => Script::Common,
        0x203A => Script::Common,
        0x203B..=0x203E => Script::Common,
        0x203F..=0x2040 => Script::Common,
        0x2041..=0x2043 => Script::Common,
        0x2044 => Script::Common,
        0x2045 => Script::Common,
        0x2046 => Script::Common,
        0x2047..=0x2051 => Script::Common,
        0x2052 => Script::Common,
        0x2053 => Script::Common,
        0x2054 => Script::Common,
        0x2055..=0x205E => Script::Common,
        0x205F => Script::Common,
        0x2060..=0x2064 => Script::Common,
        0x2066..=0x206F => Script::Common,
        0x2070 => Script::Common,
        0x2074..=0x2079 => Script::Common,
        0x207A..=0x207C => Script::Common,
        0x207D => Script::Common,
        0x207E => Script::Common,
        0x2080..=0x2089 => Script::Common,
        0x208A..=0x208C => Script::Common,
        0x208D => Script::Common,
        0x208E => Script::Common,
        0x20A0..=0x20BE => Script::Common,
        0x2100..=0x2101 => Script::Common,
        0x2102 => Script::Common,
        0x2103..=0x2106 => Script::Common,
        0x2107 => Script::Common,
        0x2108..=0x2109 => Script::Common,
        0x210A..=0x2113 => Script::Common,
        0x2114 => Script::Common,
        0x2115 => Script::Common,
        0x2116..=0x2117 => Script::Common,
        0x2118 => Script::Common,
        0x2119..=0x211D => Script::Common,
        0x211E..=0x2123 => Script::Common,
        0x2124 => Script::Common,
        0x2125 => Script::Common,
        0x2127 => Script::Common,
        0x2128 => Script::Common,
        0x2129 => Script::Common,
        0x212C..=0x212D => Script::Common,
        0x212E => Script::Common,
        0x212F..=0x2131 => Script::Common,
        0x2133..=0x2134 => Script::Common,
        0x2135..=0x2138 => Script::Common,
        0x2139 => Script::Common,
        0x213A..=0x213B => Script::Common,
        0x213C..=0x213F => Script::Common,
        0x2140..=0x2144 => Script::Common,
        0x2145..=0x2149 => Script::Common,
        0x214A => Script::Common,
        0x214B => Script::Common,
        0x214C..=0x214D => Script::Common,
        0x214F => Script::Common,
        0x2150..=0x215F => Script::Common,
        0x2189 => Script::Common,
        0x218A..=0x218B => Script::Common,
        0x2190..=0x2194 => Script::Common,
        0x2195..=0x2199 => Script::Common,
        0x219A..=0x219B => Script::Common,
        0x219C..=0x219F => Script::Common,
        0x21A0 => Script::Common,
        0x21A1..=0x21A2 => Script::Common,
        0x21A3 => Script::Common,
        0x21A4..=0x21A5 => Script::Common,
        0x21A6 => Script::Common,
        0x21A7..=0x21AD => Script::Common,
        0x21AE => Script::Common,
        0x21AF..=0x21CD => Script::Common,
        0x21CE..=0x21CF => Script::Common,
        0x21D0..=0x21D1 => Script::Common,
        0x21D2 => Script::Common,
        0x21D3 => Script::Common,
        0x21D4 => Script::Common,
        0x21D5..=0x21F3 => Script::Common,
        0x21F4..=0x22FF => Script::Common,
        0x2300..=0x2307 => Script::Common,
        0x2308 => Script::Common,
        0x2309 => Script::Common,
        0x230A => Script::Common,
        0x230B => Script::Common,
        0x230C..=0x231F => Script::Common,
        0x2320..=0x2321 => Script::Common,
        0x2322..=0x2328 => Script::Common,
        0x2329 => Script::Common,
        0x232A => Script::Common,
        0x232B..=0x237B => Script::Common,
        0x237C => Script::Common,
        0x237D..=0x239A => Script::Common,
        0x239B..=0x23B3 => Script::Common,
        0x23B4..=0x23DB => Script::Common,
        0x23DC..=0x23E1 => Script::Common,
        0x23E2..=0x23FE => Script::Common,
        0x2400..=0x2426 => Script::Common,
        0x2440..=0x244A => Script::Common,
        0x2460..=0x249B => Script::Common,
        0x249C..=0x24E9 => Script::Common,
        0x24EA..=0x24FF => Script::Common,
        0x2500..=0x25B6 => Script::Common,
        0x25B7 => Script::Common,
        0x25B8..=0x25C0 => Script::Common,
        0x25C1 => Script::Common,
        0x25C2..=0x25F7 => Script::Common,
        0x25F8..=0x25FF => Script::Common,
        0x2600..=0x266E => Script::Common,
        0x266F => Script::Common,
        0x2670..=0x2767 => Script::Common,
        0x2768 => Script::Common,
        0x2769 => Script::Common,
        0x276A => Script::Common,
        0x276B => Script::Common,
        0x276C => Script::Common,
        0x276D => Script::Common,
        0x276E => Script::Common,
        0x276F => Script::Common,
        0x2770 => Script::Common,
        0x2771 => Script::Common,
        0x2772 => Script::Common,
        0x2773 => Script::Common,
        0x2774 => Script::Common,
        0x2775 => Script::Common,
        0x2776..=0x2793 => Script::Common,
        0x2794..=0x27BF => Script::Common,
        0x27C0..=0x27C4 => Script::Common,
        0x27C5 => Script::Common,
        0x27C6 => Script::Common,
        0x27C7..=0x27E5 => Script::Common,
        0x27E6 => Script::Common,
        0x27E7 => Script::Common,
        0x27E8 => Script::Common,
        0x27E9 => Script::Common,
        0x27EA => Script::Common,
        0x27EB => Script::Common,
        0x27EC => Script::Common,
        0x27ED => Script::Common,
        0x27EE => Script::Common,
        0x27EF => Script::Common,
        0x27F0..=0x27FF => Script::Common,
        0x2900..=0x2982 => Script::Common,
        0x2983 => Script::Common,
        0x2984 => Script::Common,
        0x2985 => Script::Common,
        0x2986 => Script::Common,
        0x2987 => Script::Common,
        0x2988 => Script::Common,
        0x2989 => Script::Common,
        0x298A => Script::Common,
        0x298B => Script::Common,
        0x298C => Script::Common,
        0x298D => Script::Common,
        0x298E => Script::Common,
        0x298F => Script::Common,
        0x2990 => Script::Common,
        0x2991 => Script::Common,
        0x2992 => Script::Common,
        0x2993 => Script::Common,
        0x2994 => Script::Common,
        0x2995 => Script::Common,
        0x2996 => Script::Common,
        0x2997 => Script::Common,
        0x2998 => Script::Common,
        0x2999..=0x29D7 => Script::Common,
        0x29D8 => Script::Common,
        0x29D9 => Script::Common,
        0x29DA => Script::Common,
        0x29DB => Script::Common,
        0x29DC..=0x29FB => Script::Common,
        0x29FC => Script::Common,
        0x29FD => Script::Common,
        0x29FE..=0x2AFF => Script::Common,
        0x2B00..=0x2B2F => Script::Common,
        0x2B30..=0x2B44 => Script::Common,
        0x2B45..=0x2B46 => Script::Common,
        0x2B47..=0x2B4C => Script::Common,
        0x2B4D..=0x2B73 => Script::Common,
        0x2B76..=0x2B95 => Script::Common,
        0x2B98..=0x2BB9 => Script::Common,
        0x2BBD..=0x2BC8 => Script::Common,
        0x2BCA..=0x2BD1 => Script::Common,
        0x2BEC..=0x2BEF => Script::Common,
        0x2E00..=0x2E01 => Script::Common,
        0x2E02 => Script::Common,
        0x2E03 => Script::Common,
        0x2E04 => Script::Common,
        0x2E05 => Script::Common,
        0x2E06..=0x2E08 => Script::Common,
        0x2E09 => Script::Common,
        0x2E0A => Script::Common,
        0x2E0B => Script::Common,
        0x2E0C => Script::Common,
        0x2E0D => Script::Common,
        0x2E0E..=0x2E16 => Script::Common,
        0x2E17 => Script::Common,
        0x2E18..=0x2E19 => Script::Common,
        0x2E1A => Script::Common,
        0x2E1B => Script::Common,
        0x2E1C => Script::Common,
        0x2E1D => Script::Common,
        0x2E1E..=0x2E1F => Script::Common,
        0x2E20 => Script::Common,
        0x2E21 => Script::Common,
        0x2E22 => Script::Common,
        0x2E23 => Script::Common,
        0x2E24 => Script::Common,
        0x2E25 => Script::Common,
        0x2E26 => Script::Common,
        0x2E27 => Script::Common,
        0x2E28 => Script::Common,
        0x2E29 => Script::Common,
        0x2E2A..=0x2E2E => Script::Common,
        0x2E2F => Script::Common,
        0x2E30..=0x2E39 => Script::Common,
        0x2E3A..=0x2E3B => Script::Common,
        0x2E3C..=0x2E3F => Script::Common,
        0x2E40 => Script::Common,
        0x2E41 => Script::Common,
        0x2E42 => Script::Common,
        0x2E43..=0x2E44 => Script::Common,
        0x2FF0..=0x2FFB => Script::Common,
        0x3000 => Script::Common,
        0x3001..=0x3003 => Script::Common,
        0x3004 => Script::Common,
        0x3006 => Script::Common,
        0x3008 => Script::Common,
        0x3009 => Script::Common,
        0x300A => Script::Common,
        0x300B => Script::Common,
        0x300C => Script::Common,
        0x300D => Script::Common,
        0x300E => Script::Common,
        0x300F => Script::Common,
        0x3010 => Script::Common,
        0x3011 => Script::Common,
        0x3012..=0x3013 => Script::Common,
        0x3014 => Script::Common,
        0x3015 => Script::Common,
        0x3016 => Script::Common,
        0x3017 => Script::Common,
        0x3018 => Script::Common,
        0x3019 => Script::Common,
        0x301A => Script::Common,
        0x301B => Script::Common,
        0x301C => Script::Common,
        0x301D => Script::Common,
        0x301E..=0x301F => Script::Common,
        0x3020 => Script::Common,
        0x3030 => Script::Common,
        0x3031..=0x3035 => Script::Common,
        0x3036..=0x3037 => Script::Common,
        0x303C => Script::Common,
        0x303D => Script::Common,
        0x303E..=0x303F => Script::Common,
        0x309B..=0x309C => Script::Common,
        0x30A0 => Script::Common,
        0x30FB => Script::Common,
        0x30FC => Script::Common,
        0x3190..=0x3191 => Script::Common,
        0x3192..=0x3195 => Script::Common,
        0x3196..=0x319F => Script::Common,
        0x31C0..=0x31E3 => Script::Common,
        0x3220..=0x3229 => Script::Common,
        0x322A..=0x3247 => Script::Common,
        0x3248..=0x324F => Script::Common,
        0x3250 => Script::Common,
        0x3251..=0x325F => Script::Common,
        0x327F => Script::Common,
        0x3280..=0x3289 => Script::Common,
        0x328A..=0x32B0 => Script::Common,
        0x32B1..=0x32BF => Script::Common,
        0x32C0..=0x32CF => Script::Common,
        0x3358..=0x33FF => Script::Common,
        0x4DC0..=0x4DFF => Script::Common,
        0xA700..=0xA716 => Script::Common,
        0xA717..=0xA71F => Script::Common,
        0xA720..=0xA721 => Script::Common,
        0xA788 => Script::Common,
        0xA789..=0xA78A => Script::Common,
        0xA830..=0xA835 => Script::Common,
        0xA836..=0xA837 => Script::Common,
        0xA838 => Script::Common,
        0xA839 => Script::Common,
        0xA92E => Script::Common,
        0xA9CF => Script::Common,
        0xAB5B => Script::Common,
        0xFD3E => Script::Common,
        0xFD3F => Script::Common,
        0xFE10..=0xFE16 => Script::Common,
        0xFE17 => Script::Common,
        0xFE18 => Script::Common,
        0xFE19 => Script::Common,
        0xFE30 => Script::Common,
        0xFE31..=0xFE32 => Script::Common,
        0xFE33..=0xFE34 => Script::Common,
        0xFE35 => Script::Common,
        0xFE36 => Script::Common,
        0xFE37 => Script::Common,
        0xFE38 => Script::Common,
        0xFE39 => Script::Common,
        0xFE3A => Script::Common,
        0xFE3B => Script::Common,
        0xFE3C => Script::Common,
        0xFE3D => Script::Common,
        0xFE3E => Script::Common,
        0xFE3F => Script::Common,
        0xFE40 => Script::Common,
        0xFE41 => Script::Common,
        0xFE42 => Script::Common,
        0xFE43 => Script::Common,
        0xFE44 => Script::Common,
        0xFE45..=0xFE46 => Script::Common,
        0xFE47 => Script::Common,
        0xFE48 => Script::Common,
        0xFE49..=0xFE4C => Script::Common,
        0xFE4D..=0xFE4F => Script::Common,
        0xFE50..=0xFE52 => Script::Common,
        0xFE54..=0xFE57 => Script::Common,
        0xFE58 => Script::Common,
        0xFE59 => Script::Common,
        0xFE5A => Script::Common,
        0xFE5B => Script::Common,
        0xFE5C => Script::Common,
        0xFE5D => Script::Common,
        0xFE5E => Script::Common,
        0xFE5F..=0xFE61 => Script::Common,
        0xFE62 => Script::Common,
        0xFE63 => Script::Common,
        0xFE64..=0xFE66 => Script::Common,
        0xFE68 => Script::Common,
        0xFE69 => Script::Common,
        0xFE6A..=0xFE6B => Script::Common,
        0xFEFF => Script::Common,
        0xFF01..=0xFF03 => Script::Common,
        0xFF04 => Script::Common,
        0xFF05..=0xFF07 => Script::Common,
        0xFF08 => Script::Common,
        0xFF09 => Script::Common,
        0xFF0A => Script::Common,
        0xFF0B => Script::Common,
        0xFF0C => Script::Common,
        0xFF0D => Script::Common,
        0xFF0E..=0xFF0F => Script::Common,
        0xFF10..=0xFF19 => Script::Common,
        0xFF1A..=0xFF1B => Script::Common,
        0xFF1C..=0xFF1E => Script::Common,
        0xFF1F..=0xFF20 => Script::Common,
        0xFF3B => Script::Common,
        0xFF3C => Script::Common,
        0xFF3D => Script::Common,
        0xFF3E => Script::Common,
        0xFF3F => Script::Common,
        0xFF40 => Script::Common,
        0xFF5B => Script::Common,
        0xFF5C => Script::Common,
        0xFF5D => Script::Common,
        0xFF5E => Script::Common,
        0xFF5F => Script::Common,
        0xFF60 => Script::Common,
        0xFF61 => Script::Common,
        0xFF62 => Script::Common,
        0xFF63 => Script::Common,
        0xFF64..=0xFF65 => Script::Common,
        0xFF70 => Script::Common,
        0xFF9E..=0xFF9F => Script::Common,
        0xFFE0..=0xFFE1 => Script::Common,
        0xFFE2 => Script::Common,
        0xFFE3 => Script::Common,
        0xFFE4 => Script::Common,
        0xFFE5..=0xFFE6 => Script::Common,
        0xFFE8 => Script::Common,
        0xFFE9..=0xFFEC => Script::Common,
        0xFFED..=0xFFEE => Script::Common,
        0xFFF9..=0xFFFB => Script::Common,
        0xFFFC..=0xFFFD => Script::Common,
        0x10100..=0x10102 => Script::Common,
        0x10107..=0x10133 => Script::Common,
        0x10137..=0x1013F => Script::Common,
        0x10190..=0x1019B => Script::Common,
        0x101D0..=0x101FC => Script::Common,
        0x102E1..=0x102FB => Script::Common,
        0x1BCA0..=0x1BCA3 => Script::Common,
        0x1D000..=0x1D0F5 => Script::Common,
        0x1D100..=0x1D126 => Script::Common,
        0x1D129..=0x1D164 => Script::Common,
        0x1D165..=0x1D166 => Script::Common,
        0x1D16A..=0x1D16C => Script::Common,
        0x1D16D..=0x1D172 => Script::Common,
        0x1D173..=0x1D17A => Script::Common,
        0x1D183..=0x1D184 => Script::Common,
        0x1D18C..=0x1D1A9 => Script::Common,
        0x1D1AE..=0x1D1E8 => Script::Common,
        0x1D300..=0x1D356 => Script::Common,
        0x1D360..=0x1D371 => Script::Common,
        0x1D400..=0x1D454 => Script::Common,
        0x1D456..=0x1D49C => Script::Common,
        0x1D49E..=0x1D49F => Script::Common,
        0x1D4A2 => Script::Common,
        0x1D4A5..=0x1D4A6 => Script::Common,
        0x1D4A9..=0x1D4AC => Script::Common,
        0x1D4AE..=0x1D4B9 => Script::Common,
        0x1D4BB => Script::Common,
        0x1D4BD..=0x1D4C3 => Script::Common,
        0x1D4C5..=0x1D505 => Script::Common,
        0x1D507..=0x1D50A => Script::Common,
        0x1D50D..=0x1D514 => Script::Common,
        0x1D516..=0x1D51C => Script::Common,
        0x1D51E..=0x1D539 => Script::Common,
        0x1D53B..=0x1D53E => Script::Common,
        0x1D540..=0x1D544 => Script::Common,
        0x1D546 => Script::Common,
        0x1D54A..=0x1D550 => Script::Common,
        0x1D552..=0x1D6A5 => Script::Common,
        0x1D6A8..=0x1D6C0 => Script::Common,
        0x1D6C1 => Script::Common,
        0x1D6C2..=0x1D6DA => Script::Common,
        0x1D6DB => Script::Common,
        0x1D6DC..=0x1D6FA => Script::Common,
        0x1D6FB => Script::Common,
        0x1D6FC..=0x1D714 => Script::Common,
        0x1D715 => Script::Common,
        0x1D716..=0x1D734 => Script::Common,
        0x1D735 => Script::Common,
        0x1D736..=0x1D74E => Script::Common,
        0x1D74F => Script::Common,
        0x1D750..=0x1D76E => Script::Common,
        0x1D76F => Script::Common,
        0x1D770..=0x1D788 => Script::Common,
        0x1D789 => Script::Common,
        0x1D78A..=0x1D7A8 => Script::Common,
        0x1D7A9 => Script::Common,
        0x1D7AA..=0x1D7C2 => Script::Common,
        0x1D7C3 => Script::Common,
        0x1D7C4..=0x1D7CB => Script::Common,
        0x1D7CE..=0x1D7FF => Script::Common,
        0x1F000..=0x1F02B => Script::Common,
        0x1F030..=0x1F093 => Script::Common,
        0x1F0A0..=0x1F0AE => Script::Common,
        0x1F0B1..=0x1F0BF => Script::Common,
        0x1F0C1..=0x1F0CF => Script::Common,
        0x1F0D1..=0x1F0F5 => Script::Common,
        0x1F100..=0x1F10C => Script::Common,
        0x1F110..=0x1F12E => Script::Common,
        0x1F130..=0x1F16B => Script::Common,
        0x1F170..=0x1F1AC => Script::Common,
        0x1F1E6..=0x1F1FF => Script::Common,
        0x1F201..=0x1F202 => Script::Common,
        0x1F210..=0x1F23B => Script::Common,
        0x1F240..=0x1F248 => Script::Common,
        0x1F250..=0x1F251 => Script::Common,
        0x1F300..=0x1F3FA => Script::Common,
        0x1F3FB..=0x1F3FF => Script::Common,
        0x1F400..=0x1F6D2 => Script::Common,
        0x1F6E0..=0x1F6EC => Script::Common,
        0x1F6F0..=0x1F6F6 => Script::Common,
        0x1F700..=0x1F773 => Script::Common,
        0x1F780..=0x1F7D4 => Script::Common,
        0x1F800..=0x1F80B => Script::Common,
        0x1F810..=0x1F847 => Script::Common,
        0x1F850..=0x1F859 => Script::Common,
        0x1F860..=0x1F887 => Script::Common,
        0x1F890..=0x1F8AD => Script::Common,
        0x1F910..=0x1F91E => Script::Common,
        0x1F920..=0x1F927 => Script::Common,
        0x1F930 => Script::Common,
        0x1F933..=0x1F93E => Script::Common,
        0x1F940..=0x1F94B => Script::Common,
        0x1F950..=0x1F95E => Script::Common,
        0x1F980..=0x1F991 => Script::Common,
        0x1F9C0 => Script::Common,
        0xE0001 => Script::Common,
        0xE0020..=0xE007F => Script::Common,
        0x0041..=0x005A => Script::Latin,
        0x0061..=0x007A => Script::Latin,
        0x00AA => Script::Latin,
        0x00BA => Script::Latin,
        0x00C0..=0x00D6 => Script::Latin,
        0x00D8..=0x00F6 => Script::Latin,
        0x00F8..=0x01BA => Script::Latin,
        0x01BB => Script::Latin,
        0x01BC..=0x01BF => Script::Latin,
        0x01C0..=0x01C3 => Script::Latin,
        0x01C4..=0x0293 => Script::Latin,
        0x0294 => Script::Latin,
        0x0295..=0x02AF => Script::Latin,
        0x02B0..=0x02B8 => Script::Latin,
        0x02E0..=0x02E4 => Script::Latin,
        0x1D00..=0x1D25 => Script::Latin,
        0x1D2C..=0x1D5C => Script::Latin,
        0x1D62..=0x1D65 => Script::Latin,
        0x1D6B..=0x1D77 => Script::Latin,
        0x1D79..=0x1D9A => Script::Latin,
        0x1D9B..=0x1DBE => Script::Latin,
        0x1E00..=0x1EFF => Script::Latin,
        0x2071 => Script::Latin,
        0x207F => Script::Latin,
        0x2090..=0x209C => Script::Latin,
        0x212A..=0x212B => Script::Latin,
        0x2132 => Script::Latin,
        0x214E => Script::Latin,
        0x2160..=0x2182 => Script::Latin,
        0x2183..=0x2184 => Script::Latin,
        0x2185..=0x2188 => Script::Latin,
        0x2C60..=0x2C7B => Script::Latin,
        0x2C7C..=0x2C7D => Script::Latin,
        0x2C7E..=0x2C7F => Script::Latin,
        0xA722..=0xA76F => Script::Latin,
        0xA770 => Script::Latin,
        0xA771..=0xA787 => Script::Latin,
        0xA78B..=0xA78E => Script::Latin,
        0xA78F => Script::Latin,
        0xA790..=0xA7AE => Script::Latin,
        0xA7B0..=0xA7B7 => Script::Latin,
        0xA7F7 => Script::Latin,
        0xA7F8..=0xA7F9 => Script::Latin,
        0xA7FA => Script::Latin,
        0xA7FB..=0xA7FF => Script::Latin,
        0xAB30..=0xAB5A => Script::Latin,
        0xAB5C..=0xAB5F => Script::Latin,
        0xAB60..=0xAB64 => Script::Latin,
        0xFB00..=0xFB06 => Script::Latin,
        0xFF21..=0xFF3A => Script::Latin,
        0xFF41..=0xFF5A => Script::Latin,
        0x0370..=0x0373 => Script::Greek,
        0x0375 => Script::Greek,
        0x0376..=0x0377 => Script::Greek,
        0x037A => Script::Greek,
        0x037B..=0x037D => Script::Greek,
        0x037F => Script::Greek,
        0x0384 => Script::Greek,
        0x0386 => Script::Greek,
        0x0388..=0x038A => Script::Greek,
        0x038C => Script::Greek,
        0x038E..=0x03A1 => Script::Greek,
        0x03A3..=0x03E1 => Script::Greek,
        0x03F0..=0x03F5 => Script::Greek,
        0x03F6 => Script::Greek,
        0x03F7..=0x03FF => Script::Greek,
        0x1D26..=0x1D2A => Script::Greek,
        0x1D5D..=0x1D61 => Script::Greek,
        0x1D66..=0x1D6A => Script::Greek,
        0x1DBF => Script::Greek,
        0x1F00..=0x1F15 => Script::Greek,
        0x1F18..=0x1F1D => Script::Greek,
        0x1F20..=0x1F45 => Script::Greek,
        0x1F48..=0x1F4D => Script::Greek,
        0x1F50..=0x1F57 => Script::Greek,
        0x1F59 => Script::Greek,
        0x1F5B => Script::Greek,
        0x1F5D => Script::Greek,
        0x1F5F..=0x1F7D => Script::Greek,
        0x1F80..=0x1FB4 => Script::Greek,
        0x1FB6..=0x1FBC => Script::Greek,
        0x1FBD => Script::Greek,
        0x1FBE => Script::Greek,
        0x1FBF..=0x1FC1 => Script::Greek,
        0x1FC2..=0x1FC4 => Script::Greek,
        0x1FC6..=0x1FCC => Script::Greek,
        0x1FCD..=0x1FCF => Script::Greek,
        0x1FD0..=0x1FD3 => Script::Greek,
        0x1FD6..=0x1FDB => Script::Greek,
        0x1FDD..=0x1FDF => Script::Greek,
        0x1FE0..=0x1FEC => Script::Greek,
        0x1FED..=0x1FEF => Script::Greek,
        0x1FF2..=0x1FF4 => Script::Greek,
        0x1FF6..=0x1FFC => Script::Greek,
        0x1FFD..=0x1FFE => Script::Greek,
        0x2126 => Script::Greek,
        0xAB65 => Script::Greek,
        0x10140..=0x10174 => Script::Greek,
        0x10175..=0x10178 => Script::Greek,
        0x10179..=0x10189 => Script::Greek,
        0x1018A..=0x1018B => Script::Greek,
        0x1018C..=0x1018E => Script::Greek,
        0x101A0 => Script::Greek,
        0x1D200..=0x1D241 => Script::Greek,
        0x1D242..=0x1D244 => Script::Greek,
        0x1D245 => Script::Greek,
        0x0400..=0x0481 => Script::Cyrillic,
        0x0482 => Script::Cyrillic,
        0x0483..=0x0484 => Script::Cyrillic,
        0x0487 => Script::Cyrillic,
        0x0488..=0x0489 => Script::Cyrillic,
        0x048A..=0x052F => Script::Cyrillic,
        0x1C80..=0x1C88 => Script::Cyrillic,
        0x1D2B => Script::Cyrillic,
        0x1D78 => Script::Cyrillic,
        0x2DE0..=0x2DFF => Script::Cyrillic,
        0xA640..=0xA66D => Script::Cyrillic,
        0xA66E => Script::Cyrillic,
        0xA66F => Script::Cyrillic,
        0xA670..=0xA672 => Script::Cyrillic,
        0xA673 => Script::Cyrillic,
        0xA674..=0xA67D => Script::Cyrillic,
        0xA67E => Script::Cyrillic,
        0xA67F => Script::Cyrillic,
        0xA680..=0xA69B => Script::Cyrillic,
        0xA69C..=0xA69D => Script::Cyrillic,
        0xA69E..=0xA69F => Script::Cyrillic,
        0xFE2E..=0xFE2F => Script::Cyrillic,
        0x0531..=0x0556 => Script::Armenian,
        0x0559 => Script::Armenian,
        0x055A..=0x055F => Script::Armenian,
        0x0561..=0x0587 => Script::Armenian,
        0x058A => Script::Armenian,
        0x058D..=0x058E => Script::Armenian,
        0x058F => Script::Armenian,
        0xFB13..=0xFB17 => Script::Armenian,
        0x0591..=0x05BD => Script::Hebrew,
        0x05BE => Script::Hebrew,
        0x05BF => Script::Hebrew,
        0x05C0 => Script::Hebrew,
        0x05C1..=0x05C2 => Script::Hebrew,
        0x05C3 => Script::Hebrew,
        0x05C4..=0x05C5 => Script::Hebrew,
        0x05C6 => Script::Hebrew,
        0x05C7 => Script::Hebrew,
        0x05D0..=0x05EA => Script::Hebrew,
        0x05F0..=0x05F2 => Script::Hebrew,
        0x05F3..=0x05F4 => Script::Hebrew,
        0xFB1D => Script::Hebrew,
        0xFB1E => Script::Hebrew,
        0xFB1F..=0xFB28 => Script::Hebrew,
        0xFB29 => Script::Hebrew,
        0xFB2A..=0xFB36 => Script::Hebrew,
        0xFB38..=0xFB3C => Script::Hebrew,
        0xFB3E => Script::Hebrew,
        0xFB40..=0xFB41 => Script::Hebrew,
        0xFB43..=0xFB44 => Script::Hebrew,
        0xFB46..=0xFB4F => Script::Hebrew,
        0x0600..=0x0604 => Script::Arabic,
        0x0606..=0x0608 => Script::Arabic,
        0x0609..=0x060A => Script::Arabic,
        0x060B => Script::Arabic,
        0x060D => Script::Arabic,
        0x060E..=0x060F => Script::Arabic,
        0x0610..=0x061A => Script::Arabic,
        0x061E => Script::Arabic,
        0x0620..=0x063F => Script::Arabic,
        0x0641..=0x064A => Script::Arabic,
        0x0656..=0x065F => Script::Arabic,
        0x0660..=0x0669 => Script::Arabic,
        0x066A..=0x066D => Script::Arabic,
        0x066E..=0x066F => Script::Arabic,
        0x0671..=0x06D3 => Script::Arabic,
        0x06D4 => Script::Arabic,
        0x06D5 => Script::Arabic,
        0x06D6..=0x06DC => Script::Arabic,
        0x06DE => Script::Arabic,
        0x06DF..=0x06E4 => Script::Arabic,
        0x06E5..=0x06E6 => Script::Arabic,
        0x06E7..=0x06E8 => Script::Arabic,
        0x06E9 => Script::Arabic,
        0x06EA..=0x06ED => Script::Arabic,
        0x06EE..=0x06EF => Script::Arabic,
        0x06F0..=0x06F9 => Script::Arabic,
        0x06FA..=0x06FC => Script::Arabic,
        0x06FD..=0x06FE => Script::Arabic,
        0x06FF => Script::Arabic,
        0x0750..=0x077F => Script::Arabic,
        0x08A0..=0x08B4 => Script::Arabic,
        0x08B6..=0x08BD => Script::Arabic,
        0x08D4..=0x08E1 => Script::Arabic,
        0x08E3..=0x08FF => Script::Arabic,
        0xFB50..=0xFBB1 => Script::Arabic,
        0xFBB2..=0xFBC1 => Script::Arabic,
        0xFBD3..=0xFD3D => Script::Arabic,
        0xFD50..=0xFD8F => Script::Arabic,
        0xFD92..=0xFDC7 => Script::Arabic,
        0xFDF0..=0xFDFB => Script::Arabic,
        0xFDFC => Script::Arabic,
        0xFDFD => Script::Arabic,
        0xFE70..=0xFE74 => Script::Arabic,
        0xFE76..=0xFEFC => Script::Arabic,
        0x10E60..=0x10E7E => Script::Arabic,
        0x1EE00..=0x1EE03 => Script::Arabic,
        0x1EE05..=0x1EE1F => Script::Arabic,
        0x1EE21..=0x1EE22 => Script::Arabic,
        0x1EE24 => Script::Arabic,
        0x1EE27 => Script::Arabic,
        0x1EE29..=0x1EE32 => Script::Arabic,
        0x1EE34..=0x1EE37 => Script::Arabic,
        0x1EE39 => Script::Arabic,
        0x1EE3B => Script::Arabic,
        0x1EE42 => Script::Arabic,
        0x1EE47 => Script::Arabic,
        0x1EE49 => Script::Arabic,
        0x1EE4B => Script::Arabic,
        0x1EE4D..=0x1EE4F => Script::Arabic,
        0x1EE51..=0x1EE52 => Script::Arabic,
        0x1EE54 => Script::Arabic,
        0x1EE57 => Script::Arabic,
        0x1EE59 => Script::Arabic,
        0x1EE5B => Script::Arabic,
        0x1EE5D => Script::Arabic,
        0x1EE5F => Script::Arabic,
        0x1EE61..=0x1EE62 => Script::Arabic,
        0x1EE64 => Script::Arabic,
        0x1EE67..=0x1EE6A => Script::Arabic,
        0x1EE6C..=0x1EE72 => Script::Arabic,
        0x1EE74..=0x1EE77 => Script::Arabic,
        0x1EE79..=0x1EE7C => Script::Arabic,
        0x1EE7E => Script::Arabic,
        0x1EE80..=0x1EE89 => Script::Arabic,
        0x1EE8B..=0x1EE9B => Script::Arabic,
        0x1EEA1..=0x1EEA3 => Script::Arabic,
        0x1EEA5..=0x1EEA9 => Script::Arabic,
        0x1EEAB..=0x1EEBB => Script::Arabic,
        0x1EEF0..=0x1EEF1 => Script::Arabic,
        0x0700..=0x070D => Script::Syriac,
        0x070F => Script::Syriac,
        0x0710 => Script::Syriac,
        0x0711 => Script::Syriac,
        0x0712..=0x072F => Script::Syriac,
        0x0730..=0x074A => Script::Syriac,
        0x074D..=0x074F => Script::Syriac,
        0x0780..=0x07A5 => Script::Thaana,
        0x07A6..=0x07B0 => Script::Thaana,
        0x07B1 => Script::Thaana,
        0x0900..=0x0902 => Script::Devanagari,
        0x0903 => Script::Devanagari,
        0x0904..=0x0939 => Script::Devanagari,
        0x093A => Script::Devanagari,
        0x093B => Script::Devanagari,
        0x093C => Script::Devanagari,
        0x093D => Script::Devanagari,
        0x093E..=0x0940 => Script::Devanagari,
        0x0941..=0x0948 => Script::Devanagari,
        0x0949..=0x094C => Script::Devanagari,
        0x094D => Script::Devanagari,
        0x094E..=0x094F => Script::Devanagari,
        0x0950 => Script::Devanagari,
        0x0953..=0x0957 => Script::Devanagari,
        0x0958..=0x0961 => Script::Devanagari,
        0x0962..=0x0963 => Script::Devanagari,
        0x0966..=0x096F => Script::Devanagari,
        0x0970 => Script::Devanagari,
        0x0971 => Script::Devanagari,
        0x0972..=0x097F => Script::Devanagari,
        0xA8E0..=0xA8F1 => Script::Devanagari,
        0xA8F2..=0xA8F7 => Script::Devanagari,
        0xA8F8..=0xA8FA => Script::Devanagari,
        0xA8FB => Script::Devanagari,
        0xA8FC => Script::Devanagari,
        0xA8FD => Script::Devanagari,
        0x0980 => Script::Bengali,
        0x0981 => Script::Bengali,
        0x0982..=0x0983 => Script::Bengali,
        0x0985..=0x098C => Script::Bengali,
        0x098F..=0x0990 => Script::Bengali,
        0x0993..=0x09A8 => Script::Bengali,
        0x09AA..=0x09B0 => Script::Bengali,
        0x09B2 => Script::Bengali,
        0x09B6..=0x09B9 => Script::Bengali,
        0x09BC => Script::Bengali,
        0x09BD => Script::Bengali,
        0x09BE..=0x09C0 => Script::Bengali,
        0x09C1..=0x09C4 => Script::Bengali,
        0x09C7..=0x09C8 => Script::Bengali,
        0x09CB..=0x09CC => Script::Bengali,
        0x09CD => Script::Bengali,
        0x09CE => Script::Bengali,
        0x09D7 => Script::Bengali,
        0x09DC..=0x09DD => Script::Bengali,
        0x09DF..=0x09E1 => Script::Bengali,
        0x09E2..=0x09E3 => Script::Bengali,
        0x09E6..=0x09EF => Script::Bengali,
        0x09F0..=0x09F1 => Script::Bengali,
        0x09F2..=0x09F3 => Script::Bengali,
        0x09F4..=0x09F9 => Script::Bengali,
        0x09FA => Script::Bengali,
        0x09FB => Script::Bengali,
        0x0A01..=0x0A02 => Script::Gurmukhi,
        0x0A03 => Script::Gurmukhi,
        0x0A05..=0x0A0A => Script::Gurmukhi,
        0x0A0F..=0x0A10 => Script::Gurmukhi,
        0x0A13..=0x0A28 => Script::Gurmukhi,
        0x0A2A..=0x0A30 => Script::Gurmukhi,
        0x0A32..=0x0A33 => Script::Gurmukhi,
        0x0A35..=0x0A36 => Script::Gurmukhi,
        0x0A38..=0x0A39 => Script::Gurmukhi,
        0x0A3C => Script::Gurmukhi,
        0x0A3E..=0x0A40 => Script::Gurmukhi,
        0x0A41..=0x0A42 => Script::Gurmukhi,
        0x0A47..=0x0A48 => Script::Gurmukhi,
        0x0A4B..=0x0A4D => Script::Gurmukhi,
        0x0A51 => Script::Gurmukhi,
        0x0A59..=0x0A5C => Script::Gurmukhi,
        0x0A5E => Script::Gurmukhi,
        0x0A66..=0x0A6F => Script::Gurmukhi,
        0x0A70..=0x0A71 => Script::Gurmukhi,
        0x0A72..=0x0A74 => Script::Gurmukhi,
        0x0A75 => Script::Gurmukhi,
        0x0A81..=0x0A82 => Script::Gujarati,
        0x0A83 => Script::Gujarati,
        0x0A85..=0x0A8D => Script::Gujarati,
        0x0A8F..=0x0A91 => Script::Gujarati,
        0x0A93..=0x0AA8 => Script::Gujarati,
        0x0AAA..=0x0AB0 => Script::Gujarati,
        0x0AB2..=0x0AB3 => Script::Gujarati,
        0x0AB5..=0x0AB9 => Script::Gujarati,
        0x0ABC => Script::Gujarati,
        0x0ABD => Script::Gujarati,
        0x0ABE..=0x0AC0 => Script::Gujarati,
        0x0AC1..=0x0AC5 => Script::Gujarati,
        0x0AC7..=0x0AC8 => Script::Gujarati,
        0x0AC9 => Script::Gujarati,
        0x0ACB..=0x0ACC => Script::Gujarati,
        0x0ACD => Script::Gujarati,
        0x0AD0 => Script::Gujarati,
        0x0AE0..=0x0AE1 => Script::Gujarati,
        0x0AE2..=0x0AE3 => Script::Gujarati,
        0x0AE6..=0x0AEF => Script::Gujarati,
        0x0AF0 => Script::Gujarati,
        0x0AF1 => Script::Gujarati,
        0x0AF9 => Script::Gujarati,
        0x0B01 => Script::Oriya,
        0x0B02..=0x0B03 => Script::Oriya,
        0x0B05..=0x0B0C => Script::Oriya,
        0x0B0F..=0x0B10 => Script::Oriya,
        0x0B13..=0x0B28 => Script::Oriya,
        0x0B2A..=0x0B30 => Script::Oriya,
        0x0B32..=0x0B33 => Script::Oriya,
        0x0B35..=0x0B39 => Script::Oriya,
        0x0B3C => Script::Oriya,
        0x0B3D => Script::Oriya,
        0x0B3E => Script::Oriya,
        0x0B3F => Script::Oriya,
        0x0B40 => Script::Oriya,
        0x0B41..=0x0B44 => Script::Oriya,
        0x0B47..=0x0B48 => Script::Oriya,
        0x0B4B..=0x0B4C => Script::Oriya,
        0x0B4D => Script::Oriya,
        0x0B56 => Script::Oriya,
        0x0B57 => Script::Oriya,
        0x0B5C..=0x0B5D => Script::Oriya,
        0x0B5F..=0x0B61 => Script::Oriya,
        0x0B62..=0x0B63 => Script::Oriya,
        0x0B66..=0x0B6F => Script::Oriya,
        0x0B70 => Script::Oriya,
        0x0B71 => Script::Oriya,
        0x0B72..=0x0B77 => Script::Oriya,
        0x0B82 => Script::Tamil,
        0x0B83 => Script::Tamil,
        0x0B85..=0x0B8A => Script::Tamil,
        0x0B8E..=0x0B90 => Script::Tamil,
        0x0B92..=0x0B95 => Script::Tamil,
        0x0B99..=0x0B9A => Script::Tamil,
        0x0B9C => Script::Tamil,
        0x0B9E..=0x0B9F => Script::Tamil,
        0x0BA3..=0x0BA4 => Script::Tamil,
        0x0BA8..=0x0BAA => Script::Tamil,
        0x0BAE..=0x0BB9 => Script::Tamil,
        0x0BBE..=0x0BBF => Script::Tamil,
        0x0BC0 => Script::Tamil,
        0x0BC1..=0x0BC2 => Script::Tamil,
        0x0BC6..=0x0BC8 => Script::Tamil,
        0x0BCA..=0x0BCC => Script::Tamil,
        0x0BCD => Script::Tamil,
        0x0BD0 => Script::Tamil,
        0x0BD7 => Script::Tamil,
        0x0BE6..=0x0BEF => Script::Tamil,
        0x0BF0..=0x0BF2 => Script::Tamil,
        0x0BF3..=0x0BF8 => Script::Tamil,
        0x0BF9 => Script::Tamil,
        0x0BFA => Script::Tamil,
        0x0C00 => Script::Telugu,
        0x0C01..=0x0C03 => Script::Telugu,
        0x0C05..=0x0C0C => Script::Telugu,
        0x0C0E..=0x0C10 => Script::Telugu,
        0x0C12..=0x0C28 => Script::Telugu,
        0x0C2A..=0x0C39 => Script::Telugu,
        0x0C3D => Script::Telugu,
        0x0C3E..=0x0C40 => Script::Telugu,
        0x0C41..=0x0C44 => Script::Telugu,
        0x0C46..=0x0C48 => Script::Telugu,
        0x0C4A..=0x0C4D => Script::Telugu,
        0x0C55..=0x0C56 => Script::Telugu,
        0x0C58..=0x0C5A => Script::Telugu,
        0x0C60..=0x0C61 => Script::Telugu,
        0x0C62..=0x0C63 => Script::Telugu,
        0x0C66..=0x0C6F => Script::Telugu,
        0x0C78..=0x0C7E => Script::Telugu,
        0x0C7F => Script::Telugu,
        0x0C80 => Script::Kannada,
        0x0C81 => Script::Kannada,
        0x0C82..=0x0C83 => Script::Kannada,
        0x0C85..=0x0C8C => Script::Kannada,
        0x0C8E..=0x0C90 => Script::Kannada,
        0x0C92..=0x0CA8 => Script::Kannada,
        0x0CAA..=0x0CB3 => Script::Kannada,
        0x0CB5..=0x0CB9 => Script::Kannada,
        0x0CBC => Script::Kannada,
        0x0CBD => Script::Kannada,
        0x0CBE => Script::Kannada,
        0x0CBF => Script::Kannada,
        0x0CC0..=0x0CC4 => Script::Kannada,
        0x0CC6 => Script::Kannada,
        0x0CC7..=0x0CC8 => Script::Kannada,
        0x0CCA..=0x0CCB => Script::Kannada,
        0x0CCC..=0x0CCD => Script::Kannada,
        0x0CD5..=0x0CD6 => Script::Kannada,
        0x0CDE => Script::Kannada,
        0x0CE0..=0x0CE1 => Script::Kannada,
        0x0CE2..=0x0CE3 => Script::Kannada,
        0x0CE6..=0x0CEF => Script::Kannada,
        0x0CF1..=0x0CF2 => Script::Kannada,
        0x0D01 => Script::Malayalam,
        0x0D02..=0x0D03 => Script::Malayalam,
        0x0D05..=0x0D0C => Script::Malayalam,
        0x0D0E..=0x0D10 => Script::Malayalam,
        0x0D12..=0x0D3A => Script::Malayalam,
        0x0D3D => Script::Malayalam,
        0x0D3E..=0x0D40 => Script::Malayalam,
        0x0D41..=0x0D44 => Script::Malayalam,
        0x0D46..=0x0D48 => Script::Malayalam,
        0x0D4A..=0x0D4C => Script::Malayalam,
        0x0D4D => Script::Malayalam,
        0x0D4E => Script::Malayalam,
        0x0D4F => Script::Malayalam,
        0x0D54..=0x0D56 => Script::Malayalam,
        0x0D57 => Script::Malayalam,
        0x0D58..=0x0D5E => Script::Malayalam,
        0x0D5F..=0x0D61 => Script::Malayalam,
        0x0D62..=0x0D63 => Script::Malayalam,
        0x0D66..=0x0D6F => Script::Malayalam,
        0x0D70..=0x0D78 => Script::Malayalam,
        0x0D79 => Script::Malayalam,
        0x0D7A..=0x0D7F => Script::Malayalam,
        0x0D82..=0x0D83 => Script::Sinhala,
        0x0D85..=0x0D96 => Script::Sinhala,
        0x0D9A..=0x0DB1 => Script::Sinhala,
        0x0DB3..=0x0DBB => Script::Sinhala,
        0x0DBD => Script::Sinhala,
        0x0DC0..=0x0DC6 => Script::Sinhala,
        0x0DCA => Script::Sinhala,
        0x0DCF..=0x0DD1 => Script::Sinhala,
        0x0DD2..=0x0DD4 => Script::Sinhala,
        0x0DD6 => Script::Sinhala,
        0x0DD8..=0x0DDF => Script::Sinhala,
        0x0DE6..=0x0DEF => Script::Sinhala,
        0x0DF2..=0x0DF3 => Script::Sinhala,
        0x0DF4 => Script::Sinhala,
        0x111E1..=0x111F4 => Script::Sinhala,
        0x0E01..=0x0E30 => Script::Thai,
        0x0E31 => Script::Thai,
        0x0E32..=0x0E33 => Script::Thai,
        0x0E34..=0x0E3A => Script::Thai,
        0x0E40..=0x0E45 => Script::Thai,
        0x0E46 => Script::Thai,
        0x0E47..=0x0E4E => Script::Thai,
        0x0E4F => Script::Thai,
        0x0E50..=0x0E59 => Script::Thai,
        0x0E5A..=0x0E5B => Script::Thai,
        0x0E81..=0x0E82 => Script::Lao,
        0x0E84 => Script::Lao,
        0x0E87..=0x0E88 => Script::Lao,
        0x0E8A => Script::Lao,
        0x0E8D => Script::Lao,
        0x0E94..=0x0E97 => Script::Lao,
        0x0E99..=0x0E9F => Script::Lao,
        0x0EA1..=0x0EA3 => Script::Lao,
        0x0EA5 => Script::Lao,
        0x0EA7 => Script::Lao,
        0x0EAA..=0x0EAB => Script::Lao,
        0x0EAD..=0x0EB0 => Script::Lao,
        0x0EB1 => Script::Lao,
        0x0EB2..=0x0EB3 => Script::Lao,
        0x0EB4..=0x0EB9 => Script::Lao,
        0x0EBB..=0x0EBC => Script::Lao,
        0x0EBD => Script::Lao,
        0x0EC0..=0x0EC4 => Script::Lao,
        0x0EC6 => Script::Lao,
        0x0EC8..=0x0ECD => Script::Lao,
        0x0ED0..=0x0ED9 => Script::Lao,
        0x0EDC..=0x0EDF => Script::Lao,
        0x0F00 => Script::Tibetan,
        0x0F01..=0x0F03 => Script::Tibetan,
        0x0F04..=0x0F12 => Script::Tibetan,
        0x0F13 => Script::Tibetan,
        0x0F14 => Script::Tibetan,
        0x0F15..=0x0F17 => Script::Tibetan,
        0x0F18..=0x0F19 => Script::Tibetan,
        0x0F1A..=0x0F1F => Script::Tibetan,
        0x0F20..=0x0F29 => Script::Tibetan,
        0x0F2A..=0x0F33 => Script::Tibetan,
        0x0F34 => Script::Tibetan,
        0x0F35 => Script::Tibetan,
        0x0F36 => Script::Tibetan,
        0x0F37 => Script::Tibetan,
        0x0F38 => Script::Tibetan,
        0x0F39 => Script::Tibetan,
        0x0F3A => Script::Tibetan,
        0x0F3B => Script::Tibetan,
        0x0F3C => Script::Tibetan,
        0x0F3D => Script::Tibetan,
        0x0F3E..=0x0F3F => Script::Tibetan,
        0x0F40..=0x0F47 => Script::Tibetan,
        0x0F49..=0x0F6C => Script::Tibetan,
        0x0F71..=0x0F7E => Script::Tibetan,
        0x0F7F => Script::Tibetan,
        0x0F80..=0x0F84 => Script::Tibetan,
        0x0F85 => Script::Tibetan,
        0x0F86..=0x0F87 => Script::Tibetan,
        0x0F88..=0x0F8C => Script::Tibetan,
        0x0F8D..=0x0F97 => Script::Tibetan,
        0x0F99..=0x0FBC => Script::Tibetan,
        0x0FBE..=0x0FC5 => Script::Tibetan,
        0x0FC6 => Script::Tibetan,
        0x0FC7..=0x0FCC => Script::Tibetan,
        0x0FCE..=0x0FCF => Script::Tibetan,
        0x0FD0..=0x0FD4 => Script::Tibetan,
        0x0FD9..=0x0FDA => Script::Tibetan,
        0x1000..=0x102A => Script::Myanmar,
        0x102B..=0x102C => Script::Myanmar,
        0x102D..=0x1030 => Script::Myanmar,
        0x1031 => Script::Myanmar,
        0x1032..=0x1037 => Script::Myanmar,
        0x1038 => Script::Myanmar,
        0x1039..=0x103A => Script::Myanmar,
        0x103B..=0x103C => Script::Myanmar,
        0x103D..=0x103E => Script::Myanmar,
        0x103F => Script::Myanmar,
        0x1040..=0x1049 => Script::Myanmar,
        0x104A..=0x104F => Script::Myanmar,
        0x1050..=0x1055 => Script::Myanmar,
        0x1056..=0x1057 => Script::Myanmar,
        0x1058..=0x1059 => Script::Myanmar,
        0x105A..=0x105D => Script::Myanmar,
        0x105E..=0x1060 => Script::Myanmar,
        0x1061 => Script::Myanmar,
        0x1062..=0x1064 => Script::Myanmar,
        0x1065..=0x1066 => Script::Myanmar,
        0x1067..=0x106D => Script::Myanmar,
        0x106E..=0x1070 => Script::Myanmar,
        0x1071..=0x1074 => Script::Myanmar,
        0x1075..=0x1081 => Script::Myanmar,
        0x1082 => Script::Myanmar,
        0x1083..=0x1084 => Script::Myanmar,
        0x1085..=0x1086 => Script::Myanmar,
        0x1087..=0x108C => Script::Myanmar,
        0x108D => Script::Myanmar,
        0x108E => Script::Myanmar,
        0x108F => Script::Myanmar,
        0x1090..=0x1099 => Script::Myanmar,
        0x109A..=0x109C => Script::Myanmar,
        0x109D => Script::Myanmar,
        0x109E..=0x109F => Script::Myanmar,
        0xA9E0..=0xA9E4 => Script::Myanmar,
        0xA9E5 => Script::Myanmar,
        0xA9E6 => Script::Myanmar,
        0xA9E7..=0xA9EF => Script::Myanmar,
        0xA9F0..=0xA9F9 => Script::Myanmar,
        0xA9FA..=0xA9FE => Script::Myanmar,
        0xAA60..=0xAA6F => Script::Myanmar,
        0xAA70 => Script::Myanmar,
        0xAA71..=0xAA76 => Script::Myanmar,
        0xAA77..=0xAA79 => Script::Myanmar,
        0xAA7A => Script::Myanmar,
        0xAA7B => Script::Myanmar,
        0xAA7C => Script::Myanmar,
        0xAA7D => Script::Myanmar,
        0xAA7E..=0xAA7F => Script::Myanmar,
        0x10A0..=0x10C5 => Script::Georgian,
        0x10C7 => Script::Georgian,
        0x10CD => Script::Georgian,
        0x10D0..=0x10FA => Script::Georgian,
        0x10FC => Script::Georgian,
        0x10FD..=0x10FF => Script::Georgian,
        0x2D00..=0x2D25 => Script::Georgian,
        0x2D27 => Script::Georgian,
        0x2D2D => Script::Georgian,
        0x1100..=0x11FF => Script::Hangul,
        0x302E..=0x302F => Script::Hangul,
        0x3131..=0x318E => Script::Hangul,
        0x3200..=0x321E => Script::Hangul,
        0x3260..=0x327E => Script::Hangul,
        0xA960..=0xA97C => Script::Hangul,
        0xAC00..=0xD7A3 => Script::Hangul,
        0xD7B0..=0xD7C6 => Script::Hangul,
        0xD7CB..=0xD7FB => Script::Hangul,
        0xFFA0..=0xFFBE => Script::Hangul,
        0xFFC2..=0xFFC7 => Script::Hangul,
        0xFFCA..=0xFFCF => Script::Hangul,
        0xFFD2..=0xFFD7 => Script::Hangul,
        0xFFDA..=0xFFDC => Script::Hangul,
        0x1200..=0x1248 => Script::Ethiopic,
        0x124A..=0x124D => Script::Ethiopic,
        0x1250..=0x1256 => Script::Ethiopic,
        0x1258 => Script::Ethiopic,
        0x125A..=0x125D => Script::Ethiopic,
        0x1260..=0x1288 => Script::Ethiopic,
        0x128A..=0x128D => Script::Ethiopic,
        0x1290..=0x12B0 => Script::Ethiopic,
        0x12B2..=0x12B5 => Script::Ethiopic,
        0x12B8..=0x12BE => Script::Ethiopic,
        0x12C0 => Script::Ethiopic,
        0x12C2..=0x12C5 => Script::Ethiopic,
        0x12C8..=0x12D6 => Script::Ethiopic,
        0x12D8..=0x1310 => Script::Ethiopic,
        0x1312..=0x1315 => Script::Ethiopic,
        0x1318..=0x135A => Script::Ethiopic,
        0x135D..=0x135F => Script::Ethiopic,
        0x1360..=0x1368 => Script::Ethiopic,
        0x1369..=0x137C => Script::Ethiopic,
        0x1380..=0x138F => Script::Ethiopic,
        0x1390..=0x1399 => Script::Ethiopic,
        0x2D80..=0x2D96 => Script::Ethiopic,
        0x2DA0..=0x2DA6 => Script::Ethiopic,
        0x2DA8..=0x2DAE => Script::Ethiopic,
        0x2DB0..=0x2DB6 => Script::Ethiopic,
        0x2DB8..=0x2DBE => Script::Ethiopic,
        0x2DC0..=0x2DC6 => Script::Ethiopic,
        0x2DC8..=0x2DCE => Script::Ethiopic,
        0x2DD0..=0x2DD6 => Script::Ethiopic,
        0x2DD8..=0x2DDE => Script::Ethiopic,
        0xAB01..=0xAB06 => Script::Ethiopic,
        0xAB09..=0xAB0E => Script::Ethiopic,
        0xAB11..=0xAB16 => Script::Ethiopic,
        0xAB20..=0xAB26 => Script::Ethiopic,
        0xAB28..=0xAB2E => Script::Ethiopic,
        0x13A0..=0x13F5 => Script::Cherokee,
        0x13F8..=0x13FD => Script::Cherokee,
        0xAB70..=0xABBF => Script::Cherokee,
        0x1400 => Script::CanadianAboriginal,
        0x1401..=0x166C => Script::CanadianAboriginal,
        0x166D..=0x166E => Script::CanadianAboriginal,
        0x166F..=0x167F => Script::CanadianAboriginal,
        0x18B0..=0x18F5 => Script::CanadianAboriginal,
        0x1680 => Script::Ogham,
        0x1681..=0x169A => Script::Ogham,
        0x169B => Script::Ogham,
        0x169C => Script::Ogham,
        0x16A0..=0x16EA => Script::Runic,
        0x16EE..=0x16F0 => Script::Runic,
        0x16F1..=0x16F8 => Script::Runic,
        0x1780..=0x17B3 => Script::Khmer,
        0x17B4..=0x17B5 => Script::Khmer,
        0x17B6 => Script::Khmer,
        0x17B7..=0x17BD => Script::Khmer,
        0x17BE..=0x17C5 => Script::Khmer,
        0x17C6 => Script::Khmer,
        0x17C7..=0x17C8 => Script::Khmer,
        0x17C9..=0x17D3 => Script::Khmer,
        0x17D4..=0x17D6 => Script::Khmer,
        0x17D7 => Script::Khmer,
        0x17D8..=0x17DA => Script::Khmer,
        0x17DB => Script::Khmer,
        0x17DC => Script::Khmer,
        0x17DD => Script::Khmer,
        0x17E0..=0x17E9 => Script::Khmer,
        0x17F0..=0x17F9 => Script::Khmer,
        0x19E0..=0x19FF => Script::Khmer,
        0x1800..=0x1801 => Script::Mongolian,
        0x1804 => Script::Mongolian,
        0x1806 => Script::Mongolian,
        0x1807..=0x180A => Script::Mongolian,
        0x180B..=0x180D => Script::Mongolian,
        0x180E => Script::Mongolian,
        0x1810..=0x1819 => Script::Mongolian,
        0x1820..=0x1842 => Script::Mongolian,
        0x1843 => Script::Mongolian,
        0x1844..=0x1877 => Script::Mongolian,
        0x1880..=0x1884 => Script::Mongolian,
        0x1885..=0x1886 => Script::Mongolian,
        0x1887..=0x18A8 => Script::Mongolian,
        0x18A9 => Script::Mongolian,
        0x18AA => Script::Mongolian,
        0x11660..=0x1166C => Script::Mongolian,
        0x3041..=0x3096 => Script::Hiragana,
        0x309D..=0x309E => Script::Hiragana,
        0x309F => Script::Hiragana,
        0x1B001 => Script::Hiragana,
        0x1F200 => Script::Hiragana,
        0x30A1..=0x30FA => Script::Katakana,
        0x30FD..=0x30FE => Script::Katakana,
        0x30FF => Script::Katakana,
        0x31F0..=0x31FF => Script::Katakana,
        0x32D0..=0x32FE => Script::Katakana,
        0x3300..=0x3357 => Script::Katakana,
        0xFF66..=0xFF6F => Script::Katakana,
        0xFF71..=0xFF9D => Script::Katakana,
        0x1B000 => Script::Katakana,
        0x02EA..=0x02EB => Script::Bopomofo,
        0x3105..=0x312D => Script::Bopomofo,
        0x31A0..=0x31BA => Script::Bopomofo,
        0x2E80..=0x2E99 => Script::Han,
        0x2E9B..=0x2EF3 => Script::Han,
        0x2F00..=0x2FD5 => Script::Han,
        0x3005 => Script::Han,
        0x3007 => Script::Han,
        0x3021..=0x3029 => Script::Han,
        0x3038..=0x303A => Script::Han,
        0x303B => Script::Han,
        0x3400..=0x4DB5 => Script::Han,
        0x4E00..=0x9FD5 => Script::Han,
        0xF900..=0xFA6D => Script::Han,
        0xFA70..=0xFAD9 => Script::Han,
        0x20000..=0x2A6D6 => Script::Han,
        0x2A700..=0x2B734 => Script::Han,
        0x2B740..=0x2B81D => Script::Han,
        0x2B820..=0x2CEA1 => Script::Han,
        0x2F800..=0x2FA1D => Script::Han,
        0xA000..=0xA014 => Script::Yi,
        0xA015 => Script::Yi,
        0xA016..=0xA48C => Script::Yi,
        0xA490..=0xA4C6 => Script::Yi,
        0x10300..=0x1031F => Script::OldItalic,
        0x10320..=0x10323 => Script::OldItalic,
        0x10330..=0x10340 => Script::Gothic,
        0x10341 => Script::Gothic,
        0x10342..=0x10349 => Script::Gothic,
        0x1034A => Script::Gothic,
        0x10400..=0x1044F => Script::Deseret,
        0x0300..=0x036F => Script::Inherited,
        0x0485..=0x0486 => Script::Inherited,
        0x064B..=0x0655 => Script::Inherited,
        0x0670 => Script::Inherited,
        0x0951..=0x0952 => Script::Inherited,
        0x1AB0..=0x1ABD => Script::Inherited,
        0x1ABE => Script::Inherited,
        0x1CD0..=0x1CD2 => Script::Inherited,
        0x1CD4..=0x1CE0 => Script::Inherited,
        0x1CE2..=0x1CE8 => Script::Inherited,
        0x1CED => Script::Inherited,
        0x1CF4 => Script::Inherited,
        0x1CF8..=0x1CF9 => Script::Inherited,
        0x1DC0..=0x1DF5 => Script::Inherited,
        0x1DFB..=0x1DFF => Script::Inherited,
        0x200C..=0x200D => Script::Inherited,
        0x20D0..=0x20DC => Script::Inherited,
        0x20DD..=0x20E0 => Script::Inherited,
        0x20E1 => Script::Inherited,
        0x20E2..=0x20E4 => Script::Inherited,
        0x20E5..=0x20F0 => Script::Inherited,
        0x302A..=0x302D => Script::Inherited,
        0x3099..=0x309A => Script::Inherited,
        0xFE00..=0xFE0F => Script::Inherited,
        0xFE20..=0xFE2D => Script::Inherited,
        0x101FD => Script::Inherited,
        0x102E0 => Script::Inherited,
        0x1D167..=0x1D169 => Script::Inherited,
        0x1D17B..=0x1D182 => Script::Inherited,
        0x1D185..=0x1D18B => Script::Inherited,
        0x1D1AA..=0x1D1AD => Script::Inherited,
        0xE0100..=0xE01EF => Script::Inherited,
        0x1700..=0x170C => Script::Tagalog,
        0x170E..=0x1711 => Script::Tagalog,
        0x1712..=0x1714 => Script::Tagalog,
        0x1720..=0x1731 => Script::Hanunoo,
        0x1732..=0x1734 => Script::Hanunoo,
        0x1740..=0x1751 => Script::Buhid,
        0x1752..=0x1753 => Script::Buhid,
        0x1760..=0x176C => Script::Tagbanwa,
        0x176E..=0x1770 => Script::Tagbanwa,
        0x1772..=0x1773 => Script::Tagbanwa,
        0x1900..=0x191E => Script::Limbu,
        0x1920..=0x1922 => Script::Limbu,
        0x1923..=0x1926 => Script::Limbu,
        0x1927..=0x1928 => Script::Limbu,
        0x1929..=0x192B => Script::Limbu,
        0x1930..=0x1931 => Script::Limbu,
        0x1932 => Script::Limbu,
        0x1933..=0x1938 => Script::Limbu,
        0x1939..=0x193B => Script::Limbu,
        0x1940 => Script::Limbu,
        0x1944..=0x1945 => Script::Limbu,
        0x1946..=0x194F => Script::Limbu,
        0x1950..=0x196D => Script::TaiLe,
        0x1970..=0x1974 => Script::TaiLe,
        0x10000..=0x1000B => Script::LinearB,
        0x1000D..=0x10026 => Script::LinearB,
        0x10028..=0x1003A => Script::LinearB,
        0x1003C..=0x1003D => Script::LinearB,
        0x1003F..=0x1004D => Script::LinearB,
        0x10050..=0x1005D => Script::LinearB,
        0x10080..=0x100FA => Script::LinearB,
        0x10380..=0x1039D => Script::Ugaritic,
        0x1039F => Script::Ugaritic,
        0x10450..=0x1047F => Script::Shavian,
        0x10480..=0x1049D => Script::Osmanya,
        0x104A0..=0x104A9 => Script::Osmanya,
        0x10800..=0x10805 => Script::Cypriot,
        0x10808 => Script::Cypriot,
        0x1080A..=0x10835 => Script::Cypriot,
        0x10837..=0x10838 => Script::Cypriot,
        0x1083C => Script::Cypriot,
        0x1083F => Script::Cypriot,
        0x2800..=0x28FF => Script::Braille,
        0x1A00..=0x1A16 => Script::Buginese,
        0x1A17..=0x1A18 => Script::Buginese,
        0x1A19..=0x1A1A => Script::Buginese,
        0x1A1B => Script::Buginese,
        0x1A1E..=0x1A1F => Script::Buginese,
        0x03E2..=0x03EF => Script::Coptic,
        0x2C80..=0x2CE4 => Script::Coptic,
        0x2CE5..=0x2CEA => Script::Coptic,
        0x2CEB..=0x2CEE => Script::Coptic,
        0x2CEF..=0x2CF1 => Script::Coptic,
        0x2CF2..=0x2CF3 => Script::Coptic,
        0x2CF9..=0x2CFC => Script::Coptic,
        0x2CFD => Script::Coptic,
        0x2CFE..=0x2CFF => Script::Coptic,
        0x1980..=0x19AB => Script::NewTaiLue,
        0x19B0..=0x19C9 => Script::NewTaiLue,
        0x19D0..=0x19D9 => Script::NewTaiLue,
        0x19DA => Script::NewTaiLue,
        0x19DE..=0x19DF => Script::NewTaiLue,
        0x2C00..=0x2C2E => Script::Glagolitic,
        0x2C30..=0x2C5E => Script::Glagolitic,
        0x1E000..=0x1E006 => Script::Glagolitic,
        0x1E008..=0x1E018 => Script::Glagolitic,
        0x1E01B..=0x1E021 => Script::Glagolitic,
        0x1E023..=0x1E024 => Script::Glagolitic,
        0x1E026..=0x1E02A => Script::Glagolitic,
        0x2D30..=0x2D67 => Script::Tifinagh,
        0x2D6F => Script::Tifinagh,
        0x2D70 => Script::Tifinagh,
        0x2D7F => Script::Tifinagh,
        0xA800..=0xA801 => Script::SylotiNagri,
        0xA802 => Script::SylotiNagri,
        0xA803..=0xA805 => Script::SylotiNagri,
        0xA806 => Script::SylotiNagri,
        0xA807..=0xA80A => Script::SylotiNagri,
        0xA80B => Script::SylotiNagri,
        0xA80C..=0xA822 => Script::SylotiNagri,
        0xA823..=0xA824 => Script::SylotiNagri,
        0xA825..=0xA826 => Script::SylotiNagri,
        0xA827 => Script::SylotiNagri,
        0xA828..=0xA82B => Script::SylotiNagri,
        0x103A0..=0x103C3 => Script::OldPersian,
        0x103C8..=0x103CF => Script::OldPersian,
        0x103D0 => Script::OldPersian,
        0x103D1..=0x103D5 => Script::OldPersian,
        0x10A00 => Script::Kharoshthi,
        0x10A01..=0x10A03 => Script::Kharoshthi,
        0x10A05..=0x10A06 => Script::Kharoshthi,
        0x10A0C..=0x10A0F => Script::Kharoshthi,
        0x10A10..=0x10A13 => Script::Kharoshthi,
        0x10A15..=0x10A17 => Script::Kharoshthi,
        0x10A19..=0x10A33 => Script::Kharoshthi,
        0x10A38..=0x10A3A => Script::Kharoshthi,
        0x10A3F => Script::Kharoshthi,
        0x10A40..=0x10A47 => Script::Kharoshthi,
        0x10A50..=0x10A58 => Script::Kharoshthi,
        0x1B00..=0x1B03 => Script::Balinese,
        0x1B04 => Script::Balinese,
        0x1B05..=0x1B33 => Script::Balinese,
        0x1B34 => Script::Balinese,
        0x1B35 => Script::Balinese,
        0x1B36..=0x1B3A => Script::Balinese,
        0x1B3B => Script::Balinese,
        0x1B3C => Script::Balinese,
        0x1B3D..=0x1B41 => Script::Balinese,
        0x1B42 => Script::Balinese,
        0x1B43..=0x1B44 => Script::Balinese,
        0x1B45..=0x1B4B => Script::Balinese,
        0x1B50..=0x1B59 => Script::Balinese,
        0x1B5A..=0x1B60 => Script::Balinese,
        0x1B61..=0x1B6A => Script::Balinese,
        0x1B6B..=0x1B73 => Script::Balinese,
        0x1B74..=0x1B7C => Script::Balinese,
        0x12000..=0x12399 => Script::Cuneiform,
        0x12400..=0x1246E => Script::Cuneiform,
        0x12470..=0x12474 => Script::Cuneiform,
        0x12480..=0x12543 => Script::Cuneiform,
        0x10900..=0x10915 => Script::Phoenician,
        0x10916..=0x1091B => Script::Phoenician,
        0x1091F => Script::Phoenician,
        0xA840..=0xA873 => Script::PhagsPa,
        0xA874..=0xA877 => Script::PhagsPa,
        0x07C0..=0x07C9 => Script::Nko,
        0x07CA..=0x07EA => Script::Nko,
        0x07EB..=0x07F3 => Script::Nko,
        0x07F4..=0x07F5 => Script::Nko,
        0x07F6 => Script::Nko,
        0x07F7..=0x07F9 => Script::Nko,
        0x07FA => Script::Nko,
        0x1B80..=0x1B81 => Script::Sundanese,
        0x1B82 => Script::Sundanese,
        0x1B83..=0x1BA0 => Script::Sundanese,
        0x1BA1 => Script::Sundanese,
        0x1BA2..=0x1BA5 => Script::Sundanese,
        0x1BA6..=0x1BA7 => Script::Sundanese,
        0x1BA8..=0x1BA9 => Script::Sundanese,
        0x1BAA => Script::Sundanese,
        0x1BAB..=0x1BAD => Script::Sundanese,
        0x1BAE..=0x1BAF => Script::Sundanese,
        0x1BB0..=0x1BB9 => Script::Sundanese,
        0x1BBA..=0x1BBF => Script::Sundanese,
        0x1CC0..=0x1CC7 => Script::Sundanese,
        0x1C00..=0x1C23 => Script::Lepcha,
        0x1C24..=0x1C2B => Script::Lepcha,
        0x1C2C..=0x1C33 => Script::Lepcha,
        0x1C34..=0x1C35 => Script::Lepcha,
        0x1C36..=0x1C37 => Script::Lepcha,
        0x1C3B..=0x1C3F => Script::Lepcha,
        0x1C40..=0x1C49 => Script::Lepcha,
        0x1C4D..=0x1C4F => Script::Lepcha,
        0x1C50..=0x1C59 => Script::OlChiki,
        0x1C5A..=0x1C77 => Script::OlChiki,
        0x1C78..=0x1C7D => Script::OlChiki,
        0x1C7E..=0x1C7F => Script::OlChiki,
        0xA500..=0xA60B => Script::Vai,
        0xA60C => Script::Vai,
        0xA60D..=0xA60F => Script::Vai,
        0xA610..=0xA61F => Script::Vai,
        0xA620..=0xA629 => Script::Vai,
        0xA62A..=0xA62B => Script::Vai,
        0xA880..=0xA881 => Script::Saurashtra,
        0xA882..=0xA8B3 => Script::Saurashtra,
        0xA8B4..=0xA8C3 => Script::Saurashtra,
        0xA8C4..=0xA8C5 => Script::Saurashtra,
        0xA8CE..=0xA8CF => Script::Saurashtra,
        0xA8D0..=0xA8D9 => Script::Saurashtra,
        0xA900..=0xA909 => Script::KayahLi,
        0xA90A..=0xA925 => Script::KayahLi,
        0xA926..=0xA92D => Script::KayahLi,
        0xA92F => Script::KayahLi,
        0xA930..=0xA946 => Script::Rejang,
        0xA947..=0xA951 => Script::Rejang,
        0xA952..=0xA953 => Script::Rejang,
        0xA95F => Script::Rejang,
        0x10280..=0x1029C => Script::Lycian,
        0x102A0..=0x102D0 => Script::Carian,
        0x10920..=0x10939 => Script::Lydian,
        0x1093F => Script::Lydian,
        0xAA00..=0xAA28 => Script::Cham,
        0xAA29..=0xAA2E => Script::Cham,
        0xAA2F..=0xAA30 => Script::Cham,
        0xAA31..=0xAA32 => Script::Cham,
        0xAA33..=0xAA34 => Script::Cham,
        0xAA35..=0xAA36 => Script::Cham,
        0xAA40..=0xAA42 => Script::Cham,
        0xAA43 => Script::Cham,
        0xAA44..=0xAA4B => Script::Cham,
        0xAA4C => Script::Cham,
        0xAA4D => Script::Cham,
        0xAA50..=0xAA59 => Script::Cham,
        0xAA5C..=0xAA5F => Script::Cham,
        0x1A20..=0x1A54 => Script::TaiTham,
        0x1A55 => Script::TaiTham,
        0x1A56 => Script::TaiTham,
        0x1A57 => Script::TaiTham,
        0x1A58..=0x1A5E => Script::TaiTham,
        0x1A60 => Script::TaiTham,
        0x1A61 => Script::TaiTham,
        0x1A62 => Script::TaiTham,
        0x1A63..=0x1A64 => Script::TaiTham,
        0x1A65..=0x1A6C => Script::TaiTham,
        0x1A6D..=0x1A72 => Script::TaiTham,
        0x1A73..=0x1A7C => Script::TaiTham,
        0x1A7F => Script::TaiTham,
        0x1A80..=0x1A89 => Script::TaiTham,
        0x1A90..=0x1A99 => Script::TaiTham,
        0x1AA0..=0x1AA6 => Script::TaiTham,
        0x1AA7 => Script::TaiTham,
        0x1AA8..=0x1AAD => Script::TaiTham,
        0xAA80..=0xAAAF => Script::TaiViet,
        0xAAB0 => Script::TaiViet,
        0xAAB1 => Script::TaiViet,
        0xAAB2..=0xAAB4 => Script::TaiViet,
        0xAAB5..=0xAAB6 => Script::TaiViet,
        0xAAB7..=0xAAB8 => Script::TaiViet,
        0xAAB9..=0xAABD => Script::TaiViet,
        0xAABE..=0xAABF => Script::TaiViet,
        0xAAC0 => Script::TaiViet,
        0xAAC1 => Script::TaiViet,
        0xAAC2 => Script::TaiViet,
        0xAADB..=0xAADC => Script::TaiViet,
        0xAADD => Script::TaiViet,
        0xAADE..=0xAADF => Script::TaiViet,
        0x10B00..=0x10B35 => Script::Avestan,
        0x10B39..=0x10B3F => Script::Avestan,
        0x13000..=0x1342E => Script::EgyptianHieroglyphs,
        0x0800..=0x0815 => Script::Samaritan,
        0x0816..=0x0819 => Script::Samaritan,
        0x081A => Script::Samaritan,
        0x081B..=0x0823 => Script::Samaritan,
        0x0824 => Script::Samaritan,
        0x0825..=0x0827 => Script::Samaritan,
        0x0828 => Script::Samaritan,
        0x0829..=0x082D => Script::Samaritan,
        0x0830..=0x083E => Script::Samaritan,
        0xA4D0..=0xA4F7 => Script::Lisu,
        0xA4F8..=0xA4FD => Script::Lisu,
        0xA4FE..=0xA4FF => Script::Lisu,
        0xA6A0..=0xA6E5 => Script::Bamum,
        0xA6E6..=0xA6EF => Script::Bamum,
        0xA6F0..=0xA6F1 => Script::Bamum,
        0xA6F2..=0xA6F7 => Script::Bamum,
        0x16800..=0x16A38 => Script::Bamum,
        0xA980..=0xA982 => Script::Javanese,
        0xA983 => Script::Javanese,
        0xA984..=0xA9B2 => Script::Javanese,
        0xA9B3 => Script::Javanese,
        0xA9B4..=0xA9B5 => Script::Javanese,
        0xA9B6..=0xA9B9 => Script::Javanese,
        0xA9BA..=0xA9BB => Script::Javanese,
        0xA9BC => Script::Javanese,
        0xA9BD..=0xA9C0 => Script::Javanese,
        0xA9C1..=0xA9CD => Script::Javanese,
        0xA9D0..=0xA9D9 => Script::Javanese,
        0xA9DE..=0xA9DF => Script::Javanese,
        0xAAE0..=0xAAEA => Script::MeeteiMayek,
        0xAAEB => Script::MeeteiMayek,
        0xAAEC..=0xAAED => Script::MeeteiMayek,
        0xAAEE..=0xAAEF => Script::MeeteiMayek,
        0xAAF0..=0xAAF1 => Script::MeeteiMayek,
        0xAAF2 => Script::MeeteiMayek,
        0xAAF3..=0xAAF4 => Script::MeeteiMayek,
        0xAAF5 => Script::MeeteiMayek,
        0xAAF6 => Script::MeeteiMayek,
        0xABC0..=0xABE2 => Script::MeeteiMayek,
        0xABE3..=0xABE4 => Script::MeeteiMayek,
        0xABE5 => Script::MeeteiMayek,
        0xABE6..=0xABE7 => Script::MeeteiMayek,
        0xABE8 => Script::MeeteiMayek,
        0xABE9..=0xABEA => Script::MeeteiMayek,
        0xABEB => Script::MeeteiMayek,
        0xABEC => Script::MeeteiMayek,
        0xABED => Script::MeeteiMayek,
        0xABF0..=0xABF9 => Script::MeeteiMayek,
        0x10840..=0x10855 => Script::ImperialAramaic,
        0x10857 => Script::ImperialAramaic,
        0x10858..=0x1085F => Script::ImperialAramaic,
        0x10A60..=0x10A7C => Script::OldSouthArabian,
        0x10A7D..=0x10A7E => Script::OldSouthArabian,
        0x10A7F => Script::OldSouthArabian,
        0x10B40..=0x10B55 => Script::InscriptionalParthian,
        0x10B58..=0x10B5F => Script::InscriptionalParthian,
        0x10B60..=0x10B72 => Script::InscriptionalPahlavi,
        0x10B78..=0x10B7F => Script::InscriptionalPahlavi,
        0x10C00..=0x10C48 => Script::OldTurkic,
        0x11080..=0x11081 => Script::Kaithi,
        0x11082 => Script::Kaithi,
        0x11083..=0x110AF => Script::Kaithi,
        0x110B0..=0x110B2 => Script::Kaithi,
        0x110B3..=0x110B6 => Script::Kaithi,
        0x110B7..=0x110B8 => Script::Kaithi,
        0x110B9..=0x110BA => Script::Kaithi,
        0x110BB..=0x110BC => Script::Kaithi,
        0x110BD => Script::Kaithi,
        0x110BE..=0x110C1 => Script::Kaithi,
        0x1BC0..=0x1BE5 => Script::Batak,
        0x1BE6 => Script::Batak,
        0x1BE7 => Script::Batak,
        0x1BE8..=0x1BE9 => Script::Batak,
        0x1BEA..=0x1BEC => Script::Batak,
        0x1BED => Script::Batak,
        0x1BEE => Script::Batak,
        0x1BEF..=0x1BF1 => Script::Batak,
        0x1BF2..=0x1BF3 => Script::Batak,
        0x1BFC..=0x1BFF => Script::Batak,
        0x11000 => Script::Brahmi,
        0x11001 => Script::Brahmi,
        0x11002 => Script::Brahmi,
        0x11003..=0x11037 => Script::Brahmi,
        0x11038..=0x11046 => Script::Brahmi,
        0x11047..=0x1104D => Script::Brahmi,
        0x11052..=0x11065 => Script::Brahmi,
        0x11066..=0x1106F => Script::Brahmi,
        0x1107F => Script::Brahmi,
        0x0840..=0x0858 => Script::Mandaic,
        0x0859..=0x085B => Script::Mandaic,
        0x085E => Script::Mandaic,
        0x11100..=0x11102 => Script::Chakma,
        0x11103..=0x11126 => Script::Chakma,
        0x11127..=0x1112B => Script::Chakma,
        0x1112C => Script::Chakma,
        0x1112D..=0x11134 => Script::Chakma,
        0x11136..=0x1113F => Script::Chakma,
        0x11140..=0x11143 => Script::Chakma,
        0x109A0..=0x109B7 => Script::MeroiticCursive,
        0x109BC..=0x109BD => Script::MeroiticCursive,
        0x109BE..=0x109BF => Script::MeroiticCursive,
        0x109C0..=0x109CF => Script::MeroiticCursive,
        0x109D2..=0x109FF => Script::MeroiticCursive,
        0x10980..=0x1099F => Script::MeroiticHieroglyphs,
        0x16F00..=0x16F44 => Script::Miao,
        0x16F50 => Script::Miao,
        0x16F51..=0x16F7E => Script::Miao,
        0x16F8F..=0x16F92 => Script::Miao,
        0x16F93..=0x16F9F => Script::Miao,
        0x11180..=0x11181 => Script::Sharada,
        0x11182 => Script::Sharada,
        0x11183..=0x111B2 => Script::Sharada,
        0x111B3..=0x111B5 => Script::Sharada,
        0x111B6..=0x111BE => Script::Sharada,
        0x111BF..=0x111C0 => Script::Sharada,
        0x111C1..=0x111C4 => Script::Sharada,
        0x111C5..=0x111C9 => Script::Sharada,
        0x111CA..=0x111CC => Script::Sharada,
        0x111CD => Script::Sharada,
        0x111D0..=0x111D9 => Script::Sharada,
        0x111DA => Script::Sharada,
        0x111DB => Script::Sharada,
        0x111DC => Script::Sharada,
        0x111DD..=0x111DF => Script::Sharada,
        0x110D0..=0x110E8 => Script::SoraSompeng,
        0x110F0..=0x110F9 => Script::SoraSompeng,
        0x11680..=0x116AA => Script::Takri,
        0x116AB => Script::Takri,
        0x116AC => Script::Takri,
        0x116AD => Script::Takri,
        0x116AE..=0x116AF => Script::Takri,
        0x116B0..=0x116B5 => Script::Takri,
        0x116B6 => Script::Takri,
        0x116B7 => Script::Takri,
        0x116C0..=0x116C9 => Script::Takri,
        0x10530..=0x10563 => Script::CaucasianAlbanian,
        0x1056F => Script::CaucasianAlbanian,
        0x16AD0..=0x16AED => Script::BassaVah,
        0x16AF0..=0x16AF4 => Script::BassaVah,
        0x16AF5 => Script::BassaVah,
        0x1BC00..=0x1BC6A => Script::Duployan,
        0x1BC70..=0x1BC7C => Script::Duployan,
        0x1BC80..=0x1BC88 => Script::Duployan,
        0x1BC90..=0x1BC99 => Script::Duployan,
        0x1BC9C => Script::Duployan,
        0x1BC9D..=0x1BC9E => Script::Duployan,
        0x1BC9F => Script::Duployan,
        0x10500..=0x10527 => Script::Elbasan,
        0x11300..=0x11301 => Script::Grantha,
        0x11302..=0x11303 => Script::Grantha,
        0x11305..=0x1130C => Script::Grantha,
        0x1130F..=0x11310 => Script::Grantha,
        0x11313..=0x11328 => Script::Grantha,
        0x1132A..=0x11330 => Script::Grantha,
        0x11332..=0x11333 => Script::Grantha,
        0x11335..=0x11339 => Script::Grantha,
        0x1133C => Script::Grantha,
        0x1133D => Script::Grantha,
        0x1133E..=0x1133F => Script::Grantha,
        0x11340 => Script::Grantha,
        0x11341..=0x11344 => Script::Grantha,
        0x11347..=0x11348 => Script::Grantha,
        0x1134B..=0x1134D => Script::Grantha,
        0x11350 => Script::Grantha,
        0x11357 => Script::Grantha,
        0x1135D..=0x11361 => Script::Grantha,
        0x11362..=0x11363 => Script::Grantha,
        0x11366..=0x1136C => Script::Grantha,
        0x11370..=0x11374 => Script::Grantha,
        0x16B00..=0x16B2F => Script::PahawhHmong,
        0x16B30..=0x16B36 => Script::PahawhHmong,
        0x16B37..=0x16B3B => Script::PahawhHmong,
        0x16B3C..=0x16B3F => Script::PahawhHmong,
        0x16B40..=0x16B43 => Script::PahawhHmong,
        0x16B44 => Script::PahawhHmong,
        0x16B45 => Script::PahawhHmong,
        0x16B50..=0x16B59 => Script::PahawhHmong,
        0x16B5B..=0x16B61 => Script::PahawhHmong,
        0x16B63..=0x16B77 => Script::PahawhHmong,
        0x16B7D..=0x16B8F => Script::PahawhHmong,
        0x11200..=0x11211 => Script::Khojki,
        0x11213..=0x1122B => Script::Khojki,
        0x1122C..=0x1122E => Script::Khojki,
        0x1122F..=0x11231 => Script::Khojki,
        0x11232..=0x11233 => Script::Khojki,
        0x11234 => Script::Khojki,
        0x11235 => Script::Khojki,
        0x11236..=0x11237 => Script::Khojki,
        0x11238..=0x1123D => Script::Khojki,
        0x1123E => Script::Khojki,
        0x10600..=0x10736 => Script::LinearA,
        0x10740..=0x10755 => Script::LinearA,
        0x10760..=0x10767 => Script::LinearA,
        0x11150..=0x11172 => Script::Mahajani,
        0x11173 => Script::Mahajani,
        0x11174..=0x11175 => Script::Mahajani,
        0x11176 => Script::Mahajani,
        0x10AC0..=0x10AC7 => Script::Manichaean,
        0x10AC8 => Script::Manichaean,
        0x10AC9..=0x10AE4 => Script::Manichaean,
        0x10AE5..=0x10AE6 => Script::Manichaean,
        0x10AEB..=0x10AEF => Script::Manichaean,
        0x10AF0..=0x10AF6 => Script::Manichaean,
        0x1E800..=0x1E8C4 => Script::MendeKikakui,
        0x1E8C7..=0x1E8CF => Script::MendeKikakui,
        0x1E8D0..=0x1E8D6 => Script::MendeKikakui,
        0x11600..=0x1162F => Script::Modi,
        0x11630..=0x11632 => Script::Modi,
        0x11633..=0x1163A => Script::Modi,
        0x1163B..=0x1163C => Script::Modi,
        0x1163D => Script::Modi,
        0x1163E => Script::Modi,
        0x1163F..=0x11640 => Script::Modi,
        0x11641..=0x11643 => Script::Modi,
        0x11644 => Script::Modi,
        0x11650..=0x11659 => Script::Modi,
        0x16A40..=0x16A5E => Script::Mro,
        0x16A60..=0x16A69 => Script::Mro,
        0x16A6E..=0x16A6F => Script::Mro,
        0x10A80..=0x10A9C => Script::OldNorthArabian,
        0x10A9D..=0x10A9F => Script::OldNorthArabian,
        0x10880..=0x1089E => Script::Nabataean,
        0x108A7..=0x108AF => Script::Nabataean,
        0x10860..=0x10876 => Script::Palmyrene,
        0x10877..=0x10878 => Script::Palmyrene,
        0x10879..=0x1087F => Script::Palmyrene,
        0x11AC0..=0x11AF8 => Script::PauCinHau,
        0x10350..=0x10375 => Script::OldPermic,
        0x10376..=0x1037A => Script::OldPermic,
        0x10B80..=0x10B91 => Script::PsalterPahlavi,
        0x10B99..=0x10B9C => Script::PsalterPahlavi,
        0x10BA9..=0x10BAF => Script::PsalterPahlavi,
        0x11580..=0x115AE => Script::Siddham,
        0x115AF..=0x115B1 => Script::Siddham,
        0x115B2..=0x115B5 => Script::Siddham,
        0x115B8..=0x115BB => Script::Siddham,
        0x115BC..=0x115BD => Script::Siddham,
        0x115BE => Script::Siddham,
        0x115BF..=0x115C0 => Script::Siddham,
        0x115C1..=0x115D7 => Script::Siddham,
        0x115D8..=0x115DB => Script::Siddham,
        0x115DC..=0x115DD => Script::Siddham,
        0x112B0..=0x112DE => Script::Khudawadi,
        0x112DF => Script::Khudawadi,
        0x112E0..=0x112E2 => Script::Khudawadi,
        0x112E3..=0x112EA => Script::Khudawadi,
        0x112F0..=0x112F9 => Script::Khudawadi,
        0x11480..=0x114AF => Script::Tirhuta,
        0x114B0..=0x114B2 => Script::Tirhuta,
        0x114B3..=0x114B8 => Script::Tirhuta,
        0x114B9 => Script::Tirhuta,
        0x114BA => Script::Tirhuta,
        0x114BB..=0x114BE => Script::Tirhuta,
        0x114BF..=0x114C0 => Script::Tirhuta,
        0x114C1 => Script::Tirhuta,
        0x114C2..=0x114C3 => Script::Tirhuta,
        0x114C4..=0x114C5 => Script::Tirhuta,
        0x114C6 => Script::Tirhuta,
        0x114C7 => Script::Tirhuta,
        0x114D0..=0x114D9 => Script::Tirhuta,
        0x118A0..=0x118DF => Script::WarangCiti,
        0x118E0..=0x118E9 => Script::WarangCiti,
        0x118EA..=0x118F2 => Script::WarangCiti,
        0x118FF => Script::WarangCiti,
        0x11700..=0x11719 => Script::Ahom,
        0x1171D..=0x1171F => Script::Ahom,
        0x11720..=0x11721 => Script::Ahom,
        0x11722..=0x11725 => Script::Ahom,
        0x11726 => Script::Ahom,
        0x11727..=0x1172B => Script::Ahom,
        0x11730..=0x11739 => Script::Ahom,
        0x1173A..=0x1173B => Script::Ahom,
        0x1173C..=0x1173E => Script::Ahom,
        0x1173F => Script::Ahom,
        0x14400..=0x14646 => Script::AnatolianHieroglyphs,
        0x108E0..=0x108F2 => Script::Hatran,
        0x108F4..=0x108F5 => Script::Hatran,
        0x108FB..=0x108FF => Script::Hatran,
        0x11280..=0x11286 => Script::Multani,
        0x11288 => Script::Multani,
        0x1128A..=0x1128D => Script::Multani,
        0x1128F..=0x1129D => Script::Multani,
        0x1129F..=0x112A8 => Script::Multani,
        0x112A9 => Script::Multani,
        0x10C80..=0x10CB2 => Script::OldHungarian,
        0x10CC0..=0x10CF2 => Script::OldHungarian,
        0x10CFA..=0x10CFF => Script::OldHungarian,
        0x1D800..=0x1D9FF => Script::SignWriting,
        0x1DA00..=0x1DA36 => Script::SignWriting,
        0x1DA37..=0x1DA3A => Script::SignWriting,
        0x1DA3B..=0x1DA6C => Script::SignWriting,
        0x1DA6D..=0x1DA74 => Script::SignWriting,
        0x1DA75 => Script::SignWriting,
        0x1DA76..=0x1DA83 => Script::SignWriting,
        0x1DA84 => Script::SignWriting,
        0x1DA85..=0x1DA86 => Script::SignWriting,
        0x1DA87..=0x1DA8B => Script::SignWriting,
        0x1DA9B..=0x1DA9F => Script::SignWriting,
        0x1DAA1..=0x1DAAF => Script::SignWriting,
        0x1E900..=0x1E943 => Script::Adlam,
        0x1E944..=0x1E94A => Script::Adlam,
        0x1E950..=0x1E959 => Script::Adlam,
        0x1E95E..=0x1E95F => Script::Adlam,
        0x11C00..=0x11C08 => Script::Bhaiksuki,
        0x11C0A..=0x11C2E => Script::Bhaiksuki,
        0x11C2F => Script::Bhaiksuki,
        0x11C30..=0x11C36 => Script::Bhaiksuki,
        0x11C38..=0x11C3D => Script::Bhaiksuki,
        0x11C3E => Script::Bhaiksuki,
        0x11C3F => Script::Bhaiksuki,
        0x11C40 => Script::Bhaiksuki,
        0x11C41..=0x11C45 => Script::Bhaiksuki,
        0x11C50..=0x11C59 => Script::Bhaiksuki,
        0x11C5A..=0x11C6C => Script::Bhaiksuki,
        0x11C70..=0x11C71 => Script::Marchen,
        0x11C72..=0x11C8F => Script::Marchen,
        0x11C92..=0x11CA7 => Script::Marchen,
        0x11CA9 => Script::Marchen,
        0x11CAA..=0x11CB0 => Script::Marchen,
        0x11CB1 => Script::Marchen,
        0x11CB2..=0x11CB3 => Script::Marchen,
        0x11CB4 => Script::Marchen,
        0x11CB5..=0x11CB6 => Script::Marchen,
        0x11400..=0x11434 => Script::Newa,
        0x11435..=0x11437 => Script::Newa,
        0x11438..=0x1143F => Script::Newa,
        0x11440..=0x11441 => Script::Newa,
        0x11442..=0x11444 => Script::Newa,
        0x11445 => Script::Newa,
        0x11446 => Script::Newa,
        0x11447..=0x1144A => Script::Newa,
        0x1144B..=0x1144F => Script::Newa,
        0x11450..=0x11459 => Script::Newa,
        0x1145B => Script::Newa,
        0x1145D => Script::Newa,
        0x104B0..=0x104D3 => Script::Osage,
        0x104D8..=0x104FB => Script::Osage,
        0x16FE0 => Script::Tangut,
        0x17000..=0x187EC => Script::Tangut,
        0x18800..=0x18AF2 => Script::Tangut,
        _ => Script::Any,
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_unicode_script() {
        assert_eq!(Script::Han, get_script('京'));
        assert_eq!(Script::Han, get_script('太'));
        assert_eq!(Script::Hiragana, get_script('い'));
        assert_eq!(Script::Katakana, get_script('グ'));
        assert_eq!(Script::Common, get_script('ー'));
        assert_eq!(Script::Latin, get_script('a'));
        assert_eq!(Script::Latin, get_script('A'));
        assert_eq!(Script::Common, get_script('0'));
        assert_eq!(Script::Common, get_script('$'));
        assert_eq!(Script::Common, get_script('@'));
        assert_eq!(Script::Common, get_script('-'));
        assert_eq!(Script::Common, get_script(' '));
        assert_eq!(Script::Common, get_script('�'));
    }
}
