#[derive(Debug, PartialEq, Eq, Clone, Copy, Hash, PartialOrd, Ord)]
#[allow(non_camel_case_types)]
#[repr(u16)]
pub enum SyntaxKind {
    ERROR = 0,
    MISSING,

    LINE_BREAK,
    WHITESPACE,
    COMMENT,
    VERBATIM,
    L_CURLY,
    R_CURLY,
    L_BRACK,
    R_BRACK,
    L_PAREN,
    R_PAREN,
    COMMA,
    EQUALITY_SIGN,
    WORD,
    DOLLAR,
    GENERIC_COMMAND_NAME,
    BEGIN_ENVIRONMENT_NAME,
    END_ENVIRONMENT_NAME,
    BEGIN_EQUATION_NAME,
    END_EQUATION_NAME,
    PART_NAME,
    CHAPTER_NAME,
    SECTION_NAME,
    SUBSECTION_NAME,
    SUBSUBSECTION_NAME,
    PARAGRAPH_NAME,
    SUBPARAGRAPH_NAME,
    ENUM_ITEM_NAME,
    CAPTION_NAME,
    CITATION_NAME,
    PACKAGE_INCLUDE_NAME,
    CLASS_INCLUDE_NAME,
    LATEX_INCLUDE_NAME,
    BIBLATEX_INCLUDE_NAME,
    BIBTEX_INCLUDE_NAME,
    GRAPHICS_INCLUDE_NAME,
    SVG_INCLUDE_NAME,
    INKSCAPE_INCLUDE_NAME,
    VERBATIM_INCLUDE_NAME,
    IMPORT_NAME,
    LABEL_DEFINITION_NAME,
    LABEL_REFERENCE_NAME,
    LABEL_REFERENCE_RANGE_NAME,
    LABEL_NUMBER_NAME,
    COMMAND_DEFINITION_NAME,
    MATH_OPERATOR_NAME,
    GLOSSARY_ENTRY_DEFINITION_NAME,
    GLOSSARY_ENTRY_REFERENCE_NAME,
    ACRONYM_DEFINITION_NAME,
    ACRONYM_DECLARATION_NAME,
    ACRONYM_REFERENCE_NAME,
    THEOREM_DEFINITION_NAME,
    COLOR_REFERENCE_NAME,
    COLOR_DEFINITION_NAME,
    COLOR_SET_DEFINITION_NAME,
    TIKZ_LIBRARY_IMPORT_NAME,
    ENVIRONMENT_DEFINITION_NAME,
    BEGIN_BLOCK_COMMENT_NAME,
    END_BLOCK_COMMENT_NAME,
    GRAPHICS_PATH_NAME,

    PREAMBLE,
    TEXT,
    KEY,
    VALUE,
    KEY_VALUE_PAIR,
    KEY_VALUE_BODY,
    CURLY_GROUP,
    CURLY_GROUP_WORD,
    CURLY_GROUP_WORD_LIST,
    CURLY_GROUP_COMMAND,
    CURLY_GROUP_KEY_VALUE,
    BRACK_GROUP,
    BRACK_GROUP_WORD,
    BRACK_GROUP_KEY_VALUE,
    PAREN_GROUP,
    MIXED_GROUP,
    GENERIC_COMMAND,
    ENVIRONMENT,
    BEGIN,
    END,
    EQUATION,
    PART,
    CHAPTER,
    SECTION,
    SUBSECTION,
    SUBSUBSECTION,
    PARAGRAPH,
    SUBPARAGRAPH,
    ENUM_ITEM,
    FORMULA,
    CAPTION,
    CITATION,
    PACKAGE_INCLUDE,
    CLASS_INCLUDE,
    LATEX_INCLUDE,
    BIBLATEX_INCLUDE,
    BIBTEX_INCLUDE,
    GRAPHICS_INCLUDE,
    SVG_INCLUDE,
    INKSCAPE_INCLUDE,
    VERBATIM_INCLUDE,
    IMPORT,
    LABEL_DEFINITION,
    LABEL_REFERENCE,
    LABEL_REFERENCE_RANGE,
    LABEL_NUMBER,
    COMMAND_DEFINITION,
    MATH_OPERATOR,
    GLOSSARY_ENTRY_DEFINITION,
    GLOSSARY_ENTRY_REFERENCE,
    ACRONYM_DEFINITION,
    ACRONYM_DECLARATION,
    ACRONYM_REFERENCE,
    THEOREM_DEFINITION,
    COLOR_REFERENCE,
    COLOR_DEFINITION,
    COLOR_SET_DEFINITION,
    TIKZ_LIBRARY_IMPORT,
    ENVIRONMENT_DEFINITION,
    GRAPHICS_PATH,
    BLOCK_COMMENT,
    ROOT,
}

impl SyntaxKind {
    pub fn is_command_name(&self) -> bool {
        use SyntaxKind::*;
        matches!(
            self,
            GENERIC_COMMAND_NAME
                | BEGIN_ENVIRONMENT_NAME
                | END_ENVIRONMENT_NAME
                | BEGIN_EQUATION_NAME
                | END_EQUATION_NAME
                | PART_NAME
                | CHAPTER_NAME
                | SECTION_NAME
                | SUBSECTION_NAME
                | SUBSUBSECTION_NAME
                | PARAGRAPH_NAME
                | SUBPARAGRAPH_NAME
                | ENUM_ITEM_NAME
                | CAPTION_NAME
                | CITATION_NAME
                | PACKAGE_INCLUDE_NAME
                | CLASS_INCLUDE_NAME
                | LATEX_INCLUDE_NAME
                | BIBLATEX_INCLUDE_NAME
                | BIBTEX_INCLUDE_NAME
                | GRAPHICS_INCLUDE_NAME
                | SVG_INCLUDE_NAME
                | INKSCAPE_INCLUDE_NAME
                | VERBATIM_INCLUDE_NAME
                | IMPORT_NAME
                | LABEL_DEFINITION_NAME
                | LABEL_REFERENCE_NAME
                | LABEL_REFERENCE_RANGE_NAME
                | LABEL_NUMBER_NAME
                | COMMAND_DEFINITION_NAME
                | MATH_OPERATOR_NAME
                | GLOSSARY_ENTRY_DEFINITION_NAME
                | GLOSSARY_ENTRY_REFERENCE_NAME
                | ACRONYM_DEFINITION_NAME
                | ACRONYM_DECLARATION_NAME
                | ACRONYM_REFERENCE_NAME
                | THEOREM_DEFINITION_NAME
                | COLOR_REFERENCE_NAME
                | COLOR_DEFINITION_NAME
                | COLOR_SET_DEFINITION_NAME
                | TIKZ_LIBRARY_IMPORT_NAME
        )
    }
}

impl From<SyntaxKind> for rowan::SyntaxKind {
    fn from(kind: SyntaxKind) -> Self {
        Self(kind as u16)
    }
}
