use color_eyre::eyre::Result;
use indoc::indoc;

use crate::cli::command::Command;
use crate::config::Config;
use crate::output::Output;

/// Output direnv function to use rtx inside direnv
///
/// See https://github.com/jdx/rtx#direnv for more information
///
/// Because this generates the legacy files based on currently installed plugins,
/// you should run this command after installing new plugins. Otherwise
/// direnv may not know to update environment variables when legacy file versions change.
#[derive(Debug, clap::Args)]
#[clap(verbatim_doc_comment, after_long_help = AFTER_LONG_HELP)]
pub struct DirenvActivate {}

impl Command for DirenvActivate {
    fn run(self, _config: Config, out: &mut Output) -> Result<()> {
        rtxprintln!(
            out,
            //       source_env "$(rtx direnv envrc "$@")"
            indoc! {r#"
                ### Do not edit. This was autogenerated by 'rtx direnv' ###
                use_rtx() {{
                  direnv_load rtx direnv exec
                }}
            "#}
        );

        Ok(())
    }
}

static AFTER_LONG_HELP: &str = color_print::cstr!(
    r#"<bold><underline>Examples:</underline></bold>
  $ <bold>rtx direnv activate > ~/.config/direnv/lib/use_rtx.sh</bold>
  $ <bold>echo 'use rtx' > .envrc</bold>
  $ <bold>direnv allow</bold>
"#
);
