#!/usr/bin/env bash
set -euo pipefail

rm -rf asdf-plugins
git clone --depth 1 https://github.com/asdf-vm/asdf-plugins
rm -f src/default_shorthands.rs

custom_plugins=(
	'("pipenv", "https://github.com/rtx-plugins/rtx-pipenv.git"),'
	'("poetry", "https://github.com/rtx-plugins/rtx-poetry.git"),'
	'("tiny",   "https://github.com/rtx-plugins/rtx-tiny.git"),'
)

asdf_plugins=$(find asdf-plugins/plugins -maxdepth 1 |
	sort |
	grep -v '/go$' |
	grep -v '/golang$' |
	grep -v '/java$' |
	grep -v '/nodejs$' |
	grep -v '/plugins$' |
	grep -v '/python$' |
	grep -v '/ruby$')

num_plugins=$(echo "$asdf_plugins" | wc -l | tr -d ' ')
num_plugins=$((num_plugins + ${#custom_plugins[@]}))

cat >src/default_shorthands.rs <<EOF
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !GENERATED FILE!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !GENERATED FILE!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !GENERATED FILE!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// This file is generated by scripts/update-shorthand-repo.sh
// DO NOT EDIT THIS FILE MANUALLY. YOUR PR WILL BE REJECTED.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !GENERATED FILE!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !GENERATED FILE!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !GENERATED FILE!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

use once_cell::sync::Lazy;
use std::collections::HashMap;

pub static DEFAULT_SHORTHANDS: Lazy<HashMap<&'static str, &'static str>> =
    Lazy::new(|| HashMap::from(DEFAULT_SHORTHAND_LIST));

#[rustfmt::skip]
#[cfg_attr(coverage_nightly, no_coverage)]
const DEFAULT_SHORTHAND_LIST: [(&str, &str); $num_plugins] = [
    // asdf original shorthands from https://github.com/asdf-vm/asdf-plugins
EOF
for file in $asdf_plugins; do
	plugin=$(basename "$file")
	repository=$(cat "$file")
	repository="${repository/#repository = /}"
	echo "    (\"$plugin\", \"$repository\")," >>src/default_shorthands.rs
done
echo "    // rtx custom shorthands" >>src/default_shorthands.rs
for plugin in "${custom_plugins[@]}"; do
	echo "    $plugin" >>src/default_shorthands.rs
done
echo "];" >>src/default_shorthands.rs
rm -rf asdf-plugins
