#!/usr/bin/env bats

load ../test_helper

# For this script to work, `ssh localhost` must connect without asking
# anything.

@test "remote (ssh)" {
    mkdir subdir
    cd subdir
    pijul_uncovered init
    mkdir a b
    echo initial_a >> a/file.txt
    echo initial_b >> b/file.txt
    pijul_uncovered record -a -n -A edith -m 'create two files and dirs'
    echo addition_a >> a/file.txt
    echo addition_b >> b/file.txt
    pijul_uncovered record -a -n -A me -m 'edit two files in dirs'

    # The following definition is intentionally stupid: indeed, why
    # not define this variable at the beginning of this test, instead
    # of relative to the current directory? This actually tests
    # find_repo_root's use of canonical paths.
    REMOTE_DIR=$(pwd)/../remote
    mkdir -p $REMOTE_DIR
    # cd $REMOTE_DIR
    # pijul_uncovered init
    # cd $PIJUL_REPO_DIR/subdir

    export HOME=$HOME_BACKUP
    RUST_LOG=pijul=debug REMOTE_PIJUL="$PIJUL_EXE" pijul clone . localhost:$REMOTE_DIR/repo &> /tmp/log

    diff $REMOTE_DIR/repo/a/file.txt a/file.txt
    diff $REMOTE_DIR/repo/b/file.txt b/file.txt

    cd $REMOTE_DIR/repo
    echo blabla >> a/file.txt
    pijul_uncovered record -a -n -A me -m "remote"

    cd $PIJUL_REPO_DIR/subdir
    REMOTE_PIJUL="$PIJUL_EXE" pijul pull -p 22 -a localhost:$REMOTE_DIR --set-default
    REMOTE_PIJUL="$PIJUL_EXE" pijul push -p 22 -a localhost:$REMOTE_DIR --set-default

    cd $REMOTE_DIR/repo
    echo blibli >> a/file.txt
    pijul_uncovered record -a -n -A me -m "http"
    python -m http.server 8000&
    HTTP=$!
    trap "$(trap -p EXIT); kill -9 $HTTP" EXIT
    sleep 1
    cd $PIJUL_REPO_DIR/subdir
    pijul pull -a http://localhost:8000
    pijul pull -a file://$REMOTE_DIR/repo

    OTHER_CLONE=$(pwd)/../other_clone
    cd $OTHER_CLONE
    pijul clone localhost:$REMOTE_DIR/repo
}
