#!/usr/bin/env bats

load ../test_helper

@test "dist works" {
    make_repo toto
    cd toto
    touch act1 act2 act3
    mkdir d
    touch d/act4 d/act5
    pijul add act1 act2 d d/act4
    pijul record -am "bunch of files" -A "Élisabeth Jacquet de la Guerre"
    pijul dist -d "cephale-et-procris-1.0"
    test -e cephale-et-procris-1.0.tar.gz
    run tar ztvf cephale-et-procris-1.0.tar.gz
    assert_output "cephale-et-procris-1.0/act1"
    assert_output "cephale-et-procris-1.0/act2"
    assert_output "cephale-et-procris-1.0/d/act4"
    [[ ! ( $output =~ act3 ) ]]
    [[ ! ( $output =~ d/act5 ) ]]
}
