<!-- This file is autogenerated! Do not modify it -->

# Paper sizes
<a href="https://numbat.dev/?q=%23+Compute+ISO+216+paper+sizes+for+the+A+series%0A%23%0A%23+https%3A%2F%2Fen.wikipedia.org%2Fwiki%2FISO_216%0A%0Astruct+PaperSize+%7B%0A++++width%3A+Length%2C%0A++++height%3A+Length%2C%0A%7D%0A%0Afn+paper_size_A%28n%3A+Scalar%29+-%3E+PaperSize+%3D%0A++if+n+%3D%3D+0%0A++++then%0A++++++PaperSize+%7B%0A++++++++width%3A+841+mm%2C%0A++++++++height%3A+1189+mm%0A++++++%7D%0A++++else%0A++++++PaperSize+%7B%0A++++++++width%3A+floor%28paper_size_A%28n+-+1%29.height+%2F+2%29%2C%0A++++++++height%3A+paper_size_A%28n+-+1%29.width%2C%0A++++++%7D%0A%0A%0Afn+paper_area%28size%3A+PaperSize%29+-%3E+Area+%3D%0A++++size.width+%2A+size.height%0A%0A%0Afn+size_as_string%28size%3A+PaperSize%29+%3D+%22%7Bsize.width%3A%3E4%7D+%C3%97+%7Bsize.height%3A%3E5%7D+++%7Bpaper_area%28size%29+-%3E+cm%C2%B2%3A%3E6.1f%7D%22%0Afn+row%28n%29+%3D+%22A%7Bn%3A%3C3%7D+++%7Bsize_as_string%28paper_size_A%28n%29%29%7D%22%0A%0Aprint%28%22Name++++Width+++++Height++++++++Area++%22%29%0Aprint%28%22----+++-------+++--------+++----------%22%29%0Aprint%28join%28map%28row%2C+range%280%2C+10%29%29%2C+%22%5Cn%22%29%29%0A"><i class="fa fa-play"></i> Run this example</a>

``` numbat
# Compute ISO 216 paper sizes for the A series
#
# https://en.wikipedia.org/wiki/ISO_216

struct PaperSize {
    width: Length,
    height: Length,
}

fn paper_size_A(n: Scalar) -> PaperSize =
  if n == 0
    then
      PaperSize {
        width: 841 mm,
        height: 1189 mm
      }
    else
      PaperSize {
        width: floor(paper_size_A(n - 1).height / 2),
        height: paper_size_A(n - 1).width,
      }


fn paper_area(size: PaperSize) -> Area =
    size.width * size.height


fn size_as_string(size: PaperSize) = "{size.width:>4} × {size.height:>5}   {paper_area(size) -> cm²:>6.1f}"
fn row(n) = "A{n:<3}   {size_as_string(paper_size_A(n))}"

print("Name    Width     Height        Area  ")
print("----   -------   --------   ----------")
print(join(map(row, range(0, 10)), "\n"))
```
