# Summary

# Getting started

- [Introduction](./introduction.md)
- [Tutorial](./tutorial.md)
- [Example programs](./examples.md)
    - [Acidity](./example-acidity.md)
    - [Barometric formula](./example-barometric_formula.md)
    - [Body mass index](./example-body_mass_index.md)
    - [Factorial](./example-factorial.md)
    - [Flow rate in a pipe](./example-pipe_flow_rate.md)
    - [Medication dosage](./example-medication_dosage.md)
    - [Molarity](./example-molarity.md)
    - [Musical note frequency](./example-musical_note_frequency.md)
    - [Paper sizes](./example-paper_size.md)
    - [Population growth](./example-population_growth.md)
    - [Recipe](./example-recipe.md)
    - [XKCD 687](./example-xkcd_687.md)
    - [XKCD 2585](./example-xkcd_2585.md)
    - [XKCD 2812](./example-xkcd_2812.md)
- [IDE / editor integration](./editor-integration.md)

# Numbat language reference

- [Basics](./basics.md)
  - [Number notation](./number-notation.md)
  - [Unit notation](./unit-notation.md)
  - [Operations and precedence](./operations.md)
  - [Constants](./constant-definitions.md)
  - [Unit conversions](./unit-conversions.md)
  - [Conversions functions](./conversion-functions.md)
  - [Function definitions](./function-definitions.md)
  - [Conditionals](./conditionals.md)
  - [Date and time](./date-and-time.md)
  - [Printing, testing, debugging](./procedures.md)
  - [Structs](./structs.md)
- [Advanced](./advanced.md)
  - [Dimension definitions](./dimension-definitions.md)
  - [Unit definitions](./unit-definitions.md)
  - [Syntax overview](./example-numbat_syntax.md)

# Standard library reference

- [The prelude](./prelude.md)
  - [Predefined functions](./list-functions.md)
  - [Predefined constants](./list-constants.md)
  - [List of units](./list-units.md)

# Command line tool

- [Installation](./cli-installation.md)
- [Usage](./cli-usage.md)
- [Customization](./cli-customization.md)

# Web version

- [Usage](./web-usage.md)

# Notes for developers

- [Type system](./type-system.md)

# Support

- [Contact us](./contact-us.md)
