//  ██████╗  █████╗ ███████╗███████╗██╗███╗   ██╗ ██████╗
//  ██╔══██╗██╔══██╗██╔════╝██╔════╝██║████╗  ██║██╔════╝
//  ██████╔╝███████║███████╗███████╗██║██╔██╗ ██║██║  ███╗
//  ██╔═══╝ ██╔══██║╚════██║╚════██║██║██║╚██╗██║██║   ██║
//  ██║     ██║  ██║███████║███████║██║██║ ╚████║╚██████╔╝
//  ╚═╝     ╚═╝  ╚═╝╚══════╝╚══════╝╚═╝╚═╝  ╚═══╝ ╚═════╝

#[cfg(test)]
mod passing {
    use crate::js;

    #[test]
    fn onblur_camelcase() {
        assert!(js::attr_is_event_handler("onBlur"));
    }

    #[test]
    fn onclick_lowercase() {
        assert!(js::attr_is_event_handler("onclick"));
    }

    #[test]
    fn onclick_camelcase() {
        assert!(js::attr_is_event_handler("onClick"));
    }
}

//  ███████╗ █████╗ ██╗██╗     ██╗███╗   ██╗ ██████╗
//  ██╔════╝██╔══██╗██║██║     ██║████╗  ██║██╔════╝
//  █████╗  ███████║██║██║     ██║██╔██╗ ██║██║  ███╗
//  ██╔══╝  ██╔══██║██║██║     ██║██║╚██╗██║██║   ██║
//  ██║     ██║  ██║██║███████╗██║██║ ╚████║╚██████╔╝
//  ╚═╝     ╚═╝  ╚═╝╚═╝╚══════╝╚═╝╚═╝  ╚═══╝ ╚═════╝

#[cfg(test)]
mod failing {
    use crate::js;

    #[test]
    fn href() {
        assert!(!js::attr_is_event_handler("href"));
    }

    #[test]
    fn empty_string() {
        assert!(!js::attr_is_event_handler(""));
    }

    #[test]
    fn class() {
        assert!(!js::attr_is_event_handler("class"));
    }
}
