//  ██████╗  █████╗ ███████╗███████╗██╗███╗   ██╗ ██████╗
//  ██╔══██╗██╔══██╗██╔════╝██╔════╝██║████╗  ██║██╔════╝
//  ██████╔╝███████║███████╗███████╗██║██╔██╗ ██║██║  ███╗
//  ██╔═══╝ ██╔══██║╚════██║╚════██║██║██║╚██╗██║██║   ██║
//  ██║     ██║  ██║███████║███████║██║██║ ╚████║╚██████╔╝
//  ╚═╝     ╚═╝  ╚═╝╚══════╝╚══════╝╚═╝╚═╝  ╚═══╝ ╚═════╝

#[cfg(test)]
mod passing {
    use crate::html;

    #[test]
    fn icon() {
        assert!(html::is_icon("icon"));
    }

    #[test]
    fn shortcut_icon_capitalized() {
        assert!(html::is_icon("Shortcut Icon"));
    }

    #[test]
    fn icon_uppercase() {
        assert!(html::is_icon("ICON"));
    }
}

//  ███████╗ █████╗ ██╗██╗     ██╗███╗   ██╗ ██████╗
//  ██╔════╝██╔══██╗██║██║     ██║████╗  ██║██╔════╝
//  █████╗  ███████║██║██║     ██║██╔██╗ ██║██║  ███╗
//  ██╔══╝  ██╔══██║██║██║     ██║██║╚██╗██║██║   ██║
//  ██║     ██║  ██║██║███████╗██║██║ ╚████║╚██████╔╝
//  ╚═╝     ╚═╝  ╚═╝╚═╝╚══════╝╚═╝╚═╝  ╚═══╝ ╚═════╝

#[cfg(test)]
mod failing {
    use crate::html;

    #[test]
    fn mask_icon() {
        assert!(!html::is_icon("mask-icon"));
    }

    #[test]
    fn fluid_icon() {
        assert!(!html::is_icon("fluid-icon"));
    }

    #[test]
    fn stylesheet() {
        assert!(!html::is_icon("stylesheet"));
    }

    #[test]
    fn empty_string() {
        assert!(!html::is_icon(""));
    }
}
