#!/usr/bin/perl


use Image::ExifTool::Exif;
use Image::ExifTool::Apple;
use Image::ExifTool::Canon;
use Image::ExifTool::FujiFilm;
use Image::ExifTool::Minolta;
use Image::ExifTool::Nikon;
use Image::ExifTool::Olympus;
use Image::ExifTool::Panasonic;
use Image::ExifTool::PanasonicRaw;
use Image::ExifTool::Pentax;
use Image::ExifTool::Ricoh;
use Image::ExifTool::Sigma;
use Image::ExifTool::Sony;

#
# Output the tag table
#
sub output_table($$) {
    my ($table, $table_name) = @_;
    my @keys = grep { /^[\d]*$/ } keys(%$table);

    printf "\n\nconst TagTable %s = {\n", $table_name;
    foreach $tag (sort { $a <=> $b } @keys) {

        my $value = %$table{$tag};

        my $name;
        if (ref $value eq ref {}) {
            $name = %$value{'Name'};
        } elsif (ref $value eq ref []) {
            $item = @$value[0];
            $name = %$item{'Name'};
        } else {
            $name = $value;
        }
        printf "    { 0x%x, \"%s\" },\n", $tag, $name;
    }
    print "};";
}

printf "// AUTOGENERATED with ExifTool %s (%s)\n\n", $Image::ExifTool::VERSION, $Image::ExifTool::RELEASE;
print "#include <stdint.h>\n";
print "#include <map>\n\n";
print "#include \"exif_tags.hpp\"\n";

output_table(\%Image::ExifTool::Exif::Main, "exif_tag_names");
output_table(\%Image::ExifTool::Apple::Main, "mnote_apple_tag_names");
output_table(\%Image::ExifTool::Canon::Main, "mnote_canon_tag_names");
output_table(\%Image::ExifTool::FujiFilm::Main, "mnote_fujifilm_tag_names");
output_table(\%Image::ExifTool::Minolta::Main, "mnote_minolta_tag_names");
output_table(\%Image::ExifTool::Nikon::Main, "mnote_nikon_tag_names");
output_table(\%Image::ExifTool::Nikon::Type2, "mnote_nikon2_tag_names");
output_table(\%Image::ExifTool::Olympus::Main, "mnote_olympus_tag_names");
output_table(\%Image::ExifTool::Panasonic::Main, "mnote_panasonic_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica2, "mnote_leica2_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica4, "mnote_leica4_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica5, "mnote_leica5_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica6, "mnote_leica6_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica9, "mnote_leica9_tag_names");
output_table(\%Image::ExifTool::Pentax::Main, "mnote_pentax_tag_names");
output_table(\%Image::ExifTool::Ricoh::Main, "mnote_ricoh_tag_names");
output_table(\%Image::ExifTool::Sigma::Main, "mnote_sigma_tag_names");
output_table(\%Image::ExifTool::Sony::Main, "mnote_sony_tag_names");

output_table(\%Image::ExifTool::PanasonicRaw::Main, "raw_panasonic_tag_names");
