/*
 * Hurl (https://hurl.dev)
 * Copyright (C) 2022 Orange
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

pub use self::client::{Client, HttpError};
pub use self::core::{Cookie, Header, Param, RequestCookie};
pub use self::options::ClientOptions;
pub use self::request::Request;
#[cfg(test)]
pub use self::request_spec::tests::*;
pub use self::request_spec::{Body, FileParam, Method, MultipartParam, RequestSpec};
#[cfg(test)]
pub use self::response::tests::*;
pub use self::response::{Response, Version};
pub use self::version::libcurl_version_info;

mod client;
mod core;
mod options;
mod request;
mod request_spec;
mod response;
mod version;
