// amends "package://github.com/jdx/hk/releases/download/v0.8.5/hk@0.8.5#/Config.pkl"
amends "pkl/Config.pkl"
import "pkl/Builtins.pkl"

// defines what happens during git pre-commit hook
local linters = new Mapping<String, Step> {
    ["actionlint"] = Builtins.actionlint
    // TODO: fails on releases with hk-example.pkl
    // ["pkl"] {
    //     glob = new { "*.pkl" }
    //     check = "pkl eval {{files}} >/dev/null"
    // }
    // predefined formatters+linters
     ["cargo-clippy"] = (Builtins.cargo_clippy) {
         profiles = List("slow")
         check = "cargo clippy --manifest-path {{workspace_indicator}} -- -D warnings"
     }
     ["cargo-check"] = (Builtins.cargo_check) {
         profiles = List("!slow")
     }
     ["cargo-fmt"] = Builtins.cargo_fmt
     ["dbg"] {
         // ensure no dbg! macros are used
         glob = "**/*.rs"
         check = "! rg -e 'dbg!' {{files}}"
     }
     ["eslint"] = (Builtins.eslint) {
         dir = "docs"
         prefix = "bun run"
     }
     ["prettier"] = (Builtins.prettier) {
         glob = List("*.js", "*.ts", "*.yml", "*.yaml") // override the default globs
     }
}

hooks = new {
    ["pre-commit"] {
        fix = true
        stash = "patch-file"
        steps = new {
            ["prelint"] {
                check = "mise run prelint"
                exclusive = true
            }
            ...linters
            ["postlint"] {
                check = "echo postlint"
                exclusive = true
            }
        }
    }
    ["pre-push"] {
        steps = linters
    }
    ["check"] {
        steps = linters
    }
    ["fix"] {
        fix = true
        steps = linters
    }
    //["prepare-commit-msg"] {
    //    ["render-commit-msg"] {
    //        check = "echo 'default commit message' > {{commit_msg_file}}"
    //    }
    //}

    // TODO
    // ["commit-msg"] {}
}
