### String functions

| Name       | Parameters                   | Return  | Description                                                                                                                                                          |
| ---------- | ---------------------------- | ------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| BIN        | Integer                      | Text    | Return a string containing binary representation of a Integer.                                                                                                       |
| LOWER      | Text                         | Text    | Return Text in lower case.                                                                                                                                           |
| UPPER      | Text                         | Text    | Return Text in upper case.                                                                                                                                           |
| REVERSE    | Text                         | Text    | Return a reversed string.                                                                                                                                            |
| TRIM       | Text                         | Text    | Removes leading and trailing spaces from a string.                                                                                                                   |
| LTRIM      | Text                         | Text    | Removes leading spaces from a string.                                                                                                                                |
| RTRIM      | Text                         | Text    | Removes trailing spaces from a string.                                                                                                                               |
| LEN        | Text                         | Integer | Return the length of this string.                                                                                                                                    |
| REPLICATE  | Text, Integer                | Text    | Return repeated a string a specified number of times.                                                                                                                |
| SPACE      | Integer                      | Text    | Returns a string of the specified number of space characters.                                                                                                        |
| ASCII      | Text                         | Integer | Returns the ASCII value for the specific character.                                                                                                                  |
| LEFT       | Text, Integer                | Text    | Extracts a number of characters from a string (starting from left).                                                                                                  |
| DATALENGTH | Text                         | Integer | Returns the number of bytes used to represent an expression.                                                                                                         |
| CHAR       | Integer                      | Text    | Returns the character based on the ASCII code.                                                                                                                       |
| CHARINDEX  | Text, Text                   | Integer | Returns the starting position of the first occurrence of a string in another string.                                                                                 |
| NCHAR      | Integer                      | Text    | Returns the character based on the ASCII code.                                                                                                                       |
| REPLACE    | Text, Text, Text             | Text    | Replaces all occurrences of a substring within a string, with a new substring.                                                                                       |
| SUBSTRING  | Text, Integer, Integer       | Text    | Extracts some characters from a string.                                                                                                                              |
| STUFF      | Text, Integer, Integer, Text | Text    | Deletes a part of a string and then inserts another part into the string, starting at a specified position.                                                          |
| RIGHT      | Text, Integer                | Text    | Extracts a number of characters from a string (starting from right).                                                                                                 |
| TRANSLATE  | Text, Text, Text,            | Text    | Returns the string from the first argument after the characters specified in the second argument are translated into the characters specified in the third argument. |
| SOUNDEX    | Text                         | Text    | Returns a four-character code to evaluate the similarity of two expressions.                                                                                         |
| CONCAT     | Any, Any, ...Any             | Text    | Add several string representations of values together together.                                                                                                      |
| CONCAT_WS  | Text, Any, Any, ...Any       | Text    | Add several string representations of values together together with separate.                                                                                        |
| UNICODE    | Text                         | Integer | Return an integer value (the Unicode value), for the first character of the input expression.                                                                        |
| STRCMP     | Text , Text                  | Integer | Return 0 If string1 = string2, -1 if string1 < string2, this function returns -1, and 1 if string1 > string2                                                         |
| QUOTENAME  | Text , Text                  | Text    | Returns the string (first argument) with specified delimiters (second argument), defaulting to []                                                                    |
| STR        | Text, Integer?, Integer?     | Text    | Returns a number as a string with optionals length and decimals.                                                                                                     |
