# `changelog`

This section contains the configuration options for changelog generation.

<!-- {% raw %} -->

```toml
[changelog]
header = "Changelog"
body = """
{% for group, commits in commits | group_by(attribute="group") %}
    ### {{ group | upper_first }}
    {% for commit in commits %}
        - {{ commit.message | upper_first }}
    {% endfor %}
{% endfor %}
"""
trim = true
footer = "<!-- generated by git-cliff -->"
postprocessors = [{ pattern = "foo", replace = "bar"}]
```

<!-- {% endraw %} -->

### header

Header text that will be added to the beginning of the changelog.

### body

Body template that represents a single release in the changelog.

See [templating](/docs/category/templating) for more detail.

### footer

Footer template that will be rendered and added to the end of the changelog.

The template context is the same as [`body`](#body) and contains all the releases instead of a single release.

For example, to get the list of releases, use the `{{ releases }}` variable in the template. To get information about a single release, iterate over this array and access the fields similar to [`body`](#body).

See [Keep a Changelog configuration](/docs/templating/examples#keep-a-changelog) for seeing the example of adding links to the end of the changelog.

### trim

If set to `true`, leading and trailing whitespace are removed from the [`body`](#body).

It is useful for adding indentation to the template for readability, as shown [in the example](#changelog).

### postprocessors

An array of commit postprocessors for manipulating the changelog before outputting.
Can e.g. be used for replacing commit author with GitHub usernames.
Internally postprocessors and preprocessors are the same. See [commit_preprocessors](/docs/configuration/git#commit_preprocessors) for more detail and examples, it uses the same syntax.
