---
sidebar_position: 1
---
# Rust/Cargo

For Rust projects, **git-cliff** can be configured in `Cargo.toml` via [metadata table](https://doc.rust-lang.org/cargo/reference/manifest.html#the-metadata-table). To do this, simply replace the available configuration sections with `[package.metadata.git-cliff.<section>]` and place them inside `Cargo.toml`. For example:

```toml
[package]
name = "..."

[dependencies]
# ...

[package.metadata.git-cliff.changelog]
header = "All notable changes to this project will be documented in this file."
body = "..."
footer = "<!-- generated by git-cliff -->"
# see [changelog] section for more keys

[package.metadata.git-cliff.git]
conventional_commits = true
commit_parsers = []
filter_commits = false
# see [git] section for more keys
```

For Cargo workspaces, [`workspace.metadata`](https://doc.rust-lang.org/cargo/reference/workspaces.html#the-workspacemetadata-table) table can be used. (e.g. `[workspace.metadata.git-cliff.<section>]`)
