/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_2826;
import net.minecraft.class_5539;

public final class SkyStarLightEngine
extends StarLightEngine {
    protected final int[] heightMapBlockChange = new int[256];
    protected final boolean[] nullPropagationCheckCache;
    protected final class_2338.class_2339 recalcCenterPos;
    protected final class_2338.class_2339 recalcNeighbourPos;
    protected final int[] heightMapGen;

    public SkyStarLightEngine(class_1937 world) {
        super(true, world);
        Arrays.fill(this.heightMapBlockChange, Integer.MIN_VALUE);
        this.recalcCenterPos = new class_2338.class_2339();
        this.recalcNeighbourPos = new class_2338.class_2339();
        this.heightMapGen = new int[1024];
        this.nullPropagationCheckCache = new boolean[WorldUtil.getTotalLightSections((class_5539)world)];
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            nibble = new SWMRNibbleArray(null, true);
            this.setNibbleInCache(chunkX, chunkY, chunkZ, nibble);
        }
        this.initNibble(nibble, chunkX, chunkY, chunkZ, extrude);
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setNull();
        }
    }

    protected final void initNibble(SWMRNibbleArray currNibble, int chunkX, int chunkY, int chunkZ, boolean extrude) {
        int currY;
        if (!currNibble.isNullNibbleUpdating()) {
            return;
        }
        boolean[] emptinessMap = this.getEmptinessMap(chunkX, chunkZ);
        int lowestY = this.minLightSection - 1;
        for (currY = this.maxSection; currY >= this.minSection; --currY) {
            class_2826 current;
            if (emptinessMap == null ? (current = this.getChunkSection(chunkX, currY, chunkZ)) == null || current.method_38292() : emptinessMap[currY - this.minSection]) continue;
            lowestY = currY;
            break;
        }
        if (chunkY > lowestY) {
            SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
            nibble.setNonNull();
            nibble.setFull();
            return;
        }
        if (extrude) {
            for (currY = chunkY + 1; currY <= this.maxLightSection; ++currY) {
                SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, currY, chunkZ);
                if (nibble == null || nibble.isNullNibbleUpdating()) continue;
                currNibble.setNonNull();
                currNibble.extrudeLower(nibble);
                break;
            }
        } else {
            currNibble.setNonNull();
        }
    }

    protected final void rewriteNibbleCacheForSkylight(class_2791 chunk) {
        for (SWMRNibbleArray nibble : this.nibbleCache) {
            if (nibble == null || !nibble.isNullNibbleUpdating()) continue;
            this.nibbleCache[index] = null;
            nibble.updateVisible();
        }
    }

    protected final boolean checkNullSection(int chunkX, int chunkY, int chunkZ, boolean extrudeInitialised) {
        int dx;
        int dz;
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.nullPropagationCheckCache[chunkY - this.minLightSection]) {
            return false;
        }
        this.nullPropagationCheckCache[chunkY - this.minLightSection] = true;
        boolean needInitNeighbours = false;
        block0: for (dz = -1; dz <= 1; ++dz) {
            for (dx = -1; dx <= 1; ++dx) {
                SWMRNibbleArray nibble = this.getNibbleFromCache(dx + chunkX, chunkY, dz + chunkZ);
                if (nibble == null || nibble.isNullNibbleUpdating()) continue;
                needInitNeighbours = true;
                break block0;
            }
        }
        if (needInitNeighbours) {
            for (dz = -1; dz <= 1; ++dz) {
                for (dx = -1; dx <= 1; ++dx) {
                    this.initNibble(dx + chunkX, chunkY, dz + chunkZ, (dx | dz) == 0 ? extrudeInitialised : true, true);
                }
            }
        }
        return needInitNeighbours;
    }

    protected final int getLightLevelExtruded(int worldX, int worldY, int worldZ) {
        int chunkX = worldX >> 4;
        int chunkY = worldY >> 4;
        int chunkZ = worldZ >> 4;
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            return nibble.getUpdating(worldX, worldY, worldZ);
        }
        do {
            if (++chunkY <= this.maxLightSection) continue;
            return 15;
        } while ((nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ)) == null);
        return nibble.getUpdating(worldX, 0, worldZ);
    }

    @Override
    protected boolean[] getEmptinessMap(class_2791 chunk) {
        return ((ExtendedChunk)chunk).getSkyEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(class_2791 chunk, boolean[] to) {
        ((ExtendedChunk)chunk).setSkyEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(class_2791 chunk) {
        return ((ExtendedChunk)chunk).getSkyNibbles();
    }

    @Override
    protected void setNibbles(class_2791 chunk, SWMRNibbleArray[] to) {
        ((ExtendedChunk)chunk).setSkyNibbles(to);
    }

    @Override
    protected boolean canUseChunk(class_2791 chunk) {
        return chunk.method_12009().method_12165(class_2806.field_12805) && (this.isClientSide || chunk.method_12038());
    }

    @Override
    protected void checkChunkEdges(class_2823 lightAccess, class_2791 chunk, int fromSection, int toSection) {
        Arrays.fill(this.nullPropagationCheckCache, false);
        this.rewriteNibbleCacheForSkylight(chunk);
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        for (int y = toSection; y >= fromSection; --y) {
            this.checkNullSection(chunkX, y, chunkZ, true);
        }
        super.checkChunkEdges(lightAccess, chunk, fromSection, toSection);
    }

    @Override
    protected void checkChunkEdges(class_2823 lightAccess, class_2791 chunk, ShortCollection sections) {
        Arrays.fill(this.nullPropagationCheckCache, false);
        this.rewriteNibbleCacheForSkylight(chunk);
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        ShortIterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            short y = iterator.nextShort();
            this.checkNullSection(chunkX, y, chunkZ, true);
        }
        super.checkChunkEdges(lightAccess, chunk, sections);
    }

    @Override
    protected void checkBlock(class_2823 lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        if (currentLevel == 15) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L | Long.MIN_VALUE);
        } else {
            this.setLightLevel(worldX, worldY, worldZ, 0);
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(class_2823 lightAccess, int worldX, int worldY, int worldZ, int expect) {
        Object conditionallyOpaqueState;
        if (expect == 15) {
            return expect;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        class_2680 centerState = this.getBlockState(worldX, worldY, worldZ);
        int opacity = ((ExtendedAbstractBlockState)centerState).getOpacityIfCached();
        if (opacity < 0) {
            this.recalcCenterPos.method_10103(worldX, worldY, worldZ);
            opacity = Math.max(1, centerState.method_26193(lightAccess.method_16399(), (class_2338)this.recalcCenterPos));
            conditionallyOpaqueState = ((ExtendedAbstractBlockState)centerState).isConditionallyFullOpaque() ? centerState : null;
        } else {
            conditionallyOpaqueState = null;
            opacity = Math.max(1, opacity);
        }
        int level = 0;
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            class_2680 neighbourState = this.getBlockState(offX, offY, offZ);
            if (((ExtendedAbstractBlockState)neighbourState).isConditionallyFullOpaque()) {
                class_265 thisFace;
                this.recalcNeighbourPos.method_10103(offX, offY, offZ);
                class_265 neighbourFace = neighbourState.method_26173(lightAccess.method_16399(), (class_2338)this.recalcNeighbourPos, direction.opposite.nms);
                class_265 class_2652 = thisFace = conditionallyOpaqueState == null ? class_259.method_1073() : conditionallyOpaqueState.method_26173(lightAccess.method_16399(), (class_2338)this.recalcCenterPos, direction.nms);
                if (class_259.method_20713((class_265)thisFace, (class_265)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(class_2823 lightAccess, class_2791 atChunk, Set<class_2338> positions) {
        this.rewriteNibbleCacheForSkylight(atChunk);
        Arrays.fill(this.nullPropagationCheckCache, false);
        class_1922 world = lightAccess.method_16399();
        int chunkX = atChunk.method_12004().field_9181;
        int chunkZ = atChunk.method_12004().field_9180;
        int heightMapOffset = chunkX * -16 + chunkZ * -256;
        for (class_2338 pos : positions) {
            int index = pos.method_10263() + (pos.method_10260() << 4) + heightMapOffset;
            int curr = this.heightMapBlockChange[index];
            if (pos.method_10264() <= curr) continue;
            this.heightMapBlockChange[index] = pos.method_10264();
        }
        block1: for (int index = 0; index < 256; ++index) {
            int maxY = this.heightMapBlockChange[index];
            if (maxY == Integer.MIN_VALUE) continue;
            this.heightMapBlockChange[index] = Integer.MIN_VALUE;
            int columnX = index & 0xF | chunkX << 4;
            int columnZ = index >>> 4 | chunkZ << 4;
            int maxPropagationY = this.tryPropagateSkylight(world, columnX, maxY, columnZ, true, true);
            long propagateDirection = StarLightEngine.AxisDirection.POSITIVE_Y.everythingButThisDirection;
            int encodeOffset = this.coordinateOffset;
            if (this.getLightLevelExtruded(columnX, maxPropagationY, columnZ) != 15) continue;
            this.checkNullSection(columnX >> 4, maxPropagationY >> 4, columnZ >> 4, true);
            for (int currY = maxPropagationY; currY >= this.minLightSection << 4; --currY) {
                SWMRNibbleArray nibble;
                if ((currY & 0xF) == 15) {
                    this.checkNullSection(columnX >> 4, currY >> 4, columnZ >> 4, true);
                }
                if ((nibble = this.getNibbleFromCache(columnX >> 4, currY >> 4, columnZ >> 4)) == null) {
                    currY &= 0xFFFFFFF0;
                    continue;
                }
                if (nibble.getUpdating(columnX, currY, columnZ) != 15) continue block1;
                this.appendToDecreaseQueue((long)(columnX + (columnZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
            }
        }
        this.processDelayedIncreases();
        this.processDelayedDecreases();
        for (class_2338 pos : positions) {
            this.checkBlock(lightAccess, pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        this.performLightDecrease(lightAccess);
    }

    @Override
    protected void lightChunk(class_2823 lightAccess, class_2791 chunk, boolean needsEdgeChecks) {
        this.rewriteNibbleCacheForSkylight(chunk);
        Arrays.fill(this.nullPropagationCheckCache, false);
        class_1922 world = lightAccess.method_16399();
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        class_2826[] sections = chunk.method_12006();
        int highestNonEmptySection = this.maxSection;
        while (highestNonEmptySection == this.minSection - 1 || sections[highestNonEmptySection - this.minSection] == null || sections[highestNonEmptySection - this.minSection].method_38292()) {
            this.checkNullSection(chunkX, highestNonEmptySection, chunkZ, false);
            for (StarLightEngine.AxisDirection direction : ONLY_HORIZONTAL_DIRECTIONS) {
                int currY;
                int startZ;
                int startX;
                int incZ;
                int incX;
                int neighbourX = chunkX + direction.x;
                int neighbourZ = chunkZ + direction.z;
                SWMRNibbleArray neighbourNibble = this.getNibbleFromCache(neighbourX, highestNonEmptySection, neighbourZ);
                if (neighbourNibble == null) continue;
                if (direction.x != 0) {
                    incX = 0;
                    incZ = 1;
                    startX = direction.x < 0 ? chunkX << 4 : chunkX << 4 | 0xF;
                    startZ = chunkZ << 4;
                } else {
                    incX = 1;
                    incZ = 0;
                    startZ = direction.z < 0 ? chunkZ << 4 : chunkZ << 4 | 0xF;
                    startX = chunkX << 4;
                }
                int encodeOffset = this.coordinateOffset;
                long propagateDirection = 1L << direction.ordinal();
                int maxY = currY | 0xF;
                for (currY = highestNonEmptySection << 4; currY <= maxY; ++currY) {
                    int i = 0;
                    int currX = startX;
                    int currZ = startZ;
                    while (i < 16) {
                        this.appendToIncreaseQueue((long)(currX + (currZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
                        ++i;
                        currX += incX;
                        currZ += incZ;
                    }
                }
            }
            if (highestNonEmptySection-- != this.minSection - 1) continue;
        }
        if (highestNonEmptySection >= this.minSection) {
            int minX = chunkPos.field_9181 << 4;
            int maxX = chunkPos.field_9181 << 4 | 0xF;
            int minZ = chunkPos.field_9180 << 4;
            int maxZ = chunkPos.field_9180 << 4 | 0xF;
            int startY = highestNonEmptySection << 4 | 0xF;
            for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                for (int currX = minX; currX <= maxX; ++currX) {
                    this.tryPropagateSkylight(world, currX, startY + 1, currZ, false, false);
                }
            }
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            for (int y = highestNonEmptySection; y >= this.minLightSection; --y) {
                this.checkNullSection(chunkX, y, chunkZ, false);
            }
            super.checkChunkEdges(lightAccess, chunk, this.minLightSection, highestNonEmptySection);
        } else {
            for (int y = highestNonEmptySection; y >= this.minLightSection; --y) {
                this.checkNullSection(chunkX, y, chunkZ, false);
            }
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, highestNonEmptySection);
            this.performLightIncrease(lightAccess);
        }
    }

    protected final void processDelayedIncreases() {
        long[] queue = this.increaseQueue;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int len = this.increaseQueueInitialLength;
        for (int i = 0; i < len; ++i) {
            long queueValue = queue[i];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            int propagatedLightLevel = (int)(queueValue >>> 28 & 0xFL);
            this.setLightLevel(posX, posY, posZ, propagatedLightLevel);
        }
    }

    protected final void processDelayedDecreases() {
        long[] queue = this.decreaseQueue;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int len = this.decreaseQueueInitialLength;
        for (int i = 0; i < len; ++i) {
            long queueValue = queue[i];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            this.setLightLevel(posX, posY, posZ, 0);
        }
    }

    protected final int tryPropagateSkylight(class_1922 world, int worldX, int startY, int worldZ, boolean extrudeInitialised, boolean delayLightSet) {
        class_2338.class_2339 mutablePos = this.mutablePos3;
        int encodeOffset = this.coordinateOffset;
        long propagateDirection = StarLightEngine.AxisDirection.POSITIVE_Y.everythingButThisDirection;
        if (this.getLightLevelExtruded(worldX, startY + 1, worldZ) != 15) {
            return startY;
        }
        this.checkNullSection(worldX >> 4, startY >> 4, worldZ >> 4, extrudeInitialised);
        class_2680 above = this.getBlockState(worldX, startY + 1, worldZ);
        while (startY >= this.minLightSection << 4) {
            int opacityIfCached;
            class_265 fromShape;
            if ((startY & 0xF) == 15) {
                this.checkNullSection(worldX >> 4, startY >> 4, worldZ >> 4, extrudeInitialised);
            }
            class_2680 current = this.getBlockState(worldX, startY, worldZ);
            if (((ExtendedAbstractBlockState)above).isConditionallyFullOpaque()) {
                this.mutablePos2.method_10103(worldX, startY + 1, worldZ);
                fromShape = above.method_26173(world, (class_2338)this.mutablePos2, StarLightEngine.AxisDirection.NEGATIVE_Y.nms);
                if (class_259.method_20713((class_265)class_259.method_1073(), (class_265)fromShape)) {
                    break;
                }
            } else {
                fromShape = class_259.method_1073();
            }
            if ((opacityIfCached = ((ExtendedAbstractBlockState)current).getOpacityIfCached()) != -1) {
                if (opacityIfCached != 0) break;
                this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (startY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
            } else {
                int opacity;
                mutablePos.method_10103(worldX, startY, worldZ);
                long flags = 0L;
                if (((ExtendedAbstractBlockState)current).isConditionallyFullOpaque()) {
                    class_265 cullingFace = current.method_26173(world, (class_2338)mutablePos, StarLightEngine.AxisDirection.POSITIVE_Y.nms);
                    if (class_259.method_20713((class_265)fromShape, (class_265)cullingFace)) break;
                    flags |= Long.MIN_VALUE;
                }
                if ((opacity = current.method_26193(world, (class_2338)mutablePos)) > 0) break;
                this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (startY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32 | flags);
            }
            above = current;
            if (this.getNibbleFromCache(worldX >> 4, startY >> 4, worldZ >> 4) == null) {
                --this.increaseQueueInitialLength;
                startY &= 0xFFFFFFF0;
                above = AIR_BLOCK_STATE;
            } else if (!delayLightSet) {
                this.setLightLevel(worldX, startY, worldZ, 15);
            }
            --startY;
        }
        return startY;
    }
}

