/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_340;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_340.class})
public abstract class MixinDebugHud {
    @Shadow
    @Final
    private class_310 field_2079;
    @Shadow
    @Final
    private class_327 field_2081;
    private List<String> capturedList = null;

    @Redirect(method={"renderLeftText", "renderRightText"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I"))
    private int preRenderText(List<String> list) {
        this.capturedList = list;
        return 0;
    }

    @Inject(method={"renderLeftText"}, at={@At(value="RETURN")})
    public void renderLeftText(class_4587 matrixStack, CallbackInfo ci) {
        this.renderCapturedText(matrixStack, false);
    }

    @Inject(method={"renderRightText"}, at={@At(value="RETURN")})
    public void renderRightText(class_4587 matrixStack, CallbackInfo ci) {
        this.renderCapturedText(matrixStack, true);
    }

    private void renderCapturedText(class_4587 matrixStack, boolean right) {
        Validate.notNull(this.capturedList, (String)"Failed to capture string list", (Object[])new Object[0]);
        this.renderBackdrop(matrixStack, this.capturedList, right);
        this.renderStrings(matrixStack, this.capturedList, right);
        this.capturedList = null;
    }

    private void renderStrings(class_4587 matrixStack, List<String> list, boolean right) {
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_1159 positionMatrix = matrixStack.method_23760().method_23761();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.field_2081.method_1727(string);
            float x1 = right ? (float)(this.field_2079.method_22683().method_4486() - 2 - width) : 2.0f;
            float y1 = 2 + height * i;
            this.field_2081.method_27522(string, x1, y1, 0xE0E0E0, false, positionMatrix, (class_4597)immediate, false, 0, 0xF000F0, this.field_2081.method_1726());
        }
        immediate.method_22993();
    }

    private void renderBackdrop(class_4587 matrixStack, List<String> list, boolean right) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        int color = -1873784752;
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        class_1159 matrix = matrixStack.method_23760().method_23761();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.field_2081.method_1727(string);
            int x = right ? this.field_2079.method_22683().method_4486() - 2 - width : 2;
            int y = 2 + height * i;
            float x1 = x - 1;
            float y1 = y - 1;
            float x2 = x + width + 1;
            float y2 = y + height - 1;
            bufferBuilder.method_22918(matrix, x1, y2, 0.0f).method_22915(g, h, k, f).method_1344();
            bufferBuilder.method_22918(matrix, x2, y2, 0.0f).method_22915(g, h, k, f).method_1344();
            bufferBuilder.method_22918(matrix, x2, y1, 0.0f).method_22915(g, h, k, f).method_1344();
            bufferBuilder.method_22918(matrix, x1, y1, 0.0f).method_22915(g, h, k, f).method_1344();
        }
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

