/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.passes;

import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.minecraft.class_1921;

public class BlockRenderPassManager {
    private final Reference2IntArrayMap<class_1921> mappingsId = new Reference2IntArrayMap();

    public BlockRenderPassManager() {
        this.mappingsId.defaultReturnValue(-1);
    }

    public int getRenderPassId(class_1921 layer) {
        int pass = this.mappingsId.getInt((Object)layer);
        if (pass < 0) {
            throw new NullPointerException("No render pass exists for layer: " + layer);
        }
        return pass;
    }

    private void addMapping(class_1921 layer, BlockRenderPass type) {
        if (this.mappingsId.put((Object)layer, type.ordinal()) >= 0) {
            throw new IllegalArgumentException("Layer target already defined for " + layer);
        }
    }

    public static BlockRenderPassManager createDefaultMappings() {
        BlockRenderPassManager mapper = new BlockRenderPassManager();
        mapper.addMapping(class_1921.method_23577(), BlockRenderPass.SOLID);
        mapper.addMapping(class_1921.method_23579(), BlockRenderPass.CUTOUT_MIPPED);
        mapper.addMapping(class_1921.method_23581(), BlockRenderPass.CUTOUT);
        mapper.addMapping(class_1921.method_23583(), BlockRenderPass.TRANSLUCENT);
        mapper.addMapping(class_1921.method_29997(), BlockRenderPass.TRIPWIRE);
        return mapper;
    }

    public BlockRenderPass getRenderPassForLayer(class_1921 layer) {
        return this.getRenderPass(this.getRenderPassId(layer));
    }

    public BlockRenderPass getRenderPass(int i) {
        return BlockRenderPass.VALUES[i];
    }
}

