# Contributing to `dura`

# Pull request process
1. Discuss changes before starting. This helps avoid awkward situations, like where something has already been tried or isn't feasible for a non-obvious reason.
2. Add tests, if possible
    * [`end_to_end_test.rs`](https://github.com/tkellogg/dura/blob/master/tests/end_to_end_test.rs) is a good place to test out new functionality, and the test code reads fairly well.
    * Unit tests are preferred, when feasible. They go inside source files.
3. Explain the behavior as best as possible. Things like screenshots and GIFs can be helpful when it's visual.
4. Breathe deep. Smell the fresh clean air.

I try to get to PRs within a day. I'm usually quicker than that, but sometimes things slide through the cracks.

Oh! And please be kind. We're all here because we want to help other people. Please remember that.


# Coding guidelines

## Printing output
* All `stdout` is routed through the logger and is JSON.
* Messages to the user should be on `stderr` and are plain text (e.g. can't take a lock)
* Use serialized structs to write JSON logs, so that the structure remains mostly backward compatible. Try not to rename fields, in case someone has written scripts against it.


