use crate::shell_install::ShellFamily;

pub const BASH: ShellFamily<'static> = ShellFamily {
    name: "bash",
    sourcing_files: &[".bashrc", ".zshrc"],
    version: 1,
    script: BASH_FUNC,
};

// This script has been tested on bash and zsh.
// It's installed under the bash name (~/.config/broot
// but linked from both the .bashrc and the .zshrc files
const BASH_FUNC: &str = r#"
# This script was automatically generated by the broot function
# More information can be found in https://github.com/Canop/broot

# This function starts broot and executes the command
# it produces, if any.
# It's needed because some shell commands, like `cd`,
# have no useful effect if executed in a subshell.
function br {
    f=$(mktemp)
    (
	set +e
	broot --outcmd "$f" "$@"
	code=$?
	if [ "$code" != 0 ]; then
	    rm -f "$f"
	    exit "$code"
	fi
    )
    code=$?
    if [ "$code" != 0 ]; then
	return "$code"
    fi
    d=$(<"$f")
    rm -f "$f"
    eval "$d"
}
"#;
