## Description

_A description of the change and what it does. If relevant (such as any change that modifies the UI), **please provide screenshots** of the change:_

## Issue

_If applicable, what issue does this address?_

Closes: #

## Type of change

_Remove the irrelevant ones:_

- [x] _Bug fix (non-breaking change which fixes an issue)_
- [x] _New feature (non-breaking change which adds functionality)_
- [x] _Breaking change (if this change causes breakage or new behaviour, please state what)_
- [x] _Refactoring (a change that doesn't change application functionality)_
- [x] _Other (something else - please specify)_

## Test methodology

_If relevant, please state how this was tested:_

_Furthermore, please tick which platforms this change was tested on:_

- [ ] _Windows_
- [ ] _macOS_
- [ ] _Linux_

_If relevant, all of these platforms should be tested._

## Checklist

_If relevant, ensure the following have been met:_

- [ ] _Change has been tested to work, and does not cause new breakage unless intended_
- [ ] _Code has been self-reviewed_
- [ ] _Documentation has been added/updated if needed (README, help menu, etc.)_
- [ ] _Passes CI pipeline (clippy check and `cargo test` check)_
- [ ] _Areas your change affects have been linted using rustfmt (`cargo fmt`)_
- [ ] _No merge conflicts arise from the change_

## Other information

_Provide any other relevant information to this change:_
