#!/usr/bin/env bash

set -ex

# Incorporate TARGET env var to the build and test process
cargo build --target "$TARGET" --verbose

# We cannot run arm executables on linux
if [[ $TARGET != arm-unknown-linux-gnueabihf ]]; then
    cargo test --target "$TARGET" --verbose

    # Run 'bat' on its own source code and the README
    cargo run --target "$TARGET" -- src/main.rs README.md --paging=never
fi
