#!/usr/bin/env python3
#
# List our crates as they appear in Cargo.toml.  Useful for scripting.
#
# NB you may want list_crates_publish instead
# *This* script excludes crates according to an ad-hoc criterion

import toml.decoder
import sys
import os.path

TOPDIR = os.path.split(os.path.dirname(sys.argv[0]))[0]
WORKSPACE_TOML = os.path.join(TOPDIR, "Cargo.toml")


def strip_prefix(s, prefixes):
    for prefix in prefixes:
        if s.startswith(prefix):
            return s[len(prefix):]
    return s


def crate_list():
    t = toml.decoder.load(WORKSPACE_TOML)
    return list(strip_prefix(name, ["crates/", "maint/", "examples/gsoc2023/", "examples/hyper/"]) for name in t['workspace']['members'])


if __name__ == '__main__':
    for item in crate_list():
        print(item)
