# State and key management CLI

Arti will need the following new subcommands:

  * `arti-keys`, porcelain key management commands, for general key management
  * `arti-keys-raw`, plumbing key management commands
  * `arti-hss`, for managing the state (including keys) of hidden services
  * `arti-hsc`, for managing the state (including keys) of hidden service
    clients

Initially, `arti-hss` and `arti-hsc` will be only used for listing,
manipulating, and verifying the contents of Arti key stores (they are frontends
to Arti's [`KeyMgr`]). In the future, they will be extended to support
manipulatating other types of persistent state too (for example, `arti hss` will
also be used for manipulating the on-disk IPT records of the service).

NOTE: The subcommands documented here do not exist yet. Rather than being the
documentation for a finished product, this document is
  * a design document describing what needs to be implemented (which implicitly
    highlights what `KeyMgr` features we are missing)
  * a starting point for the CLI docs (although it might require some
    amendments, depending on how much the implementation deviates from what is
    described here)

This document illustrates what the rendered man pages for the future state
management CLIs might look like. The actual documentation/man pages will be be
generated by rendering the [ROFF] obtained from the documentation of Arti's
`clap::Command` (which will include the new `hsc` and `hss` subcommands).

NOTE: This document talks about "keys and certificates", but the `KeyMgr` does not
currently support certificates (but it will in the future. See [arti#955])

NOTE: `arti-keys`, `arti-keys-raw`, `arti-hsc` and `arti-hss` will be
implemented as arti subcommands (`arti keys`, `arti hsc`, `arti hss`).

TODO HSS: Design commands for converting C Tor HS service state to an Arti
keystore and associated state (calling it something like `arti-hss migrate` or
`arti-hss ctor-migrate`)

## `arti-keys`
```
NAME
       arti-keys - Command-line key management tools for Arti

DESCRIPTION
       A CLI for accessing, manipulating and validating the contents of Arti key
       stores.

       As with arti, keystores are configured through Arti's TOML config
       (specified using the --config flag).

       The key management functionality is exposed as a collection of
       subcommands, each subcommand supporting a different set of options.

       This command provides high-level subcommands ("porcelain"), suitable for
       most use cases. Its subcommands implement high-level operations,
       manipulating either individual keys or key bundles, as applicable. They
       also provide guardrails preventing users from corrupting the key stores,
       and are suitable for routine key management tasks. Moreover, they don't
       require familiarity with the implementation details of Arti's key stores.

       TODO: explain what an ArtiPath is (ArtiPaths are mentioned throughout
       the manual)

OPTIONS
       -c, --config <FILE>
               Specify which config file(s) to read. Defaults to
               [File("$HOME/.config/arti/arti.toml"),
               Dir("$HOME/.config/arti/arti.d/")]

           --disable-fs-permission-checks
               Don't check permissions on the files we use.

       --keystore-dir <ARTI_KEYSTORE>
          Use the keystore from the specified directory, which should be an Arti
          format keystore. This is a convenience alias for
          -o storage.keystore.path=<ARTI_KEYSTORE>

       -h, --help
               Print help information

       -l, --log-level <LEVEL>
               Override the log level (usually one of 'trace', 'debug', 'info', 'warn', 'error').

       -o <KEY=VALUE>
               Override config file parameters, using TOML-like syntax.

       -V, --version
            Print version information

SUBCOMMANDS
       help               Print this message or the help of the given subcommand(s)
       list               List keys and certificates from the configured key stores
       describe           Print information about a specific key
       verify             Perform validity and consistency checks
```

### `arti-keys-list`

```
NAME
       arti-keys-list - List keys and certificates from the configured key
       stores

SYNOPSIS
       arti keys list [OPTIONS]

DESCRIPTION
       List the keys and certificates from the specified key stores. If no key
       stores are specified, this command lists the keys and certificates from
       all stores.

       In the pretty-printed output:
          * expired keys and certificates are annotated with (exp).
          * unrecognized keys and certificates (i.e. keys that have an unknown
            purpose) are annotated with (unk)
          * the keys and certificates that are not associated with one of the
            configured identities (i.e. keys with an unrecognized client/service
            nickname) are also annotated with (unk)

OPTIONS
       --keystore all
            List the keys and certificates from all key stores. This is the
            default behavior if the --keystore flag is omitted
       --keystore default
            List the keys and certificates from the default keystore.
       --keystore [<kid>...]
            Specifies the IDs of the keystores to list keys and certificates
            from. The IDs must be associated with keystores from the Arti TOML
            config. It is an error to specify a key store ID not associated with
            any of the configured key stores.
        --output [pretty|json]
            The output format. Defaults to 'pretty', a pretty-printed,
            human-friendly format.
       --verbose
           Print more information about each listed key. This includes a
           description of the key, the ID of the key store it is located in, and
           whether the key is unrecognized or expired. This flag is disregarded
           if --output=json, because the JSON output always contains the full
           description of the key

       TODO: in the future we might want an option for only listing certs or
       only listing a type of key
       TODO: maybe this needs an option for listing keys that match a given
       ArtiPath pattern?

EXAMPLES
       To pretty-print all the keys and certificates from keystores foo
       and bar:

         arti keys --config arti.toml list   \
           --keystore foo,bar                \
           --output pretty

       Sample output:

         ===== foo =====
           client/alice/abc.onion/KS_hsc_desc_enc.x25519_private
           client/alice/xyz.onion/KS_hsc_desc_enc.x25519_private
           client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private (unk)
           hs/carol/KS_hs_id.expanded_ed25519_private
           hs/carol/KS_hs_blind_id+19666_1440_43200.ed25519_expanded_private (exp)
           hs/carol/KS_hs_blind_id+19667_1440_43200.ed25519_expanded_private
           hs/carol/KS_hs_desc_sign+19666_1440_43200.ed25519_expanded_private (exp)
           hs/carol/KS_hs_desc_sign+19667_1440_43200.ed25519_expanded_private
           hs/dan/KS_hs_id.expanded_ed25519_private
           hs/eve/KS_hs_blind_id+19666_1440_43200.ed25519_expanded_private (unk)
           hs/eve/KS_hs_desc_sign+19667_1440_43200.ed25519_expanded_private (unk)
         ===== bar =====
           client/bob/def.onion/KS_hsc_desc_enc.x25519_private

       To include more information about each key, use --verbose:

         arti keys --config arti.toml list   \
           --keystore foo,bar                \
           --output pretty                   \
           --verbose

       Sample output:

         ===== client/alice/abc.onion/KS_hsc_desc_enc.x25519_private =====
           purpose: Client authorization key, used for onion descriptor decryption
           client: alice
           keystore ID: foo
           expired: no

         ===== client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private =====
           purpose: unknown
           client: alice
           keystore ID: foo

         ===== hs/eve/KS_hs_desc_sign+19666_1440_43200.ed25519_expanded_private =====
           purpose: descriptor signing key
           service: unknown
           keystore ID: foo
           expired: unknown

         ===== hs/eve/KS_hs_desc_sign+19667_1440_43200.ed25519_expanded_private =====
           purpose: descriptor signing key
           service: unknown
           keystore ID: foo
           expired: unknown
          ...


       With --output=json, the command prints the same information in JSON format.

       TODO: Add JSON output sample
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::list_matching`
  * `KeyMgr::describe`

TODO: we might want to add a `KeyMgr::list_all` for listing all the keys from a
given store (today this can be achieved by calling `list_matching` with a `"*"`
`KeyPathPattern`).

This command will be implemented by an API that uses `KeyMgr::list_matching` and
`KeyMgr::describe` under the hood. Note: `KeyMgr::list_matching` lists the keys
from all keystores. It will need to be modified to accept a `KeystoreSelector`
argument to support only listing the keys from a given keystore (otherwise we
can't implement the `--keystore` option). We'll also need some way of detecting
which keys are expired: given a valid `KeyPath`, the API will:
  * parse it back into its corresponding `KeySpecifier`
  * check if the `TimePeriod` stored in the `KeySpecifier` is "relevant". If it
    is not, it will declare the key expired. Checking if the `TimePeriod` is
    relevant or not can be done by checking if it's one of the
    `NetDir::hs_all_time_periods()` returned by a recent `NetDir`.
    Alternatively, the API could try to "guess" which time periods are relevant
    based on the current wallclock time

### `arti-keys-verify`

```
NAME
       arti-keys-verify - perform consistency, validity, and integrity checks
       on the specified stores

SYNOPSIS
       arti keys verify [OPTIONS]

DESCRIPTION
       The key vality checks fail if there are any
         * keys and certificates not associated with any current identity
         * unrecognized keys
         * expired keys
         * ... (TODO)

       If --fix is not specified, this command lists the keys and
       certificates that failed the validity checks from each key store,
       along with the reason for the failure.

       Note:
          * expired keys and certificates are annotated with (exp).
          * unrecognized keys and certificates (i.e. keys that have an unknown
            purpose) are annotated with (unk)
          * the keys and certificates that are not associated with one of the
            configured identities (i.e. keys with an unrecognized client/service
            nickname) are also annotated with (unk)

OPTIONS
       --keystore default
            Perform checks on the default keystore. This is the default
            behavior if the --keystore flag is omitted
       --keystore [<kid>...]
            Specifies the IDs of the keystores to check. The IDs must
            be associated with keystores from the Arti TOML config. It is an
            error to specify a key store ID not associated with any of the
            configured key stores.
       --fix
            Attempt to fix the problems detected. Any expired or unrecognized
            keys and certificates are removed. Prompts before every removal
        --output [pretty|json]
            The output format. Defaults to 'pretty', a pretty-printed,
            human-friendly format
       --verbose
            Print more information about each reported problem. This flag is
            disregarded if --output=json, because the JSON output always
            contains the full error report

EXAMPLES
       Perform validity checks on keystores foo and bar:

         arti keys verify --config arti.toml \
           --keystore foo,bar                \
           --output pretty

       Sample output:

         verifying 2 keystores
         bar ... OK
         foo ... FAILED

         failures:

         ====== foo ======
         client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private (unk)
         hs/carol/KS_hs_blind_id+19666_1440_43200.ed25519_expanded_private (exp)
         hs/carol/KS_hs_desc_sign+19666_1440_43200.ed25519_expanded_private (exp)

       Perform validity checks on keystores foo and bar, removing any invalid keys:

        arti kets verify --config arti.toml \
          --keystore foo,bar                \
          --fix

       Sample output:

         verifying 2 keystores
         bar ... OK
         foo ... FAILED

         failures:

         ====== foo ======
         client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private (unk) Remove? [y/N]: y
         hs/carol/KS_hs_blind_id+19666_1440_43200.ed25519_expanded_private (exp) Remove? [y/N]: y
         hs/carol/KS_hs_desc_sign+19666_1440_43200.ed25519_expanded_private (exp) Remove? [y/N]: N
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::list_matching`
  * `KeyMgr::describe`
  * `KeyMgr::remove`

This command is exactly like `arti-keys-list`, except it also removes the
invalid keys if prompted to do so.

### `arti-keys-describe`

```
NAME
       arti-keys-describe - print information about a specific key

SYNOPSIS
       arti keys describe [OPTIONS] <ARTI_PATH>

DESCRIPTION
       Given the ArtiPath of a key, print a description of what the key is used
       for.
OPTIONS
       --output [pretty|json]
           The output format. Defaults to 'pretty', a pretty-printed,
           human-friendly format
       --verbose
           Print more information about the key. This includes a description of
           the key, the ID of the key store it is located in, and whether the
           key is unrecognized or expired. This flag is disregarded if
           --output=json, because the JSON output always contains the full
           description of the key

       TODO: maybe this needs an option for describing keys that match a given
       ArtiPath pattern?

EXAMPLES
       Describe the ArtiPath of a hidden service identity key:

         arti keys describe hs/carol/KS_hs_id.expanded_ed25519_private

       Sample output:

         ===== hs/carol/KS_hs_id.expanded_ed25519_private =====
           purpose: The long-term identity keypair of the service.
           type: ed25519 keypair
           service: carol
           expired: no

       Describe a malformed client ArtiPath:

         arti keys describe \
             client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private

       Sample output:
         ===== client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private =====
           purpose: unknown
           type: x25519 keypair
           expired: unknown

       Describe a malformed ArtiPath:

         arti keys describe abc.xyz

       Sample output:
         ===== abc.xyz =====
           purpose: unknown
           type: unknown
           expired: unknown
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::describe`

This will be implemented by an API based on `KeyMgr::describe`. As mentioned
under `arti-keys-list`, the API will also need to be able to detect if the
specified key is expired or not (this is not something `KeyMgr` can do. See
`KeystoreSweeper` for an example of how key expiration is detected and handled
today. The key expiration logic will need to be factored out of
`KeystoreSweeper`, because we'll need it for the CLI APIs too).

## `arti-keys-raw`

```
NAME
       arti-keys-raw - Command-line key management plumbing tools for Arti

DESCRIPTION
       A CLI for accessing and manipulating the contents of Arti key stores.

       As with arti, keystores are configured through Arti's TOML config
       (specified using the --config flag).

       The key management functionality is exposed as a collection of "plumbing"
       subcommands, each subcommand supporting a different set of options.

       The arti-keys-raw commands operate at a lower level than the arti-keys(1)
       commands. They operate on individual keys, specified as `ArtiPath`s. As
       such, their misuse can lead to key store corruption.

       You most likely do **not** need to use these: all common/routine use
       cases *should* be covered by the higher level arti-keys(1) subcommands.
       If you find yourself needing these commands for routine key management
       tasks, it means we are missing a porcelain wrapper for your workflow.

       TODO: explain what an ArtiPath is (ArtiPaths are mentioned throughout
       the manual)

OPTIONS
       -c, --config <FILE>
               Specify which config file(s) to read. Defaults to
               [File("$HOME/.config/arti/arti.toml"),
               Dir("$HOME/.config/arti/arti.d/")]

           --disable-fs-permission-checks
               Don't check permissions on the files we use.

       --keystore-dir <ARTI_KEYSTORE>
          Use the keystore from the specified directory, which should be an Arti
          format keystore. This is a convenience alias for
          -o storage.keystore.path=<ARTI_KEYSTORE>

       -h, --help
               Print help information

       -l, --log-level <LEVEL>
               Override the log level (usually one of 'trace', 'debug', 'info', 'warn', 'error').

       -o <KEY=VALUE>
               Override config file parameters, using TOML-like syntax.

       -V, --version
            Print version information

SUBCOMMANDS
       list            Plumbing subcommand for listing the files from key stores
       remove-by-path  Plumbing subcommand for removing files from key stores

```

### `arti-keys-raw-list` (plumbing)


```
NAME
       arti-keys-raw-list - List all available keys, without interpreting their
       meaning

SYNOPSIS
       arti keys-raw list [OPTIONS]

DESCRIPTION
       List the keys and certificates from the specified key stores. If no key
       stores are specified, this command lists the keys and certificates from
       all stores.

OPTIONS
       --keystore all
            List the keys and certificates from all key stores. This is the
            default behavior if the --keystore flag is omitted
       --keystore default
            List the keys and certificates from the default keystore.
       --keystore [<kid>...]
            Specifies the IDs of the keystores to list keys and certificates
            from. The IDs must be associated with keystores from the Arti TOML
            config. It is an error to specify a key store ID not associated with
            any of the configured key stores.

EXAMPLES
       List the keys in keystores foo and bar:

         arti keys-raw list --config arti.toml \
           --keystore foo,bar

       Sample output:
         ===== foo =====
           abc/not-a-key.txt
           client/alice/abc.onion/ks_hsc_desc_enc.x25519_private
           client/alice/xyz.onion/KS_hsc_desc_enc.x25519_private
           client/alice/xyz.onion/KS_hsc_desc_not_a_valid_name.x25519_private
           hs/carol/KS_hs_id.expanded_ed25519_private
           hs/carol/KS_hs_blind_id+19666_1440_43200.ed25519_expanded_private
           hs/carol/KS_hs_blind_id+19667_1440_43200.ed25519_expanded_private
           hs/carol/KS_hs_desc_sign+19666_1440_43200.ed25519_expanded_private
           hs/carol/KS_hs_desc_sign+19667_1440_43200.ed25519_expanded_private
           hs/dan/KS_hs_id.expanded_ed25519_private
           hs/eve/KS_hs_blind_id+19666_1440_43200.ed25519_expanded_private
           hs/eve/KS_hs_desc_sign+19667_1440_43200.ed25519_expanded_private
         ===== bar =====
           client/bob/def.onion/KS_hsc_desc_enc.x25519_private
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::list_matching`

### `arti-keys-raw-remove-by-path` (plumbing)

```
NAME
       arti-keys-raw-remove-by-path - Remove a key, given its ArtiPath

SYNOPSIS
       arti keys-raw remove-by-path [OPTIONS] <RAW_PATH>

DESCRIPTION
      Remove the specified file from the key store.

      The specified RAW_PATH is in the format of an ArtiPath, and so it is
      relative to the key store root.

      TODO: warn about misuse

OPTIONS
       --keystore default
            Remove the key from the default keystore. This is the default
            behavior if the --keystore flag is omitted
       --keystore <kid>
            Specifies the ID of the keystore to remove the key from. The ID must
            match one of the key store IDs configured in the specified config. It
            is an error to specify an unrecognized key store ID.
      --remove-all
            Remove **all** the keys and certificates of this key from all
            keystores. This is a dangerous option and should be used with care.
            Prompts before removal. Cannot be used with --keystore

EXAMPLES

       Remove a file from keystore foo:

         arti keys-raw --config arti.toml remove-by-path            \
             --keystore foo                                         \
             client/alice/abc.onion/ks_hsc_desc_enc.x25519_private


       Remove a file that is probably not a key from keystore foo:

         arti keys-raw --config arti.toml remove-by-path            \
             --keystore foo                                         \
             foo/some-file.txt
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::remove`

## `arti-hsc`

```
NAME
       arti-hsc - Command-line tool for managing the state of Arti hidden
       service clients

SYNOPSIS
       arti hsc [OPTIONS] <SUBCOMMAND> [SUBCOMMAND-OPTIONS]

DESCRIPTION
       A CLI for accessing, manipulating and validating the contents of Arti key
       stores and other peristent state.

       As with arti, keystores are configured through Arti's TOML config
       (specified using the --config flag).

       The state management functionality is exposed as a collection of
       subcommands, each subcommand supporting a different set of options.

       TODO: explain what an ArtiPath is (ArtiPaths are mentioned throughout
       the manual)

OPTIONS
       -c, --config <FILE>
               Specify which config file(s) to read. Defaults to
               [File("$HOME/.config/arti/arti.toml"),
               Dir("$HOME/.config/arti/arti.d/")]

           --disable-fs-permission-checks
               Don't check permissions on the files we use.

       --keystore-dir <ARTI_KEYSTORE>
          Use the keystore from the specified directory, which should be an Arti
          format keystore. This is a convenience alias for
          -o storage.keystore.path=<ARTI_KEYSTORE>

       -h, --help
               Print help information

       -l, --log-level <LEVEL>
               Override the log level (usually one of 'trace', 'debug', 'info', 'warn', 'error').

       -o <KEY=VALUE>
               Override config file parameters, using TOML-like syntax.

       -V, --version
            Print version information

SUBCOMMANDS
       help           Print this message or the help of the given subcommand(s)
       generate-key   Generate a key in one of the configured key stores
       remove-key     Remove a key from one of the configured key stores
```

### `arti-hsc-generate-key`

```
NAME
       arti-hsc-generate-key-auth - Generate a hidden service client authorization key

SYNOPSIS
       arti hsc generate-key auth [OPTIONS]

DESCRIPTION
       NOTE: while generate-key currently has only one subcommand ("auth"), in
       the future we might need to extend it with additional subcommands (if we
       extend the protocol to support other forms of client auth, for example)

       Generate a hidden service client authorization key, placing the keypair
       in the specified key store.

       This generates an x25519 descriptor encryption keypair and prints the
       corresponding public key to stdout in the format specified via the
       --pub-format option.

       This command should be run by clients who want to connect to a hidden
       service that requires client authorization.

       To connect to a hidden service that has client authorization enabled,
       clients need to share the public part of the key with the hidden service
       through a secure channel. The hidden service can then authorize the
       client to connect by encrypting its descriptor with the client's public
       key. The client uses the generated x25519 keypair to compute the keys for
       decrypting the superencrypted layer of the descriptor.

OPTIONS
       --keystore default
            Generate the key in the default keystore. This is the default
            behavior if the --keystore flag is omitted
       --keystore <kid>
            Specifies the ID of the keystore to generate the key into. The ID
            must match one of the key store IDs configured in the specified
            config. It is an error to specify an unrecognized key store ID.
       --nickname
            The nickname of the client for which to generate the key
       --hsid
            The hidden service for which to generate the key
       --pub-format [arti|ctor]
            The format to print the public part of the key in
            TODO: decide what the arti format looks like
       --force
            Whether to overwrite the key if it already exists

EXAMPLES
       Generate a client authorization key for service xyz.onion in keystore foo:

         arti hsc --config arti.toml generate-key auth --keystore foo  \
             --nickname alice                                          \
             --hsid xyz.onion                                          \
             --pub-format ctor

      Stdout:

         descriptor:x25519:dz4q5xqlb4ldnbs72iarrml4ephk3du4i7o2cgiva5lwr6wkquja

      TODO: update this section and document the arti --pub-format after we
      reach a conclusion in #1028
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::generate`

### `arti-hsc-remove-key`

```
NAME
       arti-hsc-remove-key - remove a client authorization key from the specified
       key store

SYNOPSIS
       arti hsc remove-key auth [OPTIONS]

DESCRIPTION
       NOTE: like generate-key, remove-key currently has only one subcommand
       ("auth").

       Remove a hidden service client authorization key from the specified key
       store.

       After removing the key, the client will no longer be able to connect to
       the service specified via --hsid, if the service has enabled client
       authorization.

OPTIONS
       --nickname
            The nickname of the client for which to remove the key
       --hsid
            The hidden service the key is associated with

EXAMPLES
       Remove the client authorization key for service xyz.onion from keystore foo:

         arti hsc --config arti.toml remove-key auth --keystore foo    \
             --type desc-enc                                           \
             --nickname alice                                          \
             --hsid xyz.onion
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::remove`

## `arti-hss`

```
NAME
       arti-hss - Command-line tool for managing the state of Arti hidden
       services

SYNOPSIS
       arti hss [OPTIONS] <SUBCOMMAND> [SUBCOMMAND-OPTIONS]

DESCRIPTION
      A state management tool for Arti hidden services.

      The managed state includes:
         * the IPT state of the service stored on disk
         * the keys associated with the service

OPTIONS
       -c, --config <FILE>
               Specify which config file(s) to read. Defaults to
               [File("$HOME/.config/arti/arti.toml"),
               Dir("$HOME/.config/arti/arti.d/")]

           --disable-fs-permission-checks
               Don't check permissions on the files we use.

       --keystore-dir <ARTI_KEYSTORE>
          Use the keystore from the specified directory, which should be an Arti
          format keystore. This is a convenience alias for
          -o storage.keystore.path=<ARTI_KEYSTORE>

       -h, --help
               Print help information

       -l, --log-level <LEVEL>
               Override the log level (usually one of 'trace', 'debug', 'info', 'warn', 'error').

       -o <KEY=VALUE>
               Override config file parameters, using TOML-like syntax.

       -V, --version
            Print version information

SUBCOMMANDS
       help                  Print this message or the help of the given subcommand(s)
       new-service           Initialize a new hidden service
       generate-online-keys  Generate all the keys necessary to run a hidden service
       destroy               Remove all the keys and state of a hidden service
       print-onion           Print the .onion address of a service
       auth-clients          Manage the authorized clients of this hidden service
       destroy-and-recreate  Generate a new identity keypair for a hidden service
```

### `arti-hss-new-service`

```
NAME
       arti-hss-new-service - initialize a new hidden service

SYNOPSIS
       arti hss new-service [OPTIONS]

DESCRIPTION
      Initializes a new hidden service by generating a new identity keypair and
      placing it in the specified key store.

      Users wanting to create a new service that will run in offline mode should
      run this command on a secure offline host to create its identity keys, and
      then run arti-hss-generate-online-keys(1) to generate the keys needed to
      run the service.

      Before running this command, ensure the hidden service you are
      initializing is configured in the Arti config (specified via --config).

      If Arti is already running using a config that contains an entry for the
      hidden service, its identity key has likely already been automatically
      generated by Arti. If that is the case, this command will report that an
      identity key already exists for the service, and exit with an error.

      TODO: make Arti support watching for keystore changes. Decide what happens
      if a new service is configured while Arti is running

OPTIONS
       --keystore default
            Place the identity key in the default keystore. This is the default
            behavior if the --keystore flag is omitted
       --keystore <kid>
            Specifies the ID of the keystore to generate the identity key into.
            The ID must match one of the key store IDs configured in the
            specified config. It is an error to specify an unrecognized key
            store ID.
       --nickname
            The nickname of the service

EXAMPLES
       Initialize a new hidden service with nickname "shallot" in the default
       key store:

         arti hss --config arti.toml new-service \
             --nickname shallot

       Sample output:

         Generated a new hidden service using nickname "shallot":
           wrxdvcaqpuzakbfww5sxs6r2uybczwijzfn2ezy2osaj7iox7kl7nhad.onion

       If any of the configured keystores contain any entries for service
       "shallot", a new identity key pair will **not** be generated:

         Cannot generate a new service with nickname "shallot": keystores foo and
         bar contain keys associated with a pre-existing hidden service with the
         same nickname

            Hint: use a different nickname.

            Alternatively, if you want to erase the service with nickname
            "shallot", run:

               arti hss --config arti.toml destroy \
                   --nickname shallot

            before retrying the operation

       If the public part of the identity key is available, this command also
       prints the corresponding .onion address before exiting:

         Cannot generate new hidden service with nickname "shallot": an identity key
         already exists
           wrxdvcaqpuzakbfww5sxs6r2uybczwijzfn2ezy2osaj7iox7kl7nhad.onion

```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::generate`

### `arti-hss-generate-online-keys`

```
NAME
       arti-hss-generate-online-keys - generate the keys needed to run a hidden service in offline mode

SYNOPSIS
       arti hss generate-online-keys [OPTIONS]

DESCRIPTION
      Generates all the keys required for a hidden service to operate without
      needing access to its identity key, up to a given time period.

      You do **not** need to run this command unless you want to run a hidden
      service in offline mode (where the identity key of the service is kept
      offline). If the identity keys are "online" (i.e. available on the host
      running the hidden service), you do not need to run this command, as Arti
      will automatically generate all the necessary keys and certificates.

      This command should be run on a secure offline system where the secret
      identity key of the service is available. It generates keys inside an
      "online" keystore, specified via --online-keystore-dir. Because the
      "online" keystore is a directory on disk, it can be copied from the
      offline system to the (online) hidden service host using the file-copying
      utilities available on your system. On the online system, the
      storage.keystore.path from the TOML config of the hidden service should
      point to the path the "online" keystore was copied to.

      The service will be able to operate without its secret identity key until
      the time specified via --up-to. After that, additional keys will
      need to be generated.

      This command assumes the hidden service has already been initialized,
      either manually, using arti-hss-new-service(1), or implicitly,
      by starting arti as a hidden service,
      and that the identity keypair is available in one
      of the configured key stores.

      Generates the following keys and certificates for each time period
      starting from the current time period up until the time specified
      via --up-to:

        * blinded identity keypair
        * descriptor signing key
        * descriptor signing certificate (obtained by signing the descriptor
          signing key with the blinded identity key)

OPTIONS
       --online-keystore-dir
            The root of the online keystore, where the keys will be generated.
            The keystore directory will be created if it does not already exist.
       --nickname
            The nickname of the service for which to generate the keys
       --up-to {<TIMESTAMP>|<DURATION>}
            A timestamp or duration representing the validity interval of
            the generated keys. The service will be able to run using the
            generated keys until the specified <TIMESTAMP>, or for the specified
            <DURATION>. after which new keys will need to be generated.
            Timestamps represent an absolute date/time given in RFC3339 format.
            Durations are relative to the current time (i.e. the time when this
            command was run), and represent a number of hours, minutes, or days
            (for example "--up-to 48h", --up-to 48 hours", "--up-to 10 days").

EXAMPLES
       Initialize a new "online" keystore at $HOME/foo with the keys needed in
       order for hidden service "shallot" to run in offline mode until
       2023-02-09T12:00:00Z (the identity key of the service must be in one of
       the keystores configured in arti.toml):

         arti hss --config arti.toml generate-online-keys \
             --online-keystore-dir $HOME/foo              \
             --nickname shallot                           \
             --up-to 2023-02-09T12:00:00Z

       Keystore foo can be exported to the online system by copying the
       $HOME/foo directory. On the online system, in the TOML config of the
       hidden service, storage.keystore.path should point to the parent directory
       of foo (TODO: make the keystore ID part of the config).
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::generate`

### `arti-hss-destroy`

```
NAME
       arti-hss-destroy - remove the persistent state and all the keys of a hidden service

SYNOPSIS
       arti hss destroy [OPTIONS]

DESCRIPTION
       Remove the persistent state and all the keys of a hidden service.

       This removes
         * the IPT state of the service stored on disk
         * any the keys associated with the service, from all key stores

OPTIONS
       --nickname
            The nickname of the service to erase

EXAMPLES
       Erase all the keys and state hidden service with nickname "shallot":

         arti hss --config arti.toml destroy \
             --nickname shallot
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::remove`

### `arti-hss-print-onion`

```
NAME
       arti-hss-print-onion - print the .onion address of a service

SYNOPSIS
       arti hss print-onion [OPTIONS]

DESCRIPTION
      Print the .onion address of a service.

OPTIONS
       --nickname
            The nickname of the service to display

EXAMPLES
      Print the .onion address of the service with nickname allium from the
      default keystore:

        arti hss --nickname allium print-onion-name

     Sample output:
        wrxdvcaqpuzakbfww5sxs6r2uybczwijzfn2ezy2osaj7iox7kl7nhad.onion
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::get`

### `arti-hss-auth-clients`

```
NAME
       arti-hss-auth-clients - Manage the authorized clients of this hidden service

SYNOPSIS
       arti hss auth-clients [SUBCOMMAND]

DESCRIPTION
      A command for managing the authorized clients of an Arti hidden service.

      TODO: document how these commands are supposed to work after we reach a
      conclusion in #1028

SUBCOMMANDS
       help                  Print this message or the help of the given subcommand(s)
       import                Import the public keys of a client
       disable               Un-authorize a previously authorized client
       enable                Authorize a new client
```

### `arti-hss-destroy-and-recreate`

```
NAME
       arti-hss-destroy-and-recreate - Generate a new identity keypair for a hidden service

SYNOPSIS
       arti hss destroy-and-recreate [OPTIONS]

DESCRIPTION
       A command for generating a new set of keys for an existing hidden
       service.

       This command deletes all the keys, including identity key, of the
       specified sevice and generates a fresh identity keypair.

       This command preserves the nickname of the service and its configuration
       (including the authorized clients).

       TODO: Expand on the description, add an example

OPTIONS
       --nickname
            The nickname of the service to destroy and recreate
```

#### Implementation

Required `KeyMgr` APIs:

  * `KeyMgr::remove`
  * `KeyMgr::generate`



[`KeyMgr`]: https://docs.rs/tor-keymgr/0.4.0/tor_keymgr/struct.KeyMgr.html
[ROFF]: https://crates.io/crates/clap_mangen
[arti#955]: https://gitlab.torproject.org/tpo/core/arti/-/issues/955

