(* Capstone Disassembler Engine
 * By Nguyen Anh Quynh <aquynh@gmail.com>, 2013> *)

(* architecture specific info of instruction *)
type x86_op_mem = {
	base: int;
	index: int;
	scale: int;
	displ: int;
}

type x86_op = 
	| X86_OP_INVALID of int
	| X86_OP_REG of int
	| X86_OP_IMM of int
	| X86_OP_FP of float
	| X86_OP_MEM of x86_op_mem

type cs_x86 = { 
	prefix: int array;
	segment: int;
	opcode: int array;
	op_size: int;
	addr_size: int;
	disp_size: int;
	imm_size: int;
	modrm: int;
	sib: int;
	disp: int;
	sib_index: int;
	sib_scale: int;
	sib_base: int;
	op_count: int;
	operands: x86_op array;
}

(* all Intel reigsters *)
let _X86_REG_INVALID = 0;;
let _X86_REG_AH = 1;;
let _X86_REG_AL = 2;;
let _X86_REG_AX = 3;;
let _X86_REG_BH = 4;;
let _X86_REG_BL = 5;;
let _X86_REG_BP = 6;;
let _X86_REG_BPL = 7;;
let _X86_REG_BX = 8;;
let _X86_REG_CH = 9;;
let _X86_REG_CL = 10;;
let _X86_REG_CS = 11;;
let _X86_REG_CX = 12;;
let _X86_REG_DH = 13;;
let _X86_REG_DI = 14;;
let _X86_REG_DIL = 15;;
let _X86_REG_DL = 16;;
let _X86_REG_DS = 17;;
let _X86_REG_DX = 18;;
let _X86_REG_EAX = 19;;
let _X86_REG_EBP = 20;;
let _X86_REG_EBX = 21;;
let _X86_REG_ECX = 22;;
let _X86_REG_EDI = 23;;
let _X86_REG_EDX = 24;;
let _X86_REG_FLAGS = 25;;
let _X86_REG_EIP = 26;;
let _X86_REG_EIZ = 27;;
let _X86_REG_ES = 28;;
let _X86_REG_ESI = 29;;
let _X86_REG_ESP = 30;;
let _X86_REG_FPSW = 31;;
let _X86_REG_FS = 32;;
let _X86_REG_GS = 33;;
let _X86_REG_IP = 34;;
let _X86_REG_RAX = 35;;
let _X86_REG_RBP = 36;;
let _X86_REG_RBX = 37;;
let _X86_REG_RCX = 38;;
let _X86_REG_RDI = 39;;
let _X86_REG_RDX = 40;;
let _X86_REG_RIP = 41;;
let _X86_REG_RIZ = 42;;
let _X86_REG_RSI = 43;;
let _X86_REG_RSP = 44;;
let _X86_REG_SI = 45;;
let _X86_REG_SIL = 46;;
let _X86_REG_SP = 47;;
let _X86_REG_SPL = 48;;
let _X86_REG_SS = 49;;
let _X86_REG_CR0 = 50;;
let _X86_REG_CR1 = 51;;
let _X86_REG_CR2 = 52;;
let _X86_REG_CR3 = 53;;
let _X86_REG_CR4 = 54;;
let _X86_REG_CR5 = 55;;
let _X86_REG_CR6 = 56;;
let _X86_REG_CR7 = 57;;
let _X86_REG_CR8 = 58;;
let _X86_REG_CR9 = 59;;
let _X86_REG_CR10 = 60;;
let _X86_REG_CR11 = 61;;
let _X86_REG_CR12 = 62;;
let _X86_REG_CR13 = 63;;
let _X86_REG_CR14 = 64;;
let _X86_REG_CR15 = 65;;
let _X86_REG_DR0 = 66;;
let _X86_REG_DR1 = 67;;
let _X86_REG_DR2 = 68;;
let _X86_REG_DR3 = 69;;
let _X86_REG_DR4 = 70;;
let _X86_REG_DR5 = 71;;
let _X86_REG_DR6 = 72;;
let _X86_REG_DR7 = 73;;
let _X86_REG_FP0 = 74;;
let _X86_REG_FP1 = 75;;
let _X86_REG_FP2 = 76;;
let _X86_REG_FP3 = 77;;
let _X86_REG_FP4 = 78;;
let _X86_REG_FP5 = 79;;
let _X86_REG_FP6 = 80;;
let _X86_REG_K0 = 81;;
let _X86_REG_K1 = 82;;
let _X86_REG_K2 = 83;;
let _X86_REG_K3 = 84;;
let _X86_REG_K4 = 85;;
let _X86_REG_K5 = 86;;
let _X86_REG_K6 = 87;;
let _X86_REG_K7 = 88;;
let _X86_REG_MM0 = 89;;
let _X86_REG_MM1 = 90;;
let _X86_REG_MM2 = 91;;
let _X86_REG_MM3 = 92;;
let _X86_REG_MM4 = 93;;
let _X86_REG_MM5 = 94;;
let _X86_REG_MM6 = 95;;
let _X86_REG_MM7 = 96;;
let _X86_REG_R8 = 97;;
let _X86_REG_R9 = 98;;
let _X86_REG_R10 = 99;;
let _X86_REG_R11 = 100;;
let _X86_REG_R12 = 101;;
let _X86_REG_R13 = 102;;
let _X86_REG_R14 = 103;;
let _X86_REG_R15 = 104;;
let _X86_REG_ST0 = 105;;
let _X86_REG_ST1 = 106;;
let _X86_REG_ST2 = 107;;
let _X86_REG_ST3 = 108;;
let _X86_REG_ST4 = 109;;
let _X86_REG_ST5 = 110;;
let _X86_REG_ST6 = 111;;
let _X86_REG_ST7 = 112;;
let _X86_REG_XMM0 = 113;;
let _X86_REG_XMM1 = 114;;
let _X86_REG_XMM2 = 115;;
let _X86_REG_XMM3 = 116;;
let _X86_REG_XMM4 = 117;;
let _X86_REG_XMM5 = 118;;
let _X86_REG_XMM6 = 119;;
let _X86_REG_XMM7 = 120;;
let _X86_REG_XMM8 = 121;;
let _X86_REG_XMM9 = 122;;
let _X86_REG_XMM10 = 123;;
let _X86_REG_XMM11 = 124;;
let _X86_REG_XMM12 = 125;;
let _X86_REG_XMM13 = 126;;
let _X86_REG_XMM14 = 127;;
let _X86_REG_XMM15 = 128;;
let _X86_REG_XMM16 = 129;;
let _X86_REG_XMM17 = 130;;
let _X86_REG_XMM18 = 131;;
let _X86_REG_XMM19 = 132;;
let _X86_REG_XMM20 = 133;;
let _X86_REG_XMM21 = 134;;
let _X86_REG_XMM22 = 135;;
let _X86_REG_XMM23 = 136;;
let _X86_REG_XMM24 = 137;;
let _X86_REG_XMM25 = 138;;
let _X86_REG_XMM26 = 139;;
let _X86_REG_XMM27 = 140;;
let _X86_REG_XMM28 = 141;;
let _X86_REG_XMM29 = 142;;
let _X86_REG_XMM30 = 143;;
let _X86_REG_XMM31 = 144;;
let _X86_REG_YMM0 = 145;;
let _X86_REG_YMM1 = 146;;
let _X86_REG_YMM2 = 147;;
let _X86_REG_YMM3 = 148;;
let _X86_REG_YMM4 = 149;;
let _X86_REG_YMM5 = 150;;
let _X86_REG_YMM6 = 151;;
let _X86_REG_YMM7 = 152;;
let _X86_REG_YMM8 = 153;;
let _X86_REG_YMM9 = 154;;
let _X86_REG_YMM10 = 155;;
let _X86_REG_YMM11 = 156;;
let _X86_REG_YMM12 = 157;;
let _X86_REG_YMM13 = 158;;
let _X86_REG_YMM14 = 159;;
let _X86_REG_YMM15 = 160;;
let _X86_REG_YMM16 = 161;;
let _X86_REG_YMM17 = 162;;
let _X86_REG_YMM18 = 163;;
let _X86_REG_YMM19 = 164;;
let _X86_REG_YMM20 = 165;;
let _X86_REG_YMM21 = 166;;
let _X86_REG_YMM22 = 167;;
let _X86_REG_YMM23 = 168;;
let _X86_REG_YMM24 = 169;;
let _X86_REG_YMM25 = 170;;
let _X86_REG_YMM26 = 171;;
let _X86_REG_YMM27 = 172;;
let _X86_REG_YMM28 = 173;;
let _X86_REG_YMM29 = 174;;
let _X86_REG_YMM30 = 175;;
let _X86_REG_YMM31 = 176;;
let _X86_REG_ZMM0 = 177;;
let _X86_REG_ZMM1 = 178;;
let _X86_REG_ZMM2 = 179;;
let _X86_REG_ZMM3 = 180;;
let _X86_REG_ZMM4 = 181;;
let _X86_REG_ZMM5 = 182;;
let _X86_REG_ZMM6 = 183;;
let _X86_REG_ZMM7 = 184;;
let _X86_REG_ZMM8 = 185;;
let _X86_REG_ZMM9 = 186;;
let _X86_REG_ZMM10 = 187;;
let _X86_REG_ZMM11 = 188;;
let _X86_REG_ZMM12 = 189;;
let _X86_REG_ZMM13 = 190;;
let _X86_REG_ZMM14 = 191;;
let _X86_REG_ZMM15 = 192;;
let _X86_REG_ZMM16 = 193;;
let _X86_REG_ZMM17 = 194;;
let _X86_REG_ZMM18 = 195;;
let _X86_REG_ZMM19 = 196;;
let _X86_REG_ZMM20 = 197;;
let _X86_REG_ZMM21 = 198;;
let _X86_REG_ZMM22 = 199;;
let _X86_REG_ZMM23 = 200;;
let _X86_REG_ZMM24 = 201;;
let _X86_REG_ZMM25 = 202;;
let _X86_REG_ZMM26 = 203;;
let _X86_REG_ZMM27 = 204;;
let _X86_REG_ZMM28 = 205;;
let _X86_REG_ZMM29 = 206;;
let _X86_REG_ZMM30 = 207;;
let _X86_REG_ZMM31 = 208;;
let _X86_REG_R8B = 209;;
let _X86_REG_R9B = 210;;
let _X86_REG_R10B = 211;;
let _X86_REG_R11B = 212;;
let _X86_REG_R12B = 213;;
let _X86_REG_R13B = 214;;
let _X86_REG_R14B = 215;;
let _X86_REG_R15B = 216;;
let _X86_REG_R8D = 217;;
let _X86_REG_R9D = 218;;
let _X86_REG_R10D = 219;;
let _X86_REG_R11D = 220;;
let _X86_REG_R12D = 221;;
let _X86_REG_R13D = 222;;
let _X86_REG_R14D = 223;;
let _X86_REG_R15D = 224;;
let _X86_REG_R8W = 225;;
let _X86_REG_R9W = 226;;
let _X86_REG_R10W = 227;;
let _X86_REG_R11W = 228;;
let _X86_REG_R12W = 229;;
let _X86_REG_R13W = 230;;
let _X86_REG_R14W = 231;;
let _X86_REG_R15W = 232;;

(* all Intel instructions *)
let _X86_INS_INVALID = 0;;
let _X86_INS_AAA = 1;;
let _X86_INS_AAD = 2;;
let _X86_INS_AAM = 3;;
let _X86_INS_AAS = 4;;
let _X86_INS_FABS = 5;;
let _X86_INS_ADC = 6;;
let _X86_INS_ADCX = 7;;
let _X86_INS_ADD = 8;;
let _X86_INS_ADDPD = 9;;
let _X86_INS_ADDPS = 10;;
let _X86_INS_ADDSD = 11;;
let _X86_INS_ADDSS = 12;;
let _X86_INS_ADDSUBPD = 13;;
let _X86_INS_ADDSUBPS = 14;;
let _X86_INS_FADD = 15;;
let _X86_INS_FIADD = 16;;
let _X86_INS_FADDP = 17;;
let _X86_INS_ADOX = 18;;
let _X86_INS_AESDECLAST = 19;;
let _X86_INS_AESDEC = 20;;
let _X86_INS_AESENCLAST = 21;;
let _X86_INS_AESENC = 22;;
let _X86_INS_AESIMC = 23;;
let _X86_INS_AESKEYGENASSIST = 24;;
let _X86_INS_AND = 25;;
let _X86_INS_ANDN = 26;;
let _X86_INS_ANDNPD = 27;;
let _X86_INS_ANDNPS = 28;;
let _X86_INS_ANDPD = 29;;
let _X86_INS_ANDPS = 30;;
let _X86_INS_ARPL = 31;;
let _X86_INS_BEXTR = 32;;
let _X86_INS_BLENDPD = 33;;
let _X86_INS_BLENDPS = 34;;
let _X86_INS_BLENDVPD = 35;;
let _X86_INS_BLENDVPS = 36;;
let _X86_INS_BLSI = 37;;
let _X86_INS_BLSMSK = 38;;
let _X86_INS_BLSR = 39;;
let _X86_INS_BOUND = 40;;
let _X86_INS_BSF = 41;;
let _X86_INS_BSR = 42;;
let _X86_INS_BSWAP = 43;;
let _X86_INS_BT = 44;;
let _X86_INS_BTC = 45;;
let _X86_INS_BTR = 46;;
let _X86_INS_BTS = 47;;
let _X86_INS_BZHI = 48;;
let _X86_INS_CALL = 49;;
let _X86_INS_CALLW = 50;;
let _X86_INS_CBW = 51;;
let _X86_INS_CDQ = 52;;
let _X86_INS_CDQE = 53;;
let _X86_INS_FCHS = 54;;
let _X86_INS_CLAC = 55;;
let _X86_INS_CLC = 56;;
let _X86_INS_CLD = 57;;
let _X86_INS_CLFLUSH = 58;;
let _X86_INS_CLGI = 59;;
let _X86_INS_CLI = 60;;
let _X86_INS_CLTS = 61;;
let _X86_INS_CMC = 62;;
let _X86_INS_CMOVA = 63;;
let _X86_INS_CMOVAE = 64;;
let _X86_INS_CMOVB = 65;;
let _X86_INS_CMOVBE = 66;;
let _X86_INS_FCMOVBE = 67;;
let _X86_INS_FCMOVB = 68;;
let _X86_INS_CMOVE = 69;;
let _X86_INS_FCMOVE = 70;;
let _X86_INS_CMOVG = 71;;
let _X86_INS_CMOVGE = 72;;
let _X86_INS_CMOVL = 73;;
let _X86_INS_CMOVLE = 74;;
let _X86_INS_FCMOVNBE = 75;;
let _X86_INS_FCMOVNB = 76;;
let _X86_INS_CMOVNE = 77;;
let _X86_INS_FCMOVNE = 78;;
let _X86_INS_CMOVNO = 79;;
let _X86_INS_CMOVNP = 80;;
let _X86_INS_FCMOVNU = 81;;
let _X86_INS_CMOVNS = 82;;
let _X86_INS_CMOVO = 83;;
let _X86_INS_CMOVP = 84;;
let _X86_INS_FCMOVU = 85;;
let _X86_INS_CMOVS = 86;;
let _X86_INS_CMP = 87;;
let _X86_INS_CMPPD = 88;;
let _X86_INS_CMPPS = 89;;
let _X86_INS_CMPSW = 90;;
let _X86_INS_CMPSD = 91;;
let _X86_INS_CMPSQ = 92;;
let _X86_INS_CMPSB = 93;;
let _X86_INS_CMPSS = 94;;
let _X86_INS_CMPXCHG16B = 95;;
let _X86_INS_CMPXCHG = 96;;
let _X86_INS_CMPXCHG8B = 97;;
let _X86_INS_COMISD = 98;;
let _X86_INS_COMISS = 99;;
let _X86_INS_FCOMP = 100;;
let _X86_INS_FCOMPI = 101;;
let _X86_INS_FCOMI = 102;;
let _X86_INS_FCOM = 103;;
let _X86_INS_FCOS = 104;;
let _X86_INS_CPUID = 105;;
let _X86_INS_CQO = 106;;
let _X86_INS_CRC32 = 107;;
let _X86_INS_CS = 108;;
let _X86_INS_CVTDQ2PD = 109;;
let _X86_INS_CVTDQ2PS = 110;;
let _X86_INS_CVTPD2DQ = 111;;
let _X86_INS_CVTPD2PS = 112;;
let _X86_INS_CVTPS2DQ = 113;;
let _X86_INS_CVTPS2PD = 114;;
let _X86_INS_CVTSD2SI = 115;;
let _X86_INS_CVTSD2SS = 116;;
let _X86_INS_CVTSI2SD = 117;;
let _X86_INS_CVTSI2SS = 118;;
let _X86_INS_CVTSS2SD = 119;;
let _X86_INS_CVTSS2SI = 120;;
let _X86_INS_CVTTPD2DQ = 121;;
let _X86_INS_CVTTPS2DQ = 122;;
let _X86_INS_CVTTSD2SI = 123;;
let _X86_INS_CVTTSS2SI = 124;;
let _X86_INS_CWD = 125;;
let _X86_INS_CWDE = 126;;
let _X86_INS_DAA = 127;;
let _X86_INS_DAS = 128;;
let _X86_INS_DATA16 = 129;;
let _X86_INS_DEC = 130;;
let _X86_INS_DIV = 131;;
let _X86_INS_DIVPD = 132;;
let _X86_INS_DIVPS = 133;;
let _X86_INS_FDIVR = 134;;
let _X86_INS_FIDIVR = 135;;
let _X86_INS_FDIVRP = 136;;
let _X86_INS_DIVSD = 137;;
let _X86_INS_DIVSS = 138;;
let _X86_INS_FDIV = 139;;
let _X86_INS_FIDIV = 140;;
let _X86_INS_FDIVP = 141;;
let _X86_INS_DPPD = 142;;
let _X86_INS_DPPS = 143;;
let _X86_INS_DS = 144;;
let _X86_INS_RET = 145;;
let _X86_INS_ENTER = 146;;
let _X86_INS_ES = 147;;
let _X86_INS_EXTRACTPS = 148;;
let _X86_INS_EXTRQ = 149;;
let _X86_INS_F2XM1 = 150;;
let _X86_INS_LCALL = 151;;
let _X86_INS_LJMP = 152;;
let _X86_INS_FBLD = 153;;
let _X86_INS_FBSTP = 154;;
let _X86_INS_FCOMPP = 155;;
let _X86_INS_FDECSTP = 156;;
let _X86_INS_FEMMS = 157;;
let _X86_INS_FFREE = 158;;
let _X86_INS_FICOM = 159;;
let _X86_INS_FICOMP = 160;;
let _X86_INS_FINCSTP = 161;;
let _X86_INS_FLDCW = 162;;
let _X86_INS_FLDENV = 163;;
let _X86_INS_FLDL2E = 164;;
let _X86_INS_FLDL2T = 165;;
let _X86_INS_FLDLG2 = 166;;
let _X86_INS_FLDLN2 = 167;;
let _X86_INS_FLDPI = 168;;
let _X86_INS_FNCLEX = 169;;
let _X86_INS_FNINIT = 170;;
let _X86_INS_FNOP = 171;;
let _X86_INS_FNSTCW = 172;;
let _X86_INS_FNSTSW = 173;;
let _X86_INS_FPATAN = 174;;
let _X86_INS_FPREM = 175;;
let _X86_INS_FPREM1 = 176;;
let _X86_INS_FPTAN = 177;;
let _X86_INS_FRNDINT = 178;;
let _X86_INS_FRSTOR = 179;;
let _X86_INS_FNSAVE = 180;;
let _X86_INS_FSCALE = 181;;
let _X86_INS_FSINCOS = 182;;
let _X86_INS_FNSTENV = 183;;
let _X86_INS_FS = 184;;
let _X86_INS_FXAM = 185;;
let _X86_INS_FXRSTOR = 186;;
let _X86_INS_FXRSTORQ = 187;;
let _X86_INS_FXSAVE = 188;;
let _X86_INS_FXSAVEQ = 189;;
let _X86_INS_FXTRACT = 190;;
let _X86_INS_FYL2X = 191;;
let _X86_INS_FYL2XP1 = 192;;
let _X86_INS_MOVAPD = 193;;
let _X86_INS_MOVAPS = 194;;
let _X86_INS_ORPD = 195;;
let _X86_INS_ORPS = 196;;
let _X86_INS_VMOVAPD = 197;;
let _X86_INS_VMOVAPS = 198;;
let _X86_INS_XORPD = 199;;
let _X86_INS_XORPS = 200;;
let _X86_INS_GS = 201;;
let _X86_INS_HADDPD = 202;;
let _X86_INS_HADDPS = 203;;
let _X86_INS_HLT = 204;;
let _X86_INS_HSUBPD = 205;;
let _X86_INS_HSUBPS = 206;;
let _X86_INS_IDIV = 207;;
let _X86_INS_FILD = 208;;
let _X86_INS_IMUL = 209;;
let _X86_INS_INS = 210;;
let _X86_INS_IN = 211;;
let _X86_INS_INC = 212;;
let _X86_INS_INSERTPS = 213;;
let _X86_INS_INSERTQ = 214;;
let _X86_INS_INT = 215;;
let _X86_INS_INT3 = 216;;
let _X86_INS_INTO = 217;;
let _X86_INS_INVD = 218;;
let _X86_INS_INVEPT = 219;;
let _X86_INS_INVLPG = 220;;
let _X86_INS_INVLPGA = 221;;
let _X86_INS_INVPCID = 222;;
let _X86_INS_INVVPID = 223;;
let _X86_INS_IRET = 224;;
let _X86_INS_IRETD = 225;;
let _X86_INS_IRETQ = 226;;
let _X86_INS_FISTTP = 227;;
let _X86_INS_FIST = 228;;
let _X86_INS_FISTP = 229;;
let _X86_INS_UCOMISD = 230;;
let _X86_INS_UCOMISS = 231;;
let _X86_INS_VCMPSD = 232;;
let _X86_INS_VCMPSS = 233;;
let _X86_INS_VCOMISD = 234;;
let _X86_INS_VCOMISS = 235;;
let _X86_INS_VCVTSD2SS = 236;;
let _X86_INS_VCVTSI2SD = 237;;
let _X86_INS_VCVTSI2SS = 238;;
let _X86_INS_VCVTSS2SD = 239;;
let _X86_INS_VCVTTSD2SI = 240;;
let _X86_INS_VCVTTSS2SI = 241;;
let _X86_INS_VUCOMISD = 242;;
let _X86_INS_VUCOMISS = 243;;
let _X86_INS_JAE = 244;;
let _X86_INS_JA = 245;;
let _X86_INS_JBE = 246;;
let _X86_INS_JB = 247;;
let _X86_INS_JCXZ = 248;;
let _X86_INS_JECXZ = 249;;
let _X86_INS_JE = 250;;
let _X86_INS_JGE = 251;;
let _X86_INS_JG = 252;;
let _X86_INS_JLE = 253;;
let _X86_INS_JL = 254;;
let _X86_INS_JMP = 255;;
let _X86_INS_JMPQ = 256;;
let _X86_INS_JNE = 257;;
let _X86_INS_JNO = 258;;
let _X86_INS_JNP = 259;;
let _X86_INS_JNS = 260;;
let _X86_INS_JO = 261;;
let _X86_INS_JP = 262;;
let _X86_INS_JRCXZ = 263;;
let _X86_INS_JS = 264;;
let _X86_INS_KADDW = 265;;
let _X86_INS_KANDNW = 266;;
let _X86_INS_KANDW = 267;;
let _X86_INS_KMOVW = 268;;
let _X86_INS_KNOTW = 269;;
let _X86_INS_KORTESTW = 270;;
let _X86_INS_KORW = 271;;
let _X86_INS_KSHIFTLW = 272;;
let _X86_INS_KSHIFTRW = 273;;
let _X86_INS_KTESTW = 274;;
let _X86_INS_KUNPCKBW = 275;;
let _X86_INS_KXNORW = 276;;
let _X86_INS_KXORW = 277;;
let _X86_INS_LAHF = 278;;
let _X86_INS_LAR = 279;;
let _X86_INS_LDDQU = 280;;
let _X86_INS_LDMXCSR = 281;;
let _X86_INS_LDS = 282;;
let _X86_INS_FLDZ = 283;;
let _X86_INS_FLD1 = 284;;
let _X86_INS_FLD = 285;;
let _X86_INS_LEA = 286;;
let _X86_INS_LEAVE = 287;;
let _X86_INS_LES = 288;;
let _X86_INS_LFENCE = 289;;
let _X86_INS_LFS = 290;;
let _X86_INS_LGDT = 291;;
let _X86_INS_LGS = 292;;
let _X86_INS_LIDT = 293;;
let _X86_INS_LLDT = 294;;
let _X86_INS_LMSW = 295;;
let _X86_INS_OR = 296;;
let _X86_INS_LOCK = 297;;
let _X86_INS_SUB = 298;;
let _X86_INS_XOR = 299;;
let _X86_INS_LODSB = 300;;
let _X86_INS_LODSD = 301;;
let _X86_INS_LODSQ = 302;;
let _X86_INS_LODSW = 303;;
let _X86_INS_LOOP = 304;;
let _X86_INS_LOOPE = 305;;
let _X86_INS_LOOPNE = 306;;
let _X86_INS_RETF = 307;;
let _X86_INS_LSL = 308;;
let _X86_INS_LSS = 309;;
let _X86_INS_LTR = 310;;
let _X86_INS_XADD = 311;;
let _X86_INS_LZCNT = 312;;
let _X86_INS_MASKMOVDQU = 313;;
let _X86_INS_MAXPD = 314;;
let _X86_INS_MAXPS = 315;;
let _X86_INS_MAXSD = 316;;
let _X86_INS_MAXSS = 317;;
let _X86_INS_MFENCE = 318;;
let _X86_INS_MINPD = 319;;
let _X86_INS_MINPS = 320;;
let _X86_INS_MINSD = 321;;
let _X86_INS_MINSS = 322;;
let _X86_INS_CVTPD2PI = 323;;
let _X86_INS_CVTPI2PD = 324;;
let _X86_INS_CVTPI2PS = 325;;
let _X86_INS_CVTPS2PI = 326;;
let _X86_INS_CVTTPD2PI = 327;;
let _X86_INS_CVTTPS2PI = 328;;
let _X86_INS_EMMS = 329;;
let _X86_INS_MASKMOVQ = 330;;
let _X86_INS_MOVD = 331;;
let _X86_INS_MOVDQ2Q = 332;;
let _X86_INS_MOVNTQ = 333;;
let _X86_INS_MOVQ2DQ = 334;;
let _X86_INS_MOVQ = 335;;
let _X86_INS_PABSB = 336;;
let _X86_INS_PABSD = 337;;
let _X86_INS_PABSW = 338;;
let _X86_INS_PACKSSDW = 339;;
let _X86_INS_PACKSSWB = 340;;
let _X86_INS_PACKUSWB = 341;;
let _X86_INS_PADDB = 342;;
let _X86_INS_PADDD = 343;;
let _X86_INS_PADDQ = 344;;
let _X86_INS_PADDSB = 345;;
let _X86_INS_PADDSW = 346;;
let _X86_INS_PADDUSB = 347;;
let _X86_INS_PADDUSW = 348;;
let _X86_INS_PADDW = 349;;
let _X86_INS_PALIGNR = 350;;
let _X86_INS_PANDN = 351;;
let _X86_INS_PAND = 352;;
let _X86_INS_PAVGB = 353;;
let _X86_INS_PAVGW = 354;;
let _X86_INS_PCMPEQB = 355;;
let _X86_INS_PCMPEQD = 356;;
let _X86_INS_PCMPEQW = 357;;
let _X86_INS_PCMPGTB = 358;;
let _X86_INS_PCMPGTD = 359;;
let _X86_INS_PCMPGTW = 360;;
let _X86_INS_PEXTRW = 361;;
let _X86_INS_PHADDSW = 362;;
let _X86_INS_PHADDW = 363;;
let _X86_INS_PHADDD = 364;;
let _X86_INS_PHSUBD = 365;;
let _X86_INS_PHSUBSW = 366;;
let _X86_INS_PHSUBW = 367;;
let _X86_INS_PINSRW = 368;;
let _X86_INS_PMADDUBSW = 369;;
let _X86_INS_PMADDWD = 370;;
let _X86_INS_PMAXSW = 371;;
let _X86_INS_PMAXUB = 372;;
let _X86_INS_PMINSW = 373;;
let _X86_INS_PMINUB = 374;;
let _X86_INS_PMOVMSKB = 375;;
let _X86_INS_PMULHRSW = 376;;
let _X86_INS_PMULHUW = 377;;
let _X86_INS_PMULHW = 378;;
let _X86_INS_PMULLW = 379;;
let _X86_INS_PMULUDQ = 380;;
let _X86_INS_POR = 381;;
let _X86_INS_PSADBW = 382;;
let _X86_INS_PSHUFB = 383;;
let _X86_INS_PSHUFW = 384;;
let _X86_INS_PSIGNB = 385;;
let _X86_INS_PSIGND = 386;;
let _X86_INS_PSIGNW = 387;;
let _X86_INS_PSLLD = 388;;
let _X86_INS_PSLLQ = 389;;
let _X86_INS_PSLLW = 390;;
let _X86_INS_PSRAD = 391;;
let _X86_INS_PSRAW = 392;;
let _X86_INS_PSRLD = 393;;
let _X86_INS_PSRLQ = 394;;
let _X86_INS_PSRLW = 395;;
let _X86_INS_PSUBB = 396;;
let _X86_INS_PSUBD = 397;;
let _X86_INS_PSUBQ = 398;;
let _X86_INS_PSUBSB = 399;;
let _X86_INS_PSUBSW = 400;;
let _X86_INS_PSUBUSB = 401;;
let _X86_INS_PSUBUSW = 402;;
let _X86_INS_PSUBW = 403;;
let _X86_INS_PUNPCKHBW = 404;;
let _X86_INS_PUNPCKHDQ = 405;;
let _X86_INS_PUNPCKHWD = 406;;
let _X86_INS_PUNPCKLBW = 407;;
let _X86_INS_PUNPCKLDQ = 408;;
let _X86_INS_PUNPCKLWD = 409;;
let _X86_INS_PXOR = 410;;
let _X86_INS_MONITOR = 411;;
let _X86_INS_MONTMUL = 412;;
let _X86_INS_MOV = 413;;
let _X86_INS_MOVABS = 414;;
let _X86_INS_MOVBE = 415;;
let _X86_INS_MOVDDUP = 416;;
let _X86_INS_MOVDQA = 417;;
let _X86_INS_MOVDQU = 418;;
let _X86_INS_MOVHLPS = 419;;
let _X86_INS_MOVHPD = 420;;
let _X86_INS_MOVHPS = 421;;
let _X86_INS_MOVLHPS = 422;;
let _X86_INS_MOVLPD = 423;;
let _X86_INS_MOVLPS = 424;;
let _X86_INS_MOVMSKPD = 425;;
let _X86_INS_MOVMSKPS = 426;;
let _X86_INS_MOVNTDQA = 427;;
let _X86_INS_MOVNTDQ = 428;;
let _X86_INS_MOVNTI = 429;;
let _X86_INS_MOVNTPD = 430;;
let _X86_INS_MOVNTPS = 431;;
let _X86_INS_MOVNTSD = 432;;
let _X86_INS_MOVNTSS = 433;;
let _X86_INS_MOVSB = 434;;
let _X86_INS_MOVSD = 435;;
let _X86_INS_MOVSHDUP = 436;;
let _X86_INS_MOVSLDUP = 437;;
let _X86_INS_MOVSQ = 438;;
let _X86_INS_MOVSS = 439;;
let _X86_INS_MOVSW = 440;;
let _X86_INS_MOVSX = 441;;
let _X86_INS_MOVSXD = 442;;
let _X86_INS_MOVUPD = 443;;
let _X86_INS_MOVUPS = 444;;
let _X86_INS_MOVZX = 445;;
let _X86_INS_MPSADBW = 446;;
let _X86_INS_MUL = 447;;
let _X86_INS_MULPD = 448;;
let _X86_INS_MULPS = 449;;
let _X86_INS_MULSD = 450;;
let _X86_INS_MULSS = 451;;
let _X86_INS_MULX = 452;;
let _X86_INS_FMUL = 453;;
let _X86_INS_FIMUL = 454;;
let _X86_INS_FMULP = 455;;
let _X86_INS_MWAIT = 456;;
let _X86_INS_NEG = 457;;
let _X86_INS_NOP = 458;;
let _X86_INS_NOT = 459;;
let _X86_INS_OUT = 460;;
let _X86_INS_OUTSB = 461;;
let _X86_INS_OUTSD = 462;;
let _X86_INS_OUTSW = 463;;
let _X86_INS_PACKUSDW = 464;;
let _X86_INS_PAUSE = 465;;
let _X86_INS_PAVGUSB = 466;;
let _X86_INS_PBLENDVB = 467;;
let _X86_INS_PBLENDW = 468;;
let _X86_INS_PCLMULQDQ = 469;;
let _X86_INS_PCMPEQQ = 470;;
let _X86_INS_PCMPESTRI = 471;;
let _X86_INS_PCMPESTRM = 472;;
let _X86_INS_PCMPGTQ = 473;;
let _X86_INS_PCMPISTRI = 474;;
let _X86_INS_PCMPISTRM = 475;;
let _X86_INS_PDEP = 476;;
let _X86_INS_PEXT = 477;;
let _X86_INS_PEXTRB = 478;;
let _X86_INS_PEXTRD = 479;;
let _X86_INS_PEXTRQ = 480;;
let _X86_INS_PF2ID = 481;;
let _X86_INS_PF2IW = 482;;
let _X86_INS_PFACC = 483;;
let _X86_INS_PFADD = 484;;
let _X86_INS_PFCMPEQ = 485;;
let _X86_INS_PFCMPGE = 486;;
let _X86_INS_PFCMPGT = 487;;
let _X86_INS_PFMAX = 488;;
let _X86_INS_PFMIN = 489;;
let _X86_INS_PFMUL = 490;;
let _X86_INS_PFNACC = 491;;
let _X86_INS_PFPNACC = 492;;
let _X86_INS_PFRCPIT1 = 493;;
let _X86_INS_PFRCPIT2 = 494;;
let _X86_INS_PFRCP = 495;;
let _X86_INS_PFRSQIT1 = 496;;
let _X86_INS_PFRSQRT = 497;;
let _X86_INS_PFSUBR = 498;;
let _X86_INS_PFSUB = 499;;
let _X86_INS_PHMINPOSUW = 500;;
let _X86_INS_PI2FD = 501;;
let _X86_INS_PI2FW = 502;;
let _X86_INS_PINSRB = 503;;
let _X86_INS_PINSRD = 504;;
let _X86_INS_PINSRQ = 505;;
let _X86_INS_PMAXSB = 506;;
let _X86_INS_PMAXSD = 507;;
let _X86_INS_PMAXUD = 508;;
let _X86_INS_PMAXUW = 509;;
let _X86_INS_PMINSB = 510;;
let _X86_INS_PMINSD = 511;;
let _X86_INS_PMINUD = 512;;
let _X86_INS_PMINUW = 513;;
let _X86_INS_PMOVSXBD = 514;;
let _X86_INS_PMOVSXBQ = 515;;
let _X86_INS_PMOVSXBW = 516;;
let _X86_INS_PMOVSXDQ = 517;;
let _X86_INS_PMOVSXWD = 518;;
let _X86_INS_PMOVSXWQ = 519;;
let _X86_INS_PMOVZXBD = 520;;
let _X86_INS_PMOVZXBQ = 521;;
let _X86_INS_PMOVZXBW = 522;;
let _X86_INS_PMOVZXDQ = 523;;
let _X86_INS_PMOVZXWD = 524;;
let _X86_INS_PMOVZXWQ = 525;;
let _X86_INS_PMULDQ = 526;;
let _X86_INS_PMULHRW = 527;;
let _X86_INS_PMULLD = 528;;
let _X86_INS_POP = 529;;
let _X86_INS_POPA = 530;;
let _X86_INS_POPCNT = 531;;
let _X86_INS_POPF = 532;;
let _X86_INS_POPFD = 533;;
let _X86_INS_POPFQ = 534;;
let _X86_INS_PREFETCH = 535;;
let _X86_INS_PREFETCHNTA = 536;;
let _X86_INS_PREFETCHT0 = 537;;
let _X86_INS_PREFETCHT1 = 538;;
let _X86_INS_PREFETCHT2 = 539;;
let _X86_INS_PREFETCHW = 540;;
let _X86_INS_PSHUFD = 541;;
let _X86_INS_PSHUFHW = 542;;
let _X86_INS_PSHUFLW = 543;;
let _X86_INS_PSLLDQ = 544;;
let _X86_INS_PSRLDQ = 545;;
let _X86_INS_PSWAPD = 546;;
let _X86_INS_PTEST = 547;;
let _X86_INS_PUNPCKHQDQ = 548;;
let _X86_INS_PUNPCKLQDQ = 549;;
let _X86_INS_PUSH = 550;;
let _X86_INS_PUSHA = 551;;
let _X86_INS_PUSHF = 552;;
let _X86_INS_PUSHFD = 553;;
let _X86_INS_PUSHFQ = 554;;
let _X86_INS_RCL = 555;;
let _X86_INS_RCPPS = 556;;
let _X86_INS_RCPSS = 557;;
let _X86_INS_RCR = 558;;
let _X86_INS_RDFSBASE = 559;;
let _X86_INS_RDGSBASE = 560;;
let _X86_INS_RDMSR = 561;;
let _X86_INS_RDPMC = 562;;
let _X86_INS_RDRAND = 563;;
let _X86_INS_RDSEED = 564;;
let _X86_INS_RDTSC = 565;;
let _X86_INS_RDTSCP = 566;;
let _X86_INS_REPNE = 567;;
let _X86_INS_REP = 568;;
let _X86_INS_REX64 = 569;;
let _X86_INS_ROL = 570;;
let _X86_INS_ROR = 571;;
let _X86_INS_RORX = 572;;
let _X86_INS_ROUNDPD = 573;;
let _X86_INS_ROUNDPS = 574;;
let _X86_INS_ROUNDSD = 575;;
let _X86_INS_ROUNDSS = 576;;
let _X86_INS_RSM = 577;;
let _X86_INS_RSQRTPS = 578;;
let _X86_INS_RSQRTSS = 579;;
let _X86_INS_SAHF = 580;;
let _X86_INS_SAR = 581;;
let _X86_INS_SARX = 582;;
let _X86_INS_SBB = 583;;
let _X86_INS_SCASW = 584;;
let _X86_INS_SCASD = 585;;
let _X86_INS_SCASQ = 586;;
let _X86_INS_SCASB = 587;;
let _X86_INS_SETAE = 588;;
let _X86_INS_SETA = 589;;
let _X86_INS_SETBE = 590;;
let _X86_INS_SETB = 591;;
let _X86_INS_SETE = 592;;
let _X86_INS_SETGE = 593;;
let _X86_INS_SETG = 594;;
let _X86_INS_SETLE = 595;;
let _X86_INS_SETL = 596;;
let _X86_INS_SETNE = 597;;
let _X86_INS_SETNO = 598;;
let _X86_INS_SETNP = 599;;
let _X86_INS_SETNS = 600;;
let _X86_INS_SETO = 601;;
let _X86_INS_SETP = 602;;
let _X86_INS_SETS = 603;;
let _X86_INS_SFENCE = 604;;
let _X86_INS_SGDT = 605;;
let _X86_INS_SHA1MSG1 = 606;;
let _X86_INS_SHA1MSG2 = 607;;
let _X86_INS_SHA1NEXTE = 608;;
let _X86_INS_SHA1RNDS4 = 609;;
let _X86_INS_SHA256MSG1 = 610;;
let _X86_INS_SHA256MSG2 = 611;;
let _X86_INS_SHA256RNDS2 = 612;;
let _X86_INS_SHL = 613;;
let _X86_INS_SHLD = 614;;
let _X86_INS_SHLX = 615;;
let _X86_INS_SHR = 616;;
let _X86_INS_SHRD = 617;;
let _X86_INS_SHRX = 618;;
let _X86_INS_SHUFPD = 619;;
let _X86_INS_SHUFPS = 620;;
let _X86_INS_SIDT = 621;;
let _X86_INS_FSIN = 622;;
let _X86_INS_SKINIT = 623;;
let _X86_INS_SLDT = 624;;
let _X86_INS_SMSW = 625;;
let _X86_INS_SQRTPD = 626;;
let _X86_INS_SQRTPS = 627;;
let _X86_INS_SQRTSD = 628;;
let _X86_INS_SQRTSS = 629;;
let _X86_INS_FSQRT = 630;;
let _X86_INS_SS = 631;;
let _X86_INS_STAC = 632;;
let _X86_INS_STC = 633;;
let _X86_INS_STD = 634;;
let _X86_INS_STGI = 635;;
let _X86_INS_STI = 636;;
let _X86_INS_STMXCSR = 637;;
let _X86_INS_STOSB = 638;;
let _X86_INS_STOSD = 639;;
let _X86_INS_STOSQ = 640;;
let _X86_INS_STOSW = 641;;
let _X86_INS_STR = 642;;
let _X86_INS_FST = 643;;
let _X86_INS_FSTP = 644;;
let _X86_INS_SUBPD = 645;;
let _X86_INS_SUBPS = 646;;
let _X86_INS_FSUBR = 647;;
let _X86_INS_FISUBR = 648;;
let _X86_INS_FSUBRP = 649;;
let _X86_INS_SUBSD = 650;;
let _X86_INS_SUBSS = 651;;
let _X86_INS_FSUB = 652;;
let _X86_INS_FISUB = 653;;
let _X86_INS_FSUBP = 654;;
let _X86_INS_SWAPGS = 655;;
let _X86_INS_SYSCALL = 656;;
let _X86_INS_SYSENTER = 657;;
let _X86_INS_SYSEXIT = 658;;
let _X86_INS_SYSRET = 659;;
let _X86_INS_TEST = 660;;
let _X86_INS_UD2 = 661;;
let _X86_INS_FTST = 662;;
let _X86_INS_TZCNT = 663;;
let _X86_INS_FUCOMPI = 664;;
let _X86_INS_FUCOMI = 665;;
let _X86_INS_FUCOMPP = 666;;
let _X86_INS_FUCOMP = 667;;
let _X86_INS_FUCOM = 668;;
let _X86_INS_UD2B = 669;;
let _X86_INS_UNPCKHPD = 670;;
let _X86_INS_UNPCKHPS = 671;;
let _X86_INS_UNPCKLPD = 672;;
let _X86_INS_UNPCKLPS = 673;;
let _X86_INS_VADDPD = 674;;
let _X86_INS_VADDPS = 675;;
let _X86_INS_VADDSD = 676;;
let _X86_INS_VADDSS = 677;;
let _X86_INS_VADDSUBPD = 678;;
let _X86_INS_VADDSUBPS = 679;;
let _X86_INS_VAESDECLAST = 680;;
let _X86_INS_VAESDEC = 681;;
let _X86_INS_VAESENCLAST = 682;;
let _X86_INS_VAESENC = 683;;
let _X86_INS_VAESIMC = 684;;
let _X86_INS_VAESKEYGENASSIST = 685;;
let _X86_INS_VALIGND = 686;;
let _X86_INS_VALIGNQ = 687;;
let _X86_INS_VANDNPD = 688;;
let _X86_INS_VANDNPS = 689;;
let _X86_INS_VANDPD = 690;;
let _X86_INS_VANDPS = 691;;
let _X86_INS_VBLENDMPD = 692;;
let _X86_INS_VBLENDMPS = 693;;
let _X86_INS_VBLENDPD = 694;;
let _X86_INS_VBLENDPS = 695;;
let _X86_INS_VBLENDVPD = 696;;
let _X86_INS_VBLENDVPS = 697;;
let _X86_INS_VBROADCASTF128 = 698;;
let _X86_INS_VBROADCASTI128 = 699;;
let _X86_INS_VBROADCASTSD = 700;;
let _X86_INS_VBROADCASTSS = 701;;
let _X86_INS_VCMPPD = 702;;
let _X86_INS_VVCMPPD = 703;;
let _X86_INS_VCMPPS = 704;;
let _X86_INS_VVCMPPS = 705;;
let _X86_INS_VCVTDQ2PD = 706;;
let _X86_INS_VCVTDQ2PS = 707;;
let _X86_INS_VCVTPD2DQX = 708;;
let _X86_INS_VCVTPD2DQ = 709;;
let _X86_INS_VCVTPD2PSX = 710;;
let _X86_INS_VCVTPD2PS = 711;;
let _X86_INS_VCVTPH2PS = 712;;
let _X86_INS_VCVTPS2DQ = 713;;
let _X86_INS_VCVTPS2PD = 714;;
let _X86_INS_VCVTPS2PH = 715;;
let _X86_INS_VCVTSD2SI = 716;;
let _X86_INS_VCVTSS2SI = 717;;
let _X86_INS_VCVTTPD2DQX = 718;;
let _X86_INS_VCVTTPD2DQ = 719;;
let _X86_INS_VCVTTPD2UDQ = 720;;
let _X86_INS_VCVTTPS2DQ = 721;;
let _X86_INS_VCVTTPS2UDQ = 722;;
let _X86_INS_VCVTUDQ2PD = 723;;
let _X86_INS_VCVTUDQ2PS = 724;;
let _X86_INS_VDIVPD = 725;;
let _X86_INS_VDIVPS = 726;;
let _X86_INS_VDIVSD = 727;;
let _X86_INS_VDIVSS = 728;;
let _X86_INS_VDPPD = 729;;
let _X86_INS_VDPPS = 730;;
let _X86_INS_VERR = 731;;
let _X86_INS_VERW = 732;;
let _X86_INS_VEXTRACTF128 = 733;;
let _X86_INS_VEXTRACTF32X4 = 734;;
let _X86_INS_VEXTRACTF64X4 = 735;;
let _X86_INS_VEXTRACTI128 = 736;;
let _X86_INS_VEXTRACTI32X4 = 737;;
let _X86_INS_VEXTRACTI64X4 = 738;;
let _X86_INS_VEXTRACTPS = 739;;
let _X86_INS_VFMADD132PD = 740;;
let _X86_INS_VFMADD132PS = 741;;
let _X86_INS_VFMADD213PD = 742;;
let _X86_INS_VFMADD213PS = 743;;
let _X86_INS_VFMADDPD = 744;;
let _X86_INS_VFMADD231PD = 745;;
let _X86_INS_VFMADDPS = 746;;
let _X86_INS_VFMADD231PS = 747;;
let _X86_INS_VFMADDSD = 748;;
let _X86_INS_VFMADD213SD = 749;;
let _X86_INS_VFMADD132SD = 750;;
let _X86_INS_VFMADD231SD = 751;;
let _X86_INS_VFMADDSS = 752;;
let _X86_INS_VFMADD213SS = 753;;
let _X86_INS_VFMADD132SS = 754;;
let _X86_INS_VFMADD231SS = 755;;
let _X86_INS_VFMADDSUB132PD = 756;;
let _X86_INS_VFMADDSUB132PS = 757;;
let _X86_INS_VFMADDSUB213PD = 758;;
let _X86_INS_VFMADDSUB213PS = 759;;
let _X86_INS_VFMADDSUBPD = 760;;
let _X86_INS_VFMADDSUB231PD = 761;;
let _X86_INS_VFMADDSUBPS = 762;;
let _X86_INS_VFMADDSUB231PS = 763;;
let _X86_INS_VFMSUB132PD = 764;;
let _X86_INS_VFMSUB132PS = 765;;
let _X86_INS_VFMSUB213PD = 766;;
let _X86_INS_VFMSUB213PS = 767;;
let _X86_INS_VFMSUBADD132PD = 768;;
let _X86_INS_VFMSUBADD132PS = 769;;
let _X86_INS_VFMSUBADD213PD = 770;;
let _X86_INS_VFMSUBADD213PS = 771;;
let _X86_INS_VFMSUBADDPD = 772;;
let _X86_INS_VFMSUBADD231PD = 773;;
let _X86_INS_VFMSUBADDPS = 774;;
let _X86_INS_VFMSUBADD231PS = 775;;
let _X86_INS_VFMSUBPD = 776;;
let _X86_INS_VFMSUB231PD = 777;;
let _X86_INS_VFMSUBPS = 778;;
let _X86_INS_VFMSUB231PS = 779;;
let _X86_INS_VFMSUBSD = 780;;
let _X86_INS_VFMSUB213SD = 781;;
let _X86_INS_VFMSUB132SD = 782;;
let _X86_INS_VFMSUB231SD = 783;;
let _X86_INS_VFMSUBSS = 784;;
let _X86_INS_VFMSUB213SS = 785;;
let _X86_INS_VFMSUB132SS = 786;;
let _X86_INS_VFMSUB231SS = 787;;
let _X86_INS_VFNMADD132PD = 788;;
let _X86_INS_VFNMADD132PS = 789;;
let _X86_INS_VFNMADD213PD = 790;;
let _X86_INS_VFNMADD213PS = 791;;
let _X86_INS_VFNMADDPD = 792;;
let _X86_INS_VFNMADD231PD = 793;;
let _X86_INS_VFNMADDPS = 794;;
let _X86_INS_VFNMADD231PS = 795;;
let _X86_INS_VFNMADDSD = 796;;
let _X86_INS_VFNMADD213SD = 797;;
let _X86_INS_VFNMADD132SD = 798;;
let _X86_INS_VFNMADD231SD = 799;;
let _X86_INS_VFNMADDSS = 800;;
let _X86_INS_VFNMADD213SS = 801;;
let _X86_INS_VFNMADD132SS = 802;;
let _X86_INS_VFNMADD231SS = 803;;
let _X86_INS_VFNMSUB132PD = 804;;
let _X86_INS_VFNMSUB132PS = 805;;
let _X86_INS_VFNMSUB213PD = 806;;
let _X86_INS_VFNMSUB213PS = 807;;
let _X86_INS_VFNMSUBPD = 808;;
let _X86_INS_VFNMSUB231PD = 809;;
let _X86_INS_VFNMSUBPS = 810;;
let _X86_INS_VFNMSUB231PS = 811;;
let _X86_INS_VFNMSUBSD = 812;;
let _X86_INS_VFNMSUB213SD = 813;;
let _X86_INS_VFNMSUB132SD = 814;;
let _X86_INS_VFNMSUB231SD = 815;;
let _X86_INS_VFNMSUBSS = 816;;
let _X86_INS_VFNMSUB213SS = 817;;
let _X86_INS_VFNMSUB132SS = 818;;
let _X86_INS_VFNMSUB231SS = 819;;
let _X86_INS_VFRCZPD = 820;;
let _X86_INS_VFRCZPS = 821;;
let _X86_INS_VFRCZSD = 822;;
let _X86_INS_VFRCZSS = 823;;
let _X86_INS_VORPD = 824;;
let _X86_INS_VORPS = 825;;
let _X86_INS_VXORPD = 826;;
let _X86_INS_VXORPS = 827;;
let _X86_INS_VGATHERDPD = 828;;
let _X86_INS_VGATHERDPS = 829;;
let _X86_INS_VGATHERQPD = 830;;
let _X86_INS_VGATHERQPS = 831;;
let _X86_INS_VHADDPD = 832;;
let _X86_INS_VHADDPS = 833;;
let _X86_INS_VHSUBPD = 834;;
let _X86_INS_VHSUBPS = 835;;
let _X86_INS_VINSERTF128 = 836;;
let _X86_INS_VINSERTF32X4 = 837;;
let _X86_INS_VINSERTF64X4 = 838;;
let _X86_INS_VINSERTI128 = 839;;
let _X86_INS_VINSERTI32X4 = 840;;
let _X86_INS_VINSERTI64X4 = 841;;
let _X86_INS_VINSERTPS = 842;;
let _X86_INS_VLDDQU = 843;;
let _X86_INS_VLDMXCSR = 844;;
let _X86_INS_VMASKMOVDQU = 845;;
let _X86_INS_VMASKMOVPD = 846;;
let _X86_INS_VMASKMOVPS = 847;;
let _X86_INS_VMAXPD = 848;;
let _X86_INS_VMAXPS = 849;;
let _X86_INS_VMAXSD = 850;;
let _X86_INS_VMAXSS = 851;;
let _X86_INS_VMCALL = 852;;
let _X86_INS_VMCLEAR = 853;;
let _X86_INS_VMFUNC = 854;;
let _X86_INS_VMINPD = 855;;
let _X86_INS_VMINPS = 856;;
let _X86_INS_VMINSD = 857;;
let _X86_INS_VMINSS = 858;;
let _X86_INS_VMLAUNCH = 859;;
let _X86_INS_VMLOAD = 860;;
let _X86_INS_VMMCALL = 861;;
let _X86_INS_VMOVQ = 862;;
let _X86_INS_VVMOVQ = 863;;
let _X86_INS_VMOVDDUP = 864;;
let _X86_INS_VMOVD = 865;;
let _X86_INS_VMOVDQA32 = 866;;
let _X86_INS_VMOVDQA64 = 867;;
let _X86_INS_VMOVDQA = 868;;
let _X86_INS_VMOVDQU32 = 869;;
let _X86_INS_VMOVDQU64 = 870;;
let _X86_INS_VMOVDQU = 871;;
let _X86_INS_VMOVHLPS = 872;;
let _X86_INS_VMOVHPD = 873;;
let _X86_INS_VMOVHPS = 874;;
let _X86_INS_VMOVLHPS = 875;;
let _X86_INS_VMOVLPD = 876;;
let _X86_INS_VMOVLPS = 877;;
let _X86_INS_VMOVMSKPD = 878;;
let _X86_INS_VMOVMSKPS = 879;;
let _X86_INS_VMOVNTDQA = 880;;
let _X86_INS_VMOVNTDQ = 881;;
let _X86_INS_VMOVNTPD = 882;;
let _X86_INS_VMOVNTPS = 883;;
let _X86_INS_VMOVSD = 884;;
let _X86_INS_VMOVSHDUP = 885;;
let _X86_INS_VMOVSLDUP = 886;;
let _X86_INS_VMOVSS = 887;;
let _X86_INS_VMOVUPD = 888;;
let _X86_INS_VMOVUPS = 889;;
let _X86_INS_VMPSADBW = 890;;
let _X86_INS_VMPTRLD = 891;;
let _X86_INS_VMPTRST = 892;;
let _X86_INS_VMREAD = 893;;
let _X86_INS_VMRESUME = 894;;
let _X86_INS_VMRUN = 895;;
let _X86_INS_VMSAVE = 896;;
let _X86_INS_VMULPD = 897;;
let _X86_INS_VMULPS = 898;;
let _X86_INS_VMULSD = 899;;
let _X86_INS_VMULSS = 900;;
let _X86_INS_VMWRITE = 901;;
let _X86_INS_VMXOFF = 902;;
let _X86_INS_VMXON = 903;;
let _X86_INS_VPABSB = 904;;
let _X86_INS_VPABSD = 905;;
let _X86_INS_VPABSQ = 906;;
let _X86_INS_VPABSW = 907;;
let _X86_INS_VPACKSSDW = 908;;
let _X86_INS_VPACKSSWB = 909;;
let _X86_INS_VPACKUSDW = 910;;
let _X86_INS_VPACKUSWB = 911;;
let _X86_INS_VPADDB = 912;;
let _X86_INS_VPADDD = 913;;
let _X86_INS_VPADDQ = 914;;
let _X86_INS_VPADDSB = 915;;
let _X86_INS_VPADDSW = 916;;
let _X86_INS_VPADDUSB = 917;;
let _X86_INS_VPADDUSW = 918;;
let _X86_INS_VPADDW = 919;;
let _X86_INS_VPALIGNR = 920;;
let _X86_INS_VPANDD = 921;;
let _X86_INS_VPANDND = 922;;
let _X86_INS_VPANDNQ = 923;;
let _X86_INS_VPANDN = 924;;
let _X86_INS_VPANDQ = 925;;
let _X86_INS_VPAND = 926;;
let _X86_INS_VPAVGB = 927;;
let _X86_INS_VPAVGW = 928;;
let _X86_INS_VPBLENDD = 929;;
let _X86_INS_VPBLENDMD = 930;;
let _X86_INS_VPBLENDMQ = 931;;
let _X86_INS_VPBLENDVB = 932;;
let _X86_INS_VPBLENDW = 933;;
let _X86_INS_VPBROADCASTB = 934;;
let _X86_INS_VPBROADCASTD = 935;;
let _X86_INS_VPBROADCASTMB2Q = 936;;
let _X86_INS_VPBROADCASTMW2D = 937;;
let _X86_INS_VPBROADCASTQ = 938;;
let _X86_INS_VPBROADCASTW = 939;;
let _X86_INS_VPCLMULQDQ = 940;;
let _X86_INS_VPCMOV = 941;;
let _X86_INS_VPCMPD = 942;;
let _X86_INS_VPCMPEQB = 943;;
let _X86_INS_VPCMPEQD = 944;;
let _X86_INS_VPCMPEQQ = 945;;
let _X86_INS_VPCMPEQW = 946;;
let _X86_INS_VPCMPESTRI = 947;;
let _X86_INS_VPCMPESTRM = 948;;
let _X86_INS_VPCMPGTB = 949;;
let _X86_INS_VPCMPGTD = 950;;
let _X86_INS_VPCMPGTQ = 951;;
let _X86_INS_VPCMPGTW = 952;;
let _X86_INS_VPCMPISTRI = 953;;
let _X86_INS_VPCMPISTRM = 954;;
let _X86_INS_VPCMPQ = 955;;
let _X86_INS_VPCMPUD = 956;;
let _X86_INS_VPCMPUQ = 957;;
let _X86_INS_VPCOMB = 958;;
let _X86_INS_VPCOMD = 959;;
let _X86_INS_VPCOMQ = 960;;
let _X86_INS_VPCOMUB = 961;;
let _X86_INS_VPCOMUD = 962;;
let _X86_INS_VPCOMUQ = 963;;
let _X86_INS_VPCOMUW = 964;;
let _X86_INS_VPCOMW = 965;;
let _X86_INS_VPERM2F128 = 966;;
let _X86_INS_VPERM2I128 = 967;;
let _X86_INS_VPERMD = 968;;
let _X86_INS_VPERMI2D = 969;;
let _X86_INS_VPERMI2PD = 970;;
let _X86_INS_VPERMI2PS = 971;;
let _X86_INS_VPERMI2Q = 972;;
let _X86_INS_VPERMIL2PD = 973;;
let _X86_INS_VPERMIL2PS = 974;;
let _X86_INS_VPERMILPD = 975;;
let _X86_INS_VPERMILPS = 976;;
let _X86_INS_VPERMPD = 977;;
let _X86_INS_VPERMPS = 978;;
let _X86_INS_VPERMQ = 979;;
let _X86_INS_VPEXTRB = 980;;
let _X86_INS_VPEXTRD = 981;;
let _X86_INS_VPEXTRQ = 982;;
let _X86_INS_VPEXTRW = 983;;
let _X86_INS_VPGATHERDD = 984;;
let _X86_INS_VPGATHERDQ = 985;;
let _X86_INS_VPGATHERQD = 986;;
let _X86_INS_VPGATHERQQ = 987;;
let _X86_INS_VPHADDBD = 988;;
let _X86_INS_VPHADDBQ = 989;;
let _X86_INS_VPHADDBW = 990;;
let _X86_INS_VPHADDDQ = 991;;
let _X86_INS_VPHADDD = 992;;
let _X86_INS_VPHADDSW = 993;;
let _X86_INS_VPHADDUBD = 994;;
let _X86_INS_VPHADDUBQ = 995;;
let _X86_INS_VPHADDUBW = 996;;
let _X86_INS_VPHADDUDQ = 997;;
let _X86_INS_VPHADDUWD = 998;;
let _X86_INS_VPHADDUWQ = 999;;
let _X86_INS_VPHADDWD = 1000;;
let _X86_INS_VPHADDWQ = 1001;;
let _X86_INS_VPHADDW = 1002;;
let _X86_INS_VPHMINPOSUW = 1003;;
let _X86_INS_VPHSUBBW = 1004;;
let _X86_INS_VPHSUBDQ = 1005;;
let _X86_INS_VPHSUBD = 1006;;
let _X86_INS_VPHSUBSW = 1007;;
let _X86_INS_VPHSUBWD = 1008;;
let _X86_INS_VPHSUBW = 1009;;
let _X86_INS_VPINSRB = 1010;;
let _X86_INS_VPINSRD = 1011;;
let _X86_INS_VPINSRQ = 1012;;
let _X86_INS_VPINSRW = 1013;;
let _X86_INS_VPMACSDD = 1014;;
let _X86_INS_VPMACSDQH = 1015;;
let _X86_INS_VPMACSDQL = 1016;;
let _X86_INS_VPMACSSDD = 1017;;
let _X86_INS_VPMACSSDQH = 1018;;
let _X86_INS_VPMACSSDQL = 1019;;
let _X86_INS_VPMACSSWD = 1020;;
let _X86_INS_VPMACSSWW = 1021;;
let _X86_INS_VPMACSWD = 1022;;
let _X86_INS_VPMACSWW = 1023;;
let _X86_INS_VPMADCSSWD = 1024;;
let _X86_INS_VPMADCSWD = 1025;;
let _X86_INS_VPMADDUBSW = 1026;;
let _X86_INS_VPMADDWD = 1027;;
let _X86_INS_VPMASKMOVD = 1028;;
let _X86_INS_VPMASKMOVQ = 1029;;
let _X86_INS_VPMAXSB = 1030;;
let _X86_INS_VPMAXSD = 1031;;
let _X86_INS_VPMAXSW = 1032;;
let _X86_INS_VPMAXUB = 1033;;
let _X86_INS_VPMAXUD = 1034;;
let _X86_INS_VPMAXUW = 1035;;
let _X86_INS_VPMINSB = 1036;;
let _X86_INS_VPMINSD = 1037;;
let _X86_INS_VPMINSW = 1038;;
let _X86_INS_VPMINUB = 1039;;
let _X86_INS_VPMINUD = 1040;;
let _X86_INS_VPMINUW = 1041;;
let _X86_INS_VPMOVDB = 1042;;
let _X86_INS_VPMOVDW = 1043;;
let _X86_INS_VPMOVMSKB = 1044;;
let _X86_INS_VPMOVQB = 1045;;
let _X86_INS_VPMOVQD = 1046;;
let _X86_INS_VPMOVQW = 1047;;
let _X86_INS_VPMOVSDB = 1048;;
let _X86_INS_VPMOVSDW = 1049;;
let _X86_INS_VPMOVSQB = 1050;;
let _X86_INS_VPMOVSQD = 1051;;
let _X86_INS_VPMOVSQW = 1052;;
let _X86_INS_VPMOVSXBD = 1053;;
let _X86_INS_VPMOVSXBQ = 1054;;
let _X86_INS_VPMOVSXBW = 1055;;
let _X86_INS_VPMOVSXDQ = 1056;;
let _X86_INS_VPMOVSXWD = 1057;;
let _X86_INS_VPMOVSXWQ = 1058;;
let _X86_INS_VPMOVUSDB = 1059;;
let _X86_INS_VPMOVUSDW = 1060;;
let _X86_INS_VPMOVUSQB = 1061;;
let _X86_INS_VPMOVUSQD = 1062;;
let _X86_INS_VPMOVUSQW = 1063;;
let _X86_INS_VPMOVZXBD = 1064;;
let _X86_INS_VPMOVZXBQ = 1065;;
let _X86_INS_VPMOVZXBW = 1066;;
let _X86_INS_VPMOVZXDQ = 1067;;
let _X86_INS_VPMOVZXWD = 1068;;
let _X86_INS_VPMOVZXWQ = 1069;;
let _X86_INS_VPMULDQ = 1070;;
let _X86_INS_VPMULHRSW = 1071;;
let _X86_INS_VPMULHUW = 1072;;
let _X86_INS_VPMULHW = 1073;;
let _X86_INS_VPMULLD = 1074;;
let _X86_INS_VPMULLW = 1075;;
let _X86_INS_VPMULUDQ = 1076;;
let _X86_INS_VPORD = 1077;;
let _X86_INS_VPORQ = 1078;;
let _X86_INS_VPOR = 1079;;
let _X86_INS_VPPERM = 1080;;
let _X86_INS_VPROTB = 1081;;
let _X86_INS_VPROTD = 1082;;
let _X86_INS_VPROTQ = 1083;;
let _X86_INS_VPROTW = 1084;;
let _X86_INS_VPSADBW = 1085;;
let _X86_INS_VPSCATTERDD = 1086;;
let _X86_INS_VPSCATTERDQ = 1087;;
let _X86_INS_VPSCATTERQD = 1088;;
let _X86_INS_VPSCATTERQQ = 1089;;
let _X86_INS_VPSHAB = 1090;;
let _X86_INS_VPSHAD = 1091;;
let _X86_INS_VPSHAQ = 1092;;
let _X86_INS_VPSHAW = 1093;;
let _X86_INS_VPSHLB = 1094;;
let _X86_INS_VPSHLD = 1095;;
let _X86_INS_VPSHLQ = 1096;;
let _X86_INS_VPSHLW = 1097;;
let _X86_INS_VPSHUFB = 1098;;
let _X86_INS_VPSHUFD = 1099;;
let _X86_INS_VPSHUFHW = 1100;;
let _X86_INS_VPSHUFLW = 1101;;
let _X86_INS_VPSIGNB = 1102;;
let _X86_INS_VPSIGND = 1103;;
let _X86_INS_VPSIGNW = 1104;;
let _X86_INS_VPSLLDQ = 1105;;
let _X86_INS_VPSLLD = 1106;;
let _X86_INS_VPSLLQ = 1107;;
let _X86_INS_VPSLLVD = 1108;;
let _X86_INS_VPSLLVQ = 1109;;
let _X86_INS_VPSLLW = 1110;;
let _X86_INS_VPSRAD = 1111;;
let _X86_INS_VPSRAQ = 1112;;
let _X86_INS_VPSRAVD = 1113;;
let _X86_INS_VPSRAVQ = 1114;;
let _X86_INS_VPSRAW = 1115;;
let _X86_INS_VPSRLDQ = 1116;;
let _X86_INS_VPSRLD = 1117;;
let _X86_INS_VPSRLQ = 1118;;
let _X86_INS_VPSRLVD = 1119;;
let _X86_INS_VPSRLVQ = 1120;;
let _X86_INS_VPSRLW = 1121;;
let _X86_INS_VPSUBB = 1122;;
let _X86_INS_VPSUBD = 1123;;
let _X86_INS_VPSUBQ = 1124;;
let _X86_INS_VPSUBSB = 1125;;
let _X86_INS_VPSUBSW = 1126;;
let _X86_INS_VPSUBUSB = 1127;;
let _X86_INS_VPSUBUSW = 1128;;
let _X86_INS_VPSUBW = 1129;;
let _X86_INS_VPTESTMD = 1130;;
let _X86_INS_VPTESTMQ = 1131;;
let _X86_INS_VPTEST = 1132;;
let _X86_INS_VPUNPCKHBW = 1133;;
let _X86_INS_VPUNPCKHDQ = 1134;;
let _X86_INS_VPUNPCKHQDQ = 1135;;
let _X86_INS_VPUNPCKHWD = 1136;;
let _X86_INS_VPUNPCKLBW = 1137;;
let _X86_INS_VPUNPCKLDQ = 1138;;
let _X86_INS_VPUNPCKLQDQ = 1139;;
let _X86_INS_VPUNPCKLWD = 1140;;
let _X86_INS_VPXORD = 1141;;
let _X86_INS_VPXORQ = 1142;;
let _X86_INS_VPXOR = 1143;;
let _X86_INS_VRCP14PD = 1144;;
let _X86_INS_VRCP14PS = 1145;;
let _X86_INS_VRCP14SD = 1146;;
let _X86_INS_VRCP14SS = 1147;;
let _X86_INS_VRCPPS = 1148;;
let _X86_INS_VRCPSS = 1149;;
let _X86_INS_VRNDSCALESD = 1150;;
let _X86_INS_VRNDSCALESS = 1151;;
let _X86_INS_VRNDSCALEPD = 1152;;
let _X86_INS_VRNDSCALEPS = 1153;;
let _X86_INS_VROUNDPD = 1154;;
let _X86_INS_VROUNDPS = 1155;;
let _X86_INS_VROUNDSD = 1156;;
let _X86_INS_VROUNDSS = 1157;;
let _X86_INS_VRSQRT14PD = 1158;;
let _X86_INS_VRSQRT14PS = 1159;;
let _X86_INS_VRSQRT14SD = 1160;;
let _X86_INS_VRSQRT14SS = 1161;;
let _X86_INS_VRSQRTPS = 1162;;
let _X86_INS_VRSQRTSS = 1163;;
let _X86_INS_VSCATTERDPD = 1164;;
let _X86_INS_VSCATTERDPS = 1165;;
let _X86_INS_VSCATTERQPD = 1166;;
let _X86_INS_VSCATTERQPS = 1167;;
let _X86_INS_VSHUFPD = 1168;;
let _X86_INS_VSHUFPS = 1169;;
let _X86_INS_VSQRTPD = 1170;;
let _X86_INS_VSQRT = 1171;;
let _X86_INS_VSQRTPS = 1172;;
let _X86_INS_VSQRTSD = 1173;;
let _X86_INS_VSQRTSS = 1174;;
let _X86_INS_VSTMXCSR = 1175;;
let _X86_INS_VSUBPD = 1176;;
let _X86_INS_VSUBPS = 1177;;
let _X86_INS_VSUBSD = 1178;;
let _X86_INS_VSUBSS = 1179;;
let _X86_INS_VTESTPD = 1180;;
let _X86_INS_VTESTPS = 1181;;
let _X86_INS_VUNPCKHPD = 1182;;
let _X86_INS_VUNPCKHPS = 1183;;
let _X86_INS_VUNPCKLPD = 1184;;
let _X86_INS_VUNPCKLPS = 1185;;
let _X86_INS_VZEROALL = 1186;;
let _X86_INS_VZEROUPPER = 1187;;
let _X86_INS_WAIT = 1188;;
let _X86_INS_WBINVD = 1189;;
let _X86_INS_WRFSBASE = 1190;;
let _X86_INS_WRGSBASE = 1191;;
let _X86_INS_WRMSR = 1192;;
let _X86_INS_XABORT = 1193;;
let _X86_INS_XACQUIRE = 1194;;
let _X86_INS_XBEGIN = 1195;;
let _X86_INS_XCHG = 1196;;
let _X86_INS_FXCH = 1197;;
let _X86_INS_XCRYPTCBC = 1198;;
let _X86_INS_XCRYPTCFB = 1199;;
let _X86_INS_XCRYPTCTR = 1200;;
let _X86_INS_XCRYPTECB = 1201;;
let _X86_INS_XCRYPTOFB = 1202;;
let _X86_INS_XEND = 1203;;
let _X86_INS_XGETBV = 1204;;
let _X86_INS_XLATB = 1205;;
let _X86_INS_XRELEASE = 1206;;
let _X86_INS_XRSTOR = 1207;;
let _X86_INS_XRSTOR64 = 1208;;
let _X86_INS_XSAVE = 1209;;
let _X86_INS_XSAVE64 = 1210;;
let _X86_INS_XSAVEOPT = 1211;;
let _X86_INS_XSAVEOPT64 = 1212;;
let _X86_INS_XSETBV = 1213;;
let _X86_INS_XSHA1 = 1214;;
let _X86_INS_XSHA256 = 1215;;
let _X86_INS_XSTORE = 1216;;
let _X86_INS_XTEST = 1217;;

(* all Intel instruction groups *)
let _X86_GRP_INVALID = 0;;
let _X86_GRP_3DNOW = 1;;
let _X86_GRP_AES = 2;;
let _X86_GRP_ADX = 3;;
let _X86_GRP_AVX = 4;;
let _X86_GRP_AVX2 = 5;;
let _X86_GRP_AVX512 = 6;;
let _X86_GRP_BMI = 7;;
let _X86_GRP_BMI2 = 8;;
let _X86_GRP_CMOV = 9;;
let _X86_GRP_F16C = 10;;
let _X86_GRP_FMA = 11;;
let _X86_GRP_FMA4 = 12;;
let _X86_GRP_FSGSBASE = 13;;
let _X86_GRP_HLE = 14;;
let _X86_GRP_MMX = 15;;
let _X86_GRP_MODE32 = 16;;
let _X86_GRP_MODE64 = 17;;
let _X86_GRP_RTM = 18;;
let _X86_GRP_SHA = 19;;
let _X86_GRP_SSE1 = 20;;
let _X86_GRP_SSE2 = 21;;
let _X86_GRP_SSE3 = 22;;
let _X86_GRP_SSE41 = 23;;
let _X86_GRP_SSE42 = 24;;
let _X86_GRP_SSE4A = 25;;
let _X86_GRP_SSSE3 = 26;;
let _X86_GRP_PCLMUL = 27;;
let _X86_GRP_XOP = 28;;

